/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.mongo.v2.ScrapeTaskStatusV2;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.service.UserService;
import ai.platon.scent.rest.api.service.v2.ScrapeTaskStatusV2Service;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"x/v2/tasks"}, consumes={"application/json"}, produces={"application/json"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u000f\u001a\u00020\u00102\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017\u00a2\u0006\u0002\u0010\u0017J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00142\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J&\u0010\u001b\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u00142\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J&\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001e\u001a\u00020\u00142\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\n\b\u0003\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lai/platon/scent/rest/api/controller/ScrapeTaskV2Controller;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "service", "Lai/platon/scent/rest/api/service/v2/ScrapeTaskStatusV2Service;", "userService", "Lai/platon/scent/rest/api/service/UserService;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/rest/api/service/v2/ScrapeTaskStatusV2Service;Lai/platon/scent/rest/api/service/UserService;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getService", "()Lai/platon/scent/rest/api/service/v2/ScrapeTaskStatusV2Service;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "count", "", "statusCode", "", "authToken", "", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "(Ljava/lang/Integer;Ljava/lang/String;Ljavax/servlet/http/HttpServletRequest;)J", "getById", "Lai/platon/scent/mongo/v2/ScrapeTaskStatusV2;", "id", "getByUUID", "uuid", "getByUrl", "url", "list", "", "scent-rest"})
public class ScrapeTaskV2Controller {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScrapeTaskStatusV2Service service;
    @NotNull
    private final UserService userService;

    public ScrapeTaskV2Controller(@NotNull ApplicationContext applicationContext, @NotNull ScrapeTaskStatusV2Service service, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.applicationContext = applicationContext;
        this.service = service;
        this.userService = userService;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScrapeTaskStatusV2Service getService() {
        return this.service;
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @GetMapping(value={"/{id}"}, consumes={"*/*"})
    @Nullable
    public ScrapeTaskStatusV2 getById(@PathVariable @NotNull String id, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return this.getService().find(authToken, id);
    }

    @GetMapping(value={"/uuid/{uuid}"}, consumes={"*/*"})
    @Nullable
    public ScrapeTaskStatusV2 getByUUID(@PathVariable @NotNull String uuid, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return this.getService().find(authToken, uuid);
    }

    @GetMapping(value={"/url/{url}"}, consumes={"*/*"})
    @Nullable
    public ScrapeTaskStatusV2 getByUrl(@PathVariable @NotNull String url, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return this.getService().findByUrl(authToken, url);
    }

    @GetMapping(value={"/"}, consumes={"*/*"})
    @NotNull
    public List<ScrapeTaskStatusV2> list(@RequestParam @Nullable String url, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        List<ScrapeTaskStatusV2> list;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        if (url != null) {
            list = this.getService().findAllByUrl(authToken, url);
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List list$default(ScrapeTaskV2Controller scrapeTaskV2Controller, String string, String string2, HttpServletRequest httpServletRequest, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: list");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return scrapeTaskV2Controller.list(string, string2, httpServletRequest);
    }

    @GetMapping(value={"/count"}, consumes={"*/*"})
    public long count(@RequestParam @Nullable Integer statusCode, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return statusCode != null ? this.getService().countByStatusCode(authToken, statusCode) : this.getService().count(authToken);
    }

    public static /* synthetic */ long count$default(ScrapeTaskV2Controller scrapeTaskV2Controller, Integer n, String string, HttpServletRequest httpServletRequest, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        return scrapeTaskV2Controller.count(n, string, httpServletRequest);
    }
}

