/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.crawl.serialize.CompactedScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.entities.UserDashboard;
import ai.platon.scent.entities.UserDashboardHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskMonthlyHistory;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.service.DashboardService;
import ai.platon.scent.rest.api.service.UserService;
import ai.platon.scent.rest.api.service.scrape.TaskMonthlyHistoryService;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@CrossOrigin
@RequestMapping(value={"users"}, consumes={"application/json"}, produces={"application/json"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J>\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0003\u0010\u001a\u001a\u00020\u001b2\b\b\u0003\u0010\u001c\u001a\u00020\u001b2\b\b\u0003\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J4\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0003\u0010 \u001a\u00020\u00122\b\b\u0003\u0010!\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J&\u0010\"\u001a\u0004\u0018\u00010#2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u001f2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J4\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010*\u001a\u00020\u00122\b\b\u0001\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lai/platon/scent/rest/api/controller/UserController;", "", "userService", "Lai/platon/scent/rest/api/service/UserService;", "dashboardService", "Lai/platon/scent/rest/api/service/DashboardService;", "monthlyHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "(Lai/platon/scent/rest/api/service/UserService;Lai/platon/scent/rest/api/service/DashboardService;Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;)V", "getDashboardService", "()Lai/platon/scent/rest/api/service/DashboardService;", "logger", "Lorg/slf4j/Logger;", "getMonthlyHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "count", "", "authToken", "", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "download", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/crawl/serialize/CompactedScrapeResponse;", "pageNumber", "", "pageSize", "asc", "fetch", "", "offset", "limit", "getLastDashboard", "Lai/platon/scent/entities/UserDashboard;", "refresh", "", "listDashboards", "tasksCountAggregation", "Lorg/springframework/data/mongodb/core/aggregation/AggregationResults;", "Lai/platon/scent/mongo/v1/ScrapeTaskMonthlyHistory;", "days", "scent-rest"})
public class UserController {
    @NotNull
    private final UserService userService;
    @NotNull
    private final DashboardService dashboardService;
    @NotNull
    private final TaskMonthlyHistoryService monthlyHistoryService;
    @NotNull
    private final Logger logger;

    public UserController(@NotNull UserService userService, @NotNull DashboardService dashboardService, @NotNull TaskMonthlyHistoryService monthlyHistoryService) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)dashboardService, (String)"dashboardService");
        Intrinsics.checkNotNullParameter((Object)monthlyHistoryService, (String)"monthlyHistoryService");
        this.userService = userService;
        this.dashboardService = dashboardService;
        this.monthlyHistoryService = monthlyHistoryService;
        this.logger = LogsKt.getLogger(UserController.class);
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @NotNull
    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    @NotNull
    public TaskMonthlyHistoryService getMonthlyHistoryService() {
        return this.monthlyHistoryService;
    }

    @GetMapping(value={"{authToken}/dashboard"}, consumes={"*/*"})
    @ExperimentalTime
    @Nullable
    public UserDashboard getLastDashboard(@PathVariable @NotNull String authToken, @RequestParam(defaultValue="false") boolean refresh, @NotNull HttpServletRequest httpRequest) {
        UserDashboard userDashboard;
        UserDashboardHistory userDashboardHistory;
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), false, 4, null);
        if (refresh) {
            DashboardService dashboardService = this.getDashboardService();
            duration = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(2)");
            userDashboardHistory = dashboardService.create(authToken, duration);
        } else {
            this.getDashboardService().createIfAbsent(authToken);
            userDashboardHistory = this.getDashboardService().findLatest(authToken);
        }
        UserDashboardHistory dashboard = userDashboardHistory;
        duration = dashboard;
        if (duration == null) {
            userDashboard = null;
        } else {
            Duration duration2 = duration;
            boolean bl = false;
            boolean bl2 = false;
            Duration it = duration2;
            boolean bl3 = false;
            userDashboard = new UserDashboard((UserDashboardHistory)it);
        }
        return userDashboard;
    }

    @GetMapping(value={"{authToken}/tasks/aggregation/counts"}, consumes={"*/*"})
    @ExperimentalTime
    @NotNull
    public AggregationResults<ScrapeTaskMonthlyHistory> tasksCountAggregation(@PathVariable @NotNull String authToken, @RequestParam(defaultValue="30") long days, @RequestParam(defaultValue="false") boolean refresh, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Instant startTime = Instant.now().minus(Duration.ofDays(days));
        DashboardService dashboardService = this.getDashboardService();
        Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
        return dashboardService.aggregateExperimental(authToken, startTime);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"{authToken}/dashboards"}, consumes={"*/*"})
    @ExperimentalTime
    @NotNull
    public List<UserDashboard> listDashboards(@PathVariable @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), false, 4, null);
        List list = this.getDashboardService().findAll(authToken, 0, 100).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dashboardService.findAll\u2026100)\n            .content");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserDashboardHistory userDashboardHistory = (UserDashboardHistory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            UserDashboard userDashboard = new UserDashboard((UserDashboardHistory)it);
            collection.add(userDashboard);
        }
        return (List)destination$iv$iv;
    }

    @GetMapping(value={"{authToken}/count"}, consumes={"*/*"})
    public long count(@PathVariable @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return this.getMonthlyHistoryService().estimatedCount(authToken);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"{authToken}/fetch"}, consumes={"*/*"})
    @NotNull
    public List<CompactedScrapeResponse> fetch(@PathVariable @NotNull String authToken, @RequestParam(defaultValue="0") long offset, @RequestParam(defaultValue="500") int limit, @NotNull HttpServletRequest httpRequest) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        int coercedLimit = RangesKt.coerceAtMost((int)limit, (int)5000);
        List<ScrapeTaskMonthlyHistory> result = this.getMonthlyHistoryService().fetch(authToken, offset, coercedLimit);
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScrapeTaskMonthlyHistory scrapeTaskMonthlyHistory = (ScrapeTaskMonthlyHistory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CompactedScrapeResponse compactedScrapeResponse = new ScrapeResponse(it.getIdentifiedTask()).compact();
            collection.add(compactedScrapeResponse);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List fetch$default(UserController userController, String string, long l, int n, HttpServletRequest httpServletRequest, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetch");
        }
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            n = 500;
        }
        return userController.fetch(string, l, n, httpServletRequest);
    }

    @GetMapping(value={"{authToken}/download"}, consumes={"*/*"})
    @ExperimentalTime
    @NotNull
    public Page<CompactedScrapeResponse> download(@PathVariable @NotNull String authToken, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="500") int pageSize, @RequestParam(defaultValue="-1") int asc, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        int coercedPageSize = RangesKt.coerceAtMost((int)pageSize, (int)5000);
        Sort.Direction sort = asc > 0 ? Sort.Direction.ASC : Sort.Direction.DESC;
        String sortProperty = "id";
        String[] stringArray = new String[]{sortProperty};
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)coercedPageSize, (Sort.Direction)sort, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(pageNumber, coercedPa\u2026Size, sort, sortProperty)");
        PageRequest pageable = pageRequest;
        Page<ScrapeTaskMonthlyHistory> result = this.getMonthlyHistoryService().download(authToken, (Pageable)pageable);
        stringArray = result.map(UserController::download$lambda-3);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"result.map { ScrapeRespo\u2026entifiedTask).compact() }");
        return stringArray;
    }

    public static /* synthetic */ Page download$default(UserController userController, String string, int n, int n2, int n3, HttpServletRequest httpServletRequest, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: download");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 500;
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return userController.download(string, n, n2, n3, httpServletRequest);
    }

    private static final CompactedScrapeResponse download$lambda-3(ScrapeTaskMonthlyHistory it) {
        return new ScrapeResponse(it.getIdentifiedTask()).compact();
    }
}

