/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.dom.web.SlimWebNode;
import ai.platon.scent.rest.api.controller.W3NodeController;
import ai.platon.scent.rest.api.service.WebNodeService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"w3/nodes"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0003\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/rest/api/controller/W3NodeController;", "", "webNodeService", "Lai/platon/scent/rest/api/service/WebNodeService;", "(Lai/platon/scent/rest/api/service/WebNodeService;)V", "getWebNodeService", "()Lai/platon/scent/rest/api/service/WebNodeService;", "getTextualWebNodes", "", "topic", "shortenNodeId", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "scent-rest"})
public class W3NodeController {
    @NotNull
    private final WebNodeService webNodeService;

    public W3NodeController(@NotNull WebNodeService webNodeService) {
        Intrinsics.checkNotNullParameter((Object)webNodeService, (String)"webNodeService");
        this.webNodeService = webNodeService;
    }

    @NotNull
    public WebNodeService getWebNodeService() {
        return this.webNodeService;
    }

    @GetMapping(value={"textual/{topic}"}, produces={"text/plain"})
    @NotNull
    public String getTextualWebNodes(@PathVariable @NotNull String topic, @RequestParam(defaultValue="false") boolean shortenNodeId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List<SlimWebNode> tree = this.getWebNodeService().createSlimWebTree(topic, shortenNodeId);
        int size = tree.size();
        String[] stringArray = new String[]{"\n"};
        String comment2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.trimMargin$default((String)("\n            |id | parentId | depth | numChildren | path | symbol | url\n            |\n            |symbols:\n            |   1. N for new, created in 7 days\n            |   2. U for update, updated in 7 days\n            |   3. D for delete, deleted from the category tree\n            |\n            |total " + size + " nodes\n            |"), null, (int)1, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", (CharSequence)"###", (CharSequence)"\n\n", (int)0, null, (Function1)getTextualWebNodes.comment.1.INSTANCE, (int)24, null);
        return CollectionsKt.joinToString$default((Iterable)tree, (CharSequence)"\n", (CharSequence)comment2, null, (int)0, null, (Function1)getTextualWebNodes.1.INSTANCE, (int)28, null);
    }

    public static /* synthetic */ String getTextualWebNodes$default(W3NodeController w3NodeController, String string, boolean bl, HttpServletRequest httpServletRequest, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTextualWebNodes");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return w3NodeController.getTextualWebNodes(string, bl, httpServletRequest);
    }
}

