/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.schedule;

import ai.platon.commons.distributed.lock.exception.DistributedLockException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.PriorityDataCollectorsTableFormatter;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.crawl.parse.ParseFilters;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.common.ScentStatusTracker;
import ai.platon.scent.rest.api.service.scrape.Task48HourHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMonthlyHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import ai.platon.scent.rest.api.service.v1.ScrapeServiceV1;
import ai.platon.scent.rest.api.service.v2.ScrapeServiceV2;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 92\u00020\u0001:\u00019BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u00103\u001a\u000204H\u0017J\b\u00105\u001a\u000204H\u0017J\b\u00106\u001a\u000204H\u0017J\b\u00107\u001a\u000204H\u0017J\b\u00108\u001a\u000204H\u0002R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006:"}, d2={"Lai/platon/scent/rest/api/schedule/ScentRestMonitor;", "", "parseFilters", "Lai/platon/pulsar/crawl/parse/ParseFilters;", "scrapeServiceV1", "Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "task48HourHistoryService", "Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;", "taskMonthlyHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "multiHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "scrapeServiceV2", "Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "scentStatusTracker", "Lai/platon/scent/common/ScentStatusTracker;", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/parse/ParseFilters;Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;Lai/platon/scent/common/ScentStatusTracker;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "dcLog", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getGlobalCacheFactory", "()Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "logger", "getMultiHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "getParseFilters", "()Lai/platon/pulsar/crawl/parse/ParseFilters;", "getScentStatusTracker", "()Lai/platon/scent/common/ScentStatusTracker;", "getScrapeServiceV1", "()Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "getScrapeServiceV2", "()Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "getTask48HourHistoryService", "()Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;", "getTaskMonthlyHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "urlFeederHelper", "Lai/platon/pulsar/common/collect/UrlFeederHelper;", "getUrlFeederHelper", "()Lai/platon/pulsar/common/collect/UrlFeederHelper;", "checkAndReportDataCollectors", "", "collectDbStats", "executeTopTaskBatch", "maintainScrapeTaskDb", "removeRetiredFetchCacheCollector", "Companion", "scent-rest"})
public class ScentRestMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParseFilters parseFilters;
    @NotNull
    private final ScrapeServiceV1 scrapeServiceV1;
    @NotNull
    private final Task48HourHistoryService task48HourHistoryService;
    @NotNull
    private final TaskMonthlyHistoryService taskMonthlyHistoryService;
    @NotNull
    private final TaskMultiHistoryService multiHistoryService;
    @NotNull
    private final ScrapeServiceV2 scrapeServiceV2;
    @NotNull
    private final ScentStatusTracker scentStatusTracker;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final Logger dcLog;
    public static final long INITIAL_DELAY = 120000L;

    public ScentRestMonitor(@NotNull ParseFilters parseFilters, @NotNull ScrapeServiceV1 scrapeServiceV1, @NotNull Task48HourHistoryService task48HourHistoryService, @NotNull TaskMonthlyHistoryService taskMonthlyHistoryService, @NotNull TaskMultiHistoryService multiHistoryService, @NotNull ScrapeServiceV2 scrapeServiceV2, @NotNull ScentStatusTracker scentStatusTracker, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull ScentCrawlLoop crawlLoop, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)parseFilters, (String)"parseFilters");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeServiceV1), (String)"scrapeServiceV1");
        Intrinsics.checkNotNullParameter((Object)task48HourHistoryService, (String)"task48HourHistoryService");
        Intrinsics.checkNotNullParameter((Object)taskMonthlyHistoryService, (String)"taskMonthlyHistoryService");
        Intrinsics.checkNotNullParameter((Object)multiHistoryService, (String)"multiHistoryService");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeServiceV2), (String)"scrapeServiceV2");
        Intrinsics.checkNotNullParameter((Object)scentStatusTracker, (String)"scentStatusTracker");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.parseFilters = parseFilters;
        this.scrapeServiceV1 = scrapeServiceV1;
        this.task48HourHistoryService = task48HourHistoryService;
        this.taskMonthlyHistoryService = taskMonthlyHistoryService;
        this.multiHistoryService = multiHistoryService;
        this.scrapeServiceV2 = scrapeServiceV2;
        this.scentStatusTracker = scentStatusTracker;
        this.globalCacheFactory = globalCacheFactory;
        this.crawlLoop = crawlLoop;
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(ScentRestMonitor.class);
        this.dcLog = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DataCollector.class));
    }

    @NotNull
    public ParseFilters getParseFilters() {
        return this.parseFilters;
    }

    @NotNull
    public ScrapeServiceV1 getScrapeServiceV1() {
        return this.scrapeServiceV1;
    }

    @NotNull
    public Task48HourHistoryService getTask48HourHistoryService() {
        return this.task48HourHistoryService;
    }

    @NotNull
    public TaskMonthlyHistoryService getTaskMonthlyHistoryService() {
        return this.taskMonthlyHistoryService;
    }

    @NotNull
    public TaskMultiHistoryService getMultiHistoryService() {
        return this.multiHistoryService;
    }

    @NotNull
    public ScrapeServiceV2 getScrapeServiceV2() {
        return this.scrapeServiceV2;
    }

    @NotNull
    public ScentStatusTracker getScentStatusTracker() {
        return this.scentStatusTracker;
    }

    @NotNull
    public GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    public ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public UrlFeederHelper getUrlFeederHelper() {
        return new UrlFeederHelper(this.getCrawlLoop().getUrlFeeder());
    }

    @Scheduled(fixedDelay=120000L, initialDelay=120000L)
    public void checkAndReportDataCollectors() {
        if (Runtimes.INSTANCE.isDevInstance()) {
            // empty if block
        }
        try {
            this.getCrawlLoop().getUrlFeeder().getUrlPool().removeDeceased();
            List collectors = this.getCrawlLoop().getCollectors();
            this.dcLog.info("\n{}", (Object)new PriorityDataCollectorsTableFormatter((Collection)collectors));
            this.dcLog.info(this.getCrawlLoop().getAbstract());
            this.logger.info(this.getCrawlLoop().getAbstract());
            this.removeRetiredFetchCacheCollector();
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected exception", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRetiredFetchCacheCollector() {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getUrlFeederHelper().getFeeder().getCollectors();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UrlCacheCollector it = (UrlCacheCollector)element$iv;
                boolean bl = false;
                if (!(it.getDeadTime().compareTo(Instant.now()) <= 0)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        UrlCacheCollector collector = v0;
        if (collector != null) {
            this.logger.info("Removing dead collector {}, dead at {}", (Object)collector.getName(), (Object)collector.getDeadTime());
            collector.getUrlCache().deepClear();
            this.getUrlFeederHelper().remove(collector.getName());
        }
    }

    @Scheduled(fixedDelay=60000L, initialDelay=120000L)
    @ExperimentalTime
    public void collectDbStats() {
        try {
            this.getScrapeServiceV1().collectDbStats();
            this.getMultiHistoryService().collectDbStats();
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected exception", t);
        }
    }

    @Scheduled(fixedDelay=0x6DDD00L, initialDelay=60000L)
    public void maintainScrapeTaskDb() {
        try {
            this.getTask48HourHistoryService().maintainDb();
            this.getTaskMonthlyHistoryService().maintainDb();
        }
        catch (Throwable t) {
            this.logger.warn("Unexpected exception", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    @ExperimentalTime
    public void executeTopTaskBatch() {
        try {
            Iterable iterable = this.getCrawlLoop().getUrlFeeder().findByName("SCRAPE");
            boolean bl = false;
            int n = 0;
            for (Object t : iterable) {
                void it;
                PriorityDataCollector priorityDataCollector = (PriorityDataCollector)t;
                int n2 = n;
                boolean bl2 = false;
                int n3 = it.getSize();
                n = n2 + n3;
            }
            int count = n;
            if (count < 100) {
                try {
                    this.logger.debug("Try executing top N tasks ...");
                    this.getScrapeServiceV1().executeTopN();
                }
                catch (DistributedLockException e) {
                    this.logger.warn("DistributedLockException: {}", (Object)e.getMessage());
                }
                catch (Throwable e) {
                    this.logger.warn("Unexpected failure to execute top task batch", e);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to execute scrape task batch", (Throwable)e);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/rest/api/schedule/ScentRestMonitor$Companion;", "", "()V", "INITIAL_DELAY", "", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

