/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.ScentSession;
import ai.platon.scent.common.ScentWebPageExtKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0016J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/scent/rest/api/service/AnnotationService;", "", "session", "Lai/platon/scent/ScentSession;", "(Lai/platon/scent/ScentSession;)V", "logger", "Lorg/slf4j/Logger;", "annotate", "", "", "url", "annotations", "get", "scent-rest"})
public class AnnotationService {
    @NotNull
    private final ScentSession session;
    @NotNull
    private final Logger logger;

    public AnnotationService(@NotNull ScentSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.logger = LogsKt.getLogger((Object)this);
    }

    @NotNull
    public Map<String, String> get(@NotNull String url) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Map map2 = ScentWebPageExtKt.getMlLabels((WebPage)this.session.load(url));
        if (map2 == null) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        } else {
            map = map2;
        }
        return map;
    }

    @NotNull
    public Map<String, String> annotate(@NotNull String url, @NotNull Map<String, String> annotations) {
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        String normUrl = this.session.normalize(url).getSpec();
        Object[] objectArray = this.session.get(normUrl);
        boolean bl = false;
        boolean bl2 = false;
        WebPage it = objectArray;
        boolean bl3 = false;
        Object object = webPage = it.isNotInternal() ? objectArray : null;
        if (webPage == null) {
            boolean bl4 = false;
            return MapsKt.emptyMap();
        }
        WebPage page = webPage;
        ScentWebPageExtKt.addMLLabels((WebPage)page, annotations);
        this.session.persist(page);
        this.session.flush();
        WebPage webPage2 = this.session.getOrNull(normUrl);
        Object[] objectArray2 = objectArray = webPage2 == null ? null : ScentWebPageExtKt.getMlLabels((WebPage)webPage2);
        if (objectArray == null) {
            boolean bl5 = false;
            return MapsKt.emptyMap();
        }
        Object finalFields = objectArray;
        objectArray = new Object[]{page.getId(), finalFields, annotations, page.getUrl()};
        this.logger.info("{}. Annotated: {} accepted: {} | {}", objectArray);
        return finalFields;
    }
}

