/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.boilerpipe.document.TextDocument;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.session.PulsarSession;
import ai.platon.scent.ScentSession;
import ai.platon.scent.boot.autoconfigure.persist.HarvestTaskStatusRepository;
import ai.platon.scent.boot.autoconfigure.persist.RepositoriesKt;
import ai.platon.scent.common.options.CellType;
import ai.platon.scent.dm.HarvestExecutor;
import ai.platon.scent.dm.HarvestRunner;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.entities.Converters;
import ai.platon.scent.entities.HarvestResult;
import ai.platon.scent.entities.HarvestTaskStatus;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableGroupWritable;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.common.NotAuthorizedException;
import ai.platon.scent.rest.api.common.NotFoundException;
import ai.platon.scent.rest.api.common.json.TextDocumentSerializer;
import ai.platon.scent.rest.api.serialize.HarvestRequest;
import ai.platon.scent.rest.api.serialize.HarvestResponse;
import ai.platon.scent.rest.api.serialize.HarvestStatusRequest;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0019\u0010,\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\"H\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u00101\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8RX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lai/platon/scent/rest/api/service/HarvestService;", "", "session", "Lai/platon/scent/ScentSession;", "taskRepository", "Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "(Lai/platon/scent/ScentSession;Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;)V", "harvestEngine", "Lai/platon/scent/dm/HarvestExecutor;", "getHarvestEngine", "()Lai/platon/scent/dm/HarvestExecutor;", "harvestEngine$delegate", "Lkotlin/Lazy;", "harvestRunner", "Lai/platon/scent/dm/HarvestRunner;", "getHarvestRunner", "()Lai/platon/scent/dm/HarvestRunner;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getSession", "()Lai/platon/scent/ScentSession;", "getTaskRepository", "()Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "createTaskStatus", "Lai/platon/scent/entities/HarvestTaskStatus;", "normUrl", "Lai/platon/scent/dom/HNormUrl;", "request", "Lai/platon/scent/rest/api/serialize/HarvestRequest;", "findHotLinks", "", "getStatus", "Lai/platon/scent/rest/api/serialize/HarvestResponse;", "Lai/platon/scent/rest/api/serialize/HarvestStatusRequest;", "harvest", "", "harvestArticle", "baseUrl", "htmlContent", "options", "Lai/platon/scent/dom/HarvestOptions;", "withHtml", "", "harvestArticleDeferred", "(Lai/platon/scent/rest/api/serialize/HarvestRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "harvestArticles", "loadTaskStatus", "normalize", "submit", "scent-rest"})
public class HarvestService {
    @NotNull
    private final ScentSession session;
    @NotNull
    private final HarvestTaskStatusRepository taskRepository;
    private final Logger logger;
    @NotNull
    private final Lazy harvestEngine$delegate;

    public HarvestService(@NotNull ScentSession session, @NotNull HarvestTaskStatusRepository taskRepository) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)taskRepository, (String)"taskRepository");
        this.session = session;
        this.taskRepository = taskRepository;
        this.logger = LoggerFactory.getLogger(HarvestService.class);
        this.harvestEngine$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HarvestExecutor>(this){
            final /* synthetic */ HarvestService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HarvestExecutor invoke() {
                return new HarvestExecutor(this.this$0.getSession());
            }
        }));
    }

    @NotNull
    public ScentSession getSession() {
        return this.session;
    }

    @NotNull
    public HarvestTaskStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    private final HarvestExecutor getHarvestEngine() {
        Lazy lazy = this.harvestEngine$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (HarvestExecutor)lazy.getValue();
    }

    private HarvestRunner getHarvestRunner() {
        return this.getHarvestEngine().getHarvestRunner();
    }

    @NotNull
    public List<HarvestTaskStatus> findHotLinks() {
        List list = this.getTaskRepository().findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"taskRepository.findAll()");
        return list;
    }

    @NotNull
    public String harvest(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HNormUrl normUrl = this.normalize(request);
        HarvestResult group2 = (HarvestResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HarvestResult>, Object>(this, normUrl, null){
            int label;
            final /* synthetic */ HarvestService this$0;
            final /* synthetic */ HNormUrl $normUrl;
            {
                this.this$0 = $receiver;
                this.$normUrl = $normUrl;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HarvestService.access$getHarvestEngine(this.this$0).execute(this.$normUrl.getSpec(), this.$normUrl.getHOptions(), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HarvestResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return this.getSession().buildJson(group2.getTableGroup());
    }

    @NotNull
    public String submit(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HNormUrl normUrl = this.normalize(request);
        HarvestTaskStatus task = this.createTaskStatus(normUrl, request);
        this.getHarvestEngine().submit(normUrl, task);
        Object[] objectArray = new Object[]{task.getUuid(), task.getRemoteAddr(), normUrl};
        this.logger.info("Harvest task is submitted | {} | {} | {}", objectArray);
        return task.getUuid();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HarvestResponse getStatus(@NotNull HarvestStatusRequest request) throws NotAuthorizedException, NotFoundException {
        PageTableGroupWritable pageTableGroupWritable;
        HarvestResult harvestResult;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        String uuid = request.getUuid();
        HarvestTaskStatus taskStatus = this.loadTaskStatus(request);
        HarvestTaskStatus harvestTaskStatus = taskStatus.getActualTask();
        HarvestTaskStatus activeTask = harvestTaskStatus == null ? taskStatus : harvestTaskStatus;
        harvestTaskStatus = this.getHarvestEngine().getStatus(activeTask.getUuid(), 201);
        int statusCode = harvestTaskStatus.component1();
        boolean isDone = harvestTaskStatus.component2();
        HarvestResult harvestResult2 = (HarvestResult)harvestTaskStatus.component3();
        if (harvestResult2 != null && !Intrinsics.areEqual((Object)activeTask.getUuid(), (Object)harvestResult2.getStatus().getUuid())) {
            harvestResult = new HarvestResult[]{uuid, activeTask.getUuid(), harvestResult2.getStatus().getUuid()};
            this.logger.warn("The task status does not match | {} {} {}", (Object[])harvestResult);
        }
        taskStatus.setStatusCode(statusCode);
        if (statusCode == 200 && this.logger.isInfoEnabled()) {
            int n;
            int n2;
            PageTableGroup pageTableGroup;
            HarvestResult harvestResult3 = harvestResult2;
            PageTableGroup tableGroup = harvestResult3 == null ? null : harvestResult3.getTableGroup();
            PageTableGroup pageTableGroup2 = tableGroup;
            int numTables = pageTableGroup2 == null ? 0 : ((pageTableGroup = pageTableGroup2.getTables()) == null ? 0 : (n2 = pageTableGroup.size()));
            pageTableGroup = tableGroup;
            if (pageTableGroup == null) {
                n = 0;
            } else {
                List list = pageTableGroup.getTables();
                if (list == null) {
                    n = 0;
                } else {
                    int n3;
                    Iterable $this$sumBy$iv = list;
                    boolean $i$f$sumBy = false;
                    int sum$iv = 0;
                    for (Object element$iv : $this$sumBy$iv) {
                        void it;
                        OpenMapTable openMapTable = (OpenMapTable)element$iv;
                        int n4 = sum$iv;
                        boolean bl = false;
                        int n5 = it.getNumColumns();
                        sum$iv = n4 + n5;
                    }
                    n = n3 = sum$iv;
                }
            }
            int numFields = n;
            pageTableGroup = new Object[]{numTables, numFields, taskStatus.getConfiguredUrl()};
            this.logger.info("Harvest status is ok | tables: {}, fields: {} | {}", (Object[])pageTableGroup);
        }
        int n = taskStatus.getStatusCode();
        String string = taskStatus.getUuid();
        int n6 = activeTask.getNTotalPages();
        int n7 = activeTask.getNSuccessPages();
        int n8 = activeTask.getNFailedPages();
        harvestResult = harvestResult2;
        if (harvestResult == null) {
            pageTableGroupWritable = null;
        } else {
            void it;
            HarvestResult harvestResult4 = harvestResult;
            boolean bl = false;
            boolean bl2 = false;
            HarvestResult harvestResult5 = harvestResult4;
            int n9 = n8;
            int n10 = n7;
            int n11 = n6;
            String string2 = string;
            int n12 = n;
            boolean bl3 = false;
            PageTableGroupWritable pageTableGroupWritable2 = Converters.INSTANCE.convert(it.getTableGroup());
            n = n12;
            string = string2;
            n6 = n11;
            n7 = n10;
            n8 = n9;
            pageTableGroupWritable = pageTableGroupWritable2;
        }
        boolean bl = isDone;
        PageTableGroupWritable pageTableGroupWritable3 = pageTableGroupWritable;
        int n13 = n8;
        int n14 = n7;
        int n15 = n6;
        String string3 = string;
        int n16 = n;
        return new HarvestResponse(n16, string3, n15, n14, n13, pageTableGroupWritable3, bl);
    }

    @NotNull
    public String harvestArticles(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HNormUrl normUrl = this.normalize(request);
        List documents2 = (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends TextDocument>>, Object>(this, normUrl, null){
            int label;
            final /* synthetic */ HarvestService this$0;
            final /* synthetic */ HNormUrl $normUrl;
            {
                this.this$0 = $receiver;
                this.$normUrl = $normUrl;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HarvestService.access$getHarvestRunner(this.this$0).harvestArticles(this.$normUrl.getSpec(), this.$normUrl.getHOptions(), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends TextDocument>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String string = TextDocumentSerializer.INSTANCE.toJson(documents2, request.getWithHtml());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextDocumentSerializer.t\u2026uments, request.withHtml)");
        return string;
    }

    @NotNull
    public String harvestArticle(@NotNull HarvestRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HNormUrl normUrl = this.normalize(request);
        TextDocument document2 = (TextDocument)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TextDocument>, Object>(this, normUrl, null){
            int label;
            final /* synthetic */ HarvestService this$0;
            final /* synthetic */ HNormUrl $normUrl;
            {
                this.this$0 = $receiver;
                this.$normUrl = $normUrl;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return HarvestService.access$getHarvestRunner(this.this$0).harvestArticle(this.$normUrl.getSpec(), this.$normUrl.getHOptions());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TextDocument> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String string = TextDocumentSerializer.INSTANCE.toJson(document2, request.getWithHtml());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextDocumentSerializer.t\u2026cument, request.withHtml)");
        return string;
    }

    @NotNull
    public String harvestArticle(@NotNull String baseUrl, @NotNull String htmlContent, @NotNull HarvestOptions options, boolean withHtml) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)htmlContent, (String)"htmlContent");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        TextDocument document2 = (TextDocument)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TextDocument>, Object>(this, baseUrl, htmlContent, options, null){
            int label;
            final /* synthetic */ HarvestService this$0;
            final /* synthetic */ String $baseUrl;
            final /* synthetic */ String $htmlContent;
            final /* synthetic */ HarvestOptions $options;
            {
                this.this$0 = $receiver;
                this.$baseUrl = $baseUrl;
                this.$htmlContent = $htmlContent;
                this.$options = $options;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return HarvestService.access$getHarvestRunner(this.this$0).harvestArticle(this.$baseUrl, this.$htmlContent, this.$options);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TextDocument> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        String string = TextDocumentSerializer.INSTANCE.toJson(document2, withHtml);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextDocumentSerializer.toJson(document, withHtml)");
        return string;
    }

    @Nullable
    public Object harvestArticleDeferred(@NotNull HarvestRequest request, @NotNull Continuation<? super String> $completion) {
        return HarvestService.harvestArticleDeferred$suspendImpl(this, request, $completion);
    }

    static /* synthetic */ Object harvestArticleDeferred$suspendImpl(HarvestService this_, HarvestRequest request, Continuation $completion) {
        HNormUrl normUrl = this_.normalize(request);
        TextDocument document2 = this_.getHarvestRunner().harvestArticle(normUrl.getSpec(), normUrl.getHOptions());
        String string = TextDocumentSerializer.INSTANCE.toJson(document2, request.getWithHtml());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextDocumentSerializer.t\u2026cument, request.withHtml)");
        return string;
    }

    private final HNormUrl normalize(HarvestRequest request) {
        String string;
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        if (!UrlUtils.isValidUrl((String)request.getPortalUrl())) {
            throw new IllegalArgumentException("Malformed portal url | " + request.getPortalUrl());
        }
        HarvestOptions options = (HarvestOptions)PulsarSession.DefaultImpls.options$default((PulsarSession)((PulsarSession)this.getSession()), (String)((string = request.getArgs()) == null ? "" : string), null, (int)2, null);
        if (options.getCellType() == CellType.AUTO) {
            options.setCellType(CellType.PLAIN_TEXT);
        }
        return ScentSession.DefaultImpls.normalize$default((ScentSession)this.getSession(), (String)request.getPortalUrl(), (HarvestOptions)options, (boolean)false, (int)4, null);
    }

    private final HarvestTaskStatus loadTaskStatus(HarvestStatusRequest request) throws NotAuthorizedException {
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        String uuid = request.getUuid();
        HarvestTaskStatus harvestTaskStatus = RepositoriesKt.findByUuidOrNull((HarvestTaskStatusRepository)this.getTaskRepository(), (String)uuid);
        if (harvestTaskStatus == null) {
            throw new NotFoundException("Task not found <" + uuid + ">", null, 2, null);
        }
        return harvestTaskStatus;
    }

    private final HarvestTaskStatus createTaskStatus(HNormUrl normUrl, HarvestRequest request) throws NotAuthorizedException {
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        String configuredUrl = normUrl.getConfiguredUrl();
        Object object = new HarvestTaskStatus(request.getAuthToken(), configuredUrl, 0, null, null, 0, 0, 0, 0, 0, 0.0, 0, 0, null, null, 32764, null);
        boolean bl = false;
        boolean bl2 = false;
        HarvestTaskStatus $this$createTaskStatus_u24lambda_u2d2 = object;
        boolean bl3 = false;
        $this$createTaskStatus_u24lambda_u2d2.setRemoteAddr(request.getRemoteAddr());
        $this$createTaskStatus_u24lambda_u2d2.setActualTask(this.getHarvestRunner().getActiveHarvestTracker().getIfActive(normUrl));
        HarvestTaskStatus taskStatus = object;
        if (taskStatus.getActualTask() == null) {
            this.getHarvestRunner().getActiveHarvestTracker().set(configuredUrl, taskStatus);
        }
        object = this.getTaskRepository().save((Object)taskStatus);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"taskRepository.save(taskStatus)");
        return object;
    }

    public static final /* synthetic */ HarvestExecutor access$getHarvestEngine(HarvestService $this) {
        return $this.getHarvestEngine();
    }

    public static final /* synthetic */ HarvestRunner access$getHarvestRunner(HarvestService $this) {
        return $this.getHarvestRunner();
    }
}

