/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.common.ObjectConverter;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.ExportPaths;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.ScentSession;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.serialize.W3DocumentRequest;
import ai.platon.scent.rest.api.service.LoadService$proxyLinks$;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0016J$\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u000fH\u0016J\u001a\u0010 \u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lai/platon/scent/rest/api/service/LoadService;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "session", "Lai/platon/scent/ScentSession;", "getSession", "()Lai/platon/scent/ScentSession;", "setSession", "(Lai/platon/scent/ScentSession;)V", "getOrNull", "Lai/platon/pulsar/persist/WebPage;", "url", "", "injectResource", "", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "contextPath", "listAnnotationTasks", "", "load", "loadDocument", "request", "Lai/platon/scent/rest/api/serialize/W3DocumentRequest;", "uri", "args", "noScripts", "", "loadDocumentForDataAnnotation", "loadDocumentWithFileCache", "proxyLinks", "stripAttributes", "scent-rest"})
public class LoadService {
    private final Logger logger = LoggerFactory.getLogger(LoadService.class);
    @Autowired
    public ScentSession session;

    @NotNull
    public ScentSession getSession() {
        ScentSession scentSession = this.session;
        if (scentSession != null) {
            return scentSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        return null;
    }

    public void setSession(@NotNull ScentSession scentSession) {
        Intrinsics.checkNotNullParameter((Object)scentSession, (String)"<set-?>");
        this.session = scentSession;
    }

    @Nullable
    public WebPage getOrNull(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getSession().getOrNull(url);
    }

    @NotNull
    public Set<String> listAnnotationTasks() {
        boolean bl = false;
        Set urls = new LinkedHashSet();
        Path path = ExportPaths.Companion.get("annotated", "tmp").getParent();
        Stream<Path> stream = Files.list(path).filter(LoadService::listAnnotationTasks$lambda-0);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list(path).filter { it.isRegularFile() }");
        Sequence $this$mapNotNullTo$iv = StreamsKt.asSequence(stream);
        boolean $i$f$mapNotNullTo = false;
        Sequence $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Path it = (Path)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Element element = Documents.INSTANCE.parse(it, "UTF-8").selectFirstOrNull("#PulsarMetaInformation");
            if ((element == null ? null : element.attr("normalizedurl")) == null) continue;
            string = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv = string;
            boolean bl6 = false;
            ((Collection)urls).add(it$iv);
        }
        return urls;
    }

    @NotNull
    public WebPage load(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getSession().load(url);
    }

    @NotNull
    public FeaturedDocument loadDocumentForDataAnnotation(@NotNull W3DocumentRequest request, @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        FeaturedDocument document2 = this.loadDocument(request);
        if (document2.isNil()) {
            document2 = FeaturedDocument.Companion.createShell$default((FeaturedDocument.Companion)FeaturedDocument.Companion, (String)request.getUrl(), null, (int)2, null);
        }
        this.injectResource(document2, contextPath);
        return document2;
    }

    public static /* synthetic */ FeaturedDocument loadDocumentForDataAnnotation$default(LoadService loadService, W3DocumentRequest w3DocumentRequest, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadDocumentForDataAnnotation");
        }
        if ((n & 2) != 0) {
            string = "/";
        }
        return loadService.loadDocumentForDataAnnotation(w3DocumentRequest, string);
    }

    @NotNull
    public FeaturedDocument loadDocument(@NotNull String url, @Nullable String args2, boolean noScripts) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.contains$default((CharSequence)url, (CharSequence)":8182", (boolean)false, (int)2, null)) {
            this.logger.warn("Unexpected url, internal url is not allowed | {}", (Object)url);
            return FeaturedDocument.Companion.getNIL();
        }
        FeaturedDocument document2 = this.loadDocument(url, args2);
        document2.absoluteLinks();
        if (noScripts) {
            document2.stripScripts();
        }
        return document2;
    }

    public static /* synthetic */ FeaturedDocument loadDocument$default(LoadService loadService, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadDocument");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return loadService.loadDocument(string, string2, bl);
    }

    @NotNull
    public FeaturedDocument loadDocument(@NotNull W3DocumentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        if (StringsKt.contains$default((CharSequence)request.getUrl(), (CharSequence)"/w3doc?", (boolean)false, (int)2, null)) {
            this.logger.warn("Url is not allowed | {}", (Object)request.getUrl());
            return FeaturedDocument.Companion.getNIL();
        }
        boolean noScripts = Intrinsics.areEqual((Object)request.getNoScripts(), (Object)true);
        FeaturedDocument document2 = this.loadDocument(request.getUrl(), request.getArgs(), noScripts);
        if (Intrinsics.areEqual((Object)request.getMinimal(), (Object)true) || Intrinsics.areEqual((Object)request.getNoStyle(), (Object)true)) {
            document2.stripStyles();
        }
        this.stripAttributes(document2, request);
        if (request.getProxyLinks()) {
            this.proxyLinks(document2, request);
        }
        return document2;
    }

    @NotNull
    public FeaturedDocument loadDocument(@NotNull String uri, @Nullable String args2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = args2;
        WebPage page = this.getSession().load(uri, string == null ? "" : string);
        return this.getSession().parse(page, true);
    }

    @NotNull
    public FeaturedDocument loadDocumentWithFileCache(@NotNull String uri, @Nullable String args2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Path path = new ExportPaths(uri).getAnnotatedView();
        if (Files.exists(path, new LinkOption[0])) {
            return Documents.INSTANCE.parse(path, "UTF-8");
        }
        WebPage page = this.getSession().load(uri, (string = args2) == null ? "" : string);
        return this.getSession().parse(page, true);
    }

    private final void stripAttributes(FeaturedDocument document2, W3DocumentRequest request) {
        Function1 removeFilter2 = (Function1)new Function1<Attribute, Boolean>(request){
            final /* synthetic */ W3DocumentRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Attribute it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)this.$request.getMinimal(), (Object)true) || Intrinsics.areEqual((Object)this.$request.getNoImg(), (Object)true) && Intrinsics.areEqual((Object)it.getKey(), (Object)"src") || Intrinsics.areEqual((Object)this.$request.getNoMedia(), (Object)true) && Intrinsics.areEqual((Object)it.getKey(), (Object)"src") || Intrinsics.areEqual((Object)this.$request.getNoAttributes(), (Object)true) || Intrinsics.areEqual((Object)this.$request.getNoCustomAttributes(), (Object)true) && !NodesKt.getSTANDARD_ATTRIBUTES().contains(it.getKey());
            }
        };
        NodesKt.forEachElement$default((Node)((Node)document2.getDocument()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>((Function1<? super Attribute, Boolean>)removeFilter2){
            final /* synthetic */ Function1<Attribute, Boolean> $removeFilter;
            {
                this.$removeFilter = $removeFilter;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Element ele) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                Object object = ele.attributes();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ele.attributes()");
                object = (Iterable)object;
                Function1<Attribute, Boolean> function1 = this.$removeFilter;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Attribute it = (Attribute)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!((Boolean)function1.invoke((Object)it)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Attribute it = (Attribute)element$iv;
                    boolean bl = false;
                    ele.removeAttr(it.getKey());
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void proxyLinks(FeaturedDocument document2, W3DocumentRequest request) {
        void $this$associateByTo$iv$iv$iv;
        Base64.Encoder encoder = Base64.getUrlEncoder();
        ObjectConverter objectConverter = ObjectConverter.INSTANCE;
        Iterable excludes$iv = CollectionsKt.listOf((Object)"url");
        boolean $i$f$asQueryParameters = false;
        Iterable $this$associateBy$iv$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(W3DocumentRequest.class));
        boolean $i$f$associateBy = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv$iv;
        Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv;
            KProperty1 kProperty1 = (KProperty1)element$iv$iv$iv;
            Map map = destination$iv$iv$iv;
            boolean bl = false;
            String string = it$iv.getName();
            map.put(string, element$iv$iv$iv);
        }
        Map props$iv = destination$iv$iv$iv;
        String inheritedArgs = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)props$iv.entrySet()), (Function1)new Function1<Map.Entry<? extends String, ? extends KProperty1<W3DocumentRequest, ?>>, Boolean>(excludes$iv){
            final /* synthetic */ Iterable $excludes;
            {
                this.$excludes = $excludes;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ? extends KProperty1<W3DocumentRequest, ?>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return !CollectionsKt.contains((Iterable)this.$excludes, (Object)it.getKey());
            }
        }), (Function1)new Function1<Map.Entry<? extends String, ? extends KProperty1<W3DocumentRequest, ?>>, Pair<? extends String, ? extends Object>>(props$iv, request){
            final /* synthetic */ Map $props;
            final /* synthetic */ Object $t;
            {
                this.$props = $props;
                this.$t = $t;
                super(1);
            }

            @NotNull
            public final Pair<String, Object> invoke(@NotNull Map.Entry<String, ? extends KProperty1<W3DocumentRequest, ?>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                KProperty1 kProperty1 = (KProperty1)this.$props.get(it.getKey());
                return TuplesKt.to((Object)it.getKey(), kProperty1 == null ? null : kProperty1.get(this.$t));
            }
        }), (Function1)proxyLinks$$inlined$asQueryParameters$3.INSTANCE), (CharSequence)"&", null, null, (int)0, null, (Function1)proxyLinks$$inlined$asQueryParameters$4.INSTANCE, (int)30, null);
        NodesKt.forEachElement$default((Node)((Node)document2.getDocument()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(encoder, inheritedArgs){
            final /* synthetic */ Base64.Encoder $encoder;
            final /* synthetic */ String $inheritedArgs;
            {
                this.$encoder = $encoder;
                this.$inheritedArgs = $inheritedArgs;
                super(1);
            }

            public final void invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (NodeExtKt.isAnchor((Node)((Node)it))) {
                    String string = it.attr("data-original-href");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.attr(\"data-original-href\")");
                    String href = string;
                    if (StringsKt.isBlank((CharSequence)href)) {
                        string = it.attr("abs:href");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.attr(\"abs:href\")");
                        href = string;
                        it.attr("data-original-href", href);
                    }
                    String string2 = href;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    byte[] byArray = string2.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    String base64Url = this.$encoder.encodeToString(byArray);
                    String urlAgent = "/api/w3doc?url=" + base64Url + "&" + this.$inheritedArgs;
                    it.attr("href", urlAgent);
                }
            }
        }), (int)1, null);
    }

    private final void injectResource(FeaturedDocument document2, String contextPath) {
        Document doc = document2.getDocument();
        String cp = StringsKt.removeSuffix((String)contextPath, (CharSequence)"/");
        Object[] objectArray = new String[]{"js/layui.js", "js/preload.gen.js", "js/annotation.js"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            doc.createElement("script").attr("src", cp + "/" + it).appendTo(doc.body());
        }
        doc.createElement("link").attr("href", cp + "/css/layui.css").attr("rel", "stylesheet").attr("type", "text/css").appendTo(doc.head());
    }

    private static final boolean listAnnotationTasks$lambda-0(Path it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Path path = it;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        return Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }
}

