/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeSummaryHistoryRepository;
import ai.platon.scent.entities.ScrapeSummaryHistory;
import ai.platon.scent.rest.api.service.scrape.SummaryQuery;
import com.mongodb.client.ListIndexesIterable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.LongIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.DateOperators;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SampleOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaExtensionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 L*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001LB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH&J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH&J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH&J \u0010 \u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH&J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH&J \u0010!\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH&J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH&J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH&J \u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010'\u001a\u00020(H\u0007J\"\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020.H&J\b\u0010/\u001a\u00020\u000eH&J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0018\u0010/\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001f\u00100\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\t2\u0006\u00101\u001a\u00020\tH&\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u00105\u001a\u000206H&J&\u00107\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u000206H&J.\u00108\u001a\b\u0012\u0004\u0012\u00028\u0000042\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u001b2\u0006\u00105\u001a\u000206H&J\"\u0010:\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010'\u001a\u00020(H\u0007J'\u0010<\u001a\b\u0012\u0004\u0012\u0002H\u00010=\"\u0006\b\u0001\u0010\u0001\u0018\u00012\u0006\u0010\u0019\u001a\u00020\t2\u0006\u00109\u001a\u00020\u001bH\u0086\bJ\"\u0010<\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0007J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?J*\u0010A\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010B\u001a\u00020.H&J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00140&2\u0006\u0010'\u001a\u00020(H\u0007J*\u0010D\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010*\u001a\u00020E2\u0006\u0010+\u001a\u00020,2\u0006\u0010F\u001a\u00020GH\u0007J)\u0010H\u001a\b\u0012\u0004\u0012\u0002H\u00010=\"\u0006\b\u0001\u0010\u0001\u0018\u00012\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010I\u001a\u00020\u000eH\u0086\bJ\u0016\u0010J\u001a\u00020.2\u0006\u0010'\u001a\u00020\t2\u0006\u0010K\u001a\u00020\u0014J\u0012\u0010K\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020(H\u0007J,\u0010K\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010+\u001a\u00020,H\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006M"}, d2={"Lai/platon/scent/rest/api/service/scrape/ScrapeTaskServiceBase;", "T", "", "summaryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "collectionName", "", "getCollectionName", "()Ljava/lang/String;", "countCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "getCountCache", "()Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "getMongoTemplate", "()Lorg/springframework/data/mongodb/core/MongoTemplate;", "summaryCache", "Lai/platon/scent/entities/ScrapeSummaryHistory;", "getSummaryCache", "getSummaryRepository", "()Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;", "count", "authToken", "startTime", "Ljava/time/Instant;", "endTime", "countByStatusCode", "statusCode", "", "countFinished", "countPending", "countSuccess", "createCriteria", "Lorg/springframework/data/mongodb/core/query/Criteria;", "dailySummaries", "", "key", "Lai/platon/scent/rest/api/service/scrape/SummaryQuery;", "dailySummary", "timePoint", "expires", "Ljava/time/Duration;", "deleteAllOld", "", "estimatedCount", "find", "id", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "findAll", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByStatusCode", "findAllByStatusCodeAndCreatedAtAfter", "createdAt", "findLatestSummary", "hourlySummaries", "hourlySummary", "Lorg/springframework/data/mongodb/core/aggregation/AggregationResults;", "listIndexes", "Lcom/mongodb/client/ListIndexesIterable;", "Lorg/bson/Document;", "loadSummary", "maintainDb", "monthlySummaries", "monthlySummary", "Ljava/time/LocalDateTime;", "zoneId", "Ljava/time/ZoneId;", "sample", "size", "save", "summary", "Companion", "scent-rest"})
public abstract class ScrapeTaskServiceBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScrapeSummaryHistoryRepository summaryRepository;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, ScrapeSummaryHistory> summaryCache;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, Long> countCache;
    private static final java.time.Duration summaryCacheTTL = java.time.Duration.ofMinutes(10L);
    private static final java.time.Duration countCacheTTL = java.time.Duration.ofMinutes(5L);

    public ScrapeTaskServiceBase(@NotNull ScrapeSummaryHistoryRepository summaryRepository, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)summaryRepository, (String)"summaryRepository");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        this.summaryRepository = summaryRepository;
        this.mongoTemplate = mongoTemplate;
        java.time.Duration duration = summaryCacheTTL;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"summaryCacheTTL");
        this.summaryCache = new ConcurrentExpiringLRUCache(duration, 10000);
        duration = countCacheTTL;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"countCacheTTL");
        this.countCache = new ConcurrentExpiringLRUCache(duration, 10000);
    }

    @NotNull
    protected final ScrapeSummaryHistoryRepository getSummaryRepository() {
        return this.summaryRepository;
    }

    @NotNull
    public final MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @NotNull
    protected final ConcurrentExpiringLRUCache<String, ScrapeSummaryHistory> getSummaryCache() {
        return this.summaryCache;
    }

    @NotNull
    protected final ConcurrentExpiringLRUCache<String, Long> getCountCache() {
        return this.countCache;
    }

    @NotNull
    public abstract String getCollectionName();

    @NotNull
    public final ListIndexesIterable<Document> listIndexes() {
        ListIndexesIterable listIndexesIterable = this.mongoTemplate.getDb().getCollection(this.getCollectionName()).listIndexes();
        Intrinsics.checkNotNullExpressionValue((Object)listIndexesIterable, (String)"mongoTemplate.db.getColl\u2026ectionName).listIndexes()");
        return listIndexesIterable;
    }

    @Nullable
    public abstract T find(@NotNull String var1, @NotNull String var2);

    @NotNull
    public abstract Page<T> findAll(@NotNull String var1, @NotNull Pageable var2);

    @NotNull
    public abstract Page<T> findAllByStatusCode(@NotNull String var1, int var2, @NotNull Pageable var3);

    @NotNull
    public abstract Page<T> findAllByStatusCodeAndCreatedAtAfter(@NotNull String var1, int var2, @NotNull Instant var3, @NotNull Pageable var4);

    public abstract long estimatedCount();

    public long estimatedCount(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return ((Number)this.countCache.computeIfAbsent((Object)authToken, (Function1)new Function1<String, Long>(this, authToken){
            final /* synthetic */ ScrapeTaskServiceBase<T> this$0;
            final /* synthetic */ String $authToken;
            {
                this.this$0 = $receiver;
                this.$authToken = $authToken;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.count(this.$authToken);
            }
        })).longValue();
    }

    public long estimatedCount(@NotNull String authToken, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String key = authToken + " " + statusCode;
        return ((Number)this.countCache.computeIfAbsent((Object)key, (Function1)new Function1<String, Long>(this, authToken, statusCode){
            final /* synthetic */ ScrapeTaskServiceBase<T> this$0;
            final /* synthetic */ String $authToken;
            final /* synthetic */ int $statusCode;
            {
                this.this$0 = $receiver;
                this.$authToken = $authToken;
                this.$statusCode = $statusCode;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.countByStatusCode(this.$authToken, this.$statusCode);
            }
        })).longValue();
    }

    public abstract long count(@NotNull String var1);

    public abstract long count(@NotNull String var1, @NotNull Instant var2, @NotNull Instant var3);

    public abstract long countPending(@NotNull String var1);

    public abstract long countPending(@NotNull String var1, @NotNull Instant var2, @NotNull Instant var3);

    public abstract long countFinished(@NotNull String var1);

    public abstract long countFinished(@NotNull String var1, @NotNull Instant var2, @NotNull Instant var3);

    public abstract long countSuccess(@NotNull String var1);

    public abstract long countSuccess(@NotNull String var1, @NotNull Instant var2, @NotNull Instant var3);

    public abstract long countByStatusCode(@NotNull String var1, int var2);

    public abstract void deleteAllOld();

    public abstract void maintainDb();

    @ExperimentalTime
    @Nullable
    public final ScrapeSummaryHistory summary(@NotNull SummaryQuery key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.getAuthToken();
        Instant instant = key.getStartInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"key.startInstant");
        Instant instant2 = instant;
        instant = key.getEndInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"key.endInstant");
        return this.summary(string, instant2, instant, key.getExpires());
    }

    @ExperimentalTime
    @Nullable
    public final ScrapeSummaryHistory summary(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime, @NotNull java.time.Duration expires) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        ScrapeSummaryHistory summary = this.loadSummary(authToken, startTime, endTime, expires);
        if (summary != null) {
            return summary;
        }
        boolean $i$f$measureTimedValue = false;
        boolean bl = false;
        TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        boolean bl2 = false;
        TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
        boolean bl3 = false;
        Long result$iv$iv = this.count(authToken, startTime, endTime);
        TimedValue count = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
        if (((Number)count.getValue()).longValue() == 0L) {
            return null;
        }
        boolean $i$f$measureTimedValue3 = false;
        $i$f$measureTimedValue2 = false;
        TimeSource $this$measureTimedValue$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue4 = false;
        bl3 = false;
        TimeMark mark$iv$iv2 = $this$measureTimedValue$iv$iv2.markNow();
        boolean bl4 = false;
        Long result$iv$iv2 = this.countPending(authToken, startTime, endTime);
        TimedValue pendingCount = new TimedValue((Object)result$iv$iv2, mark$iv$iv2.elapsedNow-UwyO8pc(), null);
        $i$f$measureTimedValue = false;
        $i$f$measureTimedValue4 = false;
        TimeSource $this$measureTimedValue$iv$iv3 = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue5 = false;
        bl4 = false;
        TimeMark mark$iv$iv3 = $this$measureTimedValue$iv$iv3.markNow();
        boolean bl5 = false;
        Long result$iv$iv3 = this.countSuccess(authToken, startTime, endTime);
        TimedValue successCount = new TimedValue((Object)result$iv$iv3, mark$iv$iv3.elapsedNow-UwyO8pc(), null);
        $i$f$measureTimedValue = false;
        $i$f$measureTimedValue5 = false;
        Pair[] $this$measureTimedValue$iv$iv4 = (Pair[])TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue6 = false;
        bl5 = false;
        TimeMark mark$iv$iv4 = $this$measureTimedValue$iv$iv4.markNow();
        boolean bl6 = false;
        Long result$iv$iv4 = this.countFinished(authToken, startTime, endTime);
        TimedValue finishedCount = new TimedValue((Object)result$iv$iv4, mark$iv$iv4.elapsedNow-UwyO8pc(), null);
        $this$measureTimedValue$iv$iv4 = new Pair[]{TuplesKt.to((Object)"count", (Object)Duration.toString-impl((long)count.getDuration-UwyO8pc())), TuplesKt.to((Object)"pendingCount", (Object)Duration.toString-impl((long)pendingCount.getDuration-UwyO8pc())), TuplesKt.to((Object)"successCount", (Object)Duration.toString-impl((long)successCount.getDuration-UwyO8pc())), TuplesKt.to((Object)"finishedCount", (Object)Duration.toString-impl((long)finishedCount.getDuration-UwyO8pc()))};
        Map times = MapsKt.mapOf((Pair[])$this$measureTimedValue$iv$iv4);
        summary = new ScrapeSummaryHistory(authToken, ((Number)count.getValue()).longValue(), ((Number)pendingCount.getValue()).longValue(), ((Number)successCount.getValue()).longValue(), ((Number)finishedCount.getValue()).longValue(), startTime, endTime, times, null, null, null, 1792, null);
        String key = authToken + "_" + startTime + "_" + endTime;
        if (summary.isFinal()) {
            this.save(key, summary);
        }
        return summary;
    }

    public static /* synthetic */ ScrapeSummaryHistory summary$default(ScrapeTaskServiceBase scrapeTaskServiceBase, String string, Instant instant, Instant instant2, java.time.Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: summary");
        }
        if ((n & 8) != 0) {
            java.time.Duration duration2 = summaryCacheTTL;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"summaryCacheTTL");
            duration = duration2;
        }
        return scrapeTaskServiceBase.summary(string, instant, instant2, duration);
    }

    private final ScrapeSummaryHistory loadSummary(String authToken, Instant startTime, Instant endTime, java.time.Duration expires) {
        ScrapeSummaryHistory summary;
        String key = authToken + "_" + startTime + "_" + endTime;
        ScrapeSummaryHistory scrapeSummaryHistory = (ScrapeSummaryHistory)ConcurrentExpiringLRUCache.getDatum$default(this.summaryCache, (Object)key, (java.time.Duration)expires, null, (int)4, null);
        ScrapeSummaryHistory scrapeSummaryHistory2 = summary = scrapeSummaryHistory == null ? this.findLatestSummary(authToken, startTime, endTime) : scrapeSummaryHistory;
        if (summary != null) {
            ConcurrentExpiringLRUCache.putDatum$default(this.summaryCache, (Object)key, (Object)summary, (long)0L, (int)4, null);
            return summary;
        }
        return null;
    }

    private final ScrapeSummaryHistory findLatestSummary(String authToken, Instant startTime, Instant endTime) {
        return this.summaryRepository.findTopByAuthTokenAndStartTimeAndEndTimeOrderByCreatedAtDesc(authToken, startTime, endTime).orElse(null);
    }

    public final void save(@NotNull String key, @NotNull ScrapeSummaryHistory summary) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        this.summaryRepository.save((Object)summary);
        ConcurrentExpiringLRUCache.putDatum$default(this.summaryCache, (Object)key, (Object)summary, (long)0L, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    @NotNull
    public final List<ScrapeSummaryHistory> monthlySummaries(@NotNull SummaryQuery key) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Comparable<ChronoLocalDate> comparable;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Year year = Year.now();
        Iterable $this$map$iv = (Iterable)new IntRange(1, 12);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            comparable = MonthDay.of((int)it, 1).atYear(year.getValue());
            collection.add(comparable);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LocalDate it = (LocalDate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            comparable = it.atStartOfDay();
            collection.add(comparable);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalDateTime it = (LocalDateTime)element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo(key.getStartTime()) >= 0 && it.compareTo(key.getEndTime()) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ScrapeSummaryHistory scrapeSummaryHistory;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LocalDateTime it = (LocalDateTime)element$iv$iv;
            boolean bl2 = false;
            String string = key.getAuthToken();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.monthlySummary(string, it, key.getExpires(), key.getZoneId()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ScrapeSummaryHistory it$iv$iv = scrapeSummaryHistory;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @ExperimentalTime
    @Nullable
    public final ScrapeSummaryHistory monthlySummary(@NotNull String authToken, @NotNull LocalDateTime timePoint, @NotNull java.time.Duration expires, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)timePoint, (String)"timePoint");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        LocalDateTime startOfMonth = timePoint.withDayOfMonth(1).toLocalDate().atStartOfDay();
        LocalDateTime startOfNextMonth = timePoint.plusDays(31L).withDayOfMonth(1).toLocalDate().atStartOfDay();
        Intrinsics.checkNotNullExpressionValue((Object)startOfMonth, (String)"startOfMonth");
        Intrinsics.checkNotNullExpressionValue((Object)startOfNextMonth, (String)"startOfNextMonth");
        return this.summary(new SummaryQuery(authToken, startOfMonth, startOfNextMonth, expires, zoneId));
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    @NotNull
    public final List<ScrapeSummaryHistory> dailySummaries(@NotNull SummaryQuery key) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LocalDateTime startDate = key.getStartTime().toLocalDate().atStartOfDay();
        LocalDateTime endDate = key.getEndTime().toLocalDate().atStartOfDay().plusDays(1L);
        long days = java.time.Duration.between(startDate, endDate).toDays();
        Iterable iterable = (Iterable)new LongRange(0L, days);
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            long item$iv$iv;
            long l = item$iv$iv = ((LongIterator)iterator).nextLong();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instant instant = startDate.plusDays((long)it).atZone(key.getZoneId()).toInstant();
            collection.add(instant);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ScrapeSummaryHistory scrapeSummaryHistory;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Instant it = (Instant)element$iv$iv;
            boolean bl2 = false;
            String string = key.getAuthToken();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.dailySummary(string, it, key.getExpires()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ScrapeSummaryHistory it$iv$iv = scrapeSummaryHistory;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @ExperimentalTime
    @Nullable
    public final ScrapeSummaryHistory dailySummary(@NotNull String authToken, @NotNull Instant timePoint, @NotNull java.time.Duration expires) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)timePoint, (String)"timePoint");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Instant instant = timePoint.plus(java.time.Duration.ofDays(1L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"timePoint + Duration.ofDays(1)");
        return this.summary(authToken, timePoint, instant, expires);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    @NotNull
    public final List<ScrapeSummaryHistory> hourlySummaries(@NotNull SummaryQuery key) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LocalDateTime startDate = key.getStartTime().truncatedTo(ChronoUnit.HOURS);
        LocalDateTime endDate = key.getEndTime().truncatedTo(ChronoUnit.HOURS).plusHours(1L);
        long hours = java.time.Duration.between(startDate, endDate).toHours();
        Iterable iterable = (Iterable)new LongRange(0L, hours);
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            long item$iv$iv;
            long l = item$iv$iv = ((LongIterator)iterator).nextLong();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Instant instant = startDate.atZone(key.getZoneId()).toInstant().plus(java.time.Duration.ofHours((long)it));
            collection.add(instant);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ScrapeSummaryHistory scrapeSummaryHistory;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Instant it = (Instant)element$iv$iv;
            boolean bl2 = false;
            String string = key.getAuthToken();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (this.hourlySummary(string, it, key.getExpires()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ScrapeSummaryHistory it$iv$iv = scrapeSummaryHistory;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @ExperimentalTime
    @Nullable
    public final ScrapeSummaryHistory hourlySummary(@NotNull String authToken, @NotNull Instant timePoint, @NotNull java.time.Duration expires) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)timePoint, (String)"timePoint");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Instant instant = timePoint.plus(java.time.Duration.ofHours(1L));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"timePoint + Duration.ofHours(1)");
        return this.summary(authToken, timePoint, instant, expires);
    }

    public final /* synthetic */ <T> AggregationResults<T> hourlySummary(String authToken, Instant createdAt) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        boolean $i$f$hourlySummary = false;
        Criteria criteria = CriteriaExtensionsKt.isEqualTo((Criteria)new Criteria("authToken"), (Object)authToken).and("createdAt").gte((Object)createdAt);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"Criteria(\"authToken\").is\u2026reatedAt\").gte(createdAt)");
        Criteria criteria2 = criteria;
        MatchOperation matchOperation = Aggregation.match((Criteria)criteria2);
        Intrinsics.checkNotNullExpressionValue((Object)matchOperation, (String)"match(criteria)");
        MatchOperation matchStage = matchOperation;
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[0]).and((AggregationExpression)DateOperators.Year.year((Object)"$createdAt")).as("year").and((AggregationExpression)DateOperators.DayOfMonth.dayOfMonth((String)"$createdAt")).as("dayOfMonth").and((AggregationExpression)DateOperators.Hour.hour((Object)"$createdAt")).as("hour");
        Intrinsics.checkNotNullExpressionValue((Object)projectionOperation, (String)"project()\n            .a\u2026createdAt\")).`as`(\"hour\")");
        ProjectionOperation projectStage = projectionOperation;
        String[] stringArray = new String[]{"year", "dayOfMonth", "hour"};
        GroupOperation groupOperation = Aggregation.group((String[])stringArray).addToSet("year").as("year").addToSet("dayOfMonth").as("dayOfMonth").addToSet("hour").as("hour").count().as("count");
        Intrinsics.checkNotNullExpressionValue((Object)groupOperation, (String)"group(\"year\", \"dayOfMont\u2026   .count().`as`(\"count\")");
        GroupOperation countStage = groupOperation;
        AggregationOperation[] aggregationOperationArray = new AggregationOperation[]{(AggregationOperation)matchStage, (AggregationOperation)projectStage, (AggregationOperation)countStage};
        stringArray = Aggregation.newAggregation((AggregationOperation[])aggregationOperationArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"newAggregation(matchStag\u2026projectStage, countStage)");
        String[] aggregation = stringArray;
        MongoTemplate mongoTemplate = this.getMongoTemplate();
        String string = this.getCollectionName();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        stringArray = mongoTemplate.aggregate((Aggregation)aggregation, string, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mongoTemplate.aggregate(\u2026ctionName, T::class.java)");
        return (AggregationResults)stringArray;
    }

    public final /* synthetic */ <T> AggregationResults<T> sample(String authToken, long size) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        boolean $i$f$sample = false;
        MatchOperation matchOperation = Aggregation.match((Criteria)new Criteria("authToken").is((Object)authToken));
        Intrinsics.checkNotNullExpressionValue((Object)matchOperation, (String)"match(Criteria(\"authToken\").`is`(authToken))");
        MatchOperation matchStage = matchOperation;
        SampleOperation sampleOperation = Aggregation.sample((long)RangesKt.coerceAtMost((long)size, (long)10000L));
        Intrinsics.checkNotNullExpressionValue((Object)sampleOperation, (String)"sample(size.coerceAtMost(10000))");
        SampleOperation sampleStage = sampleOperation;
        AggregationOperation[] aggregationOperationArray = new AggregationOperation[]{(AggregationOperation)matchStage, (AggregationOperation)sampleStage};
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])aggregationOperationArray);
        Intrinsics.checkNotNullExpressionValue((Object)aggregation, (String)"newAggregation(matchStage, sampleStage)");
        Aggregation aggregation2 = aggregation;
        MongoTemplate mongoTemplate = this.getMongoTemplate();
        String string = this.getCollectionName();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        aggregation = mongoTemplate.aggregate(aggregation2, string, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregation, (String)"mongoTemplate.aggregate(\u2026ctionName, T::class.java)");
        return (AggregationResults)aggregation;
    }

    public static /* synthetic */ AggregationResults sample$default(ScrapeTaskServiceBase this_, String authToken, long size, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sample");
        }
        if ((n & 2) != 0) {
            size = 100L;
        }
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        boolean $i$f$sample = false;
        MatchOperation matchOperation = Aggregation.match((Criteria)new Criteria("authToken").is((Object)authToken));
        Intrinsics.checkNotNullExpressionValue((Object)matchOperation, (String)"match(Criteria(\"authToken\").`is`(authToken))");
        MatchOperation matchStage = matchOperation;
        SampleOperation sampleOperation = Aggregation.sample((long)RangesKt.coerceAtMost((long)size, (long)10000L));
        Intrinsics.checkNotNullExpressionValue((Object)sampleOperation, (String)"sample(size.coerceAtMost(10000))");
        SampleOperation sampleStage = sampleOperation;
        AggregationOperation[] aggregationOperationArray = new AggregationOperation[]{(AggregationOperation)matchStage, (AggregationOperation)sampleStage};
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])aggregationOperationArray);
        Intrinsics.checkNotNullExpressionValue((Object)aggregation, (String)"newAggregation(matchStage, sampleStage)");
        Aggregation aggregation2 = aggregation;
        MongoTemplate mongoTemplate = this_.getMongoTemplate();
        String string = this_.getCollectionName();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        aggregation = mongoTemplate.aggregate(aggregation2, string, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregation, (String)"mongoTemplate.aggregate(\u2026ctionName, T::class.java)");
        return (AggregationResults)aggregation;
    }

    private final Criteria createCriteria(String authToken, Instant startTime, Instant endTime) {
        Criteria criteria = Criteria.where((String)"authToken").is((Object)authToken).and("createdAt").gte((Object)startTime).lt((Object)endTime);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"where(\"authToken\").`is`(\u2026te(startTime).lt(endTime)");
        return criteria;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lai/platon/scent/rest/api/service/scrape/ScrapeTaskServiceBase$Companion;", "", "()V", "countCacheTTL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getCountCacheTTL", "()Ljava/time/Duration;", "summaryCacheTTL", "getSummaryCacheTTL", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public final java.time.Duration getSummaryCacheTTL() {
            return summaryCacheTTL;
        }

        public final java.time.Duration getCountCacheTTL() {
            return countCacheTTL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

