/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.scent.rest.api.service.scrape.ScrapeTaskServiceBase;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006("}, d2={"Lai/platon/scent/rest/api/service/scrape/SummaryQuery;", "", "authToken", "", "startTime", "Ljava/time/LocalDateTime;", "endTime", "expires", "Ljava/time/Duration;", "zoneId", "Ljava/time/ZoneId;", "(Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;Ljava/time/Duration;Ljava/time/ZoneId;)V", "getAuthToken", "()Ljava/lang/String;", "endInstant", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getEndInstant", "()Ljava/time/Instant;", "getEndTime", "()Ljava/time/LocalDateTime;", "getExpires", "()Ljava/time/Duration;", "startInstant", "getStartInstant", "getStartTime", "getZoneId", "()Ljava/time/ZoneId;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "scent-rest"})
public final class SummaryQuery {
    @NotNull
    private final String authToken;
    @NotNull
    private final LocalDateTime startTime;
    @NotNull
    private final LocalDateTime endTime;
    @NotNull
    private final Duration expires;
    @NotNull
    private final ZoneId zoneId;

    public SummaryQuery(@NotNull String authToken, @NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull Duration expires, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.authToken = authToken;
        this.startTime = startTime;
        this.endTime = endTime;
        this.expires = expires;
        this.zoneId = zoneId;
    }

    public /* synthetic */ SummaryQuery(String string, LocalDateTime localDateTime, LocalDateTime localDateTime2, Duration duration, ZoneId serializable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Serializable serializable2;
        if ((n & 8) != 0) {
            serializable2 = ScrapeTaskServiceBase.Companion.getSummaryCacheTTL();
            Intrinsics.checkNotNullExpressionValue((Object)serializable2, (String)"summaryCacheTTL");
            duration = serializable2;
        }
        if ((n & 0x10) != 0) {
            serializable2 = DateTimes.INSTANCE.getZoneId();
            Intrinsics.checkNotNullExpressionValue((Object)serializable2, (String)"DateTimes.zoneId");
            serializable = serializable2;
        }
        this(string, localDateTime, localDateTime2, duration, (ZoneId)serializable);
    }

    @NotNull
    public final String getAuthToken() {
        return this.authToken;
    }

    @NotNull
    public final LocalDateTime getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final LocalDateTime getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final Duration getExpires() {
        return this.expires;
    }

    @NotNull
    public final ZoneId getZoneId() {
        return this.zoneId;
    }

    public final Instant getStartInstant() {
        return this.startTime.atZone(this.zoneId).toInstant();
    }

    public final Instant getEndInstant() {
        return this.endTime.atZone(this.zoneId).toInstant();
    }

    @NotNull
    public final String component1() {
        return this.authToken;
    }

    @NotNull
    public final LocalDateTime component2() {
        return this.startTime;
    }

    @NotNull
    public final LocalDateTime component3() {
        return this.endTime;
    }

    @NotNull
    public final Duration component4() {
        return this.expires;
    }

    @NotNull
    public final ZoneId component5() {
        return this.zoneId;
    }

    @NotNull
    public final SummaryQuery copy(@NotNull String authToken, @NotNull LocalDateTime startTime, @NotNull LocalDateTime endTime, @NotNull Duration expires, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return new SummaryQuery(authToken, startTime, endTime, expires, zoneId);
    }

    public static /* synthetic */ SummaryQuery copy$default(SummaryQuery summaryQuery, String string, LocalDateTime localDateTime, LocalDateTime localDateTime2, Duration duration, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            string = summaryQuery.authToken;
        }
        if ((n & 2) != 0) {
            localDateTime = summaryQuery.startTime;
        }
        if ((n & 4) != 0) {
            localDateTime2 = summaryQuery.endTime;
        }
        if ((n & 8) != 0) {
            duration = summaryQuery.expires;
        }
        if ((n & 0x10) != 0) {
            zoneId = summaryQuery.zoneId;
        }
        return summaryQuery.copy(string, localDateTime, localDateTime2, duration, zoneId);
    }

    @NotNull
    public String toString() {
        return "SummaryQuery(authToken=" + this.authToken + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", expires=" + this.expires + ", zoneId=" + this.zoneId + ")";
    }

    public int hashCode() {
        int result = this.authToken.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + this.expires.hashCode();
        result = result * 31 + this.zoneId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SummaryQuery)) {
            return false;
        }
        SummaryQuery summaryQuery = (SummaryQuery)other;
        if (!Intrinsics.areEqual((Object)this.authToken, (Object)summaryQuery.authToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)summaryQuery.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)summaryQuery.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.expires, (Object)summaryQuery.expires)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.zoneId, (Object)summaryQuery.zoneId);
    }
}

