/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeSummaryHistoryRepository;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTask48HourHistoryRepository;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.mongo.v1.ScrapeTask48HourHistory;
import ai.platon.scent.rest.api.service.scrape.ScrapeTaskServiceBase;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0016J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0016J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;", "Lai/platon/scent/rest/api/service/scrape/ScrapeTaskServiceBase;", "Lai/platon/scent/mongo/v1/ScrapeTask48HourHistory;", "repository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;", "summaryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "collectionName", "", "getCollectionName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "count", "", "authToken", "startTime", "Ljava/time/Instant;", "endTime", "countByStatusCode", "statusCode", "", "countFinished", "countPending", "countSuccess", "deleteAllOld", "", "estimatedCount", "find", "id", "findAll", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByStatusCode", "findAllByStatusCodeAndCreatedAtAfter", "createdAt", "maintainDb", "scent-rest"})
public class Task48HourHistoryService
extends ScrapeTaskServiceBase<ScrapeTask48HourHistory> {
    @NotNull
    private final ScrapeTask48HourHistoryRepository repository;
    private final Logger logger;
    @NotNull
    private final String collectionName;

    public Task48HourHistoryService(@NotNull ScrapeTask48HourHistoryRepository repository, @NotNull ScrapeSummaryHistoryRepository summaryRepository, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)summaryRepository, (String)"summaryRepository");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        super(summaryRepository, mongoTemplate);
        this.repository = repository;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(TaskMultiHistoryService.class));
        String string = mongoTemplate.getCollectionName(ScrapeTask48HourHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mongoTemplate.getCollect\u20268HourHistory::class.java)");
        this.collectionName = string;
    }

    @Override
    @NotNull
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    @Nullable
    public ScrapeTask48HourHistory find(@NotNull String authToken, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.repository.findById((Object)id).filter(arg_0 -> Task48HourHistoryService.find$lambda-0(authToken, arg_0)).orElse(null);
    }

    @Override
    @NotNull
    public Page<ScrapeTask48HourHistory> findAll(@NotNull String authToken, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthToken(authToken, pageable);
    }

    @Override
    @NotNull
    public Page<ScrapeTask48HourHistory> findAllByStatusCode(@NotNull String authToken, int statusCode, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCode(authToken, statusCode, pageable);
    }

    @Override
    @NotNull
    public Page<ScrapeTask48HourHistory> findAllByStatusCodeAndCreatedAtAfter(@NotNull String authToken, int statusCode, @NotNull Instant createdAt, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCodeAndCreatedAtAfter(authToken, statusCode, createdAt, pageable);
    }

    @Override
    public long estimatedCount() {
        return this.getMongoTemplate().estimatedCount(ScrapeTask48HourHistory.class);
    }

    @Override
    public long count(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthToken(authToken);
    }

    @Override
    public long count(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime);
    }

    @Override
    public long countPending(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, false);
    }

    @Override
    public long countPending(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, false, startTime, endTime);
    }

    @Override
    public long countFinished(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, true);
    }

    @Override
    public long countFinished(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, true, startTime, endTime);
    }

    @Override
    public long countSuccess(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.countByStatusCode(authToken, 200);
    }

    @Override
    public long countSuccess(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskStatusCodeAndCreatedAtBetween(authToken, 200, startTime, endTime);
    }

    @Override
    public long countByStatusCode(@NotNull String authToken, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskStatusCode(authToken, statusCode);
    }

    @Override
    public void deleteAllOld() {
        Instant hoursBefore = Instant.now().minus(Duration.ofHours(48L));
        Intrinsics.checkNotNullExpressionValue((Object)hoursBefore, (String)"hoursBefore");
        long count = this.repository.deleteAllByCreatedAtBefore(hoursBefore);
        this.logger.info("Deleted {} records before {}", (Object)count, (Object)hoursBefore);
    }

    @Override
    public void maintainDb() {
        int dayOfMonth = LocalDate.now().getDayOfMonth();
        int mod = dayOfMonth % ClusterTools.INSTANCE.getCrawlerCount();
        if (ClusterTools.INSTANCE.getInstancePartition() == mod) {
            this.deleteAllOld();
        }
    }

    private static final boolean find$lambda-0(String $authToken, ScrapeTask48HourHistory it) {
        Intrinsics.checkNotNullParameter((Object)$authToken, (String)"$authToken");
        return Intrinsics.areEqual((Object)it.getAuthToken(), (Object)$authToken);
    }
}

