/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.v1;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.crawl.CoreMetrics;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.component.ScrapeTaskV1Handler;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTask48HourHistoryRepository;
import ai.platon.scent.boot.autoconfigure.service.LockService;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.common.Saved;
import ai.platon.scent.crawl.serialize.ScrapeRequest;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeStatusRequest;
import ai.platon.scent.crawl.urls.DegenerateScrapeHyperlink;
import ai.platon.scent.crawl.urls.ScrapeHyperlink;
import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.mongo.v1.ScrapeTask48HourHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskHistoriesKt;
import ai.platon.scent.mongo.v1.ScrapeTaskMultiHistory;
import ai.platon.scent.rest.api.common.IllegalRequestException;
import ai.platon.scent.rest.api.common.IllegalXSQLException;
import ai.platon.scent.rest.api.common.NotAuthorizedException;
import ai.platon.scent.rest.api.common.NotFoundException;
import ai.platon.scent.rest.api.service.DashboardService;
import ai.platon.scent.rest.api.service.scrape.PriorityTaskQueueService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 [2\u00020\u0001:\u0001[BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u00108\u001a\u000209H\u0016J&\u0010:\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020\u0016H\u0017J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020<H\u0016J\b\u0010C\u001a\u000209H\u0016J\u0010\u0010D\u001a\u0002092\u0006\u0010B\u001a\u00020<H\u0016J\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020<H\u0016J\u0010\u0010F\u001a\u0002032\u0006\u0010=\u001a\u00020>H\u0017J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020<0HH\u0017J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020<0H2\u0006\u0010I\u001a\u00020\u0016H\u0017J\u0010\u0010J\u001a\u00020<2\u0006\u0010=\u001a\u00020KH\u0017J\u0010\u0010L\u001a\u0002032\u0006\u0010=\u001a\u00020KH\u0017J\b\u0010M\u001a\u000209H\u0016J\u001c\u0010N\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u0002030O2\u0006\u0010=\u001a\u00020KH\u0017J<\u0010P\u001a\u0002092\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020<0H2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020<0H2\u0006\u0010S\u001a\u0002022\u0006\u0010T\u001a\u0002022\u0006\u0010U\u001a\u00020VH\u0003J\u0010\u0010W\u001a\u0002022\u0006\u0010=\u001a\u00020>H\u0017J\u0018\u0010X\u001a\b\u0012\u0004\u0012\u00020<0H2\b\b\u0002\u0010I\u001a\u00020\u0016H\u0017J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020<0H2\u0006\u0010I\u001a\u00020\u0016H\u0017J\u0010\u0010Z\u001a\u0002092\u0006\u0010B\u001a\u00020<H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0018\"\u0004\b&\u0010\u001aR\u001a\u0010'\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0018\"\u0004\b/\u0010\u001aR\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0018\"\u0004\b6\u0010\u001aR\u0016\u00107\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "taskQueueService", "Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;", "a48HourHistoryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;", "taskMultiHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "dashboardService", "Lai/platon/scent/rest/api/service/DashboardService;", "lockService", "Lai/platon/scent/boot/autoconfigure/service/LockService;", "coreMetrics", "Lai/platon/pulsar/crawl/CoreMetrics;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;Lai/platon/scent/rest/api/service/DashboardService;Lai/platon/scent/boot/autoconfigure/service/LockService;Lai/platon/pulsar/crawl/CoreMetrics;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "batchCount", "", "getBatchCount", "()I", "setBatchCount", "(I)V", "createCount", "getCreateCount", "setCreateCount", "lastRemainingCount", "", "getLastRemainingCount", "()J", "setLastRemainingCount", "(J)V", "loadedReadyTaskCount", "getLoadedReadyTaskCount", "setLoadedReadyTaskCount", "loadedTaskCount", "getLoadedTaskCount", "setLoadedTaskCount", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "queryCount", "getQueryCount", "setQueryCount", "responseCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "submitCount", "getSubmitCount", "setSubmitCount", "taskLogger", "collectDbStats", "", "create", "Lai/platon/scent/common/Saved;", "Lai/platon/scent/mongo/v1/ScrapeTask;", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequest;", "statusCode", "createHyperlinkOrNull", "Lai/platon/scent/crawl/urls/ScrapeHyperlink;", "task", "dropUnfinishedTasks", "enqueue", "estimateWaitTime", "execute", "executeTopN", "", "batchSize", "getScrapeTask", "Lai/platon/scent/crawl/serialize/ScrapeStatusRequest;", "getStatus", "initializeAtStartup", "load", "Lkotlin/Pair;", "reportTopBatch", "distinctTasks", "tasks", "duplicateMessage", "recentMessage", "elapsedTime", "Ljava/time/Duration;", "submit", "takeTopN", "takeTopNUnlocked", "update", "Companion", "scent-rest"})
public class ScrapeServiceV1
extends ScrapeTaskV1Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PriorityTaskQueueService taskQueueService;
    @NotNull
    private final ScrapeTask48HourHistoryRepository a48HourHistoryRepository;
    @NotNull
    private final TaskMultiHistoryService taskMultiHistoryService;
    @NotNull
    private final DashboardService dashboardService;
    @NotNull
    private final LockService lockService;
    @NotNull
    private final CoreMetrics coreMetrics;
    private final Logger logger;
    private final Logger taskLogger;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, ScrapeResponse> responseCache;
    private int queryCount;
    private int submitCount;
    private int createCount;
    private volatile int batchCount;
    private int loadedTaskCount;
    private int loadedReadyTaskCount;
    private long lastRemainingCount;
    public static final int BATCH_SIZE = 500;
    @NotNull
    private static final AtomicInteger scrapeSequence = new AtomicInteger();

    public ScrapeServiceV1(@NotNull ScentCrawlLoop crawlLoop, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull PriorityTaskQueueService taskQueueService, @NotNull ScrapeTask48HourHistoryRepository a48HourHistoryRepository, @NotNull TaskMultiHistoryService taskMultiHistoryService, @NotNull DashboardService dashboardService, @NotNull LockService lockService, @NotNull CoreMetrics coreMetrics, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)taskQueueService, (String)"taskQueueService");
        Intrinsics.checkNotNullParameter((Object)a48HourHistoryRepository, (String)"a48HourHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)taskMultiHistoryService, (String)"taskMultiHistoryService");
        Intrinsics.checkNotNullParameter((Object)dashboardService, (String)"dashboardService");
        Intrinsics.checkNotNullParameter((Object)lockService, (String)"lockService");
        Intrinsics.checkNotNullParameter((Object)coreMetrics, (String)"coreMetrics");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        super(globalCacheFactory, crawlLoop, mongoTemplate);
        this.taskQueueService = taskQueueService;
        this.a48HourHistoryRepository = a48HourHistoryRepository;
        this.taskMultiHistoryService = taskMultiHistoryService;
        this.dashboardService = dashboardService;
        this.lockService = lockService;
        this.coreMetrics = coreMetrics;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeServiceV1.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeServiceV1.class), (String)".Task");
        Duration duration = this.getResponseCacheTTL();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"responseCacheTTL");
        this.responseCache = new ConcurrentExpiringLRUCache(duration, 5000);
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(int n) {
        this.queryCount = n;
    }

    public int getSubmitCount() {
        return this.submitCount;
    }

    public void setSubmitCount(int n) {
        this.submitCount = n;
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public void setCreateCount(int n) {
        this.createCount = n;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setBatchCount(int n) {
        this.batchCount = n;
    }

    public int getLoadedTaskCount() {
        return this.loadedTaskCount;
    }

    public void setLoadedTaskCount(int n) {
        this.loadedTaskCount = n;
    }

    public int getLoadedReadyTaskCount() {
        return this.loadedReadyTaskCount;
    }

    public void setLoadedReadyTaskCount(int n) {
        this.loadedReadyTaskCount = n;
    }

    public long getLastRemainingCount() {
        return this.lastRemainingCount;
    }

    public void setLastRemainingCount(long l) {
        this.lastRemainingCount = l;
    }

    @ExperimentalTime
    @NotNull
    public ScrapeResponse execute(@NotNull ScrapeRequest request) throws IllegalRequestException {
        Object args2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Saved<String, ScrapeTask> saved = this;
        saved.setQueryCount(saved.getQueryCount() + 1);
        saved.getQueryCount();
        saved = this.create(request, 102);
        String id = (String)saved.component1();
        ScrapeTask task = (ScrapeTask)saved.component2();
        ScrapeHyperlink hyperlink = this.createHyperlink(task);
        if (!(hyperlink instanceof DegenerateScrapeHyperlink)) {
            args2 = hyperlink.getArgs();
            boolean bl = args2 != null;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = StringsKt.contains$default((CharSequence)((CharSequence)args2), (CharSequence)"-parse", (boolean)false, (int)2, null);
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        args2 = hyperlink;
        args2.setArgs(args2.getArgs() + " -ignoreFailure");
        int sequence = scrapeSequence.incrementAndGet();
        Object object = new Object[]{sequence, task.getRemoteAddr(), hyperlink.getConfiguredUrl()};
        this.taskLogger.info("{}. Execute query v1 | {} | {}", object);
        this.submitFetchUrlOrThrow(task.getPriority(), (UrlAware)hyperlink);
        object = hyperlink.get(3L, TimeUnit.MINUTES);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"hyperlink.get(3, TimeUnit.MINUTES)");
        return (ScrapeResponse)object;
    }

    @ExperimentalTime
    @NotNull
    public String submit(@NotNull ScrapeRequest request) throws NotAuthorizedException, IllegalRequestException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ScrapeServiceV1 scrapeServiceV1 = this;
        scrapeServiceV1.setSubmitCount(scrapeServiceV1.getSubmitCount() + 1);
        scrapeServiceV1.getSubmitCount();
        boolean asap = request.getAsap();
        int statusCode = asap ? 102 : 201;
        Saved<String, ScrapeTask> saved = this.create(request, statusCode);
        String id = (String)saved.component1();
        ScrapeTask task = (ScrapeTask)saved.component2();
        ScrapeHyperlink url = this.createHyperlink(task);
        if (asap) {
            this.submitFetchUrlOrThrow(task.getPriority(), (UrlAware)url);
        } else {
            this.enqueue(task);
        }
        int sequence = scrapeSequence.incrementAndGet();
        Object[] objectArray = new Object[]{sequence, task.getRemoteAddr(), url.getConfiguredUrl()};
        this.taskLogger.info("{}. Accepted v1 | {} | {}", objectArray);
        return id;
    }

    @ExperimentalTime
    @NotNull
    public ScrapeResponse getStatus(@NotNull ScrapeStatusRequest request) throws NotFoundException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String id = request.getId();
        ScrapeResponse response = (ScrapeResponse)this.responseCache.getDatum((Object)id);
        if (LangKt.alwaysFalse() && response != null) {
            response.appendMessage("cached");
            return response;
        }
        Pair<ScrapeTask, ScrapeResponse> pair = this.load(request);
        ScrapeTask task = (ScrapeTask)pair.component1();
        ScrapeResponse response2 = (ScrapeResponse)pair.component2();
        response2.setEstimatedWaitTime(this.estimateWaitTime(task));
        return response2;
    }

    @ExperimentalTime
    @NotNull
    public Saved<String, ScrapeTask> create(@NotNull ScrapeRequest request, int statusCode) throws IllegalXSQLException, IllegalRequestException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ScrapeServiceV1 scrapeServiceV1 = this;
        scrapeServiceV1.setCreateCount(scrapeServiceV1.getCreateCount() + 1);
        scrapeServiceV1.getCreateCount();
        int host = ClusterTools.INSTANCE.getInstancePartition();
        Priority13 priority = this.parsePriority(request.getPriority());
        String string = request.getAuthToken();
        String string2 = request.getSql();
        String string3 = request.getRemoteAddr();
        int n = priority.getValue();
        long l = this.taskQueueService.estimatedCount(priority);
        ScrapeTask task = new ScrapeTask(string, string3, statusCode, 0, 0, null, string2, 0, n, false, l, host, 0, null, null, null, null, null, 258744, null);
        string = task.getDetail();
        if (string != null) {
            string.setCallbackUrl(request.getCallbackUrl());
        }
        this.taskMultiHistoryService.saveCascaded(task);
        string2 = task.getId();
        boolean bl = false;
        n = 0;
        n = 0;
        boolean bl2 = false;
        if (string2 == null) {
            boolean bl3 = false;
            String string4 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        String id = string2;
        ConcurrentExpiringLRUCache.putDatum$default(this.responseCache, (Object)id, (Object)new ScrapeResponse(task), (long)0L, (int)4, null);
        return new Saved((Object)id, (Object)task);
    }

    public static /* synthetic */ Saved create$default(ScrapeServiceV1 scrapeServiceV1, ScrapeRequest scrapeRequest, int n, int n2, Object object) throws IllegalXSQLException, IllegalRequestException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n2 & 2) != 0) {
            n = 201;
        }
        return scrapeServiceV1.create(scrapeRequest, n);
    }

    @ExperimentalTime
    @NotNull
    public Pair<ScrapeTask, ScrapeResponse> load(@NotNull ScrapeStatusRequest request) throws NotFoundException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String id = request.getId();
        ScrapeTask48HourHistory scrapeTask48HourHistory = (ScrapeTask48HourHistory)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.a48HourHistoryRepository), (Object)id);
        if (scrapeTask48HourHistory == null) {
            throw new NotFoundException("Task not found <" + id + ">", null, 2, null);
        }
        ScrapeTask48HourHistory history = scrapeTask48HourHistory;
        ScrapeTask task = history.getIdentifiedTask();
        String string = task.getId();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        task.appendMessage("loaded");
        ScrapeResponse response = new ScrapeResponse(task);
        ConcurrentExpiringLRUCache.putDatum$default(this.responseCache, (Object)id, (Object)response, (long)0L, (int)4, null);
        return TuplesKt.to((Object)task, (Object)response);
    }

    public void update(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean bl = task.getId() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (!task.isSynced()) {
            if (task.getStatusCode() == 200) {
                this.getMetrics().getSuccessScrapes().mark();
            } else {
                this.getMetrics().getFailedScrapes().mark();
            }
        }
        this.taskMultiHistoryService.saveCascaded(task);
        task.appendMessage("updated");
        String string = task.getId();
        bl3 = false;
        bl4 = false;
        bl4 = false;
        boolean bl6 = false;
        if (string == null) {
            boolean bl7 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        String id = string;
        ConcurrentExpiringLRUCache.putDatum$default(this.responseCache, (Object)id, (Object)new ScrapeResponse(task), (long)0L, (int)4, null);
    }

    public void enqueue(@NotNull ScrapeTask task) {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                this.taskQueueService.add(task);
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Save failure", it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long estimateWaitTime(@NotNull ScrapeTask task) {
        int n;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.getCreateCount() % 10 == 0) {
            this.setLastRemainingCount(this.taskQueueService.estimatedCount());
        }
        int crawlerCount = ClusterTools.INSTANCE.getCrawlerCount();
        float speed = RangesKt.coerceAtLeast((float)this.coreMetrics.getFinishedFetchTasksPerSecond(), (float)0.1f);
        if (task.isDone()) {
            n = 0;
        } else if (task.getStatusCode() == 201) {
            PriorityDataCollector it;
            void $this$filterTo$iv$iv;
            int n2;
            int n3;
            Object element$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = this.getCrawlLoop().getUrlFeeder().getCollectors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                PriorityDataCollector it2 = (PriorityDataCollector)element$iv$iv;
                boolean bl = false;
                if (!(it2.getPriority() > task.getPriority())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List collectors = (List)destination$iv$iv;
            Iterable $this$sumBy$iv = collectors;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv2 : $this$sumBy$iv) {
                void it3;
                Object element$iv$iv;
                element$iv$iv = (PriorityDataCollector)element$iv2;
                n3 = sum$iv;
                boolean bl = false;
                n2 = it3.getSize();
                sum$iv = n3 + n2;
            }
            int cachedSize = sum$iv;
            Iterable $this$sumBy$iv2 = collectors;
            boolean $i$f$sumBy2 = false;
            int sum$iv2 = 0;
            for (Object element$iv3 : $this$sumBy$iv2) {
                void it4;
                PriorityDataCollector bl = (PriorityDataCollector)element$iv3;
                n3 = sum$iv2;
                boolean bl2 = false;
                n2 = it4.getEstimatedSize();
                sum$iv2 = n3 + n2;
            }
            int estimatedSize = sum$iv2;
            int priorCount = cachedSize * crawlerCount + estimatedSize;
            Iterable $this$filter$iv2 = this.getCrawlLoop().getUrlFeeder().getCollectors();
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Iterator destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PriorityDataCollector it5 = (PriorityDataCollector)element$iv$iv;
                boolean bl = false;
                if (!(it5.getPriority() == task.getPriority())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            collectors = (List)((Object)destination$iv$iv2);
            Iterable $this$sumBy$iv3 = collectors;
            boolean $i$f$sumBy3 = false;
            int sum$iv3 = 0;
            for (Object element$iv4 : $this$sumBy$iv3) {
                PriorityDataCollector bl2 = (PriorityDataCollector)element$iv4;
                n3 = sum$iv3;
                boolean bl = false;
                n2 = it.getSize();
                sum$iv3 = n3 + n2;
            }
            cachedSize = sum$iv3;
            $this$sumBy$iv3 = collectors;
            $i$f$sumBy3 = false;
            sum$iv3 = 0;
            for (Object element$iv5 : $this$sumBy$iv3) {
                it = (PriorityDataCollector)element$iv5;
                n3 = sum$iv3;
                boolean bl = false;
                n2 = it.getEstimatedSize();
                sum$iv3 = n3 + n2;
            }
            estimatedSize = sum$iv3;
            int competitorCount = (cachedSize * crawlerCount + estimatedSize) / collectors.size();
            Duration elapsedTime = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)task.getCreatedAt(), null, (int)2, null);
            float estFinishCount = (float)elapsedTime.getSeconds() * speed * (float)crawlerCount;
            float estUnloadCount = (float)task.getEstimatedOrder() - estFinishCount;
            float estimatedOrder = 1.0f + ((float)(priorCount + competitorCount) + estUnloadCount) / (float)crawlerCount;
            n = (int)estimatedOrder;
        } else {
            n = 1 + this.getCrawlLoop().getUrlFeeder().estimatedOrder(task.getPriority());
        }
        int order = n;
        return (long)((float)order / speed);
    }

    @ExperimentalTime
    @NotNull
    public ScrapeTask getScrapeTask(@NotNull ScrapeStatusRequest request) throws NotFoundException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (ScrapeTask)this.load(request).getFirst();
    }

    public void initializeAtStartup() {
        this.lockService.reset();
        this.taskMultiHistoryService.restoreUnfinishedTasks();
    }

    public void dropUnfinishedTasks() {
        String string = "NOT IMPLEMENTED";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @ExperimentalTime
    @NotNull
    public synchronized List<ScrapeTask> executeTopN() {
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            List<ScrapeTask> list = this.executeTopN(500);
            bl2 = false;
            object = Result.constructor-impl(list);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.logger.warn("Failed to execute task batch", it);
        }
        bl5 = false;
        List list = CollectionsKt.emptyList();
        boolean bl9 = false;
        return Result.isFailure-impl((Object)object2) ? list : object2;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    @NotNull
    public synchronized List<ScrapeTask> executeTopN(int batchSize) {
        void $this$mapNotNullTo$iv$iv;
        List<ScrapeTask> readyTasks = this.takeTopNUnlocked(batchSize);
        if (readyTasks.isEmpty()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = readyTasks;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ScrapeHyperlink scrapeHyperlink;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ScrapeTask it = (ScrapeTask)element$iv$iv;
            boolean bl2 = false;
            if (this.createHyperlinkOrNull(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ScrapeHyperlink it$iv$iv = scrapeHyperlink;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ScrapeHyperlink it = (ScrapeHyperlink)element$iv;
            boolean bl = false;
            boolean bl6 = this.submitFetchUrl(it.getTask().getPriority(), (UrlAware)it);
            boolean bl7 = false;
            boolean bl8 = false;
            boolean it2 = bl6;
            boolean bl9 = false;
            this.getMetrics().getLoadedScrapes().mark();
        }
        return readyTasks;
    }

    @ExperimentalTime
    @NotNull
    public synchronized List<ScrapeTask> takeTopN(int batchSize) {
        List list;
        try {
            list = this.takeTopNUnlocked(batchSize);
        }
        catch (Throwable e) {
            this.logger.warn("Unexpected failure", e);
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List takeTopN$default(ScrapeServiceV1 scrapeServiceV1, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: takeTopN");
        }
        if ((n2 & 1) != 0) {
            n = 500;
        }
        return scrapeServiceV1.takeTopN(n);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalTime
    @NotNull
    public List<ScrapeTask> takeTopNUnlocked(int batchSize) {
        void $this$mapTo$iv$iv;
        String string;
        Instant startTime = Instant.now();
        List<ScrapeTask> tasks = this.taskQueueService.takeTopN(batchSize);
        if (tasks.isEmpty()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ScrapeServiceV1 scrapeServiceV1 = this;
        scrapeServiceV1.setBatchCount(scrapeServiceV1.getBatchCount() + 1);
        scrapeServiceV1.getBatchCount();
        scrapeServiceV1 = this;
        scrapeServiceV1.setLoadedTaskCount(scrapeServiceV1.getLoadedTaskCount() + tasks.size());
        Iterable $this$distinctBy$iv = tasks;
        boolean $i$f$distinctBy2 = false;
        Object set$iv = new HashSet<String>();
        Object list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ScrapeTask it = (ScrapeTask)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            ((ArrayList)list$iv).add(e$iv);
        }
        List distinctTasks = (List)list$iv;
        if (distinctTasks.size() != tasks.size()) {
            StringCompanionObject $i$f$distinctBy2 = StringCompanionObject.INSTANCE;
            set$iv = "(unexpected duplicate %s tasks)";
            list$iv = new Object[]{tasks.size() - distinctTasks.size()};
            boolean bl = false;
            Object object = list$iv;
            String string2 = String.format((String)set$iv, Arrays.copyOf(object, ((Object)object).length));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        } else {
            string = "";
        }
        String duplicateMessage = string;
        ScrapeServiceV1 $i$f$distinctBy2 = this;
        $i$f$distinctBy2.setLoadedReadyTaskCount($i$f$distinctBy2.getLoadedReadyTaskCount() + 1);
        $i$f$distinctBy2.getLoadedReadyTaskCount();
        Iterable $this$forEach$iv = distinctTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScrapeTask it = (ScrapeTask)element$iv;
            boolean bl = false;
            it.setStatusCode(102);
        }
        Iterable $this$map$iv = distinctTasks;
        boolean $i$f$map = false;
        Iterable element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScrapeTask scrapeTask = (ScrapeTask)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ScrapeTask48HourHistory scrapeTask48HourHistory = new ScrapeTask48HourHistory((ScrapeTask)it);
            collection.add(scrapeTask48HourHistory);
        }
        List histories = (List)destination$iv$iv;
        this.a48HourHistoryRepository.saveAll((Iterable)histories);
        Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
        Duration elapsedTime = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)startTime, null, (int)2, null);
        this.reportTopBatch(distinctTasks, tasks, duplicateMessage, "", elapsedTime);
        return distinctTasks;
    }

    public void collectDbStats() {
        this.setLastRemainingCount(this.taskQueueService.estimatedCount());
    }

    @ExperimentalTime
    private final void reportTopBatch(List<ScrapeTask> distinctTasks, List<ScrapeTask> tasks, String duplicateMessage, String recentMessage, Duration elapsedTime) {
        this.collectDbStats();
        this.taskMultiHistoryService.collectDbStats();
        String msg = duplicateMessage + recentMessage;
        Object[] objectArray = new Object[]{this.getBatchCount(), distinctTasks.size(), tasks.size(), this.getLoadedTaskCount(), elapsedTime, this.taskQueueService.estimatedCount(), this.taskMultiHistoryService.getLast48HourEstCount(), this.taskMultiHistoryService.getLastMonthlyEstCount(), this.taskMultiHistoryService.getLastHistoryEstCount()};
        this.logger.info("{}. Loaded top {}/{}/{}" + msg + " tasks in {} queued: {}, 48his: {}, monHis: {}, his: {}", objectArray);
    }

    @Nullable
    public ScrapeHyperlink createHyperlinkOrNull(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            return this.createHyperlink(task);
        }
        catch (IllegalArgumentException e) {
            task.setStatusCode(400);
            this.taskMultiHistoryService.saveCascaded(task);
            this.logger.warn("Illegal argument with task {} | {}", (Object)task.getId(), (Object)e.getMessage());
            try {
                ScrapeTaskMultiHistory history = ScrapeTaskHistoriesKt.createScrapeTaskHistory((ScrapeTask)task);
                this.a48HourHistoryRepository.delete((Object)history.getA48HourHistory());
            }
            catch (Exception e2) {
                this.logger.warn("Failed to delete task {} | {}", (Object)task.getId(), (Object)e2.getMessage());
            }
        }
        catch (Exception e) {
            task.setStatusCode(400);
            this.taskMultiHistoryService.saveCascaded(task);
            this.logger.warn("Unexpected exception", (Throwable)e);
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1$Companion;", "", "()V", "BATCH_SIZE", "", "scrapeSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "getScrapeSequence", "()Ljava/util/concurrent/atomic/AtomicInteger;", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getScrapeSequence() {
            return scrapeSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

