/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.skeleton.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.context.PulsarContexts;
import ai.platon.pulsar.skeleton.crawl.CoreMetrics;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.crawl.parse.ParseFilter;
import ai.platon.pulsar.skeleton.crawl.parse.ParseFilters;
import ai.platon.scent.ScentSession;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.common.ScentConstantsKt;
import ai.platon.scent.common.jackson.ExtensionsKt;
import ai.platon.scent.entities.DataCollectorDatum;
import ai.platon.scent.entities.FetchCacheDatum;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.ScentSQLContexts;
import ai.platon.scent.rest.api.controller.SystemStatusController;
import ai.platon.scent.rest.api.service.scrape.PriorityTaskQueueService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@RestController
@CrossOrigin
@RequestMapping(value={"system/status"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J2\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u001a2\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0<2\u0006\u0010=\u001a\u00020>H\u0012J\u0010\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020>H\u0012J*\u0010A\u001a\u0002092\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0<2\u0006\u0010=\u001a\u00020>H\u0012J\"\u0010B\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u000203\u0018\u00010<0<H\u0017J\u0016\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001a0<H\u0017J\"\u0010D\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0001\u0018\u00010<0<H\u0017J\"\u0010E\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020F\u0018\u00010<0<H\u0017J\"\u0010G\u001a\u001c\u0012\u0004\u0012\u00020\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020H\u0018\u00010<0<H\u0017J\u0014\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002030<H\u0017J\u001a\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u001e0<H\u0017J\b\u0010K\u001a\u00020\u001aH\u0017J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00010<H\u0017J\b\u0010L\u001a\u00020\u001aH\u0017J&\u0010M\u001a\u00020\u001a2\b\b\u0001\u0010N\u001a\u00020\u001a2\b\b\u0003\u0010O\u001a\u0002032\b\b\u0001\u0010P\u001a\u00020\u001aH\u0017J\b\u0010Q\u001a\u00020\u001aH\u0017J\u0014\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020F0<H\u0017J\u001a\u0010S\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\u001e0<H\u0017J\b\u0010T\u001a\u00020\u001aH\u0017J\u0014\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001e0\u001eH\u0017J\u0014\u0010V\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020H0<H\u0017J\u001a\u0010W\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\u001e0<H\u0017J \u0010X\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020,0<0<H\u0017J\b\u0010Y\u001a\u000209H\u0017J$\u0010Z\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0\u001e0<2\b\b\u0003\u0010\\\u001a\u000203H\u0017J$\u0010]\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u001e0<2\b\b\u0001\u0010^\u001a\u00020\u001aH\u0017J\u001a\u0010_\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020`0\u001e0<H\u0017J$\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0\u001e0<2\b\b\u0003\u0010\\\u001a\u000203H\u0017J\u001c\u0010b\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001e0<H\u0017J\u0018\u0010c\u001a\b\u0012\u0004\u0012\u00020[0\u001e2\b\b\u0003\u0010\\\u001a\u000203H\u0017J\u0016\u0010d\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00010<H\u0017J\u0014\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00010<H\u0017J\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0017J\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020`0\u001eH\u0017J\u001c\u0010h\u001a\u00020\u001a2\b\b\u0001\u0010N\u001a\u00020\u001a2\b\b\u0003\u0010O\u001a\u000203H\u0017J\u001e\u0010i\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00010<\u0018\u00010\u001eH\u0017R\u0014\u0010\u0019\u001a\u00020\u001a8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u001c\u0010$\u001a\n %*\u0004\u0018\u00010\u001a0\u001a8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0016\u0010'\u001a\n %*\u0004\u0018\u00010(0(X\u0092\u0004\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020,0+\u0012\u0004\u0012\u00020-0*X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020/8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0002038\u0012X\u0093D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0002058RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lai/platon/scent/rest/api/controller/SystemStatusController;", "", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "metricsSystem", "Lai/platon/pulsar/skeleton/common/metrics/MetricsSystem;", "coreMetrics", "Lai/platon/pulsar/skeleton/crawl/CoreMetrics;", "taskQueueService", "Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;", "taskMultiHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "session", "Lai/platon/scent/ScentSession;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "environment", "Lorg/springframework/core/env/Environment;", "unmodifiedConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/pulsar/skeleton/common/metrics/MetricsSystem;Lai/platon/pulsar/skeleton/crawl/CoreMetrics;Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;Lorg/springframework/web/client/RestTemplate;Lai/platon/scent/ScentSession;Lorg/springframework/data/mongodb/core/MongoTemplate;Lorg/springframework/core/env/Environment;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "baseUri", "", "getBaseUri", "()Ljava/lang/String;", "baseUris", "", "getBaseUris", "()Ljava/util/List;", "glanceTempalte", "graphiteServer", "getGraphiteServer", "ipOrHost", "kotlin.jvm.PlatformType", "getIpOrHost", "logger", "Lorg/slf4j/Logger;", "metricsFilter", "Lkotlin/Function1;", "", "Lcom/codahale/metrics/Metric;", "", "registry", "Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "getRegistry", "()Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "serverPort", "", "sqlContext", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/ScentSQLContext;", "buildTable", "", "caption", "gauges", "", "body", "Lorg/jsoup/nodes/Element;", "buildTaskCounters", "arena", "buildTextualGauges", "clusterCounters", "clusterEnumCounters", "clusterGauges", "clusterHistograms", "Lcom/codahale/metrics/Histogram;", "clusterMeters", "Lcom/codahale/metrics/Meter;", "counters", "countersAggregation", "enumPrimaryCounters", "glances", "grepTailNLog", "fileName", "n", "match", "help", "histograms", "histogramsAggregation", "listLogs", "loadOptionHelp", "meters", "metersAggregation", "metrics", "mongoStatus", "reportAggregatedCollectors", "Lai/platon/scent/entities/DataCollectorDatum;", "debug", "reportAggregatedGauges", "pattern", "reportAggregatedurlPool", "Lai/platon/scent/entities/FetchCacheDatum;", "reportClusterCollectors", "reportClusterParseFilters", "reportCollectors", "reportConfiguration", "reportFetchQueue", "reportParseFilters", "reporturlPool", "tailNLog", "xsqlHelp", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nSystemStatusController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemStatusController.kt\nai/platon/scent/rest/api/controller/SystemStatusController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 RestOperationsExtensions.kt\norg/springframework/web/client/RestOperationsExtensionsKt\n*L\n1#1,632:1\n1#2:633\n1#2:651\n1549#3:634\n1620#3,3:635\n1603#3,9:638\n1855#3:647\n288#3,2:649\n1856#3:652\n1612#3:653\n766#3:654\n857#3,2:655\n766#3:657\n857#3,2:658\n1045#3:713\n1855#3,2:714\n1855#3,2:718\n1855#3,2:728\n1855#3:731\n766#3:732\n857#3,2:733\n1549#3:735\n1620#3,3:736\n1856#3:739\n1253#3,4:740\n800#3,11:744\n1855#3,2:755\n800#3,11:757\n1855#3:768\n1856#3:773\n1549#3:774\n1620#3,3:775\n766#3:778\n857#3,2:779\n1549#3:781\n1620#3,2:782\n766#3:784\n857#3,2:785\n1179#3,2:787\n1253#3,4:789\n1622#3:793\n1549#3:794\n1620#3,3:795\n766#3:799\n857#3,2:800\n1045#3:802\n1549#3:803\n1620#3,3:804\n1549#3:807\n1620#3,3:808\n1549#3:811\n1620#3,3:812\n1549#3:815\n1620#3,2:816\n1622#3:819\n1477#3:820\n1502#3,3:821\n1505#3,3:831\n2976#3,5:837\n2976#3,5:842\n2976#3,5:847\n1549#3:853\n1620#3,3:854\n1549#3:857\n1620#3,3:858\n1549#3:861\n1620#3,2:862\n1622#3:865\n1549#3:866\n1620#3,3:867\n1549#3:870\n1620#3,3:871\n1271#3,2:874\n1285#3,2:876\n1288#3:879\n1549#3:880\n1620#3,3:881\n1271#3,2:884\n1285#3,2:886\n1288#3:889\n1179#3,2:925\n1253#3,4:927\n1549#3:931\n1620#3,3:932\n1271#3,2:935\n1285#3,2:937\n1288#3:940\n1549#3:941\n1620#3,3:942\n1855#3:948\n1726#3,3:949\n2976#3,5:952\n1726#3,3:957\n2989#3,5:960\n1856#3:965\n1179#3,2:973\n1253#3,4:975\n1549#3:979\n1620#3,3:980\n1271#3,2:983\n1285#3,2:985\n1288#3:988\n1549#3:989\n1620#3,3:990\n1855#3:993\n1856#3:997\n1855#3,2:998\n1549#3:1007\n1620#3,3:1008\n1549#3:1014\n1620#3,3:1015\n1271#3,2:1018\n1285#3,2:1020\n1288#3:1023\n1549#3:1031\n1620#3,3:1032\n1549#3:1038\n1620#3,3:1039\n1271#3,2:1042\n1285#3,2:1044\n1288#3:1047\n20#4:648\n526#5:660\n511#5,6:661\n526#5:667\n511#5,6:668\n526#5:674\n511#5,6:675\n526#5:681\n511#5,6:682\n526#5:688\n511#5,6:689\n526#5:695\n511#5,6:696\n526#5:702\n511#5,6:703\n526#5:720\n511#5,6:721\n372#5,7:824\n526#5:890\n511#5,6:891\n526#5:897\n511#5,6:898\n526#5:904\n511#5,6:905\n526#5:911\n511#5,6:912\n526#5:918\n511#5,6:919\n526#5:966\n511#5,6:967\n526#5:1000\n511#5,6:1001\n526#5:1024\n511#5,6:1025\n125#6:709\n152#6,3:710\n215#6,2:716\n215#6:727\n216#6:730\n125#6:834\n152#6,2:835\n154#6:852\n215#6,2:946\n215#6,2:995\n215#6,2:1012\n215#6,2:1036\n9376#7,4:769\n93#8:798\n93#8:818\n93#8:864\n93#8:878\n38#8:888\n93#8:939\n93#8:945\n93#8:987\n93#8:994\n93#8:1011\n93#8:1022\n93#8:1035\n93#8:1046\n*S KotlinDebug\n*F\n+ 1 SystemStatusController.kt\nai/platon/scent/rest/api/controller/SystemStatusController\n*L\n85#1:651\n74#1:634\n74#1:635,3\n85#1:638,9\n85#1:647\n85#1:649,2\n85#1:652\n85#1:653\n88#1:654\n88#1:655,2\n94#1:657\n94#1:658,2\n211#1:713\n211#1:714,2\n237#1:718,2\n263#1:728,2\n277#1:731\n279#1:732\n279#1:733,2\n280#1:735\n280#1:736,3\n277#1:739\n332#1:740,4\n336#1:744,11\n336#1:755,2\n339#1:757,11\n339#1:768\n339#1:773\n361#1:774\n361#1:775,3\n364#1:778\n364#1:779,2\n365#1:781\n365#1:782,2\n368#1:784\n368#1:785,2\n369#1:787,2\n369#1:789,4\n365#1:793\n377#1:794\n377#1:795,3\n393#1:799\n393#1:800,2\n396#1:802\n397#1:803\n397#1:804,3\n416#1:807\n416#1:808,3\n419#1:811\n419#1:812,3\n422#1:815\n422#1:816,2\n422#1:819\n432#1:820\n432#1:821,3\n432#1:831,3\n436#1:837,5\n438#1:842,5\n439#1:847,5\n454#1:853\n454#1:854,3\n456#1:857\n456#1:858,3\n458#1:861\n458#1:862,2\n458#1:865\n473#1:866\n473#1:867,3\n478#1:870\n478#1:871,3\n478#1:874,2\n478#1:876,2\n478#1:879\n491#1:880\n491#1:881,3\n491#1:884,2\n491#1:886,2\n491#1:889\n508#1:925,2\n508#1:927,4\n512#1:931\n512#1:932,3\n512#1:935,2\n512#1:937,2\n512#1:940\n523#1:941\n523#1:942,3\n535#1:948\n536#1:949,3\n537#1:952,5\n538#1:957,3\n539#1:960,5\n535#1:965\n548#1:973,2\n548#1:975,4\n552#1:979\n552#1:980,3\n552#1:983,2\n552#1:985,2\n552#1:988\n563#1:989\n563#1:990,3\n563#1:993\n563#1:997\n567#1:998,2\n578#1:1007\n578#1:1008,3\n591#1:1014\n591#1:1015,3\n591#1:1018,2\n591#1:1020,2\n591#1:1023\n607#1:1031\n607#1:1032,3\n622#1:1038\n622#1:1039,3\n622#1:1042,2\n622#1:1044,2\n622#1:1047\n85#1:648\n141#1:660\n141#1:661,6\n142#1:667\n142#1:668,6\n143#1:674\n143#1:675,6\n144#1:681\n144#1:682,6\n145#1:688\n145#1:689,6\n146#1:695\n146#1:696,6\n147#1:702\n147#1:703,6\n246#1:720\n246#1:721,6\n432#1:824,7\n499#1:890\n499#1:891,6\n500#1:897\n500#1:898,6\n501#1:904\n501#1:905,6\n502#1:911\n502#1:912,6\n508#1:918\n508#1:919,6\n548#1:966\n548#1:967,6\n573#1:1000\n573#1:1001,6\n602#1:1024\n602#1:1025,6\n194#1:709\n194#1:710,3\n229#1:716,2\n260#1:727\n260#1:730\n433#1:834\n433#1:835,2\n433#1:852\n526#1:946,2\n565#1:995,2\n581#1:1012,2\n610#1:1036,2\n340#1:769,4\n379#1:798\n424#1:818\n460#1:864\n480#1:878\n492#1:888\n514#1:939\n525#1:945\n554#1:987\n564#1:994\n580#1:1011\n593#1:1022\n609#1:1035\n624#1:1046\n*E\n"})
public class SystemStatusController {
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final MetricsSystem metricsSystem;
    @NotNull
    private final CoreMetrics coreMetrics;
    @NotNull
    private final PriorityTaskQueueService taskQueueService;
    @NotNull
    private final TaskMultiHistoryService taskMultiHistoryService;
    @NotNull
    private final RestTemplate restTemplate;
    @NotNull
    private final ScentSession session;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ImmutableConfig unmodifiedConfig;
    private final Logger logger;
    @Value(value="${server.port}")
    private final int serverPort;
    @NotNull
    private final String glanceTempalte;
    @NotNull
    private final Function1<Map.Entry<String, ? extends Metric>, Boolean> metricsFilter;
    @Nullable
    private final String graphiteServer;

    /*
     * WARNING - void declaration
     */
    public SystemStatusController(@NotNull GlobalCacheFactory globalCacheFactory, @NotNull ScentCrawlLoop crawlLoop, @NotNull MetricsSystem metricsSystem, @NotNull CoreMetrics coreMetrics, @NotNull PriorityTaskQueueService taskQueueService, @NotNull TaskMultiHistoryService taskMultiHistoryService, @NotNull RestTemplate restTemplate, @NotNull ScentSession session, @NotNull MongoTemplate mongoTemplate, @NotNull Environment environment, @NotNull ImmutableConfig unmodifiedConfig) {
        String string;
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)metricsSystem, (String)"metricsSystem");
        Intrinsics.checkNotNullParameter((Object)coreMetrics, (String)"coreMetrics");
        Intrinsics.checkNotNullParameter((Object)taskQueueService, (String)"taskQueueService");
        Intrinsics.checkNotNullParameter((Object)taskMultiHistoryService, (String)"taskMultiHistoryService");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)unmodifiedConfig, (String)"unmodifiedConfig");
        this.globalCacheFactory = globalCacheFactory;
        this.crawlLoop = crawlLoop;
        this.metricsSystem = metricsSystem;
        this.coreMetrics = coreMetrics;
        this.taskQueueService = taskQueueService;
        this.taskMultiHistoryService = taskMultiHistoryService;
        this.restTemplate = restTemplate;
        this.session = session;
        this.mongoTemplate = mongoTemplate;
        this.environment = environment;
        this.unmodifiedConfig = unmodifiedConfig;
        this.logger = LoggerFactory.getLogger(SystemStatusController.class);
        this.glanceTempalte = ResourceLoader.INSTANCE.readString("wwwroot/template/glances.html");
        this.metricsFilter = metricsFilter.1.INSTANCE;
        SystemStatusController systemStatusController = this;
        String string2 = this.unmodifiedConfig.get("graphite.web.server");
        if (string2 != null) {
            void it;
            String string3;
            String string4 = string3 = string2;
            SystemStatusController systemStatusController2 = systemStatusController;
            boolean bl = false;
            boolean bl2 = NetUtil.testNetwork((String)it, (int)80);
            systemStatusController = systemStatusController2;
            string = bl2 ? string3 : null;
        } else {
            string = null;
        }
        systemStatusController.graphiteServer = string;
    }

    private AppMetricRegistry getRegistry() {
        return MetricsSystem.Companion.getDefaultMetricRegistry();
    }

    private String getIpOrHost() {
        String string = (String)ScentConstantsKt.getREGISTERED_CRAWLERS().get(AppContext.INSTANCE.getHOST_NAME());
        if (string == null) {
            string = AppContext.INSTANCE.getHOST_NAME();
        }
        return string;
    }

    private String getBaseUri() {
        return "http://" + this.getIpOrHost() + ":" + this.serverPort + "/api/system/status";
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getBaseUris() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ScentConstantsKt.getREGISTERED_CRAWLER_IPS();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("http://" + (String)it + ":" + this.serverPort + "/api/system/status");
        }
        return (List)destination$iv$iv;
    }

    private ScentSQLContext getSqlContext() {
        return ScentSQLContexts.INSTANCE.create();
    }

    @Nullable
    public String getGraphiteServer() {
        return this.graphiteServer;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(produces={"text/html"})
    @NotNull
    public String help() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = KClasses.getDeclaredMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(SystemStatusController.class));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object object;
            Object v0;
            KFunction f;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                f = (KFunction)element$iv$iv;
                boolean bl2 = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)f;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv2 : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv2;
                    boolean bl3 = false;
                    if (!(it$iv instanceof GetMapping)) continue;
                    v0 = element$iv$iv2;
                    break block6;
                }
                v0 = null;
            }
            if ((object = (Object[])((Annotation)((GetMapping)v0))) != null && (object = object.value()) != null && (object = (String)ArraysKt.firstOrNull((Object[])object)) != null) {
                Object it = object;
                boolean bl = false;
                pair = TuplesKt.to((Object)f.getName(), (Object)(this.getBaseUri() + "/" + (String)it));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List getMappings = (List)destination$iv$iv;
        Iterable $this$filter$iv = getMappings;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.contains$default((CharSequence)((CharSequence)it.getSecond()), (CharSequence)"{", (boolean)false, (int)2, null))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String ul3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", (CharSequence)"<ul>", (CharSequence)"</ul>", (int)0, null, (Function1)help.ul.2.INSTANCE, (int)24, null);
        Iterable $this$filter$iv2 = getMappings;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)((CharSequence)it.getSecond()), (CharSequence)"{", (boolean)false, (int)2, null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        String ul22 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)"\n", (CharSequence)"<ul>", (CharSequence)"</ul>", (int)0, null, (Function1)help.ul2.2.INSTANCE, (int)24, null);
        Document document2 = Document.createShell((String)this.getBaseUri());
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createShell(...)");
        Document document3 = document2;
        document3.body().append("<h2>System Status API</h2>").append(ul3).append(ul22);
        String string = document3.outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outerHtml(...)");
        return string;
    }

    @GetMapping(value={"help/loadOptions"})
    @NotNull
    public List<List<String>> loadOptionHelp() {
        return LoadOptions.Companion.getHelpList();
    }

    @GetMapping(value={"help/xsql"})
    @Nullable
    public List<Map<String, Object>> xsqlHelp() {
        String sql = "select xsql_help()";
        ResultSet rs = this.getSqlContext().executeQuery(sql);
        return ResultSetUtils.INSTANCE.getEntitiesFromResultSet(rs);
    }

    @GetMapping(value={"mongo"})
    public void mongoStatus() {
        this.mongoTemplate.executeCommand("rs.status()");
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"glances"}, produces={"text/html"})
    @NotNull
    public String glances() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv4;
        void $this$filterTo$iv$iv5;
        void $this$filterTo$iv$iv6;
        void $this$filterTo$iv$iv7;
        FeaturedDocument document2 = Documents.INSTANCE.parse(this.glanceTempalte);
        Element element = document2.getBody().selectFirst(".container");
        Intrinsics.checkNotNull((Object)element);
        Element arena = element;
        arena.appendElement("h1").text("Pulsar System Status");
        arena.appendElement("div").text(OffsetDateTime.now().toString());
        this.buildTaskCounters(arena);
        if (this.getGraphiteServer() != null) {
            arena.appendElement("hr");
            Element element2 = arena.appendElement("div");
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
            Element div = element2;
            div.appendElement("iframe").attr("width", "1050").attr("height", "350").attr("style", "border:none").attr("src", "http://" + this.getGraphiteServer() + "/S/U");
        }
        Map<String, List<Object>> allGauges = this.reportAggregatedGauges(".+");
        Regex regex = new Regex("Amazon|ExtractCounter|JdbcCommitter|v2|FatLinkExtractor");
        Map<String, List<Object>> $this$filter$iv = allGauges;
        boolean $i$f$filter = false;
        Map<String, List<Object>> map = $this$filter$iv;
        Map<String, List<Object>> destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl = false;
            boolean bl2 = !regex.containsMatchIn((CharSequence)entry2.getKey());
            if (!bl2) continue;
            destination$iv$iv.put((String)entry.getKey(), (List<Object>)entry.getValue());
        }
        Map<String, List<Object>> popularGauges = destination$iv$iv;
        Map<String, List<Object>> $this$filter$iv2 = allGauges;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Map<String, List<Object>> destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv6.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator2.next();
            boolean bl = false;
            CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            if (!new Regex("lastDistrict|lastLang").containsMatchIn(charSequence)) continue;
            destination$iv$iv2.put((String)entry.getKey(), (List<Object>)entry.getValue());
        }
        Map<String, List<Object>> textualGauges = destination$iv$iv2;
        Map<String, List<Object>> $this$filter$iv3 = popularGauges;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Map<String, List<Object>> destination$iv$iv3 = new LinkedHashMap();
        boolean bl = false;
        Iterator iterator3 = $this$filterTo$iv$iv5.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv4;
            Map.Entry it = element$iv$iv4 = iterator3.next();
            boolean bl3 = false;
            CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            if (!new Regex("[a-zA-Z]").containsMatchIn(charSequence)) continue;
            destination$iv$iv3.put((String)element$iv$iv4.getKey(), (List<Object>)element$iv$iv4.getValue());
        }
        Map<String, List<Object>> textualGauges2 = destination$iv$iv3;
        Map<String, List<Object>> $this$filter$iv4 = popularGauges;
        boolean $i$f$filter4 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Map map2 = new LinkedHashMap();
        boolean bl4 = false;
        Iterator element$iv$iv4 = $this$filterTo$iv$iv4.entrySet().iterator();
        while (element$iv$iv4.hasNext()) {
            Map.Entry element$iv$iv5;
            Map.Entry it = element$iv$iv5 = element$iv$iv4.next();
            boolean bl5 = false;
            CharSequence charSequence = CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            if (!new Regex("[.0-9]+").matches(charSequence)) continue;
            map2.put(element$iv$iv5.getKey(), element$iv$iv5.getValue());
        }
        Map numericGauges = map2;
        Map<String, List<Object>> $this$filter$iv5 = popularGauges;
        boolean $i$f$filter5 = false;
        Map<String, List<Object>> map3 = $this$filter$iv5;
        Map map4 = new LinkedHashMap();
        boolean $i$f$filterTo5 = false;
        Iterator<Map.Entry<String, List<Object>>> element$iv$iv5 = map3.entrySet().iterator();
        while (element$iv$iv5.hasNext()) {
            Map.Entry<String, List<Object>> element$iv$iv6;
            Map.Entry<String, List<Object>> it = element$iv$iv6 = element$iv$iv5.next();
            boolean bl6 = false;
            if (!StringsKt.contains$default((CharSequence)it.getKey(), (CharSequence)"successes", (boolean)false, (int)2, null)) continue;
            map4.put(element$iv$iv6.getKey(), element$iv$iv6.getValue());
        }
        Map successGauges = map4;
        Map<String, List<Object>> $this$filter$iv6 = popularGauges;
        boolean bl7 = false;
        Map<String, List<Object>> map5 = $this$filter$iv6;
        Map<String, List<Object>> destination$iv$iv6 = new LinkedHashMap();
        boolean $i$f$filterTo6 = false;
        Iterator<Map.Entry<String, List<Object>>> element$iv$iv6 = map5.entrySet().iterator();
        while (element$iv$iv6.hasNext()) {
            Map.Entry<String, List<Object>> element$iv$iv7;
            Map.Entry<String, List<Object>> it = element$iv$iv7 = element$iv$iv6.next();
            boolean bl8 = false;
            CharSequence charSequence = it.getKey();
            if (!new Regex("PrivacyContextMetrics").containsMatchIn(charSequence)) continue;
            destination$iv$iv6.put(element$iv$iv7.getKey(), element$iv$iv7.getValue());
        }
        Map<String, List<Object>> privacyContextMetrics = destination$iv$iv6;
        Map<String, List<Object>> map6 = popularGauges;
        boolean bl9 = false;
        destination$iv$iv6 = map6;
        Map destination$iv$iv7 = new LinkedHashMap();
        boolean $i$f$filterTo7 = false;
        Iterator iterator4 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator4.hasNext()) {
            Map.Entry element$iv$iv8;
            Map.Entry it = element$iv$iv8 = iterator4.next();
            boolean bl10 = false;
            CharSequence charSequence = (CharSequence)it.getKey();
            if (!new Regex("CoreMetrics").containsMatchIn(charSequence)) continue;
            destination$iv$iv7.put(element$iv$iv8.getKey(), element$iv$iv8.getValue());
        }
        Map coreMetrics = destination$iv$iv7;
        this.buildTable("Successes", successGauges, arena);
        this.buildTable("PrivacyContextMetrics", privacyContextMetrics, arena);
        this.buildTextualGauges(MapsKt.plus(textualGauges, textualGauges2), arena);
        this.buildTable("CoreMetrics", coreMetrics, arena);
        this.buildTable("Gauges", numericGauges, arena);
        Element element3 = arena.appendElement("div");
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"appendElement(...)");
        Element element4 = element3;
        element4.appendElement("h2").text("Collector");
        Map map7 = SystemStatusController.reportAggregatedCollectors$default(this, 0, 1, null);
        element4.appendElement("pre").text(ExtensionsKt.prettyScentObjectWritter().writeValueAsString((Object)map7));
        Map<String, List<FetchCacheDatum>> fetchCacheReports = this.reportAggregatedurlPool();
        Element element5 = arena.appendElement("div");
        Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"appendElement(...)");
        Element element6 = element5;
        element6.appendElement("h2").text("Fetch Cache");
        element6.appendElement("pre").text(ExtensionsKt.prettyScentObjectWritter().writeValueAsString(fetchCacheReports));
        String string = document2.getDocument().outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outerHtml(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void buildTaskCounters(Element arena) {
        Element tr;
        Pair pair;
        Pair element$iv;
        Element table;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"queuedTaskCount", (Object)this.taskQueueService.estimatedCount()), TuplesKt.to((Object)"48hourTaskCount", (Object)this.taskMultiHistoryService.getLast48HourEstCount()), TuplesKt.to((Object)"monthlyTaskCount", (Object)this.taskMultiHistoryService.getLastMonthlyEstCount()), TuplesKt.to((Object)"historyTaskCount", (Object)this.taskMultiHistoryService.getLastHistoryEstCount())};
        Map scrapeCounters = MapsKt.mapOf((Pair[])pairArray);
        float speed = this.coreMetrics.getSuccessFetchTasksPerSecond();
        double estimatedSpeed = 2.456;
        Instant now = Instant.now();
        float todayTaskCount = speed * 1.0f * (float)Duration.between(DateTimes.INSTANCE.startOfDay(), now).getSeconds();
        Duration totalRunTime = Duration.between(Instant.parse("2010-12-01T00:00:00.0Z"), now);
        Instant startOfMonth = LocalDate.now().withDayOfMonth(1).atStartOfDay().toInstant(DateTimes.INSTANCE.getZoneOffset());
        Duration monthlyRunTime = Duration.between(startOfMonth, DateTimes.INSTANCE.startOfDay());
        boolean enableEstimatedResidentTaskCounters = false;
        Object object = new Pair[]{TuplesKt.to((Object)"48hourTaskCount", (Object)(estimatedSpeed * 0.5 * (double)172800L)), TuplesKt.to((Object)"monthlyTaskCount", (Object)(estimatedSpeed * (0.5 * (double)monthlyRunTime.getSeconds()) + (double)todayTaskCount)), TuplesKt.to((Object)"historyTaskCount", (Object)(estimatedSpeed * (0.5 * (double)totalRunTime.getSeconds()) + (double)todayTaskCount))};
        object = MapsKt.mapOf((Pair[])object);
        boolean $i$f$map = false;
        void var15_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)((long)((Number)it.getValue()).doubleValue())));
        }
        List estimatedResidentTaskCounters0 = (List)destination$iv$iv;
        List estimatedResidentTaskCounters = CollectionsKt.emptyList();
        arena.appendElement("hr");
        Element element = arena.appendElement("div").addClass("row");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addClass(...)");
        Element row = element;
        Map collectorReports = SystemStatusController.reportAggregatedCollectors$default(this, 0, 1, null);
        List aggregatedCollectorReport = (List)collectorReports.get("aggregated");
        if (aggregatedCollectorReport != null) {
            void $this$forEach$iv;
            Element element2 = row.appendElement("div").addClass("col");
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"addClass(...)");
            Element col = element2;
            Element element3 = col.appendElement("table");
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"appendElement(...)");
            table = element3;
            table.appendElement("caption").text("Running tasks");
            Element tr2 = null;
            Element element4 = table.appendElement("tr");
            Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"appendElement(...)");
            tr2 = element4;
            tr2.append("<td>name</td><td>priority</td><td>size</td><td>estExtSize</td><td>collectedCount</td><td>collectCount</td>");
            Iterable $this$sortedBy$iv = aggregatedCollectorReport;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DataCollectorDatum it = (DataCollectorDatum)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)it.getPriority();
                    it = (DataCollectorDatum)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getPriority()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                DataCollectorDatum d = (DataCollectorDatum)element$iv2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
                String cells = StringsKt.trimMargin$default((String)("\n                    |<td>" + d.getName() + "</td>\n                    |<td>" + d.getPriority() + "</td>\n                    |<td>" + d.getSize() + "</td>\n                    |<td>" + d.getEstimatedExternalSize() + "</td>\n                    |<td>" + d.getCollectedCount() + "</td>\n                    |<td>" + d.getCollectCount() + "</td>\n                    "), null, (int)1, null);
                tr2.append(cells);
            }
        }
        Element element5 = arena.appendElement("div").addClass("row");
        Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"addClass(...)");
        row = element5;
        Element element6 = row.appendElement("div").addClass("col");
        Intrinsics.checkNotNullExpressionValue((Object)element6, (String)"addClass(...)");
        Element col = element6;
        table = null;
        Element element7 = col.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element7, (String)"appendElement(...)");
        table = element7;
        table.appendElement("caption").text("API Tasks Count");
        Object $this$forEach$iv = scrapeCounters;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            pair = element$iv = iterator2.next();
            boolean bl = false;
            String name = (String)pair.getKey();
            long value = ((Number)pair.getValue()).longValue();
            Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
            tr.append("<td>" + name + "</td><td>" + value + "</td>");
        }
        Element element8 = row.appendElement("div").addClass("col");
        Intrinsics.checkNotNullExpressionValue((Object)element8, (String)"addClass(...)");
        col = element8;
        Element element9 = col.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element9, (String)"appendElement(...)");
        table = element9;
        table.appendElement("caption").text("Periodical Tasks Count");
        $this$forEach$iv = estimatedResidentTaskCounters;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            pair = element$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            long value = ((Number)pair.component2()).longValue();
            Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
            tr.append("<td>" + name + "</td><td>" + value + "</td>");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildTextualGauges(Map<String, ? extends List<? extends Object>> gauges, Element body) {
        void $this$filterTo$iv$iv;
        body.appendElement("hr");
        Element element = body.appendElement("div");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element div = element;
        Map<String, ? extends List<? extends Object>> $this$filter$iv = gauges;
        boolean $i$f$filter = false;
        Map<String, ? extends List<? extends Object>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() == this.getBaseUris().size())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        destination$iv$iv.forEach((arg_0, arg_1) -> SystemStatusController.buildTextualGauges$lambda$19((Function2)new Function2<String, List<? extends Object>, Unit>(div){
            final /* synthetic */ Element $div;
            {
                this.$div = $div;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<? extends Object> values) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.$div.appendElement("h6").text(name);
                Element element = this.$div.appendElement("ul");
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
                Element ul3 = element;
                Iterable $this$forEach$iv = values;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator.next();
                    boolean bl = false;
                    ul3.appendElement("li").text(it.toString());
                }
            }
        }, arg_0, arg_1));
    }

    private void buildTable(String caption, Map<String, ? extends List<? extends Object>> gauges, Element body) {
        body.appendElement("hr");
        Element element = body.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element table = element;
        table.appendElement("caption").text(caption);
        Element element2 = table.appendElement("tbody");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element tbody = element2;
        Map<String, ? extends List<? extends Object>> $this$forEach$iv = gauges;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<? extends Object>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Element tr;
            Map.Entry<String, ? extends List<? extends Object>> element$iv;
            Map.Entry<String, ? extends List<? extends Object>> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            List<? extends Object> values = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)tbody.appendElement("tr"), (String)"appendElement(...)");
            tr.appendElement("td").text(name);
            Iterable $this$forEach$iv2 = values;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv2;
                Object it = element$iv2 = iterator2.next();
                boolean bl2 = false;
                tr.appendElement("td").text(it.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"logs"}, produces={"text/html"})
    @ExperimentalPathApi
    @NotNull
    public String listLogs() {
        String logDirectory = System.getProperty("logging.dir");
        Path path = Paths.get(logDirectory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return "";
        }
        Document document2 = Document.createShell((String)(this.getBaseUri() + "/logs"));
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createShell(...)");
        Document document3 = document2;
        Iterable $this$forEach$iv = this.getBaseUris();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Path it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String uri = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)path);
            Iterable iterable = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
            boolean $i$f$filter = false;
            void var12_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(((Object)it.getFileName()).toString());
            }
            String ul3 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", (CharSequence)"<ul>", (CharSequence)"</ul>", (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(uri){
                final /* synthetic */ String $uri;
                {
                    this.$uri = $uri;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return "<li><a href='" + this.$uri + "/logs/tail/200/" + it + "'>" + it + "</a></li>";
                }
            }), (int)24, null);
            document3.append(ul3);
        }
        String string = document3.outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outerHtml(...)");
        return string;
    }

    @GetMapping(value={"logs/tail/{n}/{fileName}"}, produces={"text/plain"})
    @NotNull
    public String tailNLog(@PathVariable @NotNull String fileName, @PathVariable int n) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String logDirectory = System.getProperty("logging.dir");
        Path path = Paths.get(logDirectory, new String[0]).resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            ReversedLinesFileReader reader = new ReversedLinesFileReader(path.toFile());
            List lines = new ArrayList();
            int lineCount = n;
            while (lineCount-- > 0) {
                String string = reader.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                lines.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)lines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    public static /* synthetic */ String tailNLog$default(SystemStatusController systemStatusController, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tailNLog");
        }
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return systemStatusController.tailNLog(string, n);
    }

    @GetMapping(value={"logs/tail/{n}/{fileName}/grep/{match}"}, produces={"text/plain"})
    @NotNull
    public String grepTailNLog(@PathVariable @NotNull String fileName, @PathVariable int n, @PathVariable @NotNull String match) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        String logDirectory = System.getProperty("logging.dir");
        Path path = Paths.get(logDirectory, new String[0]).resolve(fileName);
        if (Files.exists(path, new LinkOption[0])) {
            ReversedLinesFileReader reader = new ReversedLinesFileReader(path.toFile());
            List lines = new ArrayList();
            int lineCount = n;
            while (lineCount-- > 0) {
                String line = reader.readLine();
                Intrinsics.checkNotNull((Object)line);
                if (!StringsKt.contains((CharSequence)line, (CharSequence)match, (boolean)true)) continue;
                String string = reader.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                lines.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)lines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    public static /* synthetic */ String grepTailNLog$default(SystemStatusController systemStatusController, String string, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: grepTailNLog");
        }
        if ((n2 & 2) != 0) {
            n = 100;
        }
        return systemStatusController.grepTailNLog(string, n, string2);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/configuration"})
    @NotNull
    public Map<String, Object> reportConfiguration() {
        Object element$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Map map = new LinkedHashMap();
        Iterable $this$associateTo$iv = (Iterable)this.unmodifiedConfig.unbox();
        boolean $i$f$associateTo = false;
        for (Object element$iv2 : $this$associateTo$iv) {
            Map map2 = map;
            Map.Entry it = (Map.Entry)element$iv2;
            boolean bl = false;
            it = TuplesKt.to(it.getKey(), it.getValue());
            map2.put(it.getFirst(), it.getSecond());
        }
        Environment environment = this.environment;
        Intrinsics.checkNotNull((Object)environment, (String)"null cannot be cast to non-null type org.springframework.core.env.AbstractEnvironment");
        AbstractEnvironment env = (AbstractEnvironment)environment;
        MutablePropertySources mutablePropertySources = env.getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
        Iterable $this$filterIsInstance$iv = (Iterable)mutablePropertySources;
        boolean $i$f$filterIsInstance = false;
        element$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof MapPropertySource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            MapPropertySource it = (MapPropertySource)element$iv3;
            boolean bl2 = false;
            Object object = it.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            map.putAll((Map)object);
        }
        MutablePropertySources mutablePropertySources2 = env.getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources2, (String)"getPropertySources(...)");
        $this$filterIsInstance$iv = (Iterable)mutablePropertySources2;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl2.hasNext()) {
            element$iv$iv = bl2.next();
            if (!(element$iv$iv instanceof EnumerablePropertySource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            EnumerablePropertySource source = (EnumerablePropertySource)element$iv3;
            boolean bl3 = false;
            String[] stringArray = source.getPropertyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPropertyNames(...)");
            Object[] $this$associateWithTo$iv = stringArray;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv4 : $this$associateWithTo$iv) {
                void name;
                String string = (String)element$iv4;
                Object object = element$iv4;
                Map map3 = map;
                boolean bl4 = false;
                Object object2 = source.getProperty((String)name);
                map3.put(object, object2);
            }
        }
        return map;
    }

    @GetMapping(value={"report/fetch/queues"})
    @NotNull
    public Map<String, Object> reportFetchQueue() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"queueCount", (Object)this.taskQueueService.estimatedCount()), TuplesKt.to((Object)"48hourCount", (Object)this.taskMultiHistoryService.getLast48HourEstCount()), TuplesKt.to((Object)"monthlyCount", (Object)this.taskMultiHistoryService.getLastMonthlyEstCount()), TuplesKt.to((Object)"historyCount", (Object)this.taskMultiHistoryService.getLastHistoryEstCount())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/fetch/caches"})
    @NotNull
    public List<FetchCacheDatum> reporturlPool() {
        Iterable $this$filterTo$iv$iv;
        UrlCache it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        UrlPool urlPool = this.globalCacheFactory.getGlobalCache().getUrlPool();
        Iterable $this$map$iv = urlPool.getOrderedCaches().entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UrlCache)it.getValue());
        }
        List caches = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)urlPool.getUnorderedCaches()), (Object)urlPool.getRealTimeCache());
        Iterable $this$filter$iv = caches;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UrlCache)element$iv$iv;
            boolean bl = false;
            if (!(it.getEstimatedSize() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            it = (UrlCache)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int i = 0;
            Iterable iterable2 = it.getQueues();
            boolean $i$f$filter2 = false;
            void var15_17 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Queue it2 = (Queue)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = !((Collection)it2).isEmpty();
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv2 = $this$associate$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv3;
                Queue it3 = (Queue)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)(it3.getClass().getSimpleName() + "." + ++i), (Object)it3.size());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map queues = destination$iv$iv3;
            collection.add(new FetchCacheDatum(it.getName(), it.getSize(), it.getEstimatedSize(), queues));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/aggregation/fetch/caches"})
    @NotNull
    public Map<String, List<FetchCacheDatum>> reportAggregatedurlPool() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/report/fetch/caches");
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object object2;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                Unit unit;
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                boolean bl2 = false;
                object2 = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, List.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                if ((List)response.getBody() != null) {
                    List it2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    result.put(baseUri, it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) != null) {
                Object it3 = object2;
                boolean bl4 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it3, (String)ExceptionsKt.brief$default((Throwable)it3, null, null, (int)3, null), (Object[])new Object[0]);
            }
            collection.add((Unit)(Result.isFailure-impl((Object)object) ? null : object));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/fetch/collectors"}, produces={"application/json"})
    @NotNull
    public List<DataCollectorDatum> reportCollectors(@RequestParam(defaultValue="0") int debug) {
        void $this$mapTo$iv$iv;
        PriorityDataCollector it;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        List list;
        if (debug > 0) {
            list = this.crawlLoop.getCollectors();
        } else {
            Iterable $this$filter$iv = this.crawlLoop.getCollectors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PriorityDataCollector)element$iv$iv;
                boolean bl = false;
                if (!(it.getEstimatedSize() + it.getCollectedCount() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List collectors = list;
        Iterable $this$sortedBy$iv = collectors;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PriorityDataCollector it = (PriorityDataCollector)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (PriorityDataCollector)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PriorityDataCollector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Priority13 priority13 = Priority13.Companion.valueOfOrNull(it.getPriority());
            if (priority13 == null) {
                priority13 = Priority13.LOWEST;
            }
            Priority13 priority132 = priority13;
            int n = it.getSize();
            int n2 = it.getEstimatedSize();
            int n3 = it.getEstimatedExternalSize();
            int n4 = it.getCollectCount();
            int n5 = it.getCollectedCount();
            collection.add(new DataCollectorDatum(string, priority132, n4, n5, n, n2, n3));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List reportCollectors$default(SystemStatusController systemStatusController, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportCollectors");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return systemStatusController.reportCollectors(n);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/aggregation/fetch/collectors"}, produces={"application/json"})
    @NotNull
    public Map<String, List<DataCollectorDatum>> reportAggregatedCollectors(@RequestParam(defaultValue="0") int debug) {
        void $this$mapTo$iv$iv;
        Map groupedCollectors;
        void $this$groupByTo$iv$iv;
        Iterable iterable;
        String it;
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        Map collectors = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            object = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/report/fetch/collectors");
        }
        List urls = (List)destination$iv$iv;
        if (debug > 0) {
            $this$map$iv = urls;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it + "?debug=" + debug);
            }
            urls = (List)destination$iv$iv;
        }
        $this$map$iv = urls;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Object $i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                Unit unit;
                ResponseEntity response;
                void url;
                Throwable $this$getForEntity$iv;
                boolean $i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22 = false;
                RestOperations restOperations = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)url, String.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                if ((String)response.getBody() != null) {
                    String it2;
                    boolean bl2 = false;
                    Map map = collectors;
                    Intrinsics.checkNotNullExpressionValue((Object)ExtensionsKt.scentObjectMapper().readValue(it2, (TypeReference)new TypeReference<List<? extends DataCollectorDatum>>(){}), (String)"readValue(...)");
                    map.put(url, iterable);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22 = Result.constructor-impl(unit);
            }
            catch (Throwable $this$getForEntity$iv) {
                $i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$getForEntity$iv));
            }
            if (Result.exceptionOrNull-impl((Object)$i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22) != null) {
                Throwable it3 = $this$getForEntity$iv;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it3, (String)ExceptionsKt.brief$default((Throwable)it3, null, null, (int)3, null), (Object[])new Object[0]);
            }
            collection.add(Result.box-impl((Object)$i$a$-runCatching-SystemStatusController$reportAggregatedCollectors$2$22));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = CollectionsKt.flatten((Iterable)collectors.values());
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            DataCollectorDatum it4 = (DataCollectorDatum)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it4.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv2 = groupedCollectors = destination$iv$iv2;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        object = $this$mapTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            int n;
            DataCollectorDatum it5;
            int n2;
            Iterable $this$sumBy$iv;
            DataCollectorDatum dataCollectorDatum;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv3;
            boolean bl = false;
            String name = (String)entry.getKey();
            List collectors2 = (List)entry.getValue();
            DataCollectorDatum $this$reportAggregatedCollectors_u24lambda_u2454_u24lambda_u2453 = dataCollectorDatum = new DataCollectorDatum(name, ((DataCollectorDatum)CollectionsKt.first((List)collectors2)).getPriority(), 0, 0, 0, 0, 0, 124, null);
            boolean bl5 = false;
            iterable = collectors2;
            DataCollectorDatum dataCollectorDatum2 = $this$reportAggregatedCollectors_u24lambda_u2454_u24lambda_u2453;
            boolean $i$f$sumBy32 = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                DataCollectorDatum dataCollectorDatum3 = (DataCollectorDatum)element$iv;
                n2 = sum$iv;
                boolean bl6 = false;
                n = it5.getSize();
                sum$iv = n2 + n;
            }
            n2 = sum$iv;
            dataCollectorDatum2.setSize(n2);
            $this$sumBy$iv = collectors2;
            dataCollectorDatum2 = $this$reportAggregatedCollectors_u24lambda_u2454_u24lambda_u2453;
            Iterator $i$f$sumBy32 = $this$sumBy$iv.iterator();
            if (!$i$f$sumBy32.hasNext()) {
                throw new NoSuchElementException();
            }
            Object it6 = (DataCollectorDatum)$i$f$sumBy32.next();
            boolean bl7 = false;
            it6 = it6.getEstimatedExternalSize();
            while ($i$f$sumBy32.hasNext()) {
                DataCollectorDatum it7 = (DataCollectorDatum)$i$f$sumBy32.next();
                $i$a$-minOf-SystemStatusController$reportAggregatedCollectors$aggregatedCollector$1$1$2 = false;
                Comparable comparable = Integer.valueOf(it7.getEstimatedExternalSize());
                if (it6.compareTo(comparable) <= 0) continue;
                it6 = comparable;
            }
            dataCollectorDatum2.setEstimatedExternalSize(((Number)it6).intValue());
            $this$sumBy$iv = collectors2;
            dataCollectorDatum2 = $this$reportAggregatedCollectors_u24lambda_u2454_u24lambda_u2453;
            $i$f$sumBy32 = false;
            sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                it5 = (DataCollectorDatum)element$iv;
                n2 = sum$iv;
                boolean bl8 = false;
                n = it5.getCollectCount();
                sum$iv = n2 + n;
            }
            n2 = sum$iv;
            dataCollectorDatum2.setCollectCount(n2);
            $this$sumBy$iv = collectors2;
            dataCollectorDatum2 = $this$reportAggregatedCollectors_u24lambda_u2454_u24lambda_u2453;
            $i$f$sumBy32 = false;
            sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                it5 = (DataCollectorDatum)element$iv;
                n2 = sum$iv;
                boolean bl9 = false;
                n = it5.getCollectedCount();
                sum$iv = n2 + n;
            }
            n2 = sum$iv;
            dataCollectorDatum2.setCollectedCount(n2);
            collection.add(dataCollectorDatum);
        }
        List aggregatedCollector = (List)destination$iv$iv3;
        collectors.put("aggregated", aggregatedCollector);
        return collectors;
    }

    public static /* synthetic */ Map reportAggregatedCollectors$default(SystemStatusController systemStatusController, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportAggregatedCollectors");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return systemStatusController.reportAggregatedCollectors(n);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/cluster/fetch/collectors"}, produces={"application/json"})
    @NotNull
    public Map<String, List<DataCollectorDatum>> reportClusterCollectors(@RequestParam(defaultValue="0") int debug) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/report/fetch/collectors");
        }
        List urls = (List)destination$iv$iv;
        if (debug > 0) {
            $this$map$iv = urls;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it + "?debug=" + debug);
            }
            urls = (List)destination$iv$iv;
        }
        $this$map$iv = urls;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = this;
            try {
                Unit unit;
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                SystemStatusController $this$reportClusterCollectors_u24lambda_u2460_u24lambda_u2458 = object2;
                boolean bl2 = false;
                RestOperations restOperations = (RestOperations)$this$reportClusterCollectors_u24lambda_u2460_u24lambda_u2458.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, List.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                if ((List)response.getBody() != null) {
                    List it2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    result.put(baseUri, it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it3 = object = throwable;
                boolean bl4 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it3, (String)ExceptionsKt.brief$default((Throwable)it3, null, null, (int)3, null), (Object[])new Object[0]);
            }
            collection.add(Result.box-impl((Object)object2));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return result;
    }

    public static /* synthetic */ Map reportClusterCollectors$default(SystemStatusController systemStatusController, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportClusterCollectors");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return systemStatusController.reportClusterCollectors(n);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"report/parse/filters"})
    @NotNull
    public List<String> reportParseFilters() {
        void $this$mapTo$iv$iv;
        this.logger.info("Default pulsar context: " + PulsarContexts.create().getClass());
        this.logger.info("Session context: " + this.session.getContext().getClass());
        ParseFilters parseFilters = (ParseFilters)this.session.getContext().getBean(Reflection.getOrCreateKotlinClass(ParseFilters.class));
        Iterable $this$map$iv = parseFilters.getParseFilters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParseFilter parseFilter = (ParseFilter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId() + ": " + it.getClass().getName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/parse/filters"}, produces={"application/json"})
    @NotNull
    public Map<String, List<String>> reportClusterParseFilters() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/report/parse/filters");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object object2;
            Object object3;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            try {
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                boolean bl2 = false;
                object3 = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, List.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                object2 = Result.constructor-impl((Object)((List)response.getBody()));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it2 = object3 = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
            }
            object3 = CollectionsKt.emptyList();
            List list = (List)(Result.isFailure-impl((Object)object2) ? object3 : object2);
            object.put(t, list);
        }
        return result$iv;
    }

    @GetMapping(value={"metrics/enum/counters"})
    @NotNull
    public String enumPrimaryCounters() {
        return MetricsSystem.Companion.getReg().getEnumCounterRegistry().getStatus(true);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/enum/counters"}, produces={"application/json"})
    @NotNull
    public Map<String, String> clusterEnumCounters() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/metrics/enum/counters");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void baseUri;
            void $this$getForObject$iv;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            RestOperations restOperations = (RestOperations)this.restTemplate;
            Object[] uriVariables$iv = new Object[]{};
            boolean $i$f$getForObject = false;
            String string = (String)$this$getForObject$iv.getForObject((String)baseUri, String.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length));
            object.put(t, string);
        }
        return result$iv;
    }

    @GetMapping(value={"metrics"}, produces={"application/json"})
    @NotNull
    public Map<String, Map<String, Metric>> metrics() {
        Function1<Map.Entry<String, ? extends Metric>, Boolean> predicate$iv;
        Map $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Pair[] pairArray = new Pair[4];
        SortedMap sortedMap = this.getRegistry().getGauges();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"getGauges(...)");
        Map map = sortedMap;
        Function1<Map.Entry<String, ? extends Metric>, Boolean> function1 = this.metricsFilter;
        String string = "gauges";
        int n = 0;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map2 = destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)map2);
        SortedMap sortedMap2 = this.getRegistry().getCounters();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap2, (String)"getCounters(...)");
        $this$filter$iv = sortedMap2;
        predicate$iv = this.metricsFilter;
        string = "counters";
        n = 1;
        pairArray2 = pairArray;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        map2 = destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)map2);
        SortedMap sortedMap3 = this.getRegistry().getMeters();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap3, (String)"getMeters(...)");
        $this$filter$iv = sortedMap3;
        predicate$iv = this.metricsFilter;
        string = "meters";
        n = 2;
        pairArray2 = pairArray;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        map2 = destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)map2);
        SortedMap sortedMap4 = this.getRegistry().getHistograms();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap4, (String)"getHistograms(...)");
        $this$filter$iv = sortedMap4;
        predicate$iv = this.metricsFilter;
        string = "histograms";
        n = 3;
        pairArray2 = pairArray;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        map2 = destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)map2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/gauges"}, produces={"application/json"})
    @NotNull
    public Map<String, Object> gauges() {
        void $this$associateTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        SortedMap sortedMap = this.getRegistry().getGauges();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"getGauges(...)");
        Map map = sortedMap;
        Function1<Map.Entry<String, ? extends Metric>, Boolean> predicate$iv = this.metricsFilter;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$associate$iv = destination$iv$iv.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$filterTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Map.Entry element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)((Gauge)it.getValue()).getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/gauges"}, produces={"application/json"})
    @NotNull
    public Map<String, Map<String, Object>> clusterGauges() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/metrics/gauges");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object object2;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Object object3 = this;
            try {
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                SystemStatusController $this$clusterGauges_u24lambda_u2472_u24lambda_u2470 = object3;
                boolean bl2 = false;
                RestOperations restOperations = (RestOperations)$this$clusterGauges_u24lambda_u2472_u24lambda_u2470.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                object2 = Result.constructor-impl((Object)((Map)response.getBody()));
            }
            catch (Throwable bl2) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Object it2 = object2 = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
            }
            object2 = MapsKt.emptyMap();
            Map map = (Map)(Result.isFailure-impl((Object)object3) ? object2 : object3);
            object.put(t, map);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/aggregation/gauges"}, produces={"application/json"})
    @NotNull
    public Map<String, List<Object>> reportAggregatedGauges(@RequestParam(defaultValue=".+") @NotNull String pattern) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/metrics/gauges");
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            Object object = this;
            try {
                Unit unit;
                ResponseEntity response;
                void baseUri;
                Map $this$getForEntity$iv;
                $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476 = object;
                boolean bl2 = false;
                RestOperations restOperations = (RestOperations)((SystemStatusController)$this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476).restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                Map map = $this$getForEntity$iv = (Map)response.getBody();
                if (map != null) {
                    Intrinsics.checkNotNull((Object)map);
                    Map $this$forEach$iv = $this$getForEntity$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl3 = false;
                        String name = (String)entry.getKey();
                        Object value = entry.getValue();
                        CharSequence charSequence = name;
                        if (!new Regex(pattern).containsMatchIn(charSequence)) continue;
                        result.computeIfAbsent(name, arg_0 -> SystemStatusController.reportAggregatedGauges$lambda$78$lambda$76$lambda$75$lambda$74(reportAggregatedGauges.2.1.1.1.INSTANCE, arg_0)).add(value);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476 = Result.constructor-impl(unit);
            }
            catch (Throwable bl2) {
                $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it2 = $this$reportAggregatedGauges_u24lambda_u2478_u24lambda_u2476 = throwable;
                boolean bl4 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
            }
            collection.add(Result.box-impl((Object)object));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = result.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List values;
            block19: {
                Object it3;
                boolean bl5;
                boolean $i$f$all;
                Iterable $this$all$iv;
                block18: {
                    values = (List)element$iv;
                    boolean bl6 = false;
                    $this$all$iv = values;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        Iterator bl7 = $this$all$iv.iterator();
                        while (bl7.hasNext()) {
                            Object element$iv2;
                            it3 = element$iv2 = bl7.next();
                            boolean bl8 = false;
                            if (it3 instanceof Integer) continue;
                            bl5 = false;
                            break block18;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    $this$all$iv = values;
                    Object $this$sumBy$iv = values;
                    boolean $i$f$sumBy = false;
                    int sum$iv = 0;
                    it3 = $this$sumBy$iv.iterator();
                    while (it3.hasNext()) {
                        void it4;
                        Object element$iv3;
                        Object bl4 = element$iv3 = it3.next();
                        int n = sum$iv;
                        boolean bl9 = false;
                        Intrinsics.checkNotNull((Object)it4, (String)"null cannot be cast to non-null type kotlin.Int");
                        int n2 = (Integer)it4;
                        sum$iv = n + n2;
                    }
                    $this$sumBy$iv = sum$iv;
                    $this$all$iv.add($this$sumBy$iv);
                    continue;
                }
                $this$all$iv = values;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator $i$f$sumBy = $this$all$iv.iterator();
                    while ($i$f$sumBy.hasNext()) {
                        Object element$iv4;
                        it3 = element$iv4 = $i$f$sumBy.next();
                        boolean bl10 = false;
                        if (it3 instanceof Double || it3 instanceof Float) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            Collection collection2 = values;
            Iterable $this$sumByDouble$iv = values;
            boolean $i$f$sumByDouble = false;
            double sum$iv = 0.0;
            Iterator iterator = $this$sumByDouble$iv.iterator();
            while (iterator.hasNext()) {
                void it5;
                Object element$iv5;
                Object bl9 = element$iv5 = iterator.next();
                double d = sum$iv;
                boolean bl11 = false;
                Intrinsics.checkNotNull((Object)it5, (String)"null cannot be cast to non-null type kotlin.Double");
                double d2 = (Double)it5;
                sum$iv = d + d2;
            }
            Double d = sum$iv;
            collection2.add(d);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/counters"}, produces={"application/json"})
    @NotNull
    public Map<String, Integer> counters() {
        void $this$associateTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        SortedMap sortedMap = this.getRegistry().getCounters();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"getCounters(...)");
        Map map = sortedMap;
        Function1<Map.Entry<String, ? extends Metric>, Boolean> predicate$iv = this.metricsFilter;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$associate$iv = destination$iv$iv.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$filterTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Map.Entry element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)((int)((Counter)it.getValue()).getCount()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/counters"}, produces={"application/json"})
    @NotNull
    public Map<String, Map<String, Integer>> clusterCounters() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/metrics/counters");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object object2;
            Object object3;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            try {
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                boolean bl2 = false;
                object3 = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                object2 = Result.constructor-impl((Object)((Map)response.getBody()));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it2 = object3 = throwable;
                boolean bl3 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
            }
            object3 = MapsKt.emptyMap();
            Map map = (Map)(Result.isFailure-impl((Object)object2) ? object3 : object2);
            object.put(t, map);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/aggregation/counters"}, produces={"application/json"})
    @NotNull
    public Map<String, List<Integer>> countersAggregation() {
        void $this$mapTo$iv$iv;
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it + "/metrics/counters");
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResponseEntity response;
            Map map;
            void $this$getForEntity$iv;
            Object item$iv$iv;
            String baseUri = (String)element$iv;
            boolean bl = false;
            item$iv$iv = (RestOperations)this.restTemplate;
            Object[] uriVariables$iv = new Object[]{};
            boolean $i$f$getForEntity = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity(baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
            Map map2 = map = (Map)response.getBody();
            if (map2 == null) continue;
            Intrinsics.checkNotNull((Object)map2);
            Map $this$forEach$iv2 = map;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                int count = ((Number)entry.getValue()).intValue();
                result.computeIfAbsent(name, arg_0 -> SystemStatusController.countersAggregation$lambda$92$lambda$91$lambda$90(countersAggregation.2.1.1.INSTANCE, arg_0)).add(count);
            }
        }
        $this$forEach$iv = result.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            it.add(CollectionsKt.sumOfInt((Iterable)it));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/meters"}, produces={"application/json"})
    @NotNull
    public Map<String, Meter> meters() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        SortedMap sortedMap = this.getRegistry().getMeters();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"getMeters(...)");
        Map map = sortedMap;
        Function1<Map.Entry<String, ? extends Metric>, Boolean> predicate$iv = this.metricsFilter;
        boolean $i$f$filter = false;
        void var4_4 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/aggregation/meters"}, produces={"application/json"})
    @NotNull
    public Map<String, List<Meter>> metersAggregation() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/metrics/meters");
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object object2;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                Unit unit;
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                boolean bl2 = false;
                object2 = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                Object object3 = object2 = (Map)response.getBody();
                if (object3 != null) {
                    Intrinsics.checkNotNull((Object)object3);
                    Object $this$forEach$iv = object2;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl3 = false;
                        String name = (String)entry.getKey();
                        Meter value = (Meter)entry.getValue();
                        result.computeIfAbsent(name, arg_0 -> SystemStatusController.metersAggregation$lambda$99$lambda$97$lambda$96$lambda$95(metersAggregation.2.1.1.1.INSTANCE, arg_0)).add(value);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.exceptionOrNull-impl((Object)object) != null) {
                Object it2 = object2;
                boolean bl4 = false;
                LogsKt.warnInterruptible((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
            }
            collection.add(Result.box-impl((Object)object));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/meters"}, produces={"application/json"})
    @NotNull
    public Map<String, Map<String, Meter>> clusterMeters() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/metrics/meters");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Map map;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            try {
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                RestOperations restOperations = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                map = (Map)response.getBody();
            }
            catch (Exception e) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            object.put(t, map2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/histograms"}, produces={"application/json"})
    @NotNull
    public Map<String, Histogram> histograms() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        SortedMap sortedMap = this.getRegistry().getHistograms();
        Intrinsics.checkNotNullExpressionValue((Object)sortedMap, (String)"getHistograms(...)");
        Map map = sortedMap;
        Function1<Map.Entry<String, ? extends Metric>, Boolean> predicate$iv = this.metricsFilter;
        boolean $i$f$filter = false;
        void var4_4 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/aggregation/histograms"}, produces={"application/json"})
    @NotNull
    public Map<String, List<Meter>> histogramsAggregation() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Map result = new LinkedHashMap();
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + "/metrics/histograms");
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Unit unit;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                Unit unit2;
                ResponseEntity response;
                void baseUri;
                Map $this$getForEntity$iv;
                RestOperations restOperations = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                Map map = $this$getForEntity$iv = (Map)response.getBody();
                if (map != null) {
                    Intrinsics.checkNotNull((Object)map);
                    Map $this$forEach$iv = $this$getForEntity$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry entry = element$iv = iterator.next();
                        boolean bl2 = false;
                        String name = (String)entry.getKey();
                        Meter value = (Meter)entry.getValue();
                        result.computeIfAbsent(name, arg_0 -> SystemStatusController.histogramsAggregation$lambda$105$lambda$104$lambda$103(histogramsAggregation.2.1.1.INSTANCE, arg_0)).add(value);
                    }
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Exception e) {
                LogsKt.warnInterruptible((Object)this, (Throwable)e);
                unit = Unit.INSTANCE;
            }
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"metrics/cluster/histograms"}, produces={"application/json"})
    @NotNull
    public Map<String, Map<String, Histogram>> clusterHistograms() {
        String it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getBaseUris();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it + "/metrics/histograms");
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Map map;
            it = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            try {
                ResponseEntity response;
                void baseUri;
                void $this$getForEntity$iv;
                RestOperations restOperations = (RestOperations)this.restTemplate;
                Object[] uriVariables$iv = new Object[]{};
                boolean $i$f$getForEntity = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getForEntity$iv.getForEntity((String)baseUri, Map.class, Arrays.copyOf(uriVariables$iv, uriVariables$iv.length)), (String)"getForEntity(url, T::class.java, *uriVariables)");
                map = (Map)response.getBody();
            }
            catch (Exception e) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            object.put(t, map2);
        }
        return result$iv;
    }

    private static final void buildTextualGauges$lambda$19(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final List reportAggregatedGauges$lambda$78$lambda$76$lambda$75$lambda$74(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List countersAggregation$lambda$92$lambda$91$lambda$90(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List metersAggregation$lambda$99$lambda$97$lambda$96$lambda$95(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List histogramsAggregation$lambda$105$lambda$104$lambda$103(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

