/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.scent.boot.autoconfigure.persist.ScrapeTaskHistoryRepository;
import ai.platon.scent.persist.mongo.v1.ScrapeTaskHistory;
import com.mongodb.client.ListIndexesIterable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lai/platon/scent/rest/api/service/scrape/TaskHistoryService;", "", "repository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskHistoryRepository;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskHistoryRepository;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "collectionName", "", "count", "", "authToken", "startTime", "Ljava/time/Instant;", "endTime", "countByStatusCode", "statusCode", "", "countFinished", "countPending", "countSuccess", "estimatedCount", "findAll", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/persist/mongo/v1/ScrapeTaskHistory;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllByStatusCode", "findAllByStatusCodeAndCreatedAtAfter", "createdAt", "findAllByUrl", "url", "findById", "id", "findTopByUrl", "listIndexes", "Lcom/mongodb/client/ListIndexesIterable;", "Lorg/bson/Document;", "scent-rest"})
public class TaskHistoryService {
    @NotNull
    private final ScrapeTaskHistoryRepository repository;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final String collectionName;

    public TaskHistoryService(@NotNull ScrapeTaskHistoryRepository repository, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        this.repository = repository;
        this.mongoTemplate = mongoTemplate;
        String string = this.mongoTemplate.getCollectionName(ScrapeTaskHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCollectionName(...)");
        this.collectionName = string;
    }

    @NotNull
    public ListIndexesIterable<Document> listIndexes() {
        ListIndexesIterable listIndexesIterable = this.mongoTemplate.getDb().getCollection(this.collectionName).listIndexes();
        Intrinsics.checkNotNullExpressionValue((Object)listIndexesIterable, (String)"listIndexes(...)");
        return listIndexesIterable;
    }

    @Nullable
    public ScrapeTaskHistory findById(@NotNull String authToken, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.repository.findById((Object)id).filter(arg_0 -> TaskHistoryService.findById$lambda$0((Function1)new Function1<ScrapeTaskHistory, Boolean>(authToken){
            final /* synthetic */ String $authToken;
            {
                this.$authToken = $authToken;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ScrapeTaskHistory it) {
                return Intrinsics.areEqual((Object)it.getAuthToken(), (Object)this.$authToken);
            }
        }, arg_0)).orElse(null);
    }

    @NotNull
    public Page<ScrapeTaskHistory> findAll(@NotNull String authToken, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthToken(authToken, pageable);
    }

    @NotNull
    public Page<ScrapeTaskHistory> findAllByUrl(@NotNull String authToken, @NotNull String url, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskUrl(authToken, url, pageable);
    }

    @Nullable
    public ScrapeTaskHistory findTopByUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.repository.findTopByTaskUrl(url).orElse(null);
    }

    @Nullable
    public ScrapeTaskHistory findTopByUrl(@NotNull String authToken, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.repository.findTopByAuthTokenAndTaskUrl(authToken, url).orElse(null);
    }

    @NotNull
    public Page<ScrapeTaskHistory> findAllByStatusCode(@NotNull String authToken, int statusCode, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCode(authToken, statusCode, pageable);
    }

    @NotNull
    public Page<ScrapeTaskHistory> findAllByStatusCodeAndCreatedAtAfter(@NotNull String authToken, int statusCode, @NotNull Instant createdAt, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCodeAndCreatedAtAfter(authToken, statusCode, createdAt, pageable);
    }

    public long estimatedCount(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.mongoTemplate.estimatedCount(ScrapeTaskHistory.class);
    }

    public long count(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthToken(authToken);
    }

    public long count(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime);
    }

    public long countPending(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, false);
    }

    public long countPending(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, false, startTime, endTime);
    }

    public long countFinished(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, true);
    }

    public long countFinished(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, true, startTime, endTime);
    }

    public long countSuccess(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.countByStatusCode(authToken, 200);
    }

    public long countSuccess(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskStatusCodeAndCreatedAtBetween(authToken, 200, startTime, endTime);
    }

    public long countByStatusCode(@NotNull String authToken, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskStatusCode(authToken, statusCode);
    }

    private static final boolean findById$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

