/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.v2;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.sql.SQLTemplate;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.common.urls.NormURL;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTaskStatusV2Repository;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.crawl.serialize.ScrapeRequestV2;
import ai.platon.scent.crawl.serialize.ScrapeResponseV2;
import ai.platon.scent.crawl.serialize.ScrapeStatusRequest;
import ai.platon.scent.crawl.sql.ScrapeAPIUtils;
import ai.platon.scent.crawl.urls.ScrapeHyperlinkV2;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.persist.mongo.v2.ScrapeTaskStatusV2;
import ai.platon.scent.persist.mongo.v2.XSqlTaskStatus;
import ai.platon.scent.rest.api.common.IllegalRequestException;
import ai.platon.scent.rest.api.common.IllegalXSQLException;
import ai.platon.scent.rest.api.common.NotAuthorizedException;
import ai.platon.scent.rest.api.common.NotFoundException;
import ai.platon.scent.rest.api.service.v2.ScrapeServiceV2;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010!\u001a\u00020\"H\u0012J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020\u0015H\u0012J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010!\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020)H\u0012J\u0018\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0010\u00100\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00101\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0012R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "Lai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler;", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "taskRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskStatusV2Repository;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskStatusV2Repository;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "responseCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/scent/crawl/serialize/ScrapeResponseV2;", "getTaskRepository", "()Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskStatusV2Repository;", "collectLoadedHyperlink", "", "priority", "", "hyperlink", "Lai/platon/pulsar/common/urls/UrlAware;", "createHyperlink", "Lai/platon/scent/crawl/urls/ScrapeHyperlinkV2;", "task", "Lai/platon/scent/persist/mongo/v2/ScrapeTaskStatusV2;", "createScrapeHyperlinkOrNull", "createTask", "Lkotlin/Pair;", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequestV2;", "deleteAllTasksBefore", "endTime", "Ljava/time/Instant;", "executeQuery", "executeUnfinishedTasks0", "getScrapeTaskStatus", "Lai/platon/scent/crawl/serialize/ScrapeStatusRequest;", "getStatus", "loadTask", "minifyScrapeTaskStatusBetween", "startTime", "normalizeUrl", "Lai/platon/pulsar/skeleton/common/urls/NormURL;", "submit", "updateTask", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nScrapeServiceV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrapeServiceV2.kt\nai/platon/scent/rest/api/service/v2/ScrapeServiceV2\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1313#2,2:219\n1855#3,2:221\n1620#3,3:223\n*S KotlinDebug\n*F\n+ 1 ScrapeServiceV2.kt\nai/platon/scent/rest/api/service/v2/ScrapeServiceV2\n*L\n126#1:219,2\n154#1:221,2\n196#1:223,3\n*E\n"})
public class ScrapeServiceV2
extends ScrapeTaskHandler {
    @NotNull
    private final ScrapeTaskStatusV2Repository taskRepository;
    private final Logger logger;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, ScrapeResponseV2> responseCache;

    public ScrapeServiceV2(@NotNull GlobalCacheFactory globalCacheFactory, @NotNull ScrapeTaskStatusV2Repository taskRepository, @NotNull ScentCrawlLoop crawlLoop, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)taskRepository, (String)"taskRepository");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        super(crawlLoop, globalCacheFactory, mongoTemplate, "v2");
        this.taskRepository = taskRepository;
        this.logger = LoggerFactory.getLogger(ScrapeServiceV2.class);
        Duration duration = this.getResponseCacheTTL();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-responseCacheTTL>(...)");
        this.responseCache = new ConcurrentExpiringLRUCache(duration, 1000);
    }

    @NotNull
    public ScrapeTaskStatusV2Repository getTaskRepository() {
        return this.taskRepository;
    }

    @NotNull
    public String submit(@NotNull ScrapeRequestV2 request) throws NotAuthorizedException, IllegalRequestException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Pair<String, ScrapeTaskStatusV2> pair = this.createTask(request);
        String id = (String)pair.component1();
        ScrapeTaskStatusV2 task = (ScrapeTaskStatusV2)pair.component2();
        ScrapeHyperlinkV2 hyperlink = this.createHyperlink(task);
        if (request.getAsap()) {
            this.submitFetchUrlOrThrow(task.getPriority(), (UrlAware)hyperlink);
        }
        long sequence = this.getMetrics().getScrapes().getCounter().getCount();
        Object[] objectArray = new Object[]{sequence, task.getRemoteAddr(), hyperlink.getConfiguredUrl()};
        this.logger.info("{}. Accepted v2 | {} | {}", objectArray);
        return id;
    }

    @NotNull
    public ScrapeResponseV2 getStatus(@NotNull ScrapeStatusRequest request) throws NotFoundException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ScrapeTaskStatusV2 task = this.loadTask(request);
        return (ScrapeResponseV2)this.responseCache.computeIfAbsent((Object)request.getId(), (Function1)new Function1<String, ScrapeResponseV2>(task){
            final /* synthetic */ ScrapeTaskStatusV2 $task;
            {
                this.$task = $task;
                super(1);
            }

            @NotNull
            public final ScrapeResponseV2 invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ScrapeResponseV2(this.$task);
            }
        });
    }

    @NotNull
    public ScrapeTaskStatusV2 getScrapeTaskStatus(@NotNull ScrapeStatusRequest request) throws NotFoundException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.loadTask(request);
    }

    @NotNull
    public ScrapeResponseV2 executeQuery(@NotNull ScrapeRequestV2 request) throws IllegalRequestException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Pair<String, ScrapeTaskStatusV2> pair = this.createTask(request);
        String id = (String)pair.component1();
        ScrapeTaskStatusV2 task = (ScrapeTaskStatusV2)pair.component2();
        ScrapeHyperlinkV2 hyperlink = this.createHyperlink(task);
        this.getUrlPool().getHighestCache().getReentrantQueue().add(hyperlink);
        Object object = hyperlink.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ScrapeResponseV2)object;
    }

    public void deleteAllTasksBefore(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Instant now = Instant.now();
        long count = this.getTaskRepository().deleteAllByDoneAndCreatedAtBefore(true, endTime);
        Long l = count;
        Intrinsics.checkNotNull((Object)now);
        this.logger.info("Removed {} old scrape tasks in {}", (Object)l, (Object)DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)now, null, (int)2, null));
    }

    public void minifyScrapeTaskStatusBetween(@NotNull Instant startTime, @NotNull Instant endTime) {
        Update update;
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Criteria criteria = Criteria.where((String)"createdAt").gte((Object)startTime).lt((Object)endTime);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"lt(...)");
        Criteria criteria2 = criteria;
        Query query = new Query().addCriteria((CriteriaDefinition)criteria2);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"addCriteria(...)");
        Query query2 = query;
        Update $this$minifyScrapeTaskStatusBetween_u24lambda_u240 = update = new Update();
        boolean bl = false;
        $this$minifyScrapeTaskStatusBetween_u24lambda_u240.unset("responseBody");
        $this$minifyScrapeTaskStatusBetween_u24lambda_u240.unset("responseEntities");
        $this$minifyScrapeTaskStatusBetween_u24lambda_u240.unset("resultSets");
        $this$minifyScrapeTaskStatusBetween_u24lambda_u240.unset("syncResponseBody");
        Update update2 = update;
        this.getMongoTemplate().updateMulti(query2, (UpdateDefinition)update2, ScrapeTaskStatusV2.class);
    }

    /*
     * WARNING - void declaration
     */
    private void executeUnfinishedTasks0() {
        void $this$forEach$iv;
        int group2 = ClusterTools.INSTANCE.getInstancePartition();
        Instant days1before = Instant.now().minus(Duration.ofDays(1L));
        ScrapeTaskStatusV2Repository scrapeTaskStatusV2Repository = this.getTaskRepository();
        Intrinsics.checkNotNull((Object)days1before);
        List tasks = scrapeTaskStatusV2Repository.findAllByStatusCodeAndGroupAndCreatedAtAfter(201, group2, days1before);
        this.logger.info("Executing {} unfinished scraping tasks", (Object)tasks.size());
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)tasks), (Function1)executeUnfinishedTasks0.1.INSTANCE), (Function1)((Function1)new Function1<ScrapeTaskStatusV2, Pair<? extends Integer, ? extends ScrapeHyperlinkV2>>(this){
            final /* synthetic */ ScrapeServiceV2 this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<Integer, ScrapeHyperlinkV2> invoke(@NotNull ScrapeTaskStatusV2 task) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                ScrapeHyperlinkV2 scrapeHyperlinkV2 = ScrapeServiceV2.access$createScrapeHyperlinkOrNull(this.this$0, task);
                if (scrapeHyperlinkV2 != null) {
                    ScrapeHyperlinkV2 it = scrapeHyperlinkV2;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)task.getPriority(), (Object)it);
                } else {
                    pair = null;
                }
                return pair;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.collectLoadedHyperlink(((Number)it.getFirst()).intValue(), (UrlAware)it.getSecond());
        }
    }

    private ScrapeHyperlinkV2 createScrapeHyperlinkOrNull(ScrapeTaskStatusV2 task) {
        try {
            return this.createHyperlink(task);
        }
        catch (IllegalArgumentException e) {
            task.setStatusCode(400);
            this.getTaskRepository().save((Object)task);
        }
        catch (Throwable e) {
            task.setStatusCode(412);
            this.getTaskRepository().save((Object)task);
        }
        return null;
    }

    private ScrapeHyperlinkV2 createHyperlink(ScrapeTaskStatusV2 task) throws IllegalRequestException, IllegalXSQLException {
        this.getMetrics().getScrapes().mark();
        return new ScrapeHyperlinkV2(this.normalizeUrl(task), task, this.getSession(), (SinkCommitter)this.getSinkCommitter(), (Function1)new Function1<ScrapeTaskStatusV2, Unit>((Object)this){

            public final void invoke(@NotNull ScrapeTaskStatusV2 p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ScrapeServiceV2.access$updateTask((ScrapeServiceV2)((Object)this.receiver), p0);
            }
        }, this.getGlobalCacheFactory());
    }

    private NormURL normalizeUrl(ScrapeTaskStatusV2 task) throws IllegalRequestException, IllegalXSQLException {
        Iterable $this$forEach$iv = task.getSqlTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XSqlTaskStatus it = (XSqlTaskStatus)element$iv;
            boolean bl = false;
            ScrapeAPIUtils.INSTANCE.sanitizeSQL(it.getSql());
        }
        ScrapeAPIUtils.INSTANCE.checkArgs(task.getArgs());
        String url0 = task.getUrl();
        String args0 = task.getArgs();
        Pair pair = UrlUtils.splitUrlArgs((String)url0);
        String url = (String)pair.component1();
        String args1 = (String)pair.component2();
        return new NormURL(url, (LoadOptions)this.getSession().options(args0 + " " + args1), null, null, 12, null);
    }

    private void collectLoadedHyperlink(int priority, UrlAware hyperlink) {
        UrlCache urlCache = (UrlCache)this.getUrlPool().getOrderedCaches().get(priority);
        if (urlCache == null) {
            urlCache = this.getUrlPool().getNormalCache();
        }
        UrlCache cache = urlCache;
        cache.getReentrantQueue().add(hyperlink);
        this.getMetrics().getLoadedScrapes().mark();
    }

    private ScrapeTaskStatusV2 loadTask(ScrapeStatusRequest request) throws NotFoundException {
        String id = request.getId();
        Object t = this.getTaskRepository().findById((Object)id).orElseThrow(() -> ScrapeServiceV2.loadTask$lambda$3(id));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (ScrapeTaskStatusV2)t;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<String, ScrapeTaskStatusV2> createTask(ScrapeRequestV2 request) throws IllegalXSQLException, IllegalRequestException {
        void $this$mapTo$iv;
        int group2 = ClusterTools.INSTANCE.getInstancePartition();
        Priority13 priority = this.parsePriority(request.getPriority());
        String string = request.getAuthToken();
        if (string == null) {
            throw new IllegalRequestException("Auth token is required", null, 2, null);
        }
        String authToken = string;
        String string2 = request.getUrl();
        if (string2 == null) {
            throw new IllegalRequestException("Url is required", null, 2, null);
        }
        String url = string2;
        Object task = null;
        String string3 = request.getRemoteAddr();
        if (string3 == null) {
            string3 = "";
        }
        task = new ScrapeTaskStatusV2(authToken, string3, group2, priority.getValue(), url, request.getArgs(), 0, 0, 0, null, request.getCallbackUrl(), 0, null, null, null, false, null, null, 261056, null);
        Iterable iterable = request.getSqls().entrySet();
        Collection destination$iv = task.getSqlTasks();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Map.Entry entry = (Map.Entry)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String name = (String)entry.getKey();
            String sqlTemplate = (String)entry.getValue();
            String sql = new SQLTemplate(sqlTemplate, null, 2, null).createInstance(task.getUrl()).getSql();
            collection.add(new XSqlTaskStatus(name, sql, 0, 0, null, 28, null));
        }
        Object object = this.getTaskRepository().save(task);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        task = object;
        if (task.getId() == null) {
            String string4 = "Required value was null.";
            throw new IllegalArgumentException(string4.toString());
        }
        String string5 = task.getId();
        Intrinsics.checkNotNull((Object)string5);
        return TuplesKt.to((Object)string5, (Object)task);
    }

    private void updateTask(ScrapeTaskStatusV2 task) {
        if (task.getId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (task.getStatusCode() == 200) {
            this.getMetrics().getSuccessScrapes().mark();
        } else {
            this.getMetrics().getFailedScrapes().mark();
        }
        this.getTaskRepository().save((Object)task);
    }

    private static final NotFoundException loadTask$lambda$3(String $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("No task <" + $id + ">", null, 2, null);
    }

    public static final /* synthetic */ ScrapeHyperlinkV2 access$createScrapeHyperlinkOrNull(ScrapeServiceV2 $this, ScrapeTaskStatusV2 task) {
        return $this.createScrapeHyperlinkOrNull(task);
    }

    public static final /* synthetic */ void access$updateTask(ScrapeServiceV2 $this, ScrapeTaskStatusV2 task) {
        $this.updateTask(task);
    }
}

