/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.test.client;

import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.support.JacksonPageImpl;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001c"}, d2={"Lai/platon/scent/test/client/TestScentAdminClient;", "", "restTemplate", "Lorg/springframework/boot/test/web/client/TestRestTemplate;", "server", "", "port", "", "contextPath", "(Lorg/springframework/boot/test/web/client/TestRestTemplate;Ljava/lang/String;ILjava/lang/String;)V", "baseUri", "getBaseUri", "()Ljava/lang/String;", "getContextPath", "getPort", "()I", "getRestTemplate", "()Lorg/springframework/boot/test/web/client/TestRestTemplate;", "getServer", "getScrapeTask", "Lai/platon/scent/mongo/v1/ScrapeTask;", "id", "authToken", "queryScrapeTasks", "Lorg/springframework/data/domain/Page;", "startTime", "Ljava/time/Instant;", "endTime", "scent-tests"})
public final class TestScentAdminClient {
    @NotNull
    private final TestRestTemplate restTemplate;
    @NotNull
    private final String server;
    private final int port;
    @NotNull
    private final String contextPath;

    public TestScentAdminClient(@NotNull TestRestTemplate restTemplate, @NotNull String server, int port, @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        this.restTemplate = restTemplate;
        this.server = server;
        this.port = port;
        this.contextPath = contextPath;
    }

    public /* synthetic */ TestScentAdminClient(TestRestTemplate testRestTemplate, String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 8182;
        }
        if ((n2 & 8) != 0) {
            string2 = "/api";
        }
        this(testRestTemplate, string, n, string2);
    }

    @NotNull
    public final TestRestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    public final String getBaseUri() {
        String string = "http://%s:%d%s";
        Object[] objectArray = new Object[]{this.server, this.port, this.contextPath};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Nullable
    public final ScrapeTask getScrapeTask(@NotNull String id, @NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String url = this.getBaseUri() + "/x/v1/tasks/{id}?authToken={authToken}";
        Object[] objectArray = new Object[]{id, authToken};
        return (ScrapeTask)this.restTemplate.getForObject(url, ScrapeTask.class, objectArray);
    }

    @NotNull
    public final Page<ScrapeTask> queryScrapeTasks(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        String url = this.getBaseUri() + "/x/v1/tasks/query?authToken={authToken}&startTime={startTime}&endTime={endTime}";
        ParameterizedTypeReference<JacksonPageImpl<ScrapeTask>> responseType2 = new ParameterizedTypeReference<JacksonPageImpl<ScrapeTask>>(){};
        Object[] objectArray = new Object[]{authToken, startTime, endTime};
        ResponseEntity responseEntity2 = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, objectArray);
        JacksonPageImpl jacksonPageImpl = (JacksonPageImpl)responseEntity2.getBody();
        return jacksonPageImpl == null ? (Page)new PageImpl(CollectionsKt.emptyList()) : (Page)jacksonPageImpl;
    }

    public static /* synthetic */ Page queryScrapeTasks$default(TestScentAdminClient testScentAdminClient, String string, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant3 = Instant.now().minusSeconds(86400L);
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now().minusSeconds(3600 * 24)");
            instant = instant3;
        }
        if ((n & 4) != 0) {
            Instant instant4 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"now()");
            instant2 = instant4;
        }
        return testScentAdminClient.queryScrapeTasks(string, instant, instant2);
    }
}

