/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.FrequencyManager;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.PageCorpusTabulator;
import ai.platon.scent.analysis.diagnosis.AutoMiningDiagnotor;
import ai.platon.scent.analysis.view.CorpusVisualizer;
import ai.platon.scent.common.ScentPaths;
import ai.platon.scent.common.Systems;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.features.defined.FF;
import ai.platon.scent.dom.nodes.FullFeaturedDocumentKt;
import ai.platon.scent.dom.nodes.OrderedRegionalTileNode;
import ai.platon.scent.dom.nodes.RegionalTile;
import ai.platon.scent.dom.nodes.VisualComponent;
import ai.platon.scent.dom.nodes.VisualComponentType;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import ai.platon.scent.entities.ColumnData;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.ml.Schema;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import java.io.Closeable;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u0096\u00012\u00020\u0001:\u0004\u0096\u0001\u0097\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010X\u001a\u00020YH\u0002J\u0006\u0010Z\u001a\u00020[J\b\u0010\\\u001a\u00020YH\u0002J\u0010\u0010\\\u001a\u00020Y2\u0006\u0010]\u001a\u00020\u0007H\u0002J\b\u0010^\u001a\u00020YH\u0002J\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00070`J\b\u0010a\u001a\u00020YH\u0002J\b\u0010b\u001a\u00020YH\u0002J\u0012\u0010c\u001a\u00020Y2\b\b\u0002\u0010d\u001a\u00020eH\u0002J\b\u0010f\u001a\u00020YH\u0002J\b\u0010g\u001a\u00020YH\u0002J\b\u0010h\u001a\u00020YH\u0002J\b\u0010i\u001a\u00020YH\u0002J\b\u0010j\u001a\u00020YH\u0002J\b\u0010k\u001a\u00020YH\u0002J\b\u0010l\u001a\u00020YH\u0002J\b\u0010m\u001a\u00020YH\u0016J \u0010n\u001a\u00020o2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020o0`2\b\b\u0002\u0010q\u001a\u00020\u0006H\u0002J\b\u0010r\u001a\u00020YH\u0002J\b\u0010s\u001a\u00020YH\u0002J\u0010\u0010t\u001a\u00020[2\u0006\u0010u\u001a\u00020vH\u0002J\n\u0010w\u001a\u0004\u0018\u00010NH\u0002J\u0010\u0010x\u001a\u00020Y2\u0006\u0010y\u001a\u00020[H\u0002J\u0010\u0010z\u001a\u00020\r2\u0006\u0010{\u001a\u00020(H\u0002J\b\u0010|\u001a\u00020YH\u0002J\u001f\u0010}\u001a\u00020Y2\f\u0010~\u001a\b\u0012\u0004\u0012\u00020\u00070`2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J'\u0010\u0081\u0001\u001a\u00020Y2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u00012\t\b\u0002\u0010\u0084\u0001\u001a\u00020\u0006H\u0002J/\u0010\u0085\u0001\u001a\u00020Y2\u0006\u0010{\u001a\u00020(2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u00012\t\b\u0002\u0010\u0084\u0001\u001a\u00020\u0006H\u0002J\u001e\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070`2\r\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070`H\u0002J\t\u0010\u008a\u0001\u001a\u00020YH\u0002J\t\u0010\u008b\u0001\u001a\u00020YH\u0002J\t\u0010\u008c\u0001\u001a\u00020YH\u0002J\u0018\u0010\u008d\u0001\u001a\u00020Y2\r\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020\r0JH\u0002J\t\u0010\u008f\u0001\u001a\u00020YH\u0002J\t\u0010\u0090\u0001\u001a\u00020YH\u0002J\t\u0010\u0091\u0001\u001a\u00020YH\u0002J\u001a\u0010\u0092\u0001\u001a\u00030\u0093\u00012\u0006\u0010u\u001a\u00020v2\u0006\u00100\u001a\u000201H\u0002J\t\u0010\u0094\u0001\u001a\u00020YH\u0002J\t\u0010\u0095\u0001\u001a\u00020YH\u0002R$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\fj\u0002`\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R$\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020(0\fj\u0002`)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0011R\u0016\u0010+\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0019R\u0014\u00100\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R \u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020605X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R$\u0010;\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0011R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0019R\u001a\u0010?\u001a\u00020@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR$\u0010E\u001a\u0012\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020(0\fj\u0002`GX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0011R\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020F0JX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0019\u0010M\u001a\n -*\u0004\u0018\u00010N0N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\n -*\u0004\u0018\u00010R0RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u0004\u0018\u00010TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\n -*\u0004\u0018\u00010,0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010V\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0011\u00a8\u0006\u0098\u0001"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "Ljava/lang/AutoCloseable;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "samples", "", "", "Lai/platon/scent/dom/nodes/VisualDocument;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/dom/HNormUrl;Ljava/util/Map;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "captionedElementIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "getCaptionedElementIndexer$scent_auto_mining", "()Lcom/google/common/collect/TreeMultimap;", "categorizedTextNodeIndexer", "Lorg/jsoup/nodes/TextNode;", "Lai/platon/scent/dom/nodes/TextNodeIndexer;", "getCategorizedTextNodeIndexer$scent_auto_mining", "componentElements", "", "getComponentElements$scent_auto_mining", "()Ljava/util/List;", "components", "Lai/platon/scent/dom/nodes/VisualComponent;", "getComponents$scent_auto_mining", "constantCaptionedElementIndexer", "getConstantCaptionedElementIndexer$scent_auto_mining", "documentFrequency", "Lai/platon/pulsar/common/FrequencyManager;", "getDocumentFrequency$scent_auto_mining", "()Lai/platon/pulsar/common/FrequencyManager;", "documentUrls", "", "getDocumentUrls$scent_auto_mining", "()Ljava/util/Set;", "layoutLeftIndexer", "Lorg/jsoup/nodes/Node;", "Lai/platon/pulsar/dom/IntNodeIndexer;", "getLayoutLeftIndexer$scent_auto_mining", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "naturalComponents", "getNaturalComponents$scent_auto_mining", "options", "Lai/platon/scent/dom/HarvestOptions;", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "orderedRegionalTextNodeIndexer", "Ljava/util/TreeMap;", "Lai/platon/scent/dom/nodes/OrderedRegionalTileNode;", "getOrderedRegionalTextNodeIndexer$scent_auto_mining", "()Ljava/util/TreeMap;", "getPortalUrl", "()Lai/platon/scent/dom/HNormUrl;", "pseudoConstantTextBlockIndexer", "getPseudoConstantTextBlockIndexer$scent_auto_mining", "qualifiedDocuments", "getQualifiedDocuments$scent_auto_mining", "recoverableConfidence", "", "getRecoverableConfidence$scent_auto_mining", "()D", "setRecoverableConfidence$scent_auto_mining", "(D)V", "regionalTileNodeIndexer", "Lai/platon/scent/dom/nodes/RegionalTile;", "Lai/platon/scent/dom/nodes/RegionalTileNodeIndexer;", "getRegionalTileNodeIndexer$scent_auto_mining", "regionalTiles", "Lai/platon/pulsar/common/Frequency;", "getRegionalTiles$scent_auto_mining", "()Lai/platon/pulsar/common/Frequency;", "reportDirectory", "Ljava/nio/file/Path;", "getReportDirectory", "()Ljava/nio/file/Path;", "startTime", "Ljava/time/OffsetDateTime;", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "taskLogger", "uniquePathComponents", "getUniquePathComponents$scent_auto_mining", "addLabeledDocuments", "", "analyse", "Lai/platon/scent/analysis/AutoMiningResult;", "analysisVariables", "doc", "annotateNodes", "arrange", "", "arrangeComponents", "buildRegionalTextNodeIndex", "calculateAdvancedFeatures", "encodeOnly", "", "calculateCaptionDocFrequency", "calculateComputedStylesFeatures", "calculateGeneralCategoricalFeatures", "calculateGeneralDocFrequency", "calculateGeometricFeatures", "calculateTextNodeDocFrequency", "calculateTextualFeatures", "close", "combineTables", "Lai/platon/pulsar/common/OpenMapTable;", "tables", "uniqueKeyColumn", "detectRecoverableDocuments", "divideDistricts", "doAutoMining", "clusterer", "Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "doEncodeToDataset", "drawIfNecessary", "result", "encodeLabel", "node", "enhancePartition", "exportAllElements", "documents", "pw", "Ljava/io/PrintWriter;", "exportHeader", "schema", "Lai/platon/scent/ml/Schema;", "separator", "exportNode", "features", "Lorg/apache/commons/math3/linear/RealVector;", "filterByUris", "docs", "findLayoutComponents", "partition", "reportComponents", "reportDff", "dff", "simplifyAnnotations", "simplifyCaptions", "supplementPartition", "tabulate", "Lai/platon/scent/entities/PageTableGroup;", "traceCorpus", "validateFeatures", "Companion", "OrderingValue", "scent-auto-mining"})
public final class AnalysablePageCorpus
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HNormUrl portalUrl;
    @NotNull
    private final Map<String, VisualDocument> samples;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final Logger taskLogger;
    private final OffsetDateTime startTime;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private final Set<String> documentUrls;
    @NotNull
    private final List<VisualDocument> qualifiedDocuments;
    @NotNull
    private final FrequencyManager<String> documentFrequency;
    @NotNull
    private final TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer;
    @NotNull
    private final Frequency<RegionalTile> regionalTiles;
    @NotNull
    private final TreeMap<TextNode, OrderedRegionalTileNode> orderedRegionalTextNodeIndexer;
    @NotNull
    private final TreeMultimap<Integer, Element> captionedElementIndexer;
    @NotNull
    private final TreeMultimap<Integer, Element> constantCaptionedElementIndexer;
    @NotNull
    private final TreeMultimap<Integer, Element> pseudoConstantTextBlockIndexer;
    @NotNull
    private final TreeMultimap<String, TextNode> categorizedTextNodeIndexer;
    private double recoverableConfidence;
    @NotNull
    private final TreeMultimap<Integer, Node> layoutLeftIndexer;
    @NotNull
    private final List<VisualComponent> components;
    @NotNull
    private final TreeMultimap<String, VisualComponent> uniquePathComponents;
    @NotNull
    private final List<VisualComponent> naturalComponents;
    @NotNull
    private final List<Element> componentElements;
    @NotNull
    private static final AnalysablePageCorpus EMPTY;

    public AnalysablePageCorpus(@NotNull HNormUrl portalUrl, @NotNull Map<String, VisualDocument> samples, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.portalUrl = portalUrl;
        this.samples = samples;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AnalysablePageCorpus.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AnalysablePageCorpus.class), (String)".Task");
        this.startTime = OffsetDateTime.now();
        this.stopWatch = this.logger.isDebugEnabled() ? new Slf4JStopWatch() : null;
        boolean bl = false;
        this.documentUrls = new LinkedHashSet();
        bl = false;
        this.qualifiedDocuments = new ArrayList();
        this.documentFrequency = new FrequencyManager();
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodePositionComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), nodePositionComparator)");
        this.regionalTileNodeIndexer = treeMultimap;
        this.regionalTiles = new Frequency(null, 1, null);
        this.orderedRegionalTextNodeIndexer = new TreeMap(NodesKt.getNodePositionComparator());
        treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), nodeComparator)");
        this.captionedElementIndexer = treeMultimap;
        treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), nodeComparator)");
        this.constantCaptionedElementIndexer = treeMultimap;
        treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), nodeComparator)");
        this.pseudoConstantTextBlockIndexer = treeMultimap;
        treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), nodeComparator)");
        this.categorizedTextNodeIndexer = treeMultimap;
        boolean bl2 = false;
        treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Node it = (Node)a;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = Integer.valueOf(NodeExtKt.getTop((Node)it));
                it = (Node)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable3 = Integer.valueOf(NodeExtKt.getTop((Node)it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(naturalOrder(), compareBy { it.top })");
        this.layoutLeftIndexer = treeMultimap;
        boolean bl3 = false;
        this.components = new ArrayList();
        TreeMultimap treeMultimap2 = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create()");
        this.uniquePathComponents = treeMultimap2;
        boolean bl4 = false;
        this.naturalComponents = new ArrayList();
        bl4 = false;
        this.componentElements = new ArrayList();
    }

    @NotNull
    public final HNormUrl getPortalUrl() {
        return this.portalUrl;
    }

    public final Path getReportDirectory() {
        return AppPaths.INSTANCE.getREPORT_DIR().resolve("harvest/corpus").resolve(ScentPaths.INSTANCE.fromHost(this.portalUrl.getUrl()));
    }

    private final HarvestOptions getOptions() {
        return this.portalUrl.getHOptions();
    }

    @NotNull
    public final Set<String> getDocumentUrls$scent_auto_mining() {
        return this.documentUrls;
    }

    @NotNull
    public final List<VisualDocument> getQualifiedDocuments$scent_auto_mining() {
        return this.qualifiedDocuments;
    }

    @NotNull
    public final FrequencyManager<String> getDocumentFrequency$scent_auto_mining() {
        return this.documentFrequency;
    }

    @NotNull
    public final TreeMultimap<RegionalTile, Node> getRegionalTileNodeIndexer$scent_auto_mining() {
        return this.regionalTileNodeIndexer;
    }

    @NotNull
    public final Frequency<RegionalTile> getRegionalTiles$scent_auto_mining() {
        return this.regionalTiles;
    }

    @NotNull
    public final TreeMap<TextNode, OrderedRegionalTileNode> getOrderedRegionalTextNodeIndexer$scent_auto_mining() {
        return this.orderedRegionalTextNodeIndexer;
    }

    @NotNull
    public final TreeMultimap<Integer, Element> getCaptionedElementIndexer$scent_auto_mining() {
        return this.captionedElementIndexer;
    }

    @NotNull
    public final TreeMultimap<Integer, Element> getConstantCaptionedElementIndexer$scent_auto_mining() {
        return this.constantCaptionedElementIndexer;
    }

    @NotNull
    public final TreeMultimap<Integer, Element> getPseudoConstantTextBlockIndexer$scent_auto_mining() {
        return this.pseudoConstantTextBlockIndexer;
    }

    @NotNull
    public final TreeMultimap<String, TextNode> getCategorizedTextNodeIndexer$scent_auto_mining() {
        return this.categorizedTextNodeIndexer;
    }

    public final double getRecoverableConfidence$scent_auto_mining() {
        return this.recoverableConfidence;
    }

    public final void setRecoverableConfidence$scent_auto_mining(double d) {
        this.recoverableConfidence = d;
    }

    @NotNull
    public final TreeMultimap<Integer, Node> getLayoutLeftIndexer$scent_auto_mining() {
        return this.layoutLeftIndexer;
    }

    @NotNull
    public final List<VisualComponent> getComponents$scent_auto_mining() {
        return this.components;
    }

    @NotNull
    public final TreeMultimap<String, VisualComponent> getUniquePathComponents$scent_auto_mining() {
        return this.uniquePathComponents;
    }

    @NotNull
    public final List<VisualComponent> getNaturalComponents$scent_auto_mining() {
        return this.naturalComponents;
    }

    @NotNull
    public final List<Element> getComponentElements$scent_auto_mining() {
        return this.componentElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<VisualDocument> arrange() {
        Collection collection = this.qualifiedDocuments;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return this.qualifiedDocuments;
        }
        if (this.samples.size() < 5) {
            this.logger.warn("Too few samples: " + this.samples.size());
            boolean bl2 = false;
            return CollectionsKt.emptyList();
        }
        this.logger.info("Arrangement start - {}", (Object)Systems.INSTANCE.getHeapMessage());
        try {
            this.detectRecoverableDocuments();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace(System.err);
            bl = false;
            List list = CollectionsKt.emptyList();
            return list;
        }
        finally {
            this.logger.info("Arrangement finished - {}", (Object)Systems.INSTANCE.getHeapMessage());
        }
        collection = this.stopWatch;
        if (collection != null) {
            collection.lap("detectRecoverableDocuments");
        }
        return this.qualifiedDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AutoMiningResult analyse() {
        AutoMiningResult autoMiningResult;
        this.logger.info("Analysis start - {}", (Object)Systems.INSTANCE.getHeapMessage());
        AnalysablePageCorpus.calculateAdvancedFeatures$default(this, false, 1, null);
        AutoCloseable autoCloseable = new NodeClusterRunner(this.qualifiedDocuments, this.uniquePathComponents, this.conf);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            NodeClusterRunner it = (NodeClusterRunner)autoCloseable;
            boolean bl3 = false;
            autoMiningResult = this.doAutoMining(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        AutoMiningResult result = autoMiningResult;
        this.logger.info("Analysis finished - {}", (Object)Systems.INSTANCE.getHeapMessage());
        this.drawIfNecessary(result);
        return result;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setVisualDocument((Document)it.getDocument(), null);
        }
        this.documentUrls.clear();
        this.qualifiedDocuments.clear();
        this.documentFrequency.clear();
        this.regionalTileNodeIndexer.clear();
        this.regionalTiles.clear();
        this.orderedRegionalTextNodeIndexer.clear();
        this.captionedElementIndexer.clear();
        this.constantCaptionedElementIndexer.clear();
        this.pseudoConstantTextBlockIndexer.clear();
        this.categorizedTextNodeIndexer.clear();
        this.layoutLeftIndexer.clear();
        this.components.clear();
        this.uniquePathComponents.clear();
        this.naturalComponents.clear();
        this.componentElements.clear();
    }

    private final void drawIfNecessary(AutoMiningResult result) {
        boolean draw = this.portalUrl.getHOptions().getDraw();
        if (!draw) {
            return;
        }
        boolean drawTiles = true;
        boolean drawLeafElements = true;
        boolean drawComponents = true;
        new CorpusVisualizer(result, this.qualifiedDocuments, drawTiles, drawLeafElements, drawComponents).draw();
    }

    private final void calculateAdvancedFeatures(boolean encodeOnly) {
        if (this.qualifiedDocuments.isEmpty()) {
            return;
        }
        if (this.getOptions().getDiagnose() && this.getOptions().getNVerbose() > 0) {
            Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)new IntRange(0, this.qualifiedDocuments.size() - 1))), (int)this.getOptions().getNVerbose());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                this.getQualifiedDocuments$scent_auto_mining().get(it).setVerbose(true);
            }
        }
        this.calculateGeometricFeatures();
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateGeometricFeatures");
        }
        this.calculateTextualFeatures();
        slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateTextualFeatures");
        }
        this.calculateCaptionDocFrequency();
        slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateCaptionDocFrequency");
        }
        if (!encodeOnly) {
            this.partition();
            slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("partition");
            }
        }
        this.calculateGeneralCategoricalFeatures();
        slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateGeneralCategoricalFeatures");
        }
        this.calculateComputedStylesFeatures();
        slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateComputedStylesFeatures");
        }
        this.divideDistricts();
        slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("divideDistricts");
        }
        if (this.taskLogger.isInfoEnabled()) {
            this.reportComponents();
        }
    }

    static /* synthetic */ void calculateAdvancedFeatures$default(AnalysablePageCorpus analysablePageCorpus, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        analysablePageCorpus.calculateAdvancedFeatures(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path doEncodeToDataset() {
        this.logger.info("Encoding {} documents", (Object)this.qualifiedDocuments.size());
        Path path = Files.createTempFile("dataset-", ".csv", new FileAttribute[0]);
        Closeable closeable = new PrintWriter(path.toFile());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintWriter pw = (PrintWriter)closeable;
            boolean bl3 = false;
            this.exportAllElements(this.getQualifiedDocuments$scent_auto_mining(), pw);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return path;
    }

    private final AutoMiningResult doAutoMining(NodeClusterRunner clusterer) {
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("cluster");
        }
        clusterer.cluster();
        if (this.taskLogger.isTraceEnabled()) {
            this.traceCorpus();
        }
        PageTableGroup pageTableGroup = this.tabulate(clusterer, this.getOptions());
        AutoMiningResult result = new AutoMiningResult(this.portalUrl, this.samples, this.qualifiedDocuments, this.componentElements, pageTableGroup);
        if (this.getOptions().getDiagnose()) {
            AutoMiningDiagnotor diagnotor = new AutoMiningDiagnotor(this, clusterer, result);
            this.logger.info("Start diagnosing ...");
            diagnotor.diagnose();
            this.logger.info("Diagnosing finished, reporting ...");
            diagnotor.report();
        }
        return result;
    }

    private final void exportAllElements(List<VisualDocument> documents, PrintWriter pw) {
        int counter = 0;
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument document = (VisualDocument)element$iv;
            boolean bl = false;
            NodesKt.forEachElement$default((Node)((Node)document.getDocument()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(this, pw){
                final /* synthetic */ AnalysablePageCorpus this$0;
                final /* synthetic */ PrintWriter $pw;
                {
                    this.this$0 = $receiver;
                    this.$pw = $pw;
                    super(1);
                }

                public final void invoke(@NotNull Element ele) {
                    Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                    int n = NodeExtKt.getLeft((Node)((Node)ele));
                    boolean bl = 0 <= n ? n <= 500 : false;
                    if (bl) {
                        n = NodeExtKt.getWidth((Node)((Node)ele));
                        boolean bl2 = 200 <= n ? n <= 1100 : false;
                        if (bl2) {
                            n = NodeExtKt.getTop((Node)((Node)ele));
                            boolean bl3 = 100 <= n ? n <= 500 : false;
                            if (bl3 && NodeExtKt.getBottom((Node)((Node)ele)) > 200) {
                                Node node = (Node)ele;
                                RealVector realVector = ele.getExtension().getFeatures();
                                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"ele.extension.features");
                                AnalysablePageCorpus.exportNode$default(this.this$0, node, realVector, this.$pw, null, 8, null);
                                this.$pw.println();
                            }
                        }
                    }
                }
            }), (int)1, null);
            if (++counter % 100 != 0) continue;
            this.logger.info("Encoded {} documents", (Object)counter);
        }
    }

    private final void exportHeader(Schema schema, PrintWriter pw, String separator) {
        pw.print("Label");
        pw.print(separator);
        pw.println(CollectionsKt.joinToString$default((Iterable)schema.getColumns(), (CharSequence)",", null, null, (int)0, null, (Function1)exportHeader.1.INSTANCE, (int)30, null));
    }

    static /* synthetic */ void exportHeader$default(AnalysablePageCorpus analysablePageCorpus, Schema schema, PrintWriter printWriter, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = ",";
        }
        analysablePageCorpus.exportHeader(schema, printWriter, string);
    }

    private final void exportNode(Node node, RealVector features, PrintWriter pw, String separator) {
        pw.print(this.encodeLabel(node));
        int n = 0;
        int n2 = features.getDimension();
        if (n < n2) {
            do {
                int j = n++;
                pw.print(separator);
                pw.print(VectorsKt.get((RealVector)features, (int)j));
            } while (n < n2);
        }
    }

    static /* synthetic */ void exportNode$default(AnalysablePageCorpus analysablePageCorpus, Node node, RealVector realVector, PrintWriter printWriter, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = ",";
        }
        analysablePageCorpus.exportNode(node, realVector, printWriter, string);
    }

    private final int encodeLabel(Node node) {
        List labels = NodeExtKt.getMlLabels((Node)node);
        return labels.contains("Title") ? 1 : (labels.contains("Meta") ? 2 : (labels.contains("Content") ? 3 : 0));
    }

    /*
     * WARNING - void declaration
     */
    private final PageTableGroup tabulate(NodeClusterRunner clusterer, HarvestOptions options) {
        void destination$iv;
        void $this$mapIndexedNotNullTo$iv;
        Iterable $this$sortedByDescending$iv;
        Iterable iterable = clusterer.getTileClusterGroups$scent_auto_mining();
        boolean $i$f$sortedByDescending22 = false;
        boolean bl = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TileClusterGroup it = (TileClusterGroup)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (TileClusterGroup)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                ScoreVector scoreVector = it.getScore();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)scoreVector));
            }
        });
        $i$f$sortedByDescending22 = false;
        Collection $i$f$sortedByDescending22 = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv = $this$mapIndexedNotNullTo$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            OpenMapTable openMapTable;
            void group;
            void element$iv;
            int n = index$iv$iv++;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl3 = false;
            TileClusterGroup tileClusterGroup = (TileClusterGroup)element$iv;
            int i = index$iv;
            boolean bl4 = false;
            OpenMapTable openMapTable2 = new PageCorpusTabulator(this, (TileClusterGroup)group, 1 + i, options.getCellType()).tabulate();
            boolean bl5 = false;
            boolean bl6 = false;
            OpenMapTable it = openMapTable2;
            boolean bl7 = false;
            if ((it.isNotEmpty() ? openMapTable2 : null) == null) continue;
            openMapTable = openMapTable;
            boolean bl8 = false;
            boolean bl9 = false;
            OpenMapTable it$iv = openMapTable;
            boolean bl10 = false;
            destination$iv.add(it$iv);
        }
        List tables = (List)destination$iv;
        tables.add(0, AnalysablePageCorpus.combineTables$default(this, tables, null, 2, null));
        iterable = new PageTableGroup(this.portalUrl, tables, options);
        boolean bl11 = false;
        bl = false;
        Iterable $this$tabulate_u24lambda_u2d9 = iterable;
        boolean bl12 = false;
        $this$tabulate_u24lambda_u2d9.setSorted(true);
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final OpenMapTable combineTables(List<OpenMapTable> tables, String uniqueKeyColumn) {
        OpenMapTable.Column it;
        Object object;
        void it2;
        boolean bl7;
        Pair $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = tables;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            OpenMapTable table = (OpenMapTable)element$iv$iv;
            boolean bl2 = false;
            OpenMapTable.Column[] $this$map$iv = table.getColumns();
            boolean $i$f$map = false;
            OpenMapTable.Column[] columnArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (String item$iv$iv : $this$mapTo$iv$iv) {
                void var22_59 = item$iv$iv;
                Collection collection = destination$iv$iv2;
                bl7 = false;
                object = TuplesKt.to((Object)table.getIdent(), (Object)it2);
                collection.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List columns = (List)destination$iv$iv;
        OpenMapTable combinedTable = new OpenMapTable(columns.size(), 0);
        PageTableKt.getData((OpenMapTable)combinedTable).setCombined(true);
        OpenMapTable.Column[] $this$forEachIndexed$iv = combinedTable.getColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (OpenMapTable.Column item$iv2 : $this$forEachIndexed$iv) {
            void c;
            String item$iv$iv;
            int n = index$iv++;
            OpenMapTable.Column bl2 = item$iv2;
            int i2 = n;
            boolean bl3 = false;
            $this$mapTo$iv$iv = (Pair)columns.get(i2);
            int tableId = ((Number)$this$mapTo$iv$iv.component1()).intValue();
            OpenMapTable.Column prototype = (OpenMapTable.Column)$this$mapTo$iv$iv.component2();
            String string = prototype.getName();
            int n2 = 0;
            int n3 = 0;
            item$iv$iv = string;
            it2 = c;
            boolean bl4 = false;
            bl7 = new Regex("T\\d+C\\d+").matches((CharSequence)it);
            object = bl7 ? string : null;
            it2.setName((String)(object == null ? "T" + tableId + prototype.getName() : object));
            PageTableKt.setData((OpenMapTable.Column)c, (ColumnData)PageTableKt.getData((OpenMapTable.Column)prototype));
            c.getAttributes().putAll(prototype.getAttributes());
        }
        $i$f$forEachIndexed = false;
        Map rows = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv2 = tables;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            int n;
            int columnCount;
            void table;
            int i;
            block11: {
                int item$iv2 = index$iv2++;
                boolean c = false;
                if (item$iv2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                OpenMapTable i2 = (OpenMapTable)item$iv;
                i = item$iv2;
                boolean bl5 = false;
                columnCount = table.getNumColumns();
                OpenMapTable.Column[] $this$indexOfFirst$iv = table.getColumns();
                boolean $i$f$indexOfFirst = false;
                int n4 = 0;
                int n5 = $this$indexOfFirst$iv.length;
                while (n4 < n5) {
                    void index$iv3;
                    it = $this$indexOfFirst$iv[index$iv3];
                    boolean bl6 = false;
                    if (StringsKt.equals((String)it.getName(), (String)uniqueKeyColumn, (boolean)true)) {
                        n = index$iv3;
                        break block11;
                    }
                    ++index$iv3;
                }
                n = -1;
            }
            int keyIndex = n;
            Iterable $this$forEach$iv = table.getRows();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OpenMapTable.Cell bl7;
                String key;
                OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
                boolean bl8 = false;
                if (row.getCells().length != columnCount) {
                    this.logger.warn("Row value count does not match column count | " + row.getCells().length + " <- " + columnCount);
                }
                if ((key = (bl7 = row.get(keyIndex)) == null ? null : ((object = bl7.getValue()) == null ? null : object.toString())) == null) continue;
                object = rows.computeIfAbsent(key, arg_0 -> AnalysablePageCorpus.combineTables$lambda-18$lambda-17$lambda-15(columnCount, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rows.computeIfAbsent(key\u2026 ArrayList(columnCount) }");
                ArrayList values = (ArrayList)object;
                OpenMapTable.Cell[] $this$mapIndexedTo$iv = row.getCells();
                boolean $i$f$mapIndexedTo = false;
                int index$iv4 = 0;
                for (OpenMapTable.Cell item$iv3 : $this$mapIndexedTo$iv) {
                    Object object2;
                    void j;
                    void cell;
                    int n6 = index$iv4++;
                    OpenMapTable.Cell cell2 = item$iv3;
                    int n7 = n6;
                    Collection collection = values;
                    boolean bl9 = false;
                    void var37_79 = cell;
                    OrderingValue orderingValue = new OrderingValue(i * 10000 + j, var37_79 == null ? null : ((object2 = var37_79.getValue()) == null ? null : object2.toString()));
                    collection.add(orderingValue);
                }
            }
        }
        Map $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl10 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$values = element$iv = iterator.next();
            boolean bl11 = false;
            Map.Entry i = $dstr$key$values;
            boolean bl12 = false;
            String key = (String)i.getKey();
            Map.Entry entry = $dstr$key$values;
            boolean bl13 = false;
            ArrayList values = (ArrayList)entry.getValue();
            combinedTable.computeIfAbsent(key, (Function1)new Function1<OpenMapTable.Row, Unit>((ArrayList<OrderingValue>)values){
                final /* synthetic */ ArrayList<OrderingValue> $values;
                {
                    this.$values = $values;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OpenMapTable.Row row) {
                    Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                    Iterable $this$sortedBy$iv = this.$values;
                    boolean $i$f$sortedBy = false;
                    boolean bl = false;
                    Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            OrderingValue it = (OrderingValue)a;
                            boolean bl2 = false;
                            Comparable comparable = Integer.valueOf(it.getOrder());
                            it = (OrderingValue)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Integer n = it.getOrder();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void v;
                        int n = index$iv++;
                        boolean bl2 = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        OrderingValue orderingValue = (OrderingValue)item$iv;
                        int j = n;
                        boolean bl3 = false;
                        row.setValue(j, (Object)v.getValue());
                    }
                }
            });
        }
        return combinedTable;
    }

    static /* synthetic */ OpenMapTable combineTables$default(AnalysablePageCorpus analysablePageCorpus, List list, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Url";
        }
        return analysablePageCorpus.combineTables(list, string);
    }

    private final void traceCorpus() {
        if (this.taskLogger.isTraceEnabled()) {
            this.validateFeatures();
            this.annotateNodes();
            this.simplifyAnnotations();
            this.simplifyCaptions();
        }
    }

    private final void detectRecoverableDocuments() {
        VisualDocument it;
        if (this.samples.isEmpty()) {
            this.logger.warn("Sample is empty");
            return;
        }
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
            it.calculateCategoricalTermFrequency();
        }
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("calculateCategoricalTermFrequency");
        }
        $this$forEach$iv = this.samples.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
            it.calculateComponentEdges();
        }
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("calculateComponentEdges");
        }
        $this$forEach$iv = this.samples.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
            it.buildRegionalTileNodeIndex();
        }
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("buildRegionalTileNodeIndex");
        }
        this.calculateGeneralDocFrequency();
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("calculateGeneralDocFrequency");
        }
        this.buildRegionalTextNodeIndex();
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("buildRegionalTileNodeIndex");
        }
        this.calculateTextNodeDocFrequency();
        $this$forEach$iv = this.stopWatch;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.lap("calculateTextNodeDocFrequency");
        }
        $this$forEach$iv = this.samples.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
            it.calculateCollinearNodes();
        }
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("calculateCollinearNodes");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VisualDocument> filterByUris(List<VisualDocument> docs) {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable destination$iv$iv;
        Number number;
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = docs;
        Collection destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv;
            collection = destination$iv;
            boolean bl = false;
            number = it.getLocation().length();
            collection.add(number);
        }
        Frequency frequency = (Frequency)destination$iv;
        Integer length = (Integer)frequency.getMostEntry().getElement();
        Intrinsics.checkNotNullExpressionValue((Object)length, (String)"length");
        if (length < 20) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = docs;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                VisualDocument it = (VisualDocument)element$iv$iv;
                boolean bl = false;
                Integer n = length;
                if (!(n != null && it.getLocation().length() == n.intValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        DescriptiveStatistics ds = new DescriptiveStatistics();
        Iterable $this$map$iv = docs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator element$iv$iv = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv.next();
            VisualDocument bl = (VisualDocument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            number = it.getLocation().length();
            collection.add(number);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double it = ((Number)element$iv).doubleValue();
            boolean bl = false;
            ds.addValue(it);
        }
        int q1 = (int)ds.getPercentile(0.25);
        int q3 = (int)ds.getPercentile(0.75);
        Iterable $this$filter$iv = docs;
        boolean $i$f$filter = false;
        Iterable it = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            VisualDocument it2 = (VisualDocument)element$iv$iv2;
            boolean bl = false;
            int n = it2.getLocation().length();
            boolean bl3 = q1 <= n ? n <= q3 : false;
            if (!bl3) continue;
            destination$iv$iv3.add(element$iv$iv2);
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateGeneralCategoricalFeatures() {
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.TAG, FF.NID, FF.NCS};
        FF[] nominalFeatures = fFArray;
        Function1 nominalExtractors2 = calculateGeneralCategoricalFeatures.nominalExtractors.1.INSTANCE;
        FF[] $this$map$iv = nominalFeatures;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_10 = $this$mapTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_17 = item$iv$iv = var9_10[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = this.getDocumentFrequency$scent_auto_mining().computeIfAbsent(it.getAlias()).ordinalMap();
            collection.add(map);
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            int n2 = index$iv++;
            n = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n2;
            boolean bl = false;
            NodesKt.forEach((Node)((Node)doc.getBody()), (boolean)true, (Function1)((Function1)new Function1<Node, Unit>(pid){
                final /* synthetic */ int $pid;
                {
                    this.$pid = $pid;
                    super(1);
                }

                public final void invoke(@NotNull Node it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setPid((Node)it, (int)(1 + this.$pid));
                }
            }));
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)calculateGeneralCategoricalFeatures.1.2.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, String[]>)nominalExtractors2, nominalFeatures, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, String[]> $nominalExtractors;
                final /* synthetic */ FF[] $nominalFeatures;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$nominalExtractors = $nominalExtractors;
                    this.$nominalFeatures = $nominalFeatures;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Object[] objectArray = (Object[])this.$nominalExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$nominalFeatures;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (void item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n = index$iv++;
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        CharSequence charSequence = (CharSequence)nominal;
                        boolean bl2 = false;
                        if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                        int key = fFArray[i].getKey();
                        Integer n2 = list.get(i).get(nominal);
                        if (n2 == null) continue;
                        Integer n3 = n2;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        int it = ((Number)n3).intValue();
                        boolean bl5 = false;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + it));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateComputedStylesFeatures() {
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.FTSZ, FF.COLR, FF.BCOLR};
        FF[] nominalFeatures = fFArray;
        Function1 nominalExtractors2 = (Function1)new Function1<Element, List<? extends String>>(nominalFeatures){
            final /* synthetic */ FF[] $nominalFeatures;
            {
                this.$nominalFeatures = $nominalFeatures;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull Element it) {
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object3 = NodeExtKt.getBestElement((Node)((Node)it)).attr("st");
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.bestElement.attr(PULS\u2026_ATTR_ELEMENT_NODE_STYLE)");
                object3 = (CharSequence)object3;
                FF[] fFArray = "; ";
                int n = 0;
                fFArray = new Regex((String)fFArray);
                n = 0;
                boolean bl = false;
                object3 = fFArray.split((CharSequence)object3, n);
                fFArray = this.$nominalFeatures;
                n = 0;
                bl = false;
                Object it2 = object3;
                boolean bl2 = false;
                Object object4 = object2 = it2.size() == fFArray.length ? object3 : null;
                if (object2 == null) {
                    boolean bl3 = false;
                    object = CollectionsKt.emptyList();
                } else {
                    object = object2;
                }
                return object;
            }
        };
        FF[] $this$map$iv = nominalFeatures;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_10 = $this$mapTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_17 = item$iv$iv = var9_10[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = this.getDocumentFrequency$scent_auto_mining().computeIfAbsent(it.getAlias()).ordinalMap();
            collection.add(map);
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            int n2 = index$iv++;
            n = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n2;
            boolean bl = false;
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)calculateComputedStylesFeatures.1.1.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, ? extends List<String>>)nominalExtractors2, nominalFeatures, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, List<String>> $nominalExtractors;
                final /* synthetic */ FF[] $nominalFeatures;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$nominalExtractors = $nominalExtractors;
                    this.$nominalFeatures = $nominalFeatures;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Iterable iterable = (Iterable)this.$nominalExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$nominalFeatures;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl2 = false;
                        int key = fFArray[i].getKey();
                        Integer n2 = list.get(i).get(nominal);
                        if (n2 == null) continue;
                        Integer n3 = n2;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        int it = ((Number)n3).intValue();
                        boolean bl5 = false;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + it));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void divideDistricts() {
        Map ordinalMap = this.regionalTiles.ordinalMap();
        NavigableMap navigableMap = this.regionalTileNodeIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"regionalTileNodeIndexer.asMap()");
        Object $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Iterator $this$filterTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$regionalText$nodes = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$regionalText$nodes;
            boolean bl3 = false;
            RegionalTile regionalText = (RegionalTile)entry.getKey();
            Map.Entry entry2 = $dstr$regionalText$nodes;
            boolean bl4 = false;
            Collection nodes2 = (Collection)entry2.getValue();
            Integer n = (Integer)ordinalMap.get(regionalText);
            int ordinal = n == null ? 0 : n;
            Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
            Iterable $this$filter$iv = nodes2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Node it = (Node)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getMaybeLocallyConstant((Node)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            $this$filterTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$filterTo$iv$iv.next();
                Node it = (Node)element$iv2;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setDistrict((Node)it, (int)ordinal);
            }
        }
        $this$forEach$iv = this.qualifiedDocuments;
        $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            VisualDocument document = (VisualDocument)element$iv;
            boolean bl7 = false;
            Iterable $this$forEach$iv3 = document.getComponents();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                VisualComponent component = (VisualComponent)element$iv3;
                boolean bl8 = false;
                int district = 0;
                Iterable $this$forEach$iv4 = component.getOrderedTiles();
                boolean $i$f$forEach4 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    Node it = (Node)element$iv4;
                    boolean bl9 = false;
                    if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getMaybeLocallyConstant((Node)it)) {
                        district = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getDistrict((Node)it);
                        continue;
                    }
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setDistrict((Node)it, (int)district);
                }
            }
        }
    }

    private final void calculateGeneralDocFrequency() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            doc.getTermFrequency().forEach((arg_0, arg_1) -> AnalysablePageCorpus.calculateGeneralDocFrequency$lambda-41$lambda-40(this, arg_0, arg_1));
        }
    }

    private final void buildRegionalTextNodeIndex() {
        for (VisualDocument doc : this.samples.values()) {
            doc.getRegionalTileNodeIndexer().asMap().forEach((arg_0, arg_1) -> AnalysablePageCorpus.buildRegionalTextNodeIndex$lambda-42(this, arg_0, arg_1));
        }
    }

    private final void addLabeledDocuments() {
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
            return;
        }
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument sample = (VisualDocument)element$iv;
            boolean bl = false;
            boolean labeled2 = QueriesKt.any((Node)((Node)sample.getDocument()), (Function1)addLabeledDocuments.1.labeled.1.INSTANCE);
            if (!labeled2) continue;
            this.getQualifiedDocuments$scent_auto_mining().add(sample);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTextNodeDocFrequency() {
        if (this.regionalTileNodeIndexer.isEmpty()) {
            this.logger.warn("No regional text node");
            return;
        }
        boolean bl = this.regionalTileNodeIndexer.size() > this.qualifiedDocuments.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RegionalTileNodeIndexer size " + this.getRegionalTileNodeIndexer$scent_auto_mining().size() + ", document size: " + this.getQualifiedDocuments$scent_auto_mining().size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Frequency dff = new Frequency(null, 1, null);
        double dfRate = 0.8;
        double d = 5.0;
        double d2 = dfRate * (double)this.samples.size();
        boolean bl5 = false;
        double minDf = Math.min(d, d2);
        this.regionalTileNodeIndexer.asMap().forEach((arg_0, arg_1) -> AnalysablePageCorpus.calculateTextNodeDocFrequency$lambda-47(minDf, dff, arg_0, arg_1));
        if (dff.isEmpty()) {
            this.logger.warn("!!! No regional texts shared by " + this.samples.size() + " sample documents (df rate: " + dfRate + ") !!!");
            if (this.logger.isInfoEnabled()) {
                void $this$mapNotNullTo$iv;
                Iterable<Object> iterable = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"regionalTileNodeIndexer.asMap().values");
                iterable = iterable;
                Collection destination$iv = new TreeSet(ComparisonsKt.reverseOrder());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    void $this$mapTo$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl6 = false;
                    Collection it = (Collection)element$iv;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Object object2 = it;
                    Collection destination$iv2 = new HashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it2;
                        Node node = (Node)item$iv;
                        Collection collection = destination$iv2;
                        boolean bl8 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        String string = NodeExtKt.getLocation((Node)((Node)NodeExtKt.getOwnerDocument((Node)it2)));
                        collection.add(string);
                    }
                    object2 = ((HashSet)destination$iv2).size();
                    boolean bl9 = false;
                    boolean bl10 = false;
                    int it3 = ((Number)object2).intValue();
                    boolean bl11 = false;
                    if ((it3 > 1 ? object2 : null) == null) continue;
                    object = object;
                    boolean bl12 = false;
                    boolean bl13 = false;
                    Object it$iv = object;
                    boolean bl14 = false;
                    destination$iv.add(it$iv);
                }
                TreeSet dfs = (TreeSet)destination$iv;
                String s2 = CollectionsKt.joinToString$default((Iterable)dfs, null, null, null, (int)0, null, (Function1)calculateTextNodeDocFrequency.s.1.INSTANCE, (int)31, null);
                this.logger.info("Document frequency of regional texts: " + s2);
            }
            return;
        }
        int documentSize = ((Number)((Object)dff.getMode())).intValue();
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
        } else {
            void $this$mapNotNullTo$iv;
            Object item$iv2;
            Object v0;
            Iterable $this$firstOrNull$iv;
            Collection destination$iv;
            block15: {
                destination$iv = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(destination$iv, (String)"regionalTileNodeIndexer.asMap().values");
                $this$firstOrNull$iv = destination$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Collection it = (Collection)element$iv;
                    boolean bl15 = false;
                    if (!(it.size() == documentSize)) continue;
                    v0 = element$iv;
                    break block15;
                }
                v0 = null;
            }
            Iterable s2 = v0;
            if (s2 != null) {
                void $this$mapTo$iv;
                $this$firstOrNull$iv = s2;
                Collection destination$iv3 = this.documentUrls;
                boolean $i$f$mapTo = false;
                for (Object item$iv2 : $this$mapTo$iv) {
                    void it;
                    Node bl15 = (Node)item$iv2;
                    Collection collection = destination$iv3;
                    boolean bl16 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    String string = NodeExtKt.getLocation((Node)((Node)NodeExtKt.getOwnerDocument((Node)it)));
                    collection.add(string);
                }
                Set cfr_ignored_0 = (Set)destination$iv3;
            }
            s2 = this.samples.values();
            destination$iv = this.qualifiedDocuments;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            item$iv2 = $this$forEach$iv$iv.iterator();
            while (item$iv2.hasNext()) {
                VisualDocument visualDocument;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = item$iv2.next();
                boolean bl17 = false;
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl18 = false;
                VisualDocument visualDocument2 = it;
                boolean bl19 = false;
                boolean bl20 = false;
                VisualDocument it4 = visualDocument2;
                boolean bl21 = false;
                if ((this.getDocumentUrls$scent_auto_mining().contains(NodeExtKt.getLocation((Node)((Node)it4.getDocument()))) ? visualDocument2 : null) == null) continue;
                visualDocument = visualDocument;
                boolean bl22 = false;
                boolean bl23 = false;
                VisualDocument it$iv = visualDocument;
                boolean bl24 = false;
                destination$iv.add(it$iv);
            }
        }
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl25 = false;
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setCorpusSize((Document)it.getDocument(), (int)this.getQualifiedDocuments$scent_auto_mining().size());
            Node node = it.getDocument().getExtension().getOwnerBody();
            if (node != null) {
                node.attr("a-corpus-time", this.startTime.toString());
            }
            node = it.getDocument().getExtension().getOwnerBody();
            if (node == null) continue;
            node.attr("a-corpus-size", String.valueOf(this.getQualifiedDocuments$scent_auto_mining().size()));
        }
        $this$forEach$iv = this.regionalTileNodeIndexer.values();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"regionalTileNodeIndexer.values()");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl26 = false;
            Node node = it;
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"it");
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)node, (double)(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)node) / (double)documentSize));
        }
        this.reportDff((Frequency<Integer>)dff);
    }

    private final void reportDff(Frequency<Integer> dff) {
        Object object;
        double p;
        Multiset.Entry mostEntry = dff.getMostEntry();
        Integer mode = (Integer)mostEntry.getElement();
        int termCount = mostEntry.getCount();
        this.recoverableConfidence = p = dff.getModePercentage();
        Logger logger = this.logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger it = logger;
        boolean bl3 = false;
        Object object2 = object = it.isInfoEnabled() ? logger : null;
        if (object != null) {
            logger = StringCompanionObject.INSTANCE;
            String string = "Total %d documents share %d terms out of %d counted (%4.2f%%)";
            Object[] objectArray = new Object[]{mode, termCount, dff.getTotalFrequency(), (double)100 * p};
            boolean bl4 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            object.info(string2);
        }
        object = this.qualifiedDocuments;
        boolean bl5 = false;
        if (!object.isEmpty()) {
            object = StringCompanionObject.INSTANCE;
            String string = "Find %d/%d recoverable documents with confidence %4.2f%%";
            Object[] objectArray = new Object[]{this.qualifiedDocuments.size(), this.samples.size(), (double)100 * p};
            bl2 = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            this.logger.info(string3);
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        } else {
            this.logger.warn("No recoverable documents after pre-processing !!");
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        }
    }

    private final void calculateGeometricFeatures() {
        for (VisualDocument doc : this.qualifiedDocuments) {
            this.layoutLeftIndexer.putAll((Multimap)doc.getLayoutLeftIndexer());
        }
    }

    private final void calculateTextualFeatures() {
        for (VisualDocument doc : this.qualifiedDocuments) {
            Collection collection = doc.getRegionalTileNodeIndexer().values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"doc.regionalTileNodeIndexer.values()");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                String text2;
                Node it;
                block4: {
                    it = (Node)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof TextNode) || StringsKt.isBlank((CharSequence)NodeExtKt.getCleanText((Node)it))) continue;
                    CharSequence charSequence = NodeExtKt.getCleanText((Node)it);
                    String string = "\\s+";
                    boolean bl3 = false;
                    string = new Regex(string);
                    Double[] doubleArray = "_";
                    boolean bl4 = false;
                    text2 = string.replace(charSequence, (String)doubleArray);
                    if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)it)) {
                        NodesKt.forEachAncestor((Node)it, (Function1)((Function1)new Function1<Element, Unit>(text2){
                            final /* synthetic */ String $text;
                            {
                                this.$text = $text;
                                super(1);
                            }

                            public final void invoke(@NotNull Element ancestor) {
                                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                                NodeExtKt.addCaptionWord((Node)((Node)ancestor), (String)this.$text);
                                Element element = ancestor;
                                int n = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNumConstTextNodes((Node)((Node)element));
                                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setNumConstTextNodes((Node)((Node)element), (int)(n + 1));
                            }
                        }));
                        continue;
                    }
                    double df = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it);
                    doubleArray = new Double[]{0.2, 0.25, 0.3333333333333333, 0.5};
                    Double[] $this$any$iv = doubleArray;
                    boolean $i$f$any = false;
                    for (Double element$iv2 : $this$any$iv) {
                        double it2 = ((Number)element$iv2).doubleValue();
                        boolean bl5 = false;
                        if (!Precision.equals((double)df, (double)it2, (int)4)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                if (!bl) continue;
                this.getCategorizedTextNodeIndexer$scent_auto_mining().put((Object)text2, (Object)it);
            }
        }
        NavigableSet navigableSet = this.regionalTileNodeIndexer.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)navigableSet, (String)"regionalTileNodeIndexer.keySet()");
        this.regionalTiles.addAll((Collection)navigableSet);
    }

    private final void calculateCaptionDocFrequency() {
        for (VisualDocument doc : this.qualifiedDocuments) {
            NodeTraversor.filter((NodeFilter)new NodeFilter(this){
                final /* synthetic */ AnalysablePageCorpus this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public NodeFilter.FilterResult head(@NotNull Node node, int depth) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (!(node instanceof Element)) {
                        return NodeFilter.FilterResult.CONTINUE;
                    }
                    if (NodeCharactersKt.isDenseTextBlock$default((Node)node, (HarvestOptions)AnalysablePageCorpus.access$getOptions(this.this$0), (int)0, (int)2, null)) {
                        return NodeFilter.FilterResult.SKIP_ENTIRELY;
                    }
                    if (NodeExtKt.hasCaption((Node)node)) {
                        String caption = NodeExtKt.getCaption((Node)node) + ";" + NodeExtKt.getName((Node)node);
                        this.this$0.getCaptionedElementIndexer$scent_auto_mining().put((Object)caption.hashCode(), (Object)node);
                    }
                    return NodeFilter.FilterResult.CONTINUE;
                }
            }, (Node)((Node)doc.getBody()));
        }
        NavigableMap navigableMap = this.captionedElementIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"captionedElementIndexer.asMap()");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$captionHashCode$nodes = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$captionHashCode$nodes;
            boolean bl3 = false;
            Integer captionHashCode = (Integer)entry.getKey();
            Map.Entry entry2 = $dstr$captionHashCode$nodes;
            boolean bl4 = false;
            Collection nodes2 = (Collection)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Element node = (Element)element$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setCaptionDocFrequency((Node)((Node)node), (double)((double)nodes2.size() / (double)this.getQualifiedDocuments$scent_auto_mining().size()));
                if (Precision.equals((double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)((Node)node)), (double)1.0)) {
                    this.getConstantCaptionedElementIndexer$scent_auto_mining().put((Object)captionHashCode, (Object)node);
                }
                if (!NodeCharactersKt.isPseudoConstantTextBlock((Node)((Node)node), (HarvestOptions)this.getOptions())) continue;
                this.getPseudoConstantTextBlockIndexer$scent_auto_mining().putAll((Object)captionHashCode, (Iterable)nodes2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void partition() {
        void $this$mapTo$iv;
        Iterable $this$flatMapTo$iv;
        if (this.qualifiedDocuments.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            it.partition();
        }
        this.supplementPartition();
        this.findLayoutComponents();
        this.arrangeComponents();
        $this$forEach$iv = this.qualifiedDocuments;
        Collection destination$iv = this.components;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.qualifiedDocuments;
        destination$iv = this.naturalComponents;
        $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getNaturalComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.components;
        destination$iv = this.componentElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VisualComponent list$iv = (VisualComponent)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Element element = it.getElement();
            collection.add(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findLayoutComponents() {
        NavigableMap navigableMap = this.layoutLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"layoutLeftIndexer.asMap()");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$alignedLeft$nodes = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$alignedLeft$nodes;
            boolean bl3 = false;
            Integer alignedLeft = (Integer)entry.getKey();
            Map.Entry entry2 = $dstr$alignedLeft$nodes;
            boolean bl4 = false;
            Collection nodes2 = (Collection)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
            Iterable iterable = nodes2;
            Collection destination$iv = (Collection)new Frequency(null, 1, null);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Node node = (Node)item$iv;
                Collection collection = destination$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getRelativePath((Node)it);
                collection.add(string);
            }
            Frequency relativePaths2 = (Frequency)destination$iv;
            Multiset.Entry mostEntry = relativePaths2.getMostEntry();
            String relativePath = (String)mostEntry.getElement();
            double recall = (double)mostEntry.getCount() / (double)this.getQualifiedDocuments$scent_auto_mining().size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node it = (Node)element$iv2;
                boolean bl6 = false;
                String memo = "lay(" + alignedLeft + ")";
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                VisualDocument visualDocument = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVisualDocument((Document)NodeExtKt.getOwnerDocument((Node)it));
                if (visualDocument == null) continue;
                VisualDocument vd = visualDocument;
                visualDocument = vd.addComponentIfAbsent((Element)it, VisualComponentType.LAYOUT, memo);
                VisualComponent vc = (VisualComponent)visualDocument.component1();
                boolean created = (Boolean)visualDocument.component2();
                if (vc == null || !created) continue;
                Intrinsics.checkNotNullExpressionValue((Object)relativePath, (String)"relativePath");
                vc.setUniquePath(relativePath);
                this.getUniquePathComponents$scent_auto_mining().put((Object)relativePath, (Object)vc);
            }
        }
    }

    private final void enhancePartition() {
    }

    /*
     * WARNING - void declaration
     */
    private final void supplementPartition() {
        Map nodeGroups;
        boolean $i$f$forEach;
        Iterator iterator;
        void $this$flatMapTo$iv;
        Iterable iterable = this.qualifiedDocuments;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable $this$map$iv = it.getComponents();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                VisualComponent visualComponent = (VisualComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                iterator = it2.getRelativePath();
                collection.add(iterator);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet relativePaths2 = (HashSet)destination$iv;
        Iterable $this$associateWith$iv = relativePaths2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            String $i$f$map = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl9 = false;
            Iterable $this$mapNotNull$iv = this.getQualifiedDocuments$scent_auto_mining();
            boolean $i$f$mapNotNull = false;
            Iterable iterable3 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Element element;
                void it;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                VisualDocument doc = (VisualDocument)element$iv$iv2;
                boolean bl4 = false;
                if (doc.getDocument().selectFirst((String)it) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                Element it$iv$iv = element;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            map.put(t, list);
        }
        Map $this$forEach$iv = nodeGroups = (Map)result$iv;
        boolean $i$f$forEach2 = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$relativePath$elements = element$iv = iterator2.next();
            boolean bl8 = false;
            Map.Entry bl9 = $dstr$relativePath$elements;
            boolean bl10 = false;
            String relativePath = (String)bl9.getKey();
            Map.Entry entry = $dstr$relativePath$elements;
            boolean bl11 = false;
            List elements2 = (List)entry.getValue();
            double recall = (double)elements2.size() / (double)this.getQualifiedDocuments$scent_auto_mining().size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = elements2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Element it = (Element)element$iv2;
                boolean bl12 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String memo = "sup(" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)((Node)it)) + ")/" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcTiles((Node)((Node)it));
                VisualDocument visualDocument = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVisualDocument((Document)NodeExtKt.getOwnerDocument((Node)((Node)it)));
                if (visualDocument == null) continue;
                VisualDocument vd = visualDocument;
                visualDocument = vd.addComponentIfAbsent(it, VisualComponentType.SUPPLEMENT, memo);
                VisualComponent vc = (VisualComponent)visualDocument.component1();
                boolean created = (Boolean)visualDocument.component2();
                if (vc != null) {
                    vc.setUniquePath(relativePath);
                    this.getUniquePathComponents$scent_auto_mining().put((Object)relativePath, (Object)vc);
                }
                if (created) continue;
            }
        }
    }

    private final void arrangeComponents() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            it.buildComponentTree();
            it.arrangeComponents();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportComponents() {
        Collection $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.qualifiedDocuments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getComponents().size();
            collection.add(object);
        }
        String counts = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
        this.logger.info("Recognized components in each document: " + counts);
        this.taskLogger.info("Recognized components in each document: " + counts);
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List samples = (List)destination$iv$iv2;
        ResultSet rs = VisualComponent.Companion.toResultSet(samples, this.getOptions());
        StringBuilder buffer = new StringBuilder("Show " + samples.size() + " sample components:\n");
        new ResultSetFormatter(rs, false, true, false, 0, buffer, 26, null).format();
        this.taskLogger.info(buffer.toString());
        $this$flatMapTo$iv$iv = this.naturalComponents;
        boolean destination$iv$iv222 = false;
        if (!$this$flatMapTo$iv$iv.isEmpty()) {
            void $this$mapTo$iv;
            Iterable destination$iv$iv222 = this.naturalComponents;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                VisualComponent bl = (VisualComponent)item$iv;
                collection = destination$iv;
                boolean bl2 = false;
                object = it.getName();
                collection.add(object);
            }
            HashSet names2 = (HashSet)destination$iv;
            this.logger.info("Total {} natural components: {}", (Object)this.naturalComponents.size(), (Object)names2);
        } else {
            this.logger.info("No natural components");
        }
    }

    private final void analysisVariables() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            this.analysisVariables(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analysisVariables(VisualDocument doc) {
        Iterable $this$forEach$iv = doc.getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$mapTo$iv$iv;
            VisualComponent component = (VisualComponent)element$iv;
            boolean bl = false;
            component.findVariables();
            if (!doc.getVerbose() || !this.taskLogger.isDebugEnabled()) continue;
            Object object2 = component.getVariables().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component.variables.asMap()");
            Map $this$map$iv = (Map)object2;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            CharSequence charSequence = $this$mapTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = charSequence.entrySet().iterator();
            while (iterator.hasNext()) {
                void $dstr$keyNode$valueNodes;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                void var20_21 = $dstr$keyNode$valueNodes;
                boolean bl4 = false;
                Node keyNode = (Node)var20_21.getKey();
                void var21_22 = $dstr$keyNode$valueNodes;
                boolean bl5 = false;
                Collection valueNodes = (Collection)var21_22.getValue();
                String string = NodeExtKt.getCleanText((Node)keyNode);
                Intrinsics.checkNotNullExpressionValue((Object)valueNodes, (String)"valueNodes");
                String string2 = "<" + string + " : " + CollectionsKt.joinToString$default((Iterable)valueNodes, null, null, null, (int)0, null, (Function1)analysisVariables.2.1.1.INSTANCE, (int)31, null) + ">";
                collection.add(string2);
            }
            object2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            boolean bl6 = false;
            boolean bl7 = false;
            Object it = object2;
            boolean bl8 = false;
            charSequence = (CharSequence)it;
            bl2 = false;
            Object object3 = object = !StringsKt.isBlank((CharSequence)charSequence) ? object2 : null;
            if (object == null) continue;
            object2 = object;
            bl6 = false;
            bl7 = false;
            it = object2;
            boolean bl9 = false;
            this.taskLogger.debug((String)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void annotateNodes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.annotateNodes((FeaturedDocument)doc.getFeaturedDocument(), (HarvestOptions)this.getOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void simplifyAnnotations() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.simplifyAnnotations((FeaturedDocument)it.getFeaturedDocument(), (HarvestOptions)this.getOptions());
        }
    }

    private final void simplifyCaptions() {
        Collection collection = this.captionedElementIndexer.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"captionedElementIndexer.values()");
        Iterable $this$sortedByDescending$iv = collection;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Element it = (Element)b;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Comparable comparable = Integer.valueOf(NodeExtKt.getDepth((Node)((Node)it)));
                it = (Element)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Integer n = NodeExtKt.getDepth((Node)((Node)it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element node = (Element)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)node, (Object)node.getExtension().getOwnerBody())) {
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
                NodeExtKt.removeVariable((Node)((Node)node), (String)"a-caption");
            }
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
            if (NodeExtKt.hasVariable((Node)((Node)node), (String)"a-caption-ref")) continue;
            NodesKt.forEachAncestor((Node)((Node)node), (Function1)((Function1)new Function1<Element, Unit>(node){
                final /* synthetic */ Element $node;
                {
                    this.$node = $node;
                    super(1);
                }

                public final void invoke(@NotNull Element it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!NodeExtKt.hasVariable((Node)((Node)it), (String)"a-caption-ref")) {
                        Element element = this.$node;
                        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"node");
                        if (Intrinsics.areEqual((Object)NodeExtKt.getCaption((Node)((Node)element)), (Object)NodeExtKt.getCaption((Node)((Node)it)))) {
                            NodeExtKt.clearCaption((Node)((Node)it));
                            Node node = (Node)it;
                            element = this.$node;
                            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"node");
                            NodeExtKt.setVariable((Node)node, (String)"a-caption-ref", (Object)NodeExtKt.getSequence((Node)((Node)element)));
                        }
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFeatures() {
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$forEach$iv = this.qualifiedDocuments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl = false;
                ConcurrentSkipListSet threadIds = NodeExtKt.getThreadIds((Document)it.getDocument());
                if (threadIds.size() <= 1) continue;
                this.logger.warn("Only one thread is allowed to access a document, actual {}, {}", (Object)threadIds.size(), (Object)threadIds);
            }
            Iterable $this$filter$iv = this.qualifiedDocuments;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VisualDocument it = (VisualDocument)element$iv$iv;
                boolean bl = false;
                if (!it.getVerbose()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl = false;
                it.validateFeatures();
            }
        }
        catch (Exception e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
    }

    private static final ArrayList combineTables$lambda-18$lambda-17$lambda-15(int $columnCount, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList($columnCount);
    }

    private static final void calculateGeneralDocFrequency$lambda-41$lambda-40(AnalysablePageCorpus this$0, String name, Frequency tf) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tf, (String)"tf");
        Frequency df = this$0.getDocumentFrequency$scent_auto_mining().computeIfAbsent(name);
        Iterable $this$forEach$iv = tf.elementSet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            df.add((Comparable)((Object)it));
        }
    }

    private static final void buildRegionalTextNodeIndex$lambda-42(AnalysablePageCorpus this$0, RegionalTile regionalText, Collection nodes2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean bl = regionalText.getTf() == (double)nodes2.size();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this$0.getRegionalTileNodeIndexer$scent_auto_mining().putAll((Object)regionalText, (Iterable)nodes2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void calculateTextNodeDocFrequency$lambda-47(double $minDf, Frequency $dff, RegionalTile regionalText, Collection nodes2) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$dff, (String)"$dff");
        Intrinsics.checkNotNullExpressionValue((Object)nodes2, (String)"nodes");
        Iterable iterable = nodes2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Node node = (Node)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String string = NodeExtKt.getLocation((Node)((Node)NodeExtKt.getOwnerDocument((Node)it)));
            collection.add(string);
        }
        int df = ((HashSet)destination$iv).size();
        regionalText.setDf((double)df);
        Iterable $this$forEach$iv = nodes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)it, (double)df);
        }
        if ((double)df >= $minDf) {
            $dff.add((Comparable)Integer.valueOf(df));
        }
    }

    public static final /* synthetic */ HarvestOptions access$getOptions(AnalysablePageCorpus $this) {
        return $this.getOptions();
    }

    static {
        boolean bl = false;
        EMPTY = new AnalysablePageCorpus(HNormUrl.Companion.getNIL(), MapsKt.emptyMap(), ImmutableConfig.Companion.getEMPTY());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$OrderingValue;", "", "order", "", "value", "", "(ILjava/lang/String;)V", "getOrder", "()I", "getValue", "()Ljava/lang/String;", "scent-auto-mining"})
    private static final class OrderingValue {
        private final int order;
        @Nullable
        private final String value;

        public OrderingValue(int order2, @Nullable String value) {
            this.order = order2;
            this.value = value;
        }

        public final int getOrder() {
            return this.order;
        }

        @Nullable
        public final String getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "getEMPTY", "()Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalysablePageCorpus getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

