/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.diagnosis.Distance;
import ai.platon.scent.analysis.diagnosis.DistanceType;
import ai.platon.scent.analysis.diagnosis.NodeClusterDiagnotor;
import ai.platon.scent.ml.HasDistance;
import ai.platon.scent.ml.MathsKt;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.HasCentroid;
import ai.platon.scent.ml.unsupervised.NodeCluster;
import ai.platon.scent.ml.unsupervised.NodeClusterGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedSummaryStatistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010H\u001a\u0002012\u000e\u0010I\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0J2\u000e\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0JH\u0002J\b\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020MH\u0002J\b\u0010O\u001a\u00020MH\u0002J\b\u0010P\u001a\u00020MH\u0002J\b\u0010Q\u001a\u00020MH\u0002J\u0006\u0010R\u001a\u00020MR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001bR\u001b\u0010)\u001a\u00020*8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b+\u0010,R)\u0010/\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t00\u0012\u0004\u0012\u0002010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0018R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u000fR\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\f\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u000fR\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u00160\f\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u000fR\u0014\u00109\u001a\u00020:X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010<R\u0011\u0010?\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001bR\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001bR\u000e\u0010D\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010E\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006S"}, d2={"Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "Lai/platon/scent/ml/HasDistance;", "Lai/platon/scent/ml/unsupervised/HasCentroid;", "miningResult", "Lai/platon/scent/analysis/AutoMiningResult;", "clusterGroup", "Lai/platon/scent/ml/unsupervised/NodeClusterGroup;", "Lai/platon/scent/ml/unsupervised/NodeCluster;", "suggestSampleSize", "", "(Lai/platon/scent/analysis/AutoMiningResult;Lai/platon/scent/ml/unsupervised/NodeClusterGroup;I)V", "centroids", "", "Lorg/apache/commons/math3/linear/RealVector;", "getCentroids", "()Ljava/util/List;", "getClusterGroup", "()Lai/platon/scent/ml/unsupervised/NodeClusterGroup;", "distanceSummary", "", "Lai/platon/scent/analysis/diagnosis/DistanceType;", "", "Lai/platon/scent/analysis/diagnosis/Distance;", "getDistanceSummary", "()Ljava/util/Map;", "documentSize", "getDocumentSize", "()I", "inspectors", "Lai/platon/scent/analysis/diagnosis/NodeClusterDiagnotor;", "getInspectors", "logger", "Lorg/slf4j/Logger;", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getMiningResult", "()Lai/platon/scent/analysis/AutoMiningResult;", "order", "getOrder", "pairwiseCentroidDistances", "Lorg/apache/commons/math3/linear/Array2DRowRealMatrix;", "getPairwiseCentroidDistances", "()Lorg/apache/commons/math3/linear/Array2DRowRealMatrix;", "pairwiseCentroidDistances$delegate", "Lkotlin/Lazy;", "pairwiseClusterDistancesSummary", "Lkotlin/Pair;", "Lorg/apache/commons/math3/stat/descriptive/SummaryStatistics;", "getPairwiseClusterDistancesSummary", "pairwiseNeighborsByCentroid", "getPairwiseNeighborsByCentroid", "pairwiseNeighborsByFarthestPoints", "getPairwiseNeighborsByFarthestPoints", "pairwiseNeighborsByNearestPoints", "getPairwiseNeighborsByNearestPoints", "qualifiedRate", "", "getQualifiedRate", "()D", "qualifiedSize", "getQualifiedSize", "size", "getSize", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "getSuggestSampleSize", "timingLogger", "widestCluster", "getWidestCluster", "()Lai/platon/scent/analysis/diagnosis/NodeClusterDiagnotor;", "calcInterClusterPairwisePointDistancesSummary", "cluster", "Lai/platon/scent/ml/unsupervised/Cluster;", "cluster2", "calculateNearestNeighborsByCentroid", "", "calculateNearestNeighborsByFarthestPoints", "calculateNearestNeighborsByNearestPoints", "calculatePairwiseClusterDistancesSummary", "calculatePairwiseNearestClusterNeighbors", "diagnose", "scent-auto-mining"})
public final class ClusterTaskDiagnotor
implements HasDistance,
HasCentroid {
    @NotNull
    private final AutoMiningResult miningResult;
    @NotNull
    private final NodeClusterGroup<? extends NodeCluster> clusterGroup;
    private final int suggestSampleSize;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger timingLogger;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    private final int size;
    private final double qualifiedRate;
    @NotNull
    private final DistanceMeasure measure;
    @NotNull
    private final List<NodeClusterDiagnotor> inspectors;
    @NotNull
    private final List<RealVector> centroids;
    @NotNull
    private final Lazy pairwiseCentroidDistances$delegate;
    @NotNull
    private final Map<Pair<Integer, Integer>, SummaryStatistics> pairwiseClusterDistancesSummary;
    @NotNull
    private final List<Distance> pairwiseNeighborsByCentroid;
    @NotNull
    private final List<Distance> pairwiseNeighborsByNearestPoints;
    @NotNull
    private final List<Distance> pairwiseNeighborsByFarthestPoints;
    @NotNull
    private final Map<DistanceType, List<Distance>> distanceSummary;

    public ClusterTaskDiagnotor(@NotNull AutoMiningResult miningResult, @NotNull NodeClusterGroup<? extends NodeCluster> clusterGroup, int suggestSampleSize) {
        Intrinsics.checkNotNullParameter((Object)miningResult, (String)"miningResult");
        Intrinsics.checkNotNullParameter(clusterGroup, (String)"clusterGroup");
        this.miningResult = miningResult;
        this.clusterGroup = clusterGroup;
        this.suggestSampleSize = suggestSampleSize;
        this.logger = LogsKt.getLogger((Object)this);
        this.timingLogger = LogsKt.getLogger((Object)this, (String)".Timing");
        this.stopWatch = this.timingLogger.isDebugEnabled() ? new Slf4JStopWatch(this.timingLogger) : null;
        this.size = this.clusterGroup.getSize();
        this.qualifiedRate = 0.1;
        this.measure = (DistanceMeasure)this.miningResult.getPortalUrl().getHOptions().getMeasure();
        boolean bl = false;
        this.inspectors = new ArrayList();
        bl = false;
        this.centroids = new ArrayList();
        this.pairwiseCentroidDistances$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Array2DRowRealMatrix>(this){
            final /* synthetic */ ClusterTaskDiagnotor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Array2DRowRealMatrix invoke() {
                return new Array2DRowRealMatrix(this.this$0.getSize(), this.this$0.getSize());
            }
        }));
        bl = false;
        this.pairwiseClusterDistancesSummary = new LinkedHashMap();
        bl = false;
        this.pairwiseNeighborsByCentroid = new ArrayList();
        bl = false;
        this.pairwiseNeighborsByNearestPoints = new ArrayList();
        bl = false;
        this.pairwiseNeighborsByFarthestPoints = new ArrayList();
        bl = false;
        this.distanceSummary = new LinkedHashMap();
    }

    public /* synthetic */ ClusterTaskDiagnotor(AutoMiningResult autoMiningResult, NodeClusterGroup nodeClusterGroup, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 40;
        }
        this(autoMiningResult, nodeClusterGroup, n);
    }

    @NotNull
    public final AutoMiningResult getMiningResult() {
        return this.miningResult;
    }

    @NotNull
    public final NodeClusterGroup<? extends NodeCluster> getClusterGroup() {
        return this.clusterGroup;
    }

    public final int getSuggestSampleSize() {
        return this.suggestSampleSize;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getDocumentSize() {
        return this.miningResult.getSize();
    }

    public final double getQualifiedRate() {
        return this.qualifiedRate;
    }

    public final double getQualifiedSize() {
        double d = this.qualifiedRate * (double)this.getDocumentSize();
        double d2 = 2.0;
        boolean bl = false;
        return Math.max(d, d2);
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @NotNull
    public final List<NodeClusterDiagnotor> getInspectors() {
        return this.inspectors;
    }

    @Nullable
    public final NodeClusterDiagnotor getWidestCluster() {
        Object v0;
        Iterable $this$maxByOrNull$iv = this.inspectors;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                NodeClusterDiagnotor it = (NodeClusterDiagnotor)maxElem$iv;
                boolean bl = false;
                double maxValue$iv = it.getDiameter();
                do {
                    Object e$iv = iterator$iv.next();
                    NodeClusterDiagnotor it2 = (NodeClusterDiagnotor)e$iv;
                    $i$a$-maxByOrNull-ClusterTaskDiagnotor$widestCluster$1 = false;
                    double v$iv = it2.getDiameter();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    @NotNull
    public final List<RealVector> getCentroids() {
        return this.centroids;
    }

    @NotNull
    public final Array2DRowRealMatrix getPairwiseCentroidDistances() {
        Lazy lazy = this.pairwiseCentroidDistances$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Array2DRowRealMatrix)lazy.getValue();
    }

    @NotNull
    public final Map<Pair<Integer, Integer>, SummaryStatistics> getPairwiseClusterDistancesSummary() {
        return this.pairwiseClusterDistancesSummary;
    }

    @NotNull
    public final List<Distance> getPairwiseNeighborsByCentroid() {
        return this.pairwiseNeighborsByCentroid;
    }

    @NotNull
    public final List<Distance> getPairwiseNeighborsByNearestPoints() {
        return this.pairwiseNeighborsByNearestPoints;
    }

    @NotNull
    public final List<Distance> getPairwiseNeighborsByFarthestPoints() {
        return this.pairwiseNeighborsByFarthestPoints;
    }

    @NotNull
    public final Map<DistanceType, List<Distance>> getDistanceSummary() {
        return this.distanceSummary;
    }

    public final int getOrder() {
        return -((int)this.clusterGroup.getScore().toDouble());
    }

    /*
     * WARNING - void declaration
     */
    public final void diagnose() {
        NodeClusterDiagnotor nodeClusterDiagnotor;
        boolean bl;
        Collection collection;
        Slf4JStopWatch $this$mapTo$iv;
        if (this.clusterGroup.isEmpty()) {
            return;
        }
        Object object = this.stopWatch;
        if (object != null) {
            object.start("diagnose");
        }
        object = this.clusterGroup.getClusters();
        Collection destination$iv = this.inspectors;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NodeCluster nodeCluster = (NodeCluster)item$iv;
            collection = destination$iv;
            bl = false;
            nodeClusterDiagnotor = new NodeClusterDiagnotor((NodeCluster)it, this.getSuggestSampleSize(), this.getMeasure());
            collection.add(nodeClusterDiagnotor);
        }
        Iterable $this$forEachIndexed$iv = this.inspectors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void inspector;
            int it = index$iv++;
            bl = false;
            if (it < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodeClusterDiagnotor nodeClusterDiagnotor2 = (NodeClusterDiagnotor)item$iv;
            int i = it;
            boolean bl2 = false;
            inspector.diagnose();
        }
        $this$forEachIndexed$iv = this.stopWatch;
        if ($this$forEachIndexed$iv != null) {
            $this$forEachIndexed$iv.lap("Inspector.diagnose");
        }
        $this$forEachIndexed$iv = this.inspectors;
        destination$iv = this.centroids;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            NodeClusterDiagnotor it = (NodeClusterDiagnotor)item$iv;
            collection = destination$iv;
            boolean bl3 = false;
            nodeClusterDiagnotor = it.getCentroid();
            collection.add(nodeClusterDiagnotor);
        }
        MathsKt.fillSymmetricalMatrix(this.centroids, (RealMatrix)this.getPairwiseCentroidDistances(), (Function2<? super RealVector, ? super RealVector, Double>)((Function2)new Function2<RealVector, RealVector, Double>(this){
            final /* synthetic */ ClusterTaskDiagnotor this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Double invoke(@NotNull RealVector p1, @NotNull RealVector p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return this.this$0.distance(p1, p2);
            }
        }));
        $this$mapTo$iv = this.stopWatch;
        if ($this$mapTo$iv != null) {
            $this$mapTo$iv.lap("SymmetricalMatrix");
        }
        this.calculatePairwiseNearestClusterNeighbors();
        int diagnoseLevel = 100;
        this.logger.debug("PairwiseClusterDistancesSummary is ignored because it takes too much time");
    }

    /*
     * WARNING - void declaration
     */
    private final void calculatePairwiseClusterDistancesSummary() {
        Iterable $this$forEachIndexed$iv = this.clusterGroup.getClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodeCluster nodeCluster = (NodeCluster)item$iv;
            int i = n;
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv2 = this.getClusterGroup().getClusters();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void c2;
                void c1;
                int n2 = index$iv2++;
                boolean bl3 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NodeCluster nodeCluster2 = (NodeCluster)item$iv2;
                int j = n2;
                boolean bl4 = false;
                if (i >= j) continue;
                SummaryStatistics summary = this.calcInterClusterPairwisePointDistancesSummary((Cluster)c1, (Cluster)c2);
                Map<Pair<Integer, Integer>, SummaryStatistics> map = this.getPairwiseClusterDistancesSummary();
                Pair pair = TuplesKt.to((Object)i, (Object)j);
                boolean bl5 = false;
                map.put((Pair<Integer, Integer>)pair, summary);
                map = this.getPairwiseClusterDistancesSummary();
                pair = TuplesKt.to((Object)j, (Object)i);
                bl5 = false;
                map.put((Pair<Integer, Integer>)pair, summary);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculatePairwiseNearestClusterNeighbors() {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapIndexedTo$iv$iv222;
        this.calculateNearestNeighborsByCentroid();
        Object object2 = this.stopWatch;
        if (object2 != null) {
            object2.lap("calculateNearestNeighborsByCentroid");
        }
        this.calculateNearestNeighborsByFarthestPoints();
        object2 = this.stopWatch;
        if (object2 != null) {
            object2.lap("calculateNearestNeighborsByFarthestPoints");
        }
        this.calculateNearestNeighborsByNearestPoints();
        object2 = this.stopWatch;
        if (object2 != null) {
            object2.lap("calculateNearestNeighborsByNearestPoints");
        }
        object2 = this.distanceSummary;
        DistanceType distanceType = DistanceType.DIAMETER;
        Iterable $this$mapIndexed$iv = this.inspectors;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv222) {
            void cluster2;
            void i;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodeClusterDiagnotor nodeClusterDiagnotor = (NodeClusterDiagnotor)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = TuplesKt.to((Object)((int)i), (Object)cluster2.getDiameter());
            collection.add(object);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean $this$mapIndexedTo$iv$iv222 = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)it.getSecond();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        boolean $i$f$map = false;
        Iterable $this$mapIndexedTo$iv$iv222 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new Distance(((Number)it.getFirst()).intValue(), ((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).doubleValue(), null, 8, null);
            collection.add(object);
        }
        List list = (List)destination$iv$iv;
        boolean bl = false;
        object2.put(distanceType, list);
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateNearestNeighborsByCentroid() {
        List<Distance> neighbors = this.pairwiseNeighborsByCentroid;
        int n = 0;
        int n2 = this.size;
        if (n < n2) {
            do {
                Object v0;
                void $this$minByOrNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                int i = n++;
                Object object = this.getPairwiseCentroidDistances().getRow(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pairwiseCentroidDistances.getRow(i)");
                object = ArraysKt.withIndex((double[])object);
                boolean $i$f$filter = false;
                void var8_13 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IndexedValue it = (IndexedValue)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getIndex() > i)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        IndexedValue it = (IndexedValue)minElem$iv;
                        boolean bl = false;
                        double minValue$iv = ((Number)it.getValue()).doubleValue();
                        do {
                            Object e$iv = iterator$iv.next();
                            IndexedValue it2 = (IndexedValue)e$iv;
                            $i$a$-minByOrNull-ClusterTaskDiagnotor$calculateNearestNeighborsByCentroid$2 = false;
                            double v$iv = ((Number)it2.getValue()).doubleValue();
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                IndexedValue indexedValue = v0;
                if (indexedValue == null) continue;
                object = indexedValue;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                neighbors.add(new Distance(i, it.getIndex(), ((Number)it.getValue()).doubleValue(), null, 8, null));
            } while (n < n2);
        }
        Map<DistanceType, List<Distance>> map = this.distanceSummary;
        DistanceType distanceType = DistanceType.CENTROID;
        Iterable $this$sortedBy$iv = neighbors;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Distance it = (Distance)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getDistance());
                it = (Distance)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getDistance();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        boolean bl4 = false;
        map.put(distanceType, list);
    }

    private final void calculateNearestNeighborsByNearestPoints() {
        List<Distance> neighbors = this.pairwiseNeighborsByNearestPoints;
        int n = 0;
        int n2 = this.size;
        if (n < n2) {
            do {
                int i = n++;
                double min = Double.MAX_VALUE;
                int closestCluster = -1;
                int n3 = 0;
                int n4 = this.size;
                if (n3 < n4) {
                    do {
                        double d;
                        double d2;
                        int j;
                        if (i <= (j = n3++)) continue;
                        SummaryStatistics summaryStatistics = this.pairwiseClusterDistancesSummary.get(TuplesKt.to((Object)i, (Object)j));
                        double d3 = d2 = summaryStatistics == null ? Double.MAX_VALUE : (d = summaryStatistics.getMin());
                        if (!(d2 < min)) continue;
                        min = d2;
                        closestCluster = j;
                    } while (n3 < n4);
                }
                if (closestCluster < 0) continue;
                neighbors.add(new Distance(i, closestCluster, min, null, 8, null));
            } while (n < n2);
        }
        Map<DistanceType, List<Distance>> map = this.distanceSummary;
        DistanceType distanceType = DistanceType.NEAREST;
        Iterable $this$sortedBy$iv = neighbors;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Distance it = (Distance)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getDistance());
                it = (Distance)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getDistance();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        boolean bl2 = false;
        map.put(distanceType, list);
    }

    private final void calculateNearestNeighborsByFarthestPoints() {
        List<Distance> neighbors = this.pairwiseNeighborsByFarthestPoints;
        int n = 0;
        int n2 = this.size;
        if (n < n2) {
            do {
                int i = n++;
                double max = Double.MIN_VALUE;
                int closestCluster = -1;
                int n3 = 0;
                int n4 = this.size;
                if (n3 < n4) {
                    do {
                        double d;
                        double d2;
                        int j;
                        if (i <= (j = n3++)) continue;
                        SummaryStatistics summaryStatistics = this.pairwiseClusterDistancesSummary.get(TuplesKt.to((Object)i, (Object)j));
                        double d3 = d2 = summaryStatistics == null ? Double.MIN_VALUE : (d = summaryStatistics.getMax());
                        if (!(d2 > max)) continue;
                        max = d2;
                        closestCluster = j;
                    } while (n3 < n4);
                }
                if (closestCluster < 0) continue;
                neighbors.add(new Distance(i, closestCluster, max, null, 8, null));
            } while (n < n2);
        }
        Map<DistanceType, List<Distance>> map = this.distanceSummary;
        DistanceType distanceType = DistanceType.FARTHEST;
        Iterable $this$sortedBy$iv = neighbors;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Distance it = (Distance)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getDistance());
                it = (Distance)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getDistance();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        boolean bl2 = false;
        map.put(distanceType, list);
    }

    private final SummaryStatistics calcInterClusterPairwisePointDistancesSummary(Cluster<? extends RealVector> cluster2, Cluster<? extends RealVector> cluster22) {
        boolean bl = !Intrinsics.areEqual(cluster2, cluster22);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SynchronizedSummaryStatistics summary = new SynchronizedSummaryStatistics();
        cluster2.getPoints().parallelStream().forEach(arg_0 -> ClusterTaskDiagnotor.calcInterClusterPairwisePointDistancesSummary$lambda-16(cluster22, summary, this, arg_0));
        return (SummaryStatistics)summary;
    }

    @Override
    @NotNull
    public <T extends RealVector> RealVector centroidOf(@NotNull Cluster<T> cluster2) {
        return HasCentroid.DefaultImpls.centroidOf(this, cluster2);
    }

    @Override
    @NotNull
    public <T extends RealVector> RealVector centroidOf(@NotNull Collection<? extends T> points, int dimension) {
        return HasCentroid.DefaultImpls.centroidOf(this, points, dimension);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return HasDistance.DefaultImpls.distance((HasDistance)this, p1, p2);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return HasDistance.DefaultImpls.distance((HasDistance)this, p1, p2);
    }

    private static final void calcInterClusterPairwisePointDistancesSummary$lambda-16(Cluster $cluster2, SynchronizedSummaryStatistics $summary, ClusterTaskDiagnotor this$0, RealVector p1) {
        Intrinsics.checkNotNullParameter((Object)$cluster2, (String)"$cluster2");
        Intrinsics.checkNotNullParameter((Object)$summary, (String)"$summary");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $cluster2.getPoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RealVector p2 = (RealVector)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)p1, (String)"p1");
            $summary.addValue(this$0.distance(p1, p2));
        }
    }
}

