/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.Cluster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0002R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/platon/scent/analysis/diagnosis/ExtraEvaluator;", "", "clusters", "", "Lai/platon/scent/ml/unsupervised/Cluster;", "Lai/platon/scent/ml/NodePoint;", "(Ljava/util/List;)V", "_dd", "", "Lkotlin/Pair;", "_ds", "_sd", "_ss", "getClusters", "()Ljava/util/List;", "dd", "", "ds", "fmi", "", "getFmi", "()D", "jc", "getJc", "ri", "getRi", "sd", "ss", "compute", "", "computeContingencyTable", "scent-auto-mining"})
public final class ExtraEvaluator {
    @NotNull
    private final List<Cluster<NodePoint>> clusters;
    @NotNull
    private final List<Pair<NodePoint, NodePoint>> _ss;
    @NotNull
    private final List<Pair<NodePoint, NodePoint>> _sd;
    @NotNull
    private final List<Pair<NodePoint, NodePoint>> _ds;
    @NotNull
    private final List<Pair<NodePoint, NodePoint>> _dd;
    private int ss;
    private int sd;
    private int ds;
    private int dd;

    public ExtraEvaluator(@NotNull List<? extends Cluster<NodePoint>> clusters) {
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        this.clusters = clusters;
        boolean bl = false;
        this._ss = new ArrayList();
        bl = false;
        this._sd = new ArrayList();
        bl = false;
        this._ds = new ArrayList();
        bl = false;
        this._dd = new ArrayList();
    }

    @NotNull
    public final List<Cluster<NodePoint>> getClusters() {
        return this.clusters;
    }

    public final double getJc() {
        return 1.0 * (double)this.ss / (double)(this.ss + this.sd + this.ds);
    }

    public final double getFmi() {
        return (double)this.ss / FastMath.sqrt((double)(1.0 * (double)(this.ss + this.sd) * (double)(this.ss + this.ds)));
    }

    public final double getRi() {
        return 1.0 * (double)(this.ss + this.dd) / (double)(this.ss + this.sd + this.ds + this.dd);
    }

    public final void compute() {
        this.computeContingencyTable();
    }

    /*
     * WARNING - void declaration
     */
    private final void computeContingencyTable() {
        Iterator<Cluster<NodePoint>> iterator = this.clusters.iterator();
        while (iterator.hasNext()) {
            int n = 0;
            Cluster<NodePoint> cluster2 = iterator.next();
            int size = cluster2.getPoints().size();
            if (n >= size) continue;
            do {
                int i = n++;
                int n2 = 0;
                if (n2 >= size) continue;
                do {
                    ExtraEvaluator extraEvaluator;
                    void $this$getVariable$iv;
                    void $this$getVariable$iv2;
                    void $this$getVariable$iv3;
                    void $this$getVariable$iv4;
                    int j;
                    if (i >= (j = n2++)) continue;
                    NodePoint xi = cluster2.getPoints().get(i);
                    NodePoint xj = cluster2.getPoints().get(j);
                    Pair pair = TuplesKt.to((Object)((Object)xi), (Object)((Object)xj));
                    Node node = xi.getNode();
                    String name$iv = "predicatedLabel";
                    boolean $i$f$getVariable = false;
                    Object v$iv = $this$getVariable$iv4.getExtension().getVariables().get(name$iv);
                    Integer pi = (Integer)(v$iv instanceof Integer ? v$iv : null);
                    name$iv = xj.getNode();
                    String name$iv2 = "predicatedLabel";
                    boolean $i$f$getVariable2 = false;
                    Object v$iv2 = $this$getVariable$iv3.getExtension().getVariables().get(name$iv2);
                    Integer pj = (Integer)(v$iv2 instanceof Integer ? v$iv2 : null);
                    name$iv2 = xi.getNode();
                    String name$iv3 = "label";
                    boolean $i$f$getVariable3 = false;
                    Object v$iv3 = $this$getVariable$iv2.getExtension().getVariables().get(name$iv3);
                    Integer ri = (Integer)(v$iv3 instanceof Integer ? v$iv3 : null);
                    name$iv3 = xj.getNode();
                    String name$iv4 = "label";
                    boolean $i$f$getVariable4 = false;
                    Object v$iv4 = $this$getVariable$iv.getExtension().getVariables().get(name$iv4);
                    Integer rj = (Integer)(v$iv4 instanceof Integer ? v$iv4 : null);
                    if (Intrinsics.areEqual((Object)pi, (Object)pj) && Intrinsics.areEqual((Object)ri, (Object)rj)) {
                        extraEvaluator = this;
                        ++extraEvaluator.ss;
                        int cfr_ignored_0 = extraEvaluator.ss;
                        this._ss.add((Pair<NodePoint, NodePoint>)pair);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)pi, (Object)pj) && !Intrinsics.areEqual((Object)ri, (Object)rj)) {
                        extraEvaluator = this;
                        ++extraEvaluator.sd;
                        int cfr_ignored_1 = extraEvaluator.sd;
                        this._sd.add((Pair<NodePoint, NodePoint>)pair);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)pi, (Object)pj) && Intrinsics.areEqual((Object)ri, (Object)rj)) {
                        extraEvaluator = this;
                        ++extraEvaluator.ds;
                        int cfr_ignored_2 = extraEvaluator.ds;
                        this._ds.add((Pair<NodePoint, NodePoint>)pair);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)pi, (Object)pj) || Intrinsics.areEqual((Object)ri, (Object)rj)) continue;
                    extraEvaluator = this;
                    ++extraEvaluator.dd;
                    int cfr_ignored_3 = extraEvaluator.dd;
                    this._dd.add((Pair<NodePoint, NodePoint>)pair);
                } while (n2 < size);
            } while (n < size);
        }
    }
}

