/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.scent.analysis.diagnosis.ClusteringEvaluator;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.Measurable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/analysis/diagnosis/SumOfClusterVariances;", "Lai/platon/scent/ml/unsupervised/Measurable;", "Lai/platon/scent/analysis/diagnosis/ClusteringEvaluator;", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "(Lorg/apache/commons/math3/ml/distance/DistanceMeasure;)V", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "score", "", "clusters", "", "Lai/platon/scent/ml/unsupervised/CentroidCluster;", "Lai/platon/scent/ml/NodePoint;", "scent-auto-mining"})
public final class SumOfClusterVariances
extends ClusteringEvaluator
implements Measurable {
    @NotNull
    private final DistanceMeasure measure;

    public SumOfClusterVariances(@NotNull DistanceMeasure measure) {
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.measure = measure;
    }

    public /* synthetic */ SumOfClusterVariances(DistanceMeasure distanceMeasure, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        this(distanceMeasure);
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @Override
    public double score(@NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        double varianceSum = 0.0;
        for (CentroidCluster<NodePoint> centroidCluster : clusters) {
            Variance stat = new Variance();
            Iterable $this$forEach$iv = centroidCluster.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint it = (NodePoint)((Object)element$iv);
                boolean bl = false;
                stat.increment(this.distance((RealVector)it, centroidCluster.getCentroid()));
            }
            varianceSum += stat.getResult();
        }
        return varianceSum;
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        return Measurable.DefaultImpls.findClosestCluster(this, i, point, clusters);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }

    public SumOfClusterVariances() {
        this(null, 1, null);
    }
}

