/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.classifier;

import ai.platon.pulsar.common.FuzzyProbability;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.data.BlockLabel;
import ai.platon.scent.diagnosis.ScentDiagnostor;
import ai.platon.scent.feature.FeatureBeanFactory;
import ai.platon.scent.feature.ScentRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00100\u001a\u000201H\u0002J)\u00102\u001a\u0002012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0016\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020+2\u0006\u00105\u001a\u000206J\u0018\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\u0016H$J\b\u0010;\u001a\u000201H\u0004J\u0010\u0010;\u001a\u0002012\u0006\u00109\u001a\u00020\u0011H\u0002J\b\u0010:\u001a\u000201H\u0014J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00160=H&J\u0018\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020+H\u0004J)\u0010A\u001a\u0002012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0002\u00a2\u0006\u0002\u00103R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006C"}, d2={"Lai/platon/scent/classifier/FragmentClassifier;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "diagnostor", "Lai/platon/scent/diagnosis/ScentDiagnostor;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/scent/diagnosis/ScentDiagnostor;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getDiagnostor", "()Lai/platon/scent/diagnosis/ScentDiagnostor;", "featureFactory", "Lai/platon/scent/feature/FeatureBeanFactory;", "getFeatureFactory", "()Lai/platon/scent/feature/FeatureBeanFactory;", "<set-?>", "", "Lai/platon/pulsar/dom/DocumentFragment;", "fragments", "getFragments", "()[Lai/platon/pulsar/dom/DocumentFragment;", "[Lai/platon/pulsar/dom/DocumentFragment;", "", "labels", "getLabels", "()[Ljava/lang/String;", "[Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "scoreMatrix", "Lorg/apache/commons/math3/linear/RealMatrix;", "getScoreMatrix", "()Lorg/apache/commons/math3/linear/RealMatrix;", "setScoreMatrix", "(Lorg/apache/commons/math3/linear/RealMatrix;)V", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "getStopWatch", "()Lorg/perf4j/slf4j/Slf4JStopWatch;", "weight", "", "getWeight", "()D", "setWeight", "(D)V", "calculateScore", "", "classify", "([Lai/platon/pulsar/dom/DocumentFragment;[Ljava/lang/String;)V", "getLabel", "segmentIndex", "", "getLabelScore", "getScore", "fragment", "label", "inheritLabels", "labelsInCharge", "", "normalize", "min", "max", "reset", "segments", "scent-auto-mining"})
public abstract class FragmentClassifier {
    @NotNull
    private final ImmutableConfig conf;
    @Nullable
    private final ScentDiagnostor diagnostor;
    private final Logger log;
    @NotNull
    private final FeatureBeanFactory featureFactory;
    @NotNull
    private DocumentFragment[] fragments;
    @NotNull
    private String[] labels;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private RealMatrix scoreMatrix;
    private double weight;

    public FragmentClassifier(@NotNull ImmutableConfig conf, @Nullable ScentDiagnostor diagnostor) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.diagnostor = diagnostor;
        this.log = LoggerFactory.getLogger(FragmentClassifier.class);
        this.featureFactory = new FeatureBeanFactory(this.conf);
        this.fragments = new DocumentFragment[0];
        this.labels = new String[0];
        this.stopWatch = this.diagnostor != null ? new Slf4JStopWatch() : null;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((int)1, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"createRealMatrix(1, 1)");
        this.scoreMatrix = realMatrix;
        this.weight = 1.0;
    }

    public /* synthetic */ FragmentClassifier(ImmutableConfig immutableConfig, ScentDiagnostor scentDiagnostor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scentDiagnostor = null;
        }
        this(immutableConfig, scentDiagnostor);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @Nullable
    public final ScentDiagnostor getDiagnostor() {
        return this.diagnostor;
    }

    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final FeatureBeanFactory getFeatureFactory() {
        return this.featureFactory;
    }

    @NotNull
    public final DocumentFragment[] getFragments() {
        return this.fragments;
    }

    @NotNull
    public final String[] getLabels() {
        return this.labels;
    }

    @Nullable
    public Slf4JStopWatch getStopWatch() {
        return this.stopWatch;
    }

    @NotNull
    public final RealMatrix getScoreMatrix() {
        return this.scoreMatrix;
    }

    public final void setScoreMatrix(@NotNull RealMatrix realMatrix) {
        Intrinsics.checkNotNullParameter((Object)realMatrix, (String)"<set-?>");
        this.scoreMatrix = realMatrix;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double d) {
        this.weight = d;
    }

    @NotNull
    public final String getLabel(int segmentIndex) {
        int index = this.scoreMatrix.getRowVector(segmentIndex).getMaxIndex();
        return this.labels[index];
    }

    public final double getLabelScore(int segmentIndex) {
        double[] dArray = this.scoreMatrix.getRow(segmentIndex);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"scoreMatrix.getRow(segmentIndex)");
        Double d = ArraysKt.maxOrNull((double[])dArray);
        return d == null ? 0.0 : d;
    }

    private final void reset(DocumentFragment[] segments, String[] labels) {
        this.fragments = segments;
        this.labels = labels;
        this.scoreMatrix = (RealMatrix)new OpenMapRealMatrix(segments.length, labels.length);
    }

    public void classify(@NotNull DocumentFragment[] fragments, @NotNull String[] labels) {
        Intrinsics.checkNotNullParameter((Object)fragments, (String)"fragments");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        if (this.weight == 0.0) {
            return;
        }
        this.reset(fragments, labels);
        this.calculateScore();
    }

    @NotNull
    public abstract Iterable<String> labelsInCharge();

    protected abstract double getScore(@NotNull DocumentFragment var1, @NotNull String var2);

    @NotNull
    protected final RealMatrix normalize(double min, double max) {
        return this.scoreMatrix;
    }

    protected void label() {
        int n = 0;
        Set appliedLabels = new LinkedHashSet();
        n = 0;
        int n2 = this.fragments.length + -1;
        if (n <= n2) {
            do {
                int row = n++;
                int n3 = 0;
                int n4 = this.labels.length + -1;
                if (n3 > n4) continue;
                do {
                    int col;
                    double likelihood;
                    if (!FuzzyProbability.maybe((double)(likelihood = this.scoreMatrix.getEntry(row, col = n3++)))) continue;
                    String label = this.labels[col];
                    appliedLabels.add(label);
                    this.fragments[row].getClues().set(label, likelihood);
                } while (n3 <= n4);
            } while (n <= n2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Applied labels : " + CollectionsKt.joinToString$default((Iterable)appliedLabels, null, null, null, (int)0, null, null, (int)63, null));
        }
    }

    protected final void inheritLabels() {
        boolean bl = this.fragments.length >= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        int n = 0;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.fragments[0].getBaseSequence() < this.fragments[1].getBaseSequence();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        n = 0;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DocumentFragment[] $this$forEach$iv = this.fragments;
        boolean $i$f$forEach = false;
        DocumentFragment[] documentFragmentArray = $this$forEach$iv;
        n = documentFragmentArray.length;
        for (int i = 0; i < n; ++i) {
            DocumentFragment element$iv;
            DocumentFragment it = element$iv = documentFragmentArray[i];
            boolean bl6 = false;
            this.inheritLabels(it);
        }
    }

    private final void calculateScore() {
        int n = 0;
        int n2 = this.fragments.length + -1;
        if (n <= n2) {
            do {
                int row = n++;
                int n3 = 0;
                int n4 = this.labels.length + -1;
                if (n3 > n4) continue;
                do {
                    int col;
                    double score2;
                    if ((score2 = this.getScore(this.fragments[row], this.labels[col = n3++])) > ScentRule.Companion.getMAX_ELEMENT_SCORE()) {
                        score2 = ScentRule.Companion.getMAX_ELEMENT_SCORE();
                    }
                    if (score2 < ScentRule.Companion.getMIN_ELEMENT_SCORE()) {
                        score2 = ScentRule.Companion.getMIN_ELEMENT_SCORE();
                    }
                    this.scoreMatrix.setEntry(row, col, score2 / ScentRule.Companion.getMAX_ELEMENT_SCORE());
                } while (n3 <= n4);
            } while (n <= n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void inheritLabels(DocumentFragment fragment) {
        for (DocumentFragment child : fragment.getChildren()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = fragment.getLabels();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!new BlockLabel(it).isInheritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                child.addLabel(it);
            }
        }
    }
}

