/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.scent.classifier.FragmentClassifier;
import ai.platon.scent.diagnosis.DiagnosisFormatter;
import java.text.DecimalFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lai/platon/scent/diagnosis/ClassifierMatrixFormatter;", "Lai/platon/scent/diagnosis/DiagnosisFormatter;", "classifier", "Lai/platon/scent/classifier/FragmentClassifier;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/classifier/FragmentClassifier;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "diagnoseLabels", "", "", "getDiagnoseLabels", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fragments", "Lai/platon/pulsar/dom/DocumentFragment;", "getFragments", "()[Lai/platon/pulsar/dom/DocumentFragment;", "[Lai/platon/pulsar/dom/DocumentFragment;", "labels", "getLabels", "scoreMatrix", "Lorg/apache/commons/math3/linear/RealMatrix;", "getScoreMatrix", "()Lorg/apache/commons/math3/linear/RealMatrix;", "buildRowValues", "Lkotlin/Pair;", "", "row", "", "buildTable", "", "formatScore", "score", "process", "scent-auto-mining"})
public final class ClassifierMatrixFormatter
extends DiagnosisFormatter {
    @NotNull
    private final FragmentClassifier classifier;
    @NotNull
    private final DocumentFragment[] fragments;
    @NotNull
    private final String[] labels;
    @NotNull
    private final RealMatrix scoreMatrix;
    @NotNull
    private final String[] diagnoseLabels;

    public ClassifierMatrixFormatter(@NotNull FragmentClassifier classifier, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf);
        this.classifier = classifier;
        this.fragments = this.classifier.getFragments();
        this.labels = this.classifier.getLabels();
        this.scoreMatrix = this.classifier.getScoreMatrix();
        String[] stringArray = this.labels;
        this.diagnoseLabels = conf.getTrimmedStrings("scent.diagnose.classifier.block.labels", Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public final DocumentFragment[] getFragments() {
        return this.fragments;
    }

    @NotNull
    public final String[] getLabels() {
        return this.labels;
    }

    @NotNull
    public final RealMatrix getScoreMatrix() {
        return this.scoreMatrix;
    }

    @NotNull
    public final String[] getDiagnoseLabels() {
        return this.diagnoseLabels;
    }

    @Override
    public void process() {
        this.setCaption(this.getClass().getName() + " - " + this.classifier.getClass().getSimpleName());
        this.buildTable();
    }

    private final void buildTable() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        String string = this.classifier.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classifier.javaClass.simpleName");
        spreadBuilder.add((Object)string);
        spreadBuilder.addSpread((Object)this.diagnoseLabels);
        this.buildHeader((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        int n = 0;
        int n2 = this.fragments.length + -1;
        if (n <= n2) {
            do {
                int row;
                Pair<String[], Double> values;
                if (!(((Number)(values = this.buildRowValues(row = n++)).getSecond()).doubleValue() > 0.0)) continue;
                String[] stringArray = (String[])values.getFirst();
                this.buildRow(Arrays.copyOf(stringArray, stringArray.length));
            } while (n <= n2);
        }
    }

    private final Pair<String[], Double> buildRowValues(int row) {
        int n;
        int n2 = 0;
        int n3 = 1 + this.diagnoseLabels.length;
        String[] stringArray = new String[n3];
        while (n2 < n3) {
            n = n2++;
            stringArray[n] = "";
        }
        String[] values = stringArray;
        values[0] = StringsKt.take((String)this.fragments[row].getElementName(), (int)30);
        double sum = 0.0;
        int n4 = 0;
        n = this.labels.length + -1;
        if (n4 <= n) {
            do {
                int col;
                if (!ArraysKt.contains((Object[])this.diagnoseLabels, (Object)this.labels[col = n4++])) continue;
                double score2 = this.scoreMatrix.getEntry(row, col);
                sum += score2;
                values[col + 1] = this.formatScore(score2);
            } while (n4 <= n);
        }
        return new Pair((Object)values, (Object)sum);
    }

    private final String formatScore(double score2) {
        String string;
        if (score2 == 0.0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%-14s";
            Object[] objectArray = new Object[]{"."};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else if (score2 < 0.6) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%-12.2f";
            Object[] objectArray = new Object[]{score2};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            String string6 = new DecimalFormat("#.#").format(score2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"DecimalFormat(\"#.#\").format(score)");
            string = string6;
        }
        return string;
    }
}

