/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.Reportable;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.scent.diagnosis.DiagnosisFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.hadoop.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0012J\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u001f\u0010\u000b\u001a\u00020\u00122\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001f\"\u00020\u0007\u00a2\u0006\u0002\u0010 J\u0014\u0010\u000b\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lai/platon/scent/diagnosis/ScentDiagnostor;", "Lai/platon/pulsar/common/Reportable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "formatters", "Ljava/util/ArrayList;", "Lai/platon/scent/diagnosis/DiagnosisFormatter;", "Lkotlin/collections/ArrayList;", "getFormatters", "()Ljava/util/ArrayList;", "setFormatters", "(Ljava/util/ArrayList;)V", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "getStopWatch", "()Lorg/perf4j/slf4j/Slf4JStopWatch;", "addFormatter", "", "formatter", "diagnose", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "report", "", "reportTo", "path", "Ljava/nio/file/Path;", "setFormatter", "", "([Lai/platon/scent/diagnosis/DiagnosisFormatter;)V", "", "Companion", "scent-auto-mining"})
public final class ScentDiagnostor
implements Reportable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private ArrayList<DiagnosisFormatter> formatters;
    private static final Logger log = LoggerFactory.getLogger(ScentDiagnostor.class);
    @NotNull
    private static final String docTemplate = "wwwroot/template/diagnosis.template.html";

    public ScentDiagnostor(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.stopWatch = new Slf4JStopWatch();
        this.formatters = new ArrayList();
    }

    @NotNull
    public final Slf4JStopWatch getStopWatch() {
        return this.stopWatch;
    }

    @NotNull
    public final ArrayList<DiagnosisFormatter> getFormatters() {
        return this.formatters;
    }

    public final void setFormatters(@NotNull ArrayList<DiagnosisFormatter> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.formatters = arrayList;
    }

    public final void setFormatter(@NotNull DiagnosisFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.formatters.clear();
        this.formatters.addAll((Collection<DiagnosisFormatter>)this.formatters);
    }

    public final void setFormatters(DiagnosisFormatter ... formatters) {
        Intrinsics.checkNotNullParameter((Object)formatters, (String)"formatters");
        this.formatters.clear();
        CollectionsKt.addAll((Collection)this.formatters, (Object[])formatters);
    }

    public final void setFormatters(@NotNull Iterable<? extends DiagnosisFormatter> formatters) {
        Intrinsics.checkNotNullParameter(formatters, (String)"formatters");
        this.formatters.clear();
        CollectionsKt.addAll((Collection)this.formatters, formatters);
    }

    public final void addFormatter(@NotNull DiagnosisFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.formatters.add(formatter);
    }

    public final void diagnose() {
        Iterable $this$forEach$iv = this.formatters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiagnosisFormatter it = (DiagnosisFormatter)element$iv;
            boolean bl = false;
            it.process();
        }
    }

    public final void diagnose(@NotNull FeaturedDocument doc, @Nullable PageEntity pageEntity) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Iterable $this$forEach$iv = this.formatters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DiagnosisFormatter it = (DiagnosisFormatter)element$iv;
            boolean bl = false;
            it.process();
        }
    }

    public static /* synthetic */ void diagnose$default(ScentDiagnostor scentDiagnostor, FeaturedDocument featuredDocument, PageEntity pageEntity, int n, Object object) {
        if ((n & 2) != 0) {
            pageEntity = null;
        }
        scentDiagnostor.diagnose(featuredDocument, pageEntity);
    }

    public final void reportTo(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OpenOption[] report = this.report();
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = report;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        if (openOptionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = openOptionArray.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
        Files.write(path, byArray, openOptionArray);
        if (log.isDebugEnabled()) {
            log.debug("Diagnosis saved at: " + path);
        }
    }

    @NotNull
    public String report() {
        try {
            InputStream inputStream = ResourceLoader.INSTANCE.getResourceAsStream(docTemplate);
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream stream = inputStream;
            Document document = Jsoup.parse((InputStream)stream, (String)"utf-8", (String)docTemplate);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(stream, \"utf-8\", docTemplate)");
            Document diagnosisDoc = document;
            Element element = diagnosisDoc.getElementById("diagosis-menu");
            Intrinsics.checkNotNull((Object)element);
            Element element2 = element;
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"diagnosisDoc.getElementById(\"diagosis-menu\")!!");
            Element menu = element2;
            Element element3 = menu.appendElement("ul");
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"menu.appendElement(\"ul\")");
            Element ul = element3;
            for (DiagnosisFormatter formatter : this.formatters) {
                ul.appendElement("li").appendElement("a").text(formatter.caption()).attr("href", "#" + formatter.caption());
            }
            menu.appendElement("hr");
            menu.appendElement("div").text(DateTimes.now());
            Element element4 = diagnosisDoc.getElementById("diagosis-body");
            Intrinsics.checkNotNull((Object)element4);
            Object object = element4;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnosisDoc.getElementById(\"diagosis-body\")!!");
            Element body = object;
            for (DiagnosisFormatter formatter : this.formatters) {
                body.appendElement("div").attr("class", "back-to-top").appendElement("a").attr("name", formatter.caption()).appendElement("a").text("\u21e1 \u56de\u9876\u90e8 \u21e1").attr("href", "#");
                body.append(formatter.asTable());
                body.append("<br /><br />");
            }
            object = diagnosisDoc.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnosisDoc.toString()");
            return object;
        }
        catch (IOException e) {
            log.error(StringUtils.stringifyException((Throwable)e));
            return "";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/platon/scent/diagnosis/ScentDiagnostor$Companion;", "", "()V", "docTemplate", "", "getDocTemplate", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final String getDocTemplate() {
            return docTemplate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

