/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.statistics;

import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.data.BlockPattern;
import ai.platon.scent.feature.ScentRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\"\u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010#H\u0096\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0004J\u001c\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)J\b\u0010*\u001a\u00020 H\u0016J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003J\b\u0010/\u001a\u00020\u0003H\u0016R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lai/platon/scent/feature/statistics/BlockStatRule;", "", "id", "", "label", "leafOnly", "", "domain", "allowedPatterns", "", "Lai/platon/pulsar/dom/data/BlockPattern;", "disallowedPatterns", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/util/List;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getAllowedPatterns", "()Ljava/util/ArrayList;", "getDisallowedPatterns", "getDomain", "()Ljava/lang/String;", "getId", "getLabel", "getLeafOnly", "()Z", "rules", "Ljava/util/HashSet;", "Lai/platon/scent/feature/ScentRule;", "Lkotlin/collections/HashSet;", "getRules", "()Ljava/util/HashSet;", "compareTo", "", "other", "equals", "", "getScore", "", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "patterns", "", "hashCode", "setGlobalVar", "", "name", "value", "toString", "scent-auto-mining"})
public final class BlockStatRule
implements Comparable<BlockStatRule> {
    @NotNull
    private final String id;
    @NotNull
    private final String label;
    private final boolean leafOnly;
    @NotNull
    private final String domain;
    @NotNull
    private final HashSet<ScentRule> rules;
    @NotNull
    private final ArrayList<BlockPattern> allowedPatterns;
    @NotNull
    private final ArrayList<BlockPattern> disallowedPatterns;

    public BlockStatRule(@NotNull String id, @NotNull String label, boolean leafOnly, @NotNull String domain) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this.id = id;
        this.label = label;
        this.leafOnly = leafOnly;
        this.domain = domain;
        this.rules = new HashSet();
        this.allowedPatterns = new ArrayList();
        this.disallowedPatterns = new ArrayList();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getLeafOnly() {
        return this.leafOnly;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    @NotNull
    public final HashSet<ScentRule> getRules() {
        return this.rules;
    }

    @NotNull
    public final ArrayList<BlockPattern> getAllowedPatterns() {
        return this.allowedPatterns;
    }

    @NotNull
    public final ArrayList<BlockPattern> getDisallowedPatterns() {
        return this.disallowedPatterns;
    }

    public BlockStatRule(@NotNull String id, @NotNull String label, boolean leafOnly, @NotNull String domain, @NotNull List<BlockPattern> allowedPatterns, @NotNull List<BlockPattern> disallowedPatterns) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter(allowedPatterns, (String)"allowedPatterns");
        Intrinsics.checkNotNullParameter(disallowedPatterns, (String)"disallowedPatterns");
        this(id, label, leafOnly, domain);
        this.allowedPatterns.addAll((Collection<BlockPattern>)allowedPatterns);
        this.disallowedPatterns.addAll((Collection<BlockPattern>)disallowedPatterns);
    }

    public final double getScore(@NotNull DocumentFragment fragment, @NotNull Collection<BlockPattern> patterns) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        CharSequence charSequence = this.domain;
        boolean bl = false;
        if (!(charSequence.length() == 0) && !StringsKt.contains$default((CharSequence)fragment.getLocation(), (CharSequence)this.domain, (boolean)false, (int)2, null)) {
            return 0.0;
        }
        double score2 = this.getScore(fragment);
        if (score2 > 0.0 && CollectionUtils.containsAny((Collection)this.disallowedPatterns, patterns)) {
            score2 = ScentRule.Companion.getMIN_SCORE();
        }
        if (score2 > 0.0 && !this.allowedPatterns.isEmpty() && !CollectionUtils.containsAny((Collection)this.allowedPatterns, patterns)) {
            score2 = ScentRule.Companion.getMIN_SCORE();
        }
        return score2;
    }

    protected final double getScore(@NotNull DocumentFragment fragment) {
        ScentRule rule;
        double s2;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        double score2 = 0.0;
        Iterator<ScentRule> iterator = this.rules.iterator();
        while (iterator.hasNext() && !((score2 += (s2 = (rule = iterator.next()).getScore(fragment))) >= ScentRule.Companion.getMAX_ELEMENT_SCORE()) && !(score2 <= ScentRule.Companion.getMIN_ELEMENT_SCORE())) {
            if (!(s2 <= ScentRule.Companion.getMIN_ELEMENT_SCORE())) continue;
            String attr = fragment.getElement().attr("a-clues") + ", " + this.label + ":" + rule.name();
            fragment.getElement().attr("a-clues", attr);
            break;
        }
        return score2;
    }

    public final void setGlobalVar(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (ScentRule rule : this.rules) {
            Map map = rule.getVariables();
            boolean bl = false;
            map.put(name, value);
        }
    }

    @NotNull
    public String toString() {
        return this.id + " - " + this.label;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BlockStatRule && Intrinsics.areEqual((Object)this.id, (Object)((BlockStatRule)other).id);
    }

    @Override
    public int compareTo(@NotNull BlockStatRule other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.id.compareTo(other.id);
    }
}

