/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.statistics;

import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.dom.features.NodeFeature;
import ai.platon.scent.feature.ScentRule;
import ai.platon.scent.feature.statistics.StatFeature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0015H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/platon/scent/feature/statistics/StatRule;", "Lai/platon/scent/feature/ScentRule;", "feature", "Lai/platon/scent/feature/statistics/StatFeature;", "min", "", "max", "score", "negativeScore", "(Lai/platon/scent/feature/statistics/StatFeature;DDDD)V", "engine", "Ljavax/script/ScriptEngine;", "kotlin.jvm.PlatformType", "factory", "Ljavax/script/ScriptEngineManager;", "getFeature", "()Lai/platon/scent/feature/statistics/StatFeature;", "getNegativeScore", "()D", "references", "Ljava/util/HashMap;", "", "eval", "fragment", "Lai/platon/pulsar/dom/DocumentFragment;", "script", "getScore", "ref", "", "value", "toString", "variablize", "scent-auto-mining"})
public final class StatRule
extends ScentRule {
    @NotNull
    private final StatFeature feature;
    private final double negativeScore;
    private final double min;
    private final double max;
    @NotNull
    private final ScriptEngineManager factory;
    private final ScriptEngine engine;
    @NotNull
    private final HashMap<String, String> references;

    public StatRule(@NotNull StatFeature feature, double min, double max, double score2, double negativeScore) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Object object = StringCompanionObject.INSTANCE;
        String string = "%s-%d-%d";
        Object object2 = new Object[]{feature.getName(), (int)min, (int)max};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        super(string2, score2);
        this.feature = feature;
        this.negativeScore = negativeScore;
        this.min = min < ScentRule.Companion.getMIN_SCORE() ? ScentRule.Companion.getMIN_SCORE() : min;
        this.max = max > ScentRule.Companion.getMAX_SCORE() ? ScentRule.Companion.getMAX_SCORE() : max;
        this.factory = new ScriptEngineManager();
        this.engine = this.factory.getEngineByName("JavaScript");
        this.references = new HashMap();
        object = this.getVariables();
        string = "$_result";
        object2 = "0.0";
        bl = false;
        object.put(string, object2);
    }

    @NotNull
    public final StatFeature getFeature() {
        return this.feature;
    }

    public final double getNegativeScore() {
        return this.negativeScore;
    }

    public final void ref(@NotNull String ref, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map map = this.references;
        boolean bl = false;
        map.put(ref, value);
    }

    @Override
    public double getScore(@NotNull DocumentFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Objects.requireNonNull(fragment);
        double value = 0.0;
        value = this.feature.isSimple() ? NodeFeature.Companion.getValue(this.feature.getName(), (Node)fragment.getElement()) : this.eval(fragment, this.feature.getScript());
        double result = this.negativeScore;
        double d = this.min;
        boolean bl = value <= this.max ? d <= value : false;
        if (bl) {
            result = this.score();
        }
        return result;
    }

    private final double eval(DocumentFragment fragment, String script) {
        Objects.requireNonNull(fragment);
        double result = 0.0;
        this.engine.getBindings(100).clear();
        Object object = this.getVariables();
        boolean bl = false;
        for (Map.Entry entry : object.entrySet()) {
            this.engine.put((String)entry.getKey(), entry.getValue());
        }
        for (String name : FeatureRegistry.INSTANCE.getFeatureNames()) {
            this.engine.put(this.variablize(name), NodeFeature.Companion.getValue(name, (Node)fragment.getElement()));
        }
        object = this.references;
        bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String value = (String)object3.getValue();
            String var = this.variablize(value);
            this.engine.put(key, this.engine.get(var));
        }
        try {
            this.engine.eval(script);
            result = Double.parseDouble(this.engine.get("$_result").toString());
        }
        catch (Exception e) {
            ScentRule.Companion.getLog().error(e.toString());
        }
        return result;
    }

    private final String variablize(String feature) {
        CharSequence charSequence = feature;
        String string = "-";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "_";
        boolean bl2 = false;
        return "$" + string.replace(charSequence, string2);
    }

    @Override
    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "\n\nmin : %6.2f max : %6.2f score : %6.2f negative-score : %6.2f\n\n\nfeatures : %s\n\nvariables : %s\n\nreferences : %s";
        Object[] objectArray = new Object[]{this.min, this.max, this.score(), this.negativeScore, this.feature.toString(), this.getVariables().toString(), this.references.toString()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }
}

