/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.words.blackwhite;

import ai.platon.pulsar.common.BlackWhiteResourceConfig;
import ai.platon.pulsar.common.Strings;
import ai.platon.scent.feature.WordFeature;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lai/platon/scent/feature/words/blackwhite/CategoryFeature;", "Lai/platon/scent/feature/WordFeature;", "blackWhiteConfig", "Lai/platon/pulsar/common/BlackWhiteResourceConfig;", "(Lai/platon/pulsar/common/BlackWhiteResourceConfig;)V", "preprocess", "", "name", "validate", "", "validateSize", "Companion", "scent-auto-mining"})
public final class CategoryFeature
extends WordFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MaxCategoryWordSize = 10;

    public CategoryFeature(@NotNull BlackWhiteResourceConfig blackWhiteConfig) {
        Intrinsics.checkNotNullParameter((Object)blackWhiteConfig, (String)"blackWhiteConfig");
        super(blackWhiteConfig);
    }

    @Override
    public boolean validate(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name2 = name;
        if (!this.validateSize(name2)) {
            return false;
        }
        if (this.getWhiteWords().contains((Object)name2)) {
            return true;
        }
        if (StringUtils.isNumericSpace((CharSequence)name2)) {
            return false;
        }
        String string = Strings.trimNonCJKChar((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimNonCJKChar(name)");
        name2 = string;
        for (String badWord : this.getBlackWords()) {
            CharSequence charSequence = name2;
            Intrinsics.checkNotNullExpressionValue((Object)badWord, (String)"badWord");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)badWord, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String preprocess(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String name2 = name;
        if (!this.validateSize(name2)) {
            return "";
        }
        if (this.getWhiteWords().contains((Object)name2)) {
            return name2;
        }
        String string = Strings.trimNonCJKChar((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimNonCJKChar(name)");
        name2 = string;
        for (String word : this.getBlackWords()) {
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"word");
            name2 = StringsKt.replace$default((String)name2, (String)word, (String)"", (boolean)false, (int)4, null);
        }
        return !this.validateSize(name2) ? "" : name2;
    }

    public final boolean validateSize(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int count = Strings.countChinese((String)name);
        return count <= MaxCategoryWordSize;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/feature/words/blackwhite/CategoryFeature$Companion;", "", "()V", "MaxCategoryWordSize", "", "getMaxCategoryWordSize", "()I", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaxCategoryWordSize() {
            return MaxCategoryWordSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

