/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0003R\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/gui/Rule;", "Ljavax/swing/JComponent;", "orientation", "", "isMetric", "", "(IZ)V", "<set-?>", "increment", "getIncrement", "()I", "()Z", "setMetric", "(Z)V", "getOrientation", "setOrientation", "(I)V", "units", "paintComponent", "", "g", "Ljava/awt/Graphics;", "setIncrementAndUnits", "setIsMetric", "setPreferredHeight", "ph", "setPreferredWidth", "pw", "Companion", "scent-auto-mining"})
public final class Rule
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int orientation;
    private boolean isMetric;
    private int increment;
    private int units;
    private static final int INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final int HORIZONTAL;
    private static final int VERTICAL;
    private static final int SIZE;

    public Rule(int orientation, boolean isMetric) {
        this.orientation = orientation;
        this.isMetric = isMetric;
        this.setIncrementAndUnits();
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(int n) {
        this.orientation = n;
    }

    public final boolean isMetric() {
        return this.isMetric;
    }

    public final void setMetric(boolean bl) {
        this.isMetric = bl;
    }

    public final int getIncrement() {
        return this.increment;
    }

    public final void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.setIncrementAndUnits();
        this.repaint();
    }

    private final void setIncrementAndUnits() {
        if (this.isMetric) {
            this.increment = this.units = (int)((double)INCH / 2.54);
        } else {
            this.units = INCH;
            this.increment = this.units / 2;
        }
    }

    public final void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(SIZE, ph));
    }

    public final void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, SIZE));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle drawHere = g.getClipBounds();
        g.setColor(new Color(230, 163, 4));
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(new Font("SansSerif", 0, 10));
        g.setColor(Color.black);
        int end = 0;
        int start = 0;
        int tickLength = 0;
        Object text2 = null;
        if (this.orientation == HORIZONTAL) {
            start = drawHere.x / this.increment * this.increment;
            end = ((drawHere.x + drawHere.width) / this.increment + 1) * this.increment;
        } else {
            start = drawHere.y / this.increment * this.increment;
            end = ((drawHere.y + drawHere.height) / this.increment + 1) * this.increment;
        }
        if (start == 0) {
            text2 = Integer.toString(0) + (this.isMetric ? " cm" : " in");
            tickLength = 10;
            if (this.orientation == HORIZONTAL) {
                g.drawLine(0, SIZE - 1, 0, SIZE - tickLength - 1);
                g.drawString((String)text2, 2, 21);
            } else {
                g.drawLine(SIZE - 1, 0, SIZE - tickLength - 1, 0);
                g.drawString((String)text2, 9, 10);
            }
            text2 = null;
            start = this.increment;
        }
        for (int i = start; i < end; i += this.increment) {
            if (i % this.units == 0) {
                tickLength = 10;
                text2 = Integer.toString(i / this.units);
            } else {
                tickLength = 7;
                text2 = null;
            }
            if (tickLength == 0) continue;
            if (this.orientation == HORIZONTAL) {
                g.drawLine(i, SIZE - 1, i, SIZE - tickLength - 1);
                if (text2 == null) continue;
                g.drawString((String)text2, i - 3, 21);
                continue;
            }
            g.drawLine(SIZE - 1, i, SIZE - tickLength - 1, i);
            if (text2 == null) continue;
            g.drawString((String)text2, 9, i + 3);
        }
    }

    static {
        VERTICAL = 1;
        SIZE = 35;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lai/platon/scent/gui/Rule$Companion;", "", "()V", "HORIZONTAL", "", "getHORIZONTAL", "()I", "INCH", "getINCH", "SIZE", "getSIZE", "VERTICAL", "getVERTICAL", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final int getINCH() {
            return INCH;
        }

        public final int getHORIZONTAL() {
            return HORIZONTAL;
        }

        public final int getVERTICAL() {
            return VERTICAL;
        }

        public final int getSIZE() {
            return SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

