/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.HyperParametersKt;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/ml/AffineTransformer;", "Lai/platon/scent/ml/FeatureTransformer;", "schema", "Lai/platon/scent/ml/Schema;", "verbose", "", "(Lai/platon/scent/ml/Schema;Z)V", "b", "", "", "getB", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "w", "getW", "fit", "", "xs", "", "Lai/platon/scent/ml/NodePoint;", "transform", "x", "scent-auto-mining"})
public final class AffineTransformer
extends FeatureTransformer {
    @NotNull
    private final Double[] w;
    @NotNull
    private final Double[] b;

    public AffineTransformer(@NotNull Schema schema, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(schema, verbose);
        int n = HyperParametersKt.getFeatureWeights().length == DefinedFeaturesKt.getN2() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        int n3 = 0;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = this.getOutputSchema().getColumns().size();
        Double[] doubleArray = new Double[n2];
        AffineTransformer affineTransformer = this;
        while (n < n2) {
            n3 = n++;
            doubleArray[n3] = 0.0;
        }
        affineTransformer.w = doubleArray;
        n = 0;
        n2 = this.getOutputSchema().getColumns().size();
        doubleArray = new Double[n2];
        affineTransformer = this;
        while (n < n2) {
            n3 = n++;
            doubleArray[n3] = 0.0;
        }
        affineTransformer.b = doubleArray;
    }

    public /* synthetic */ AffineTransformer(Schema schema, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(schema, bl);
    }

    @NotNull
    public final Double[] getW() {
        return this.w;
    }

    @NotNull
    public final Double[] getB() {
        return this.b;
    }

    @Override
    public void fit(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Iterator<Schema.Column> iterator = this.getOutputSchema().getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int j = n++;
            Schema.Column column = iterator.next();
            int primaryKey = column.getPrimaryKey();
            this.w[j] = HyperParametersKt.getFeatureWeights()[primaryKey];
            this.b[j] = HyperParametersKt.getFeatureInception()[primaryKey];
        }
    }

    @Override
    @NotNull
    public NodePoint transform(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        int n = 0;
        int n2 = this.getOutputSchema().getColumns().size() + -1;
        if (n <= n2) {
            do {
                int j = n++;
                VectorsKt.set((RealVector)((RealVector)x), (int)j, (double)(this.w[j] * VectorsKt.get((RealVector)((RealVector)x), (int)j) + this.b[j]));
            } while (n <= n2);
        }
        return x;
    }
}

