/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.scent.ml.AffineTransformer;
import ai.platon.scent.ml.Bucketizer;
import ai.platon.scent.ml.EraseTransformer;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.HyperParametersKt;
import ai.platon.scent.ml.InsignificantFeatureRemover;
import ai.platon.scent.ml.NGramNodeEncoderBase;
import ai.platon.scent.ml.NGramTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.OneHotEncoder;
import ai.platon.scent.ml.ReversedOneHotIsolateTransformer;
import ai.platon.scent.ml.RowFormatter;
import ai.platon.scent.ml.SigmoidTransformer;
import ai.platon.scent.ml.Standardizer;
import ai.platon.scent.ml.unsupervised.PCA;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/ml/ClusterSensitiveNodeEncoder;", "Lai/platon/scent/ml/NGramNodeEncoderBase;", "nGram", "", "pcaRate", "", "dimension", "(IDI)V", "getPcaRate", "()D", "removeInsignificantFeatures", "", "getRemoveInsignificantFeatures", "()Z", "setRemoveInsignificantFeatures", "(Z)V", "encode", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "nodes", "", "Lorg/jsoup/nodes/Node;", "scent-auto-mining"})
public class ClusterSensitiveNodeEncoder
extends NGramNodeEncoderBase {
    private final double pcaRate;
    private boolean removeInsignificantFeatures;

    public ClusterSensitiveNodeEncoder(int nGram, double pcaRate, int dimension) {
        super(nGram, dimension);
        this.pcaRate = pcaRate;
        this.removeInsignificantFeatures = true;
    }

    public /* synthetic */ ClusterSensitiveNodeEncoder(int n, double d, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            d = 1.0;
        }
        if ((n3 & 4) != 0) {
            n2 = FeatureRegistry.INSTANCE.getFeatureNames().size();
        }
        this(n, d, n2);
    }

    public final double getPcaRate() {
        return this.pcaRate;
    }

    public final boolean getRemoveInsignificantFeatures() {
        return this.removeInsignificantFeatures;
    }

    public final void setRemoveInsignificantFeatures(boolean bl) {
        this.removeInsignificantFeatures = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ArrayList<NodePoint> encode(@NotNull List<? extends Node> nodes2) {
        Object isolateEncoder;
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        if (nodes2.isEmpty()) {
            boolean bl = false;
            return new ArrayList<NodePoint>();
        }
        ArrayList<NodePoint> xs = null;
        xs = super.encode(nodes2);
        int nTrace = HyperParametersKt.getTraceNFeatureLines();
        if (nTrace > 0) {
            RowFormatter.show$default(new RowFormatter(0, 0, 0, true, null, null, 55, null), xs, nTrace, false, null, 12, null);
        }
        int[] nArray = HyperParametersKt.getIgnoredFeatures();
        EraseTransformer eraser = new EraseTransformer(Arrays.copyOf(nArray, nArray.length), false, 2, null);
        Bucketizer bucketizer = new Bucketizer(false, 1, null);
        Object $this$forEachIndexed$iv = xs;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv22 = 0;
        Iterator iterator = $this$forEachIndexed$iv.iterator();
        while (iterator.hasNext()) {
            void x;
            Object item$iv = iterator.next();
            int n = index$iv22++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl2 = false;
            NodePoint x1 = x;
            x1 = eraser.transform(x1);
            eraser.show(x1);
            x1 = bucketizer.transform(x1);
            bucketizer.show(x1);
            xs.set(i, x1);
        }
        $this$forEachIndexed$iv = HyperParametersKt.getReversedOneHotIsolateFeatures();
        $i$f$forEachIndexed22 = false;
        Object index$iv22 = $this$forEachIndexed$iv;
        boolean bl = false;
        if (!(((Object)index$iv22).length == 0)) {
            int[] $i$f$forEachIndexed22 = HyperParametersKt.getReversedOneHotIsolateFeatures();
            isolateEncoder = new ReversedOneHotIsolateTransformer(Arrays.copyOf($i$f$forEachIndexed22, $i$f$forEachIndexed22.length), this.getSchema(), false);
            ((OneHotEncoder)isolateEncoder).fit((List<? extends NodePoint>)xs);
            this.setSchema(((OneHotEncoder)isolateEncoder).transformSchema());
            xs = ((ReversedOneHotIsolateTransformer)isolateEncoder).transform((List<? extends NodePoint>)xs);
            ((FeatureTransformer)isolateEncoder).show((List<? extends NodePoint>)xs, nTrace, true);
        }
        isolateEncoder = HyperParametersKt.getNominalFeatures();
        boolean $i$f$forEachIndexed22 = false;
        index$iv22 = isolateEncoder;
        bl = false;
        if (!(((Object)index$iv22).length == 0)) {
            int[] $i$f$forEachIndexed22 = HyperParametersKt.getNominalFeatures();
            OneHotEncoder hotEncoder = new OneHotEncoder(Arrays.copyOf($i$f$forEachIndexed22, $i$f$forEachIndexed22.length), this.getSchema(), 0.0, false, 4, null);
            hotEncoder.fit((List<? extends NodePoint>)xs);
            this.setSchema(hotEncoder.transformSchema());
            xs = hotEncoder.transform((List<? extends NodePoint>)xs);
            hotEncoder.show((List<? extends NodePoint>)xs, nTrace, true);
        }
        if (this.removeInsignificantFeatures) {
            InsignificantFeatureRemover featureRemover = new InsignificantFeatureRemover(this.getSchema(), false);
            featureRemover.fit((List<? extends NodePoint>)xs);
            this.setSchema(featureRemover.transformSchema());
            xs = featureRemover.transform((List<? extends NodePoint>)xs);
            FeatureTransformer.show$default(featureRemover, xs, nTrace, false, 4, null);
        }
        if (xs.size() > 2) {
            Standardizer standardizer = new Standardizer();
            standardizer.fit((List<? extends NodePoint>)xs);
            xs = standardizer.transform((List<? extends NodePoint>)xs);
        }
        SigmoidTransformer sigmoid = new SigmoidTransformer(false);
        xs = sigmoid.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(sigmoid, xs, nTrace, false, 4, null);
        if (HyperParametersKt.getApplyAffineTransform()) {
            AffineTransformer affine = new AffineTransformer(this.getSchema(), false);
            affine.fit((List<? extends NodePoint>)xs);
            xs = affine.transform((List<? extends NodePoint>)xs);
            FeatureTransformer.show$default(affine, xs, nTrace, false, 4, null);
        }
        NGramTransformer nGramTransformer = new NGramTransformer(this.getNGram(), this.getSchema(), false);
        this.setSchema(nGramTransformer.transformSchema());
        xs = nGramTransformer.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(nGramTransformer, xs, nTrace, false, 4, null);
        if (this.pcaRate > 0.0 && this.pcaRate < 1.0) {
            PCA pca = new PCA(xs, false, 0.0, 6, null).withProjection(this.pcaRate);
            xs = pca.project((List<? extends NodePoint>)xs);
            RowFormatter.show$default(new RowFormatter(0, 0, 0, false, null, null, 55, null), xs, nTrace, false, null, 12, null);
        }
        return xs;
    }
}

