/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.RowFormatter;
import ai.platon.scent.ml.Schema;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lai/platon/scent/ml/FeatureTransformer;", "", "schema", "Lai/platon/scent/ml/Schema;", "verbose", "", "(Lai/platon/scent/ml/Schema;Z)V", "formatter", "Lai/platon/scent/ml/RowFormatter;", "getFormatter", "()Lai/platon/scent/ml/RowFormatter;", "outputSchema", "getOutputSchema", "()Lai/platon/scent/ml/Schema;", "setOutputSchema", "(Lai/platon/scent/ml/Schema;)V", "getSchema", "getVerbose", "()Z", "fit", "", "xs", "", "Lai/platon/scent/ml/NodePoint;", "show", "x", "n", "", "reverse", "showHead", "transform", "Ljava/util/ArrayList;", "transformSchema", "scent-auto-mining"})
public abstract class FeatureTransformer {
    @NotNull
    private final Schema schema;
    private final boolean verbose;
    @NotNull
    private Schema outputSchema;

    public FeatureTransformer(@NotNull Schema schema, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
        this.verbose = verbose;
        this.outputSchema = this.schema;
    }

    public /* synthetic */ FeatureTransformer(Schema schema, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            schema = new Schema(null, 1, null);
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(schema, bl);
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Schema getOutputSchema() {
        return this.outputSchema;
    }

    public final void setOutputSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.outputSchema = schema;
    }

    @NotNull
    public final RowFormatter getFormatter() {
        return new RowFormatter(30, 15, 2, this.verbose, this.outputSchema, null, 32, null);
    }

    public void fit(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
    }

    @NotNull
    public Schema transformSchema() {
        return this.outputSchema;
    }

    @NotNull
    public NodePoint transform(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        return x;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ArrayList<NodePoint> transform(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        ArrayList ys = xs instanceof ArrayList ? (ArrayList)xs : new ArrayList(xs.size());
        Iterable $this$forEachIndexed$iv = xs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void x;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl2 = false;
            ys.set(i, this.transform((NodePoint)x));
        }
        return ys;
    }

    public void showHead() {
        this.getFormatter().showHead();
    }

    public void show(@NotNull List<? extends NodePoint> xs, int n, boolean reverse) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        RowFormatter.show$default(this.getFormatter(), xs, n, reverse, null, 8, null);
    }

    public static /* synthetic */ void show$default(FeatureTransformer featureTransformer, List list, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: show");
        }
        if ((n2 & 2) != 0) {
            n = 20;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        featureTransformer.show(list, n, bl);
    }

    public void show(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        this.getFormatter().show(x);
    }

    public FeatureTransformer() {
        this(null, false, 3, null);
    }
}

