/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/ml/InsignificantFeatureRemover;", "Lai/platon/scent/ml/FeatureTransformer;", "schema", "Lai/platon/scent/ml/Schema;", "verbose", "", "(Lai/platon/scent/ml/Schema;Z)V", "qualifiedDimensions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "variances", "", "Lorg/apache/commons/math3/stat/descriptive/moment/Variance;", "[Lorg/apache/commons/math3/stat/descriptive/moment/Variance;", "fit", "", "xs", "", "Lai/platon/scent/ml/NodePoint;", "transform", "transformSchema", "scent-auto-mining"})
public final class InsignificantFeatureRemover
extends FeatureTransformer {
    @NotNull
    private final Variance[] variances;
    @NotNull
    private final ArrayList<Integer> qualifiedDimensions;

    public InsignificantFeatureRemover(@NotNull Schema schema, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(schema, verbose);
        int n = 0;
        int n2 = schema.getDimension();
        Variance[] varianceArray = new Variance[n2];
        InsignificantFeatureRemover insignificantFeatureRemover = this;
        while (n < n2) {
            int n3 = n++;
            varianceArray[n3] = new Variance();
        }
        insignificantFeatureRemover.variances = varianceArray;
        n = 0;
        this.qualifiedDimensions = new ArrayList();
    }

    public /* synthetic */ InsignificantFeatureRemover(Schema schema, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(schema, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fit(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        int n = 0;
        int n2 = xs.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                int n3 = 0;
                int n4 = this.getSchema().getDimension();
                if (n3 >= n4) continue;
                do {
                    int j = n3++;
                    this.variances[j].increment(VectorsKt.get((RealVector)((RealVector)xs.get(i)), (int)j));
                } while (n3 < n4);
            } while (n <= n2);
        }
        Variance[] $this$forEachIndexed$iv = this.variances;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Variance item$iv : $this$forEachIndexed$iv) {
            void variance;
            int n5 = index$iv++;
            Variance variance2 = item$iv;
            int j = n5;
            boolean bl = false;
            double v = variance.getResult();
            if (!(v > 0.001)) continue;
            this.qualifiedDimensions.add(j);
        }
    }

    @Override
    @NotNull
    public Schema transformSchema() {
        boolean bl = false;
        List outputColumns = new ArrayList();
        Iterator<Integer> iterator = this.qualifiedDimensions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int j = n++;
            int p = ((Number)iterator.next()).intValue();
            Schema.Column column = new Schema.Column(j, this.getSchema().getColumns().get(p).getName(), 0, 4, null);
            boolean bl2 = false;
            boolean bl3 = false;
            Schema.Column it = column;
            boolean bl4 = false;
            outputColumns.add(it);
        }
        this.setOutputSchema(new Schema(outputColumns));
        return this.getOutputSchema();
    }

    @Override
    @NotNull
    public ArrayList<NodePoint> transform(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        ArrayList<NodePoint> ys = new ArrayList<NodePoint>(xs.size());
        Iterator<? extends NodePoint> iterator = xs.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            NodePoint x = iterator.next();
            double[] y = new double[this.getOutputSchema().getDimension()];
            Iterator<Integer> iterator2 = this.qualifiedDimensions.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int j = n2++;
                int col = ((Number)iterator2.next()).intValue();
                y[j] = VectorsKt.get((RealVector)((RealVector)x), (int)col);
            }
            ys.add(new NodePoint(x.getNode(), y, false, 4, null));
        }
        return ys;
    }
}

