/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.ml.NodeDataFrame;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J*\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\b\b\u0002\u0010%\u001a\u00020&R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lai/platon/scent/ml/NodeDataFrame;", "Ljava/lang/AutoCloseable;", "schema", "Lai/platon/scent/ml/Schema;", "points", "", "Lai/platon/scent/ml/NodePoint;", "separator", "", "printWriter", "Ljava/io/PrintWriter;", "(Lai/platon/scent/ml/Schema;Ljava/util/List;Ljava/lang/String;Ljava/io/PrintWriter;)V", "getPoints", "()Ljava/util/List;", "getPrintWriter", "()Ljava/io/PrintWriter;", "setPrintWriter", "(Ljava/io/PrintWriter;)V", "getSchema", "()Lai/platon/scent/ml/Schema;", "getSeparator", "()Ljava/lang/String;", "close", "", "encodeLabel", "", "node", "Lorg/jsoup/nodes/Node;", "export", "Ljava/nio/file/Path;", "exportHeader", "pw", "exportNode", "features", "Lorg/apache/commons/math3/linear/RealVector;", "exportTo", "path", "withHeader", "", "Companion", "scent-auto-mining"})
public final class NodeDataFrame
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Schema schema;
    @NotNull
    private final List<NodePoint> points;
    @NotNull
    private final String separator;
    @Nullable
    private PrintWriter printWriter;

    public NodeDataFrame(@NotNull Schema schema, @NotNull List<? extends NodePoint> points, @NotNull String separator, @Nullable PrintWriter printWriter) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        this.schema = schema;
        this.points = points;
        this.separator = separator;
        this.printWriter = printWriter;
    }

    public /* synthetic */ NodeDataFrame(Schema schema, List list, String string, PrintWriter printWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = ",";
        }
        if ((n & 8) != 0) {
            printWriter = null;
        }
        this(schema, list, string, printWriter);
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final List<NodePoint> getPoints() {
        return this.points;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @Nullable
    public final PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public final void setPrintWriter(@Nullable PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    @NotNull
    public final Path export() {
        Path path = Files.createTempFile("dataset-", ".csv", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        NodeDataFrame.exportTo$default(this, path, false, 2, null);
        return path;
    }

    @NotNull
    public final Path exportTo(@NotNull Path path, boolean withHeader) {
        PrintWriter pw;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.printWriter == null) {
            FileWriter fw = new FileWriter(path.toFile(), true);
            this.printWriter = new PrintWriter((Writer)fw, true);
        }
        if ((pw = this.printWriter) != null) {
            if (withHeader) {
                this.exportHeader(this.schema, pw, this.separator);
            }
            Iterable $this$forEach$iv = this.points;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint it = (NodePoint)((Object)element$iv);
                boolean bl = false;
                Node node = it.getNode();
                NodeDataFrame.exportNode$default(this, node, (RealVector)it, pw, null, 8, null);
                pw.println();
            }
        }
        return path;
    }

    public static /* synthetic */ Path exportTo$default(NodeDataFrame nodeDataFrame, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return nodeDataFrame.exportTo(path, bl);
    }

    @Override
    public void close() {
        PrintWriter printWriter = this.printWriter;
        if (printWriter != null) {
            printWriter.flush();
        }
        printWriter = this.printWriter;
        if (printWriter != null) {
            printWriter.close();
        }
    }

    private final void exportHeader(Schema schema, PrintWriter pw, String separator) {
        pw.print("Label");
        pw.print(separator);
        pw.println(CollectionsKt.joinToString$default((Iterable)schema.getColumns(), (CharSequence)",", null, null, (int)0, null, (Function1)exportHeader.1.INSTANCE, (int)30, null));
    }

    static /* synthetic */ void exportHeader$default(NodeDataFrame nodeDataFrame, Schema schema, PrintWriter printWriter, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = ",";
        }
        nodeDataFrame.exportHeader(schema, printWriter, string);
    }

    private final void exportNode(Node node, RealVector features, PrintWriter pw, String separator) {
        pw.print(this.encodeLabel(node));
        int n = 0;
        int n2 = features.getDimension();
        if (n < n2) {
            do {
                int j = n++;
                pw.print(separator);
                pw.print(VectorsKt.get((RealVector)features, (int)j));
            } while (n < n2);
        }
    }

    static /* synthetic */ void exportNode$default(NodeDataFrame nodeDataFrame, Node node, RealVector realVector, PrintWriter printWriter, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = ",";
        }
        nodeDataFrame.exportNode(node, realVector, printWriter, string);
    }

    private final int encodeLabel(Node node) {
        List labels = NodeExtKt.getMlLabels((Node)node);
        return labels.contains("Title") ? 1 : (labels.contains("Meta") ? 2 : (labels.contains("Content") ? 3 : 0));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/ml/NodeDataFrame$Companion;", "", "()V", "emptyDataFrame", "Lai/platon/scent/ml/NodeDataFrame;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeDataFrame emptyDataFrame() {
            boolean bl = false;
            return new NodeDataFrame(new Schema(null, 1, null), new ArrayList(), null, null, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

