/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.segment;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.DocumentFragment;
import ai.platon.pulsar.dom.DocumentFragments;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.scent.diagnosis.FragmentFormatter;
import ai.platon.scent.diagnosis.ScentDiagnostor;
import ai.platon.scent.segment.BlockFiltersKt;
import ai.platon.scent.segment.BlockLocator;
import ai.platon.scent.segment.BlockStatLocator;
import ai.platon.scent.segment.ChainedBlockLocator;
import ai.platon.scent.segment.LabelLocator;
import ai.platon.scent.segment.MlLocator;
import ai.platon.scent.segment.PatternLocator;
import ai.platon.scent.segment.SelectorLocator;
import ai.platon.scent.segment.VarianceLocator;
import ai.platon.scent.segment.detail.DocumentPartitionerImpl;
import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/segment/DocumentPartitioner;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "locator", "Lai/platon/scent/segment/BlockLocator;", "diagnostor", "Lai/platon/scent/diagnosis/ScentDiagnostor;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/scent/segment/BlockLocator;Lai/platon/scent/diagnosis/ScentDiagnostor;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "partition", "Lai/platon/pulsar/dom/DocumentFragments;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "Companion", "scent-auto-mining"})
public final class DocumentPartitioner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private BlockLocator locator;
    @Nullable
    private final ScentDiagnostor diagnostor;
    private static final Logger log = LoggerFactory.getLogger(DocumentPartitioner.class);

    public DocumentPartitioner(@NotNull ImmutableConfig conf, @NotNull BlockLocator locator, @Nullable ScentDiagnostor diagnostor) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
        this.conf = conf;
        this.locator = locator;
        this.diagnostor = diagnostor;
    }

    public /* synthetic */ DocumentPartitioner(ImmutableConfig immutableConfig, BlockLocator blockLocator, ScentDiagnostor scentDiagnostor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            blockLocator = Companion.predefinedLocators(immutableConfig);
        }
        if ((n & 4) != 0) {
            scentDiagnostor = null;
        }
        this(immutableConfig, blockLocator, scentDiagnostor);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public DocumentPartitioner(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf, Companion.predefinedLocators(conf), null, 4, null);
    }

    @NotNull
    public final DocumentFragments partition(@NotNull FeaturedDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        DocumentFragments fragments = doc.getFragments();
        LinkedHashMap counters = new LinkedHashMap();
        Object object = this.diagnostor;
        if (object != null) {
            ((ScentDiagnostor)object).addFormatter(new FragmentFormatter(doc.getFragments(), this.conf));
        }
        this.locator.locateTo(doc, fragments);
        counters.putAll(this.locator.getCounters());
        object = counters;
        String string = "unfiltered";
        Integer n = fragments.size();
        boolean bl = false;
        object.put(string, n);
        BlockFiltersKt.removeIf(fragments, (Function1<? super DocumentFragment, Boolean>)((Function1)new Function1<DocumentFragment, Boolean>(doc){
            final /* synthetic */ FeaturedDocument $doc;
            {
                this.$doc = $doc;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DocumentFragment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BlockFiltersKt.isValuelessBlock(it, this.$doc);
            }
        }));
        object = counters;
        string = "total";
        n = fragments.size();
        bl = false;
        object.put(string, n);
        Companion.buildTree(fragments);
        object = counters;
        string = "tidy";
        n = fragments.size();
        bl = false;
        object.put(string, n);
        if (log.isDebugEnabled()) {
            log.debug("Partitioner counters: " + counters);
        }
        return fragments;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/segment/DocumentPartitioner$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildTree", "", "fragments", "Lai/platon/pulsar/dom/DocumentFragments;", "predefinedLocators", "Lai/platon/scent/segment/ChainedBlockLocator;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChainedBlockLocator predefinedLocators(@NotNull ImmutableConfig conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            Object[] objectArray = new BlockLocator[]{new LabelLocator(conf), new SelectorLocator(conf), new PatternLocator(conf), new MlLocator(conf), new BlockStatLocator(conf), new VarianceLocator(conf, null, 2, null)};
            Object[] predefined = objectArray;
            return new ChainedBlockLocator(conf, ArraysKt.asIterable((Object[])predefined));
        }

        public final void buildTree(@NotNull DocumentFragments fragments) {
            Intrinsics.checkNotNullParameter((Object)fragments, (String)"fragments");
            new DocumentPartitionerImpl(fragments).buildTree();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

