/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.analysis.AutoMiner;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.AutoMiningTask;
import ai.platon.scent.analysis.DocumentLoader;
import ai.platon.scent.analysis.HarvestTaskTracker;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.FullFeaturedDocumentKt;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.common.message.ScentMiscMessageWriter;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.NavigateAnchor;
import ai.platon.scent.dom.nodes.NavigateDocument;
import ai.platon.scent.entities.AnchorGroupInfo;
import ai.platon.scent.entities.HarvestTableInfo;
import ai.platon.scent.entities.HarvestTaskStatus;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.ml.BasicNGramNodeEncoder;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.data.NodeSimpleDataFrame;
import ai.platon.scent.ml.data.SimpleDataFrame;
import ai.platon.scent.segment.NavigationLocator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 V2\u00020\u0001:\u0001VB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010 \u001a\u00020!JF\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0086@\u00a2\u0006\u0002\u0010+J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020-0\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010 \u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J*\u0010<\u001a\u0002032\u0006\u0010.\u001a\u00020\u00162\u0006\u0010 \u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J0\u0010<\u001a\u0002032\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u0016052\u0006\u0010 \u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J\u001e\u0010<\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020:0\u00152\u0006\u0010 \u001a\u000207H\u0002J*\u0010<\u001a\u0002032\u0006\u0010?\u001a\u0002062\u0006\u0010 \u001a\u0002072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;09J.\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u001b2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010 \u001a\u00020!H\u0002J4\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u000f2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020F0J2\u0006\u0010C\u001a\u00020\u001b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u000e\u0010K\u001a\u00020L2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010M\u001a\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020LH\u0002J \u0010Q\u001a\u00020A2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010R\u001a\u00020S2\u0006\u0010N\u001a\u00020OH\u0002J\u0016\u0010T\u001a\u00020*2\u0006\u0010U\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006W"}, d2={"Lai/platon/scent/analysis/AutoMiner;", "", "activeHarvestTracker", "Lai/platon/scent/analysis/HarvestTaskTracker;", "messageWriter", "Lai/platon/scent/common/message/ScentMiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/analysis/HarvestTaskTracker;Lai/platon/scent/common/message/ScentMiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getActiveHarvestTracker", "()Lai/platon/scent/analysis/HarvestTaskTracker;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxNumShow", "", "getMaxNumShow", "()I", "minSamples", "getMinSamples", "arrangeDocuments", "", "Lai/platon/pulsar/dom/FeaturedDocument;", "task", "Lai/platon/scent/analysis/AutoMiningTask;", "arrangeLinks", "Ljava/util/SortedSet;", "Lai/platon/scent/dom/nodes/AnchorGroup;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "doc", "docs", "options", "Lai/platon/scent/dom/HarvestOptions;", "createMiningTask", "portalPage", "Lai/platon/pulsar/persist/WebPage;", "anchorGroups", "itemOptions", "documentLoader", "Lai/platon/scent/analysis/DocumentLoader;", "taskStatus", "Lai/platon/scent/entities/HarvestTaskStatus;", "(Lai/platon/scent/dom/HNormUrl;Lai/platon/pulsar/persist/WebPage;Ljava/util/SortedSet;Lai/platon/scent/dom/HarvestOptions;Lai/platon/scent/analysis/DocumentLoader;Lai/platon/scent/entities/HarvestTaskStatus;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createVisualDocument", "Lai/platon/scent/analysis/corpus/VisualDocument;", "document", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "createVisualDocuments", "encodeElements", "Lai/platon/scent/ml/data/SimpleDataFrame;", "rootElements", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/ml/EncodeOptions;", "filter", "Lkotlin/Function1;", "Lorg/jsoup/nodes/Node;", "", "encodeNodes", "documents", "nodes", "rootElement", "loadAnchorGroupTo", "", "page", "anchorGroup", "destination", "", "", "logAnchorAnalysisRound", "round", "urls", "", "mine", "Lai/platon/scent/entities/PageTableGroup;", "reportTableGroup", "start", "Ljava/time/Instant;", "tableGroup", "reportTableGroupIfNecessary", "result", "Lai/platon/scent/analysis/AutoMiningResult;", "updateTask", "miningTask", "Companion", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nAutoMiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMiner.kt\nai/platon/scent/analysis/AutoMiner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Queries.kt\nai/platon/pulsar/dom/select/QueriesKt\n*L\n1#1,458:1\n288#2,2:459\n1549#2:461\n1620#2,3:462\n1620#2,3:465\n1360#2:468\n1446#2,5:469\n1549#2:474\n1620#2,3:475\n1549#2:478\n1620#2,3:479\n1549#2:486\n1620#2,3:487\n1864#2,3:490\n1549#2:496\n1620#2,3:497\n1855#2,2:500\n1559#2:502\n1590#2,4:503\n739#3,4:482\n1#4:493\n61#5,2:494\n*S KotlinDebug\n*F\n+ 1 AutoMiner.kt\nai/platon/scent/analysis/AutoMiner\n*L\n139#1:459,2\n162#1:461\n162#1:462,3\n173#1:465,3\n203#1:468\n203#1:469,5\n203#1:474\n203#1:475,3\n231#1:478\n231#1:479,3\n253#1:486\n253#1:487,3\n253#1:490,3\n319#1:496\n319#1:497,3\n381#1:500,2\n431#1:502\n431#1:503,4\n238#1:482,4\n301#1:494,2\n*E\n"})
public final class AutoMiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HarvestTaskTracker activeHarvestTracker;
    @NotNull
    private final ScentMiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final int maxNumShow;
    private final int minSamples;
    @NotNull
    private static final ConcurrentExpiringLRUCache<String, VisualDocument> visualDocumentCache = new ConcurrentExpiringLRUCache(null, 0, 3, null);

    public AutoMiner(@NotNull HarvestTaskTracker activeHarvestTracker, @NotNull ScentMiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)activeHarvestTracker, (String)"activeHarvestTracker");
        Intrinsics.checkNotNullParameter((Object)messageWriter, (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.activeHarvestTracker = activeHarvestTracker;
        this.messageWriter = messageWriter;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AutoMiner.class));
        this.maxNumShow = 50;
        this.minSamples = 10;
    }

    @NotNull
    public final HarvestTaskTracker getActiveHarvestTracker() {
        return this.activeHarvestTracker;
    }

    public final int getMaxNumShow() {
        return this.maxNumShow;
    }

    public final int getMinSamples() {
        return this.minSamples;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object createMiningTask(@NotNull HNormUrl var1_1, @NotNull WebPage var2_2, @NotNull SortedSet<AnchorGroup> var3_3, @NotNull HarvestOptions var4_4, @NotNull DocumentLoader var5_5, @NotNull HarvestTaskStatus var6_6, @NotNull Continuation<? super AutoMiningTask> var7_7) {
        if (!(var7_7 instanceof createMiningTask.1)) ** GOTO lbl-1000
        var26_8 = var7_7;
        if ((var26_8.label & -2147483648) != 0) {
            var26_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_7){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ AutoMiner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createMiningTask(null, null, null, null, null, null, (Continuation<? super AutoMiningTask>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var27_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (UrlUtils.isInternal((String)portalUrl.getSpec())) {
                    this.logger.warn("Unexpected internal portal url");
                    return null;
                }
                startTime = Instant.now();
                portalOptions = portalUrl.getHOptions();
                documents = CollectionsKt.emptyList();
                topNAnchorGroups = portalUrl.getOptions().getTopNAnchorGroups();
                maxSize = 0;
                task = new Ref.ObjectRef();
                round = 0;
                elapsed = Duration.ofSeconds(0L);
                timeout = Duration.ofMinutes(2L);
                it = anchorGroups.iterator();
lbl25:
                // 3 sources

                while (it.hasNext() && round++ < topNAnchorGroups && maxSize < this.minSamples && elapsed.compareTo(timeout) < 0) {
                    if (round > 1) {
                        var18_21 = new Object[]{Boxing.boxInt((int)round), Boxing.boxInt((int)documents.size()), Boxing.boxInt((int)this.minSamples)};
                        this.logger.warn("In round #{} found {} samples but at least {} are required, trying the next group", var18_21);
                    }
                    anchorGroup /* !! */  = (AnchorGroup)it.next();
                    urls = new LinkedHashSet<E>();
                    if (portalOptions.getLoadAnchorGroup()) {
                        Intrinsics.checkNotNull((Object)anchorGroup /* !! */ );
                        this.loadAnchorGroupTo(portalPage, anchorGroup /* !! */ , urls, portalOptions);
                    }
                    SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)anchorGroup /* !! */ .getUrlStrings()), (int)portalOptions.getTopLinks()), (Collection)urls);
                    $continuation.L$0 = this;
                    $continuation.L$1 = portalUrl;
                    $continuation.L$2 = portalPage;
                    $continuation.L$3 = itemOptions;
                    $continuation.L$4 = documentLoader;
                    $continuation.L$5 = taskStatus;
                    $continuation.L$6 = startTime;
                    $continuation.L$7 = portalOptions;
                    $continuation.L$8 = task;
                    $continuation.L$9 = timeout;
                    $continuation.L$10 = it;
                    $continuation.L$11 = anchorGroup /* !! */ ;
                    $continuation.L$12 = urls;
                    $continuation.I$0 = topNAnchorGroups;
                    $continuation.I$1 = maxSize;
                    $continuation.I$2 = round;
                    $continuation.label = 1;
                    v0 = documentLoader.loadAll(portalUrl, urls, itemOptions, (Continuation<? super Sequence<? extends FeaturedDocument>>)$continuation);
                    if (v0 == var27_10) {
                        return var27_10;
                    }
                    ** GOTO lbl77
                }
                break;
            }
            case 1: {
                round = $continuation.I$2;
                maxSize = $continuation.I$1;
                topNAnchorGroups = $continuation.I$0;
                urls = (Set)$continuation.L$12;
                anchorGroup /* !! */  = (AnchorGroup)$continuation.L$11;
                it = (Iterator<E>)$continuation.L$10;
                timeout = (Duration)$continuation.L$9;
                task = (Ref.ObjectRef)$continuation.L$8;
                portalOptions = (HarvestOptions)$continuation.L$7;
                startTime = (Instant)$continuation.L$6;
                taskStatus = (HarvestTaskStatus)$continuation.L$5;
                documentLoader = (DocumentLoader)$continuation.L$4;
                itemOptions = (HarvestOptions)$continuation.L$3;
                portalPage = (WebPage)$continuation.L$2;
                portalUrl = (HNormUrl)$continuation.L$1;
                this = (AutoMiner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl77:
                // 2 sources

                featuredDocuments = SequencesKt.toList((Sequence)((Sequence)v0));
                this.logger.info("Total {} featured documents, {} urls", (Object)Boxing.boxInt((int)featuredDocuments.size()), (Object)Boxing.boxInt((int)urls.size()));
                task0 = new AutoMiningTask(portalUrl, portalPage, (Sequence<? extends FeaturedDocument>)CollectionsKt.asSequence((Iterable)featuredDocuments), itemOptions);
                Intrinsics.checkNotNull((Object)anchorGroup /* !! */ );
                task0.setAnchorGroup(anchorGroup /* !! */ );
                documents = this.createVisualDocuments(task0);
                if (documents.size() > maxSize) {
                    maxSize = documents.size();
                    task.element = task0;
                }
                Intrinsics.checkNotNull((Object)startTime);
                elapsed = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)startTime, null, (int)2, null);
                if (!this.logger.isInfoEnabled()) ** GOTO lbl25
                this.logAnchorAnalysisRound(round, urls, anchorGroup /* !! */ , featuredDocuments);
                ** GOTO lbl25
            }
        }
        if (elapsed.compareTo(timeout) >= 0) {
            this.logger.warn("Harvest task takes long time({}) | {}", (Object)elapsed, (Object)portalUrl);
        }
        if (task.element != null) {
            block15: {
                anchorGroup /* !! */  = taskStatus.getAnchorGroups();
                var24_26 = taskStatus;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (AnchorGroupInfo)element$iv;
                    $i$a$-firstOrNull-AutoMiner$createMiningTask$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getAnchorGroupPath(), (Object)((AutoMiningTask)task.element).getAnchorGroup().getPath())) continue;
                    v1 = element$iv;
                    break block15;
                }
                v1 = null;
            }
            var24_26.setAnchorGroup((AnchorGroupInfo)v1);
        }
        return task.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<AnchorGroup> arrangeLinks(@NotNull HNormUrl portalUrl, @NotNull FeaturedDocument doc) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        if (UrlUtils.isInternal((String)portalUrl.getSpec())) {
            this.logger.warn("Unexpected internal portal url");
            return SetsKt.sortedSetOf((Object[])new AnchorGroup[0]);
        }
        HarvestOptions options = portalUrl.getHOptions();
        HarvestTaskStatus taskStatus = this.activeHarvestTracker.computeIfAbsent((NormUrl)portalUrl);
        if (!StringsKt.isBlank((CharSequence)options.getOutLinkSelector())) {
            void $this$mapTo$iv$iv;
            String restrictCss = QueriesKt.appendSelectorIfMissing((String)options.getOutLinkSelector(), (String)"a");
            Object[] $this$map$iv = (Object[])FeaturedDocument.select$default((FeaturedDocument)doc, (String)restrictCss, (int)0, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new NavigateAnchor((Element)it, null, options.getIgnoreUrlQuery(), 2, null));
            }
            List anchors = (List)destination$iv$iv;
            $this$map$iv = new AnchorGroup[]{new AnchorGroup(options.getOutLinkSelector(), anchors, null, null, 12, null)};
            return SetsKt.sortedSetOf((Object[])$this$map$iv);
        }
        NavigationLocator locator = new NavigationLocator(options);
        locator.locate(doc);
        Collection collection = locator.getAnchorGroups().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        SortedSet anchorGroups = CollectionsKt.toSortedSet((Iterable)collection, (Comparator)ComparisonsKt.reverseOrder());
        Iterable $this$map$iv = anchorGroups;
        Collection destination$iv = taskStatus.getAnchorGroups();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            AnchorGroup anchorGroup = (AnchorGroup)item$iv;
            Collection collection2 = destination$iv;
            boolean bl = false;
            collection2.add(new AnchorGroupInfo(portalUrl.getConfiguredUrl(), options.getOutLinkSelector(), it.getPath(), it.getSize()));
        }
        if (!((Collection)anchorGroups).isEmpty()) {
            Object[] objectArray = new Object[]{anchorGroups.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.info("Find {} anchor groups in page {} | file://{}", objectArray);
        } else {
            this.logger.warn("\n!!! No navigate url is found in document {} | file://{} !!!\n", (Object)doc.getLocation(), (Object)NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal());
        }
        return anchorGroups;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<AnchorGroup> arrangeLinks(@NotNull List<? extends FeaturedDocument> docs, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (docs.isEmpty()) {
            return SetsKt.sortedSetOf((Object[])new AnchorGroup[0]);
        }
        if (!StringsKt.isBlank((CharSequence)options.getOutLinkSelector())) {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            Iterable list$iv$iv;
            FeaturedDocument it;
            void $this$flatMapTo$iv$iv;
            String restrictCss = QueriesKt.appendSelectorIfMissing((String)options.getOutLinkSelector(), (String)"a");
            Iterable $this$flatMap$iv = docs;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FeaturedDocument)element$iv$iv;
                boolean bl = false;
                list$iv$iv = (Iterable)FeaturedDocument.select$default((FeaturedDocument)it, (String)restrictCss, (int)0, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new NavigateAnchor((Element)it, null, options.getIgnoreUrlQuery(), 2, null));
            }
            List anchors = (List)destination$iv$iv;
            $this$map$iv = new AnchorGroup[]{new AnchorGroup(options.getOutLinkSelector(), anchors, null, null, 12, null)};
            return SetsKt.sortedSetOf((Object[])$this$map$iv);
        }
        NavigationLocator locator = new NavigationLocator(options);
        locator.locate(docs);
        Collection collection = locator.getAnchorGroups().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        SortedSet anchorGroups = CollectionsKt.toSortedSet((Iterable)collection, (Comparator)ComparisonsKt.reverseOrder());
        FeaturedDocument doc = (FeaturedDocument)CollectionsKt.first(docs);
        if (!((Collection)anchorGroups).isEmpty()) {
            Object[] objectArray = new Object[]{anchorGroups.size(), docs.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.info("Find {} anchor groups in {} pages, portal {} | file://{}", objectArray);
        } else {
            Object[] objectArray = new Object[]{docs.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.warn("\n!!! No navigate url is found in {} pages, portal {} | file://{} !!!\n", objectArray);
        }
        return anchorGroups;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FeaturedDocument> arrangeDocuments(@NotNull AutoMiningTask task) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable $this$map$iv = this.createVisualDocuments(task);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFeaturedDocument());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VisualDocument> createVisualDocuments(AutoMiningTask task) {
        void $this$associateTo$iv;
        this.logger.info("Creating visual documents");
        AtomicInteger count = new AtomicInteger();
        Sequence<FeaturedDocument> sequence = task.getDocuments();
        Map destination$iv = new LinkedHashMap(1000);
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = destination$iv;
            FeaturedDocument it = (FeaturedDocument)element$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getBaseURI(), (Object)this.createVisualDocument(it, task.getItemOptions(), count));
            map.put(pair.getFirst(), pair.getSecond());
        }
        LinkedHashMap samples = (LinkedHashMap)destination$iv;
        this.logger.info("Total {} visual documents are created", (Object)samples.size());
        AnalysablePageCorpus corpus = new AnalysablePageCorpus(task.getPortalUrl(), samples, this.conf);
        corpus.calculateCorpusFeatures();
        corpus.findQualifiedDocuments();
        task.setCorpus$scent_auto_mining(corpus);
        if (this.logger.isDebugEnabled()) {
            void $this$forEachIndexed$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = corpus.getQualifiedDocuments$scent_auto_mining();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VisualDocument visualDocument = (VisualDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFeaturedDocument());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void document;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FeaturedDocument item$iv$iv = (FeaturedDocument)item$iv;
                int i = n;
                boolean bl = false;
                FullFeaturedDocumentKt.annotateNodes((FeaturedDocument)document, task.getItemOptions());
                AppFiles.INSTANCE.saveTo(document.getPrettyHtml(), NodeExtKt.getExportPaths((Document)document.getDocument()).getAnnotatedView(), true);
            }
        }
        return corpus.getQualifiedDocuments$scent_auto_mining();
    }

    private final VisualDocument createVisualDocument(FeaturedDocument document, HarvestOptions options, AtomicInteger count) {
        int c = count.incrementAndGet();
        if (c > 1000 && c % 1000 == 0) {
            this.logger.info("Creating {}-th visual document", (Object)c);
        } else if (c > 500 && c % 100 == 0) {
            this.logger.info("Creating {}-th visual document", (Object)c);
        } else if (c % 50 == 0) {
            this.logger.info("Creating {}-th visual document", (Object)c);
        }
        if (c % 100 == 0) {
            System.gc();
        }
        NavigateDocument navigateDocument = new NavigateDocument(document);
        navigateDocument.partition(options);
        ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setNavigateDocument((Node)((Node)document.getDocument()), (NavigateDocument)navigateDocument);
        VisualDocument visualDocument = new VisualDocument(document.getBaseURI(), document, options);
        visualDocument.calculateFeatures();
        return visualDocument;
    }

    @NotNull
    public final SimpleDataFrame encodeNodes(@NotNull FeaturedDocument document, @NotNull EncodeOptions options, @NotNull Function1<? super Node, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return this.encodeNodes((Element)document.getDocument(), options, filter2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleDataFrame encodeNodes(@NotNull Element rootElement, @NotNull EncodeOptions options, @NotNull Function1<? super Node, Boolean> filter2) {
        void $this$collectIfTo$iv;
        void destination$iv;
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        int dimension = rootElement.getExtension().getFeatures().getDimension();
        if (!(dimension > 0)) {
            boolean $i$a$-require-AutoMiner$encodeNodes$22 = false;
            String $i$a$-require-AutoMiner$encodeNodes$22 = "The document's feature should be calculated.";
            throw new IllegalArgumentException($i$a$-require-AutoMiner$encodeNodes$22.toString());
        }
        Node $i$a$-require-AutoMiner$encodeNodes$22 = (Node)rootElement;
        Collection collection = new ArrayList();
        boolean $i$f$collectIfTo = false;
        NodeTraversor.traverse((NodeVisitor)new NodeVisitor(filter2, (Collection)destination$iv){
            final /* synthetic */ Function1 $filter;
            final /* synthetic */ Collection $destination;
            {
                this.$filter = $filter;
                this.$destination = $destination;
            }

            public final void head(@NotNull Node node, int n) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (((Boolean)this.$filter.invoke((Object)node)).booleanValue()) {
                    this.$destination.add(node);
                }
            }
        }, (Node)$this$collectIfTo$iv);
        List nodes2 = (List)destination$iv;
        return this.encodeNodes(nodes2, options);
    }

    private final SimpleDataFrame encodeNodes(List<? extends Node> nodes2, EncodeOptions options) {
        NodeSimpleDataFrame nodeSimpleDataFrame;
        if (nodes2.isEmpty()) {
            return NodeSimpleDataFrame.Companion.emptyDataFrame();
        }
        BasicNGramNodeEncoder encoder = new BasicNGramNodeEncoder(options, 0, 2, null);
        ArrayList<NodePoint> points = encoder.encode(nodes2);
        NodeSimpleDataFrame it = nodeSimpleDataFrame = new NodeSimpleDataFrame((List<? extends NodePoint>)points, encoder.getSchema(), options);
        boolean bl = false;
        it.export();
        return nodeSimpleDataFrame;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleDataFrame encodeNodes(@NotNull Iterable<? extends FeaturedDocument> documents, @NotNull EncodeOptions options, @NotNull Function1<? super Node, Boolean> filter2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Iterable<? extends FeaturedDocument> iterable = documents;
        AutoMiner autoMiner = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FeaturedDocument featuredDocument = (FeaturedDocument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDocument());
        }
        return autoMiner.encodeElements((List)destination$iv$iv, options, filter2);
    }

    @NotNull
    public final SimpleDataFrame encodeElements(@NotNull Iterable<? extends Element> rootElements, @NotNull EncodeOptions options, @NotNull Function1<? super Node, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(rootElements, (String)"rootElements");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Iterator<? extends Element> it = rootElements.iterator();
        if (!it.hasNext()) {
            return NodeSimpleDataFrame.Companion.emptyDataFrame();
        }
        SimpleDataFrame head2 = this.encodeNodes(it.next(), options, filter2);
        it.forEachRemaining(arg_0 -> AutoMiner.encodeElements$lambda$12((Function1)new Function1<Element, Unit>(this, options, filter2, head2){
            final /* synthetic */ AutoMiner this$0;
            final /* synthetic */ EncodeOptions $options;
            final /* synthetic */ Function1<Node, Boolean> $filter;
            final /* synthetic */ SimpleDataFrame $head;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$filter = $filter;
                this.$head = $head;
                super(1);
            }

            public final void invoke(@NotNull Element rootElement) {
                Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
                SimpleDataFrame tail = this.this$0.encodeNodes(rootElement, this.$options, this.$filter);
                this.$head.addTail(tail);
            }
        }, arg_0));
        return head2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PageTableGroup mine(@NotNull AutoMiningTask task) {
        AutoMiningResult autoMiningResult;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Instant start = Instant.now();
        if (task.getCorpus$scent_auto_mining() == null) {
            this.arrangeDocuments(task);
        }
        AnalysablePageCorpus analysablePageCorpus = task.getCorpus$scent_auto_mining();
        if (analysablePageCorpus == null) {
            return PageTableGroup.Companion.getEMPTY();
        }
        AnalysablePageCorpus corpus = analysablePageCorpus;
        AutoCloseable autoCloseable = corpus;
        Throwable throwable = null;
        try {
            AnalysablePageCorpus c = (AnalysablePageCorpus)autoCloseable;
            boolean bl = false;
            autoMiningResult = c.analyse();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        AutoMiningResult result = autoMiningResult;
        Intrinsics.checkNotNull((Object)start);
        this.reportTableGroup(task, start, result.getPageTableGroup());
        return result.getPageTableGroup();
    }

    private final void reportTableGroupIfNecessary(AutoMiningTask task, AutoMiningResult result, Instant start) {
        boolean diagnose2 = task.getPortalUrl().getHOptions().getDiagnose();
        if (diagnose2 || this.logger.isInfoEnabled()) {
            this.reportTableGroup(task, start, result.getPageTableGroup());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HarvestTaskStatus updateTask(@NotNull AutoMiningTask miningTask, @NotNull HarvestTaskStatus task) {
        int n;
        Intrinsics.checkNotNullParameter((Object)miningTask, (String)"miningTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        AnalysablePageCorpus analysablePageCorpus = miningTask.getCorpus$scent_auto_mining();
        if (analysablePageCorpus == null) {
            return task;
        }
        AnalysablePageCorpus corpus = analysablePageCorpus;
        AutoMiningResult autoMiningResult = miningTask.getMiningResult();
        if (autoMiningResult == null) {
            return task;
        }
        AutoMiningResult miningResult = autoMiningResult;
        PageTableGroup tableGroup = miningResult.getPageTableGroup();
        String configuredUrl = miningTask.getConfiguredUrl();
        HarvestTaskStatus harvestTaskStatus = task.getActualTask();
        if (harvestTaskStatus == null) {
            harvestTaskStatus = task;
        }
        HarvestTaskStatus activeTask = harvestTaskStatus;
        activeTask.setNSuccessPages(miningTask.getNumSamples());
        activeTask.setNFailedPages(miningTask.getAnchorGroup().getSize() - miningTask.getNumSamples());
        activeTask.setNRecoverableDocuments(corpus.getQualifiedDocuments$scent_auto_mining().size());
        activeTask.setRecoverableConfidence(corpus.getRecoverableConfidence$scent_auto_mining());
        activeTask.setNTables(tableGroup.getSize());
        Iterable iterable = tableGroup.getTables();
        HarvestTaskStatus harvestTaskStatus2 = activeTask;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            OpenMapTable openMapTable = (OpenMapTable)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getNumColumns();
            n2 = n + n3;
        }
        n = n2;
        harvestTaskStatus2.setNFields(n);
        Iterable $this$forEach$iv = tableGroup.getTables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenMapTable table = (OpenMapTable)element$iv;
            boolean bl = false;
            TableData data = PageTableKt.getData((OpenMapTable)table);
            HarvestTableInfo tableInfo = new HarvestTableInfo(configuredUrl, 0, 0, data.getName(), null, table.getNumRows(), table.getNumColumns(), data.getDataTypeStatistics(), data.getClusterTaskStatus(), data.getClusterGroupMetrics(), 22, null);
            activeTask.getTableInfos().add(tableInfo);
        }
        return task;
    }

    private final void reportTableGroup(AutoMiningTask task, Instant start, PageTableGroup tableGroup) {
        AnalysablePageCorpus analysablePageCorpus = task.getCorpus$scent_auto_mining();
        if (analysablePageCorpus == null) {
            return;
        }
        AnalysablePageCorpus corpus = analysablePageCorpus;
        Duration elapsed = Duration.between(start, Instant.now());
        int numNature = corpus.getNaturalComponents$scent_auto_mining().size();
        this.logger.info("Total " + elapsed + " to analyze " + task.getNumSamples() + " documents, found " + numNature + " natural components, generated " + tableGroup.getSize() + " tables");
        if (tableGroup.isNotEmpty()) {
            String s2 = CollectionsKt.joinToString$default((Iterable)tableGroup.getTables(), (CharSequence)", ", null, null, (int)0, null, (Function1)reportTableGroup.s.1.INSTANCE, (int)30, null);
            this.logger.info("Table dimensions (row x col): " + s2);
        } else {
            this.logger.warn("!!! No table generated !!!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logAnchorAnalysisRound(int round, Set<String> urls, AnchorGroup anchorGroup, List<? extends FeaturedDocument> documents) {
        int numShow = Math.min(this.maxNumShow, documents.size());
        String s2 = "Round #" + round + " find " + documents.size() + "/" + urls.size() + "/" + anchorGroup.getSize() + " documents/urls/anchors in group #" + anchorGroup.getId() + "[" + anchorGroup.getPath() + "] with score <" + anchorGroup.getScore() + ">";
        if (this.logger.isDebugEnabled()) {
            void $this$mapIndexedTo$iv$iv;
            StringBuilder sb = new StringBuilder(s2);
            sb.append(":\n");
            Iterable $this$mapIndexed$iv = CollectionsKt.take((Iterable)documents, (int)numShow);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void doc;
                void j;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FeaturedDocument featuredDocument = (FeaturedDocument)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = "%d.\t%s [%s]\t->\t file://%s";
                Object[] objectArray = new Object[]{(int)(j + true), StringUtils.abbreviateMiddle((String)doc.getLocation(), (String)"...", (int)100), Strings.compactFormat((int)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getContentBytes((Document)doc.getDocument())), NodeExtKt.getExportPaths((Document)doc.getDocument()).getAnnotatedView()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                collection.add(string2);
            }
            CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)sb, (CharSequence)"\n", null, null, (int)0, null, (Function1)logAnchorAnalysisRound.2.INSTANCE, (int)60, null);
            this.logger.debug(sb.toString());
        } else {
            this.logger.info(s2);
        }
    }

    private final void loadAnchorGroupTo(WebPage page, AnchorGroup anchorGroup, Set<String> destination, HarvestOptions options) {
        String ident = "gn:" + anchorGroup.getId();
        Map map = page.getVividLinks();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getVividLinks(...)");
        SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence((Map)map), (Function1)((Function1)new Function1<Map.Entry<? extends CharSequence, ? extends CharSequence>, String>(ident){
            final /* synthetic */ String $ident;
            {
                this.$ident = $ident;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull Map.Entry<? extends CharSequence, ? extends CharSequence> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Map.Entry<? extends CharSequence, ? extends CharSequence> entry = it;
                String string = this.$ident;
                Map.Entry<? extends CharSequence, ? extends CharSequence> it2 = entry;
                boolean bl = false;
                CharSequence charSequence = it2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"<get-value>(...)");
                Map.Entry<CharSequence, CharSequence> entry2 = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) ? entry : null;
                return entry2 != null && (entry2 = entry2.getKey()) != null ? entry2.toString() : null;
            }
        })), (int)options.getMaxLoadedAnchors()), (Collection)destination);
    }

    private static final void encodeElements$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/analysis/AutoMiner$Companion;", "", "()V", "visualDocumentCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/scent/analysis/corpus/VisualDocument;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

