/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.PageCorpusTabulator;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.common.options.CellType;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.HyperPath;
import ai.platon.scent.dom.nodes.HyperPathBuilder;
import ai.platon.scent.entities.ClusterTaskStatus;
import ai.platon.scent.entities.ColumnData;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.NodeClusterGroupMetrics;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.RowData;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.base.Strings;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\fH\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J,\u00102\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\b\b\u0002\u00104\u001a\u00020\u00072\b\b\u0002\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J \u00108\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010=\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u001a\u0010>\u001a\u00020\f2\b\u0010?\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020AH\u0002J\u001a\u0010B\u001a\u00020\f2\b\u0010?\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020AH\u0002J\u001a\u0010C\u001a\u00020\f2\b\u0010?\u001a\u0004\u0018\u00010\u00012\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010D\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010E\u001a\u00020\f2\b\u0010@\u001a\u0004\u0018\u00010A2\b\b\u0002\u0010F\u001a\u00020\fH\u0002J\u0006\u0010G\u001a\u00020,J\u0018\u0010H\u001a\u00020*2\u0006\u0010I\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020*2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010M\u001a\u00020*2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010N\u001a\u00020*H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u000e\u0010$\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006O"}, d2={"Lai/platon/scent/analysis/corpus/PageCorpusTabulator;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "clusterGroup", "Lai/platon/scent/ml/unsupervised/TileClusterGroup;", "groupIndex", "", "cellType", "Lai/platon/scent/common/options/CellType;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Lai/platon/scent/ml/unsupervised/TileClusterGroup;ILai/platon/scent/common/options/CellType;)V", "command", "", "getCommand", "()Ljava/lang/String;", "documentSize", "getDocumentSize", "()I", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "options", "Lai/platon/scent/dom/HarvestOptions;", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "getPortalUrl", "()Lai/platon/scent/dom/HNormUrl;", "qualifiedClusters", "", "Lai/platon/scent/ml/unsupervised/TileCluster;", "getQualifiedClusters", "()Ljava/util/List;", "qualifiedClusters$delegate", "Lkotlin/Lazy;", "qualifiedRate", "", "qualifiedSize", "getQualifiedSize", "()D", "buildDatabaseRows", "", "table", "Lai/platon/pulsar/common/OpenMapTable;", "buildHtmlRows", "buildLinkCell", "location", "buildNodeRows", "buildPlainTextRows", "buildTitleCell", "title", "displayLength", "textOnly", "", "computeQualifiedClusters", "createXSQL", "url", "restrictPath", "Lai/platon/scent/dom/nodes/HyperPath;", "fillRowCells", "fillSpecialRowCells", "getRichText", "lastValue", "node", "Lorg/jsoup/nodes/Node;", "getSlimHtml", "getText", "initRows", "sniffTitle", "titleSuffix", "tabulate", "updateColumnAttributes", "cluster", "column", "Lai/platon/pulsar/common/OpenMapTable$Column;", "updateTitleColumnAttributes", "updateURLColumnAttributes", "validateClusterOrder", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nPageCorpusTabulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageCorpusTabulator.kt\nai/platon/scent/analysis/corpus/PageCorpusTabulator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,469:1\n1655#2,8:470\n1549#2:478\n1620#2,3:479\n288#2,2:482\n1360#2:484\n1446#2,5:485\n1864#2,3:490\n1855#2,2:496\n1620#2,3:499\n1620#2,3:502\n2333#2,14:505\n1194#2,2:519\n1222#2,4:521\n1864#2,2:525\n1855#2,2:528\n1866#2:531\n1864#2,2:532\n1855#2,2:534\n1866#2:536\n1864#2,2:537\n1855#2,2:539\n1866#2:541\n1864#2,2:542\n1855#2,2:544\n1866#2:546\n1864#2,2:547\n1855#2,2:549\n1866#2:551\n766#2:552\n857#2,2:553\n1045#2:555\n3792#3:493\n4307#3,2:494\n1#4:498\n215#5:527\n216#5:530\n*S KotlinDebug\n*F\n+ 1 PageCorpusTabulator.kt\nai/platon/scent/analysis/corpus/PageCorpusTabulator\n*L\n76#1:470,8\n77#1:478\n77#1:479,3\n79#1:482,2\n90#1:484\n90#1:485,5\n125#1:490,3\n164#1:496,2\n221#1:499,3\n222#1:502,3\n246#1:505,14\n271#1:519,2\n271#1:521,4\n274#1:525,2\n292#1:528,2\n274#1:531\n326#1:532,2\n327#1:534,2\n326#1:536\n352#1:537,2\n354#1:539,2\n352#1:541\n364#1:542,2\n366#1:544,2\n364#1:546\n376#1:547,2\n378#1:549,2\n376#1:551\n464#1:552\n464#1:553,2\n466#1:555\n147#1:493\n147#1:494,2\n275#1:527\n275#1:530\n*E\n"})
public final class PageCorpusTabulator {
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final TileClusterGroup clusterGroup;
    private final int groupIndex;
    @NotNull
    private final CellType cellType;
    private final Logger logger;
    private final double qualifiedRate;
    @NotNull
    private final Lazy qualifiedClusters$delegate;

    public PageCorpusTabulator(@NotNull AnalysablePageCorpus corpus, @NotNull TileClusterGroup clusterGroup, int groupIndex, @NotNull CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter((Object)clusterGroup, (String)"clusterGroup");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.corpus = corpus;
        this.clusterGroup = clusterGroup;
        this.groupIndex = groupIndex;
        this.cellType = cellType;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(PageCorpusTabulator.class));
        this.qualifiedRate = 0.5;
        this.qualifiedClusters$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends TileCluster>>(this){
            final /* synthetic */ PageCorpusTabulator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<TileCluster> invoke() {
                return PageCorpusTabulator.access$computeQualifiedClusters(this.this$0);
            }
        }));
    }

    public /* synthetic */ PageCorpusTabulator(AnalysablePageCorpus analysablePageCorpus, TileClusterGroup tileClusterGroup, int n, CellType cellType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            cellType = CellType.SLIM_HTML;
        }
        this(analysablePageCorpus, tileClusterGroup, n, cellType);
    }

    private final HNormUrl getPortalUrl() {
        return this.corpus.getPortalUrl();
    }

    private final HarvestOptions getOptions() {
        LoadOptions loadOptions = this.getPortalUrl().getOptions();
        Intrinsics.checkNotNull((Object)loadOptions, (String)"null cannot be cast to non-null type ai.platon.scent.dom.HarvestOptions");
        return (HarvestOptions)loadOptions;
    }

    private final String getCommand() {
        return this.getPortalUrl() + " " + this.getOptions().getArgs();
    }

    private final int getDocumentSize() {
        return this.corpus.getQualifiedDocuments$scent_auto_mining().size();
    }

    private final double getQualifiedSize() {
        return Math.max(this.qualifiedRate * (double)this.getDocumentSize(), 2.0);
    }

    private final List<TileCluster> getQualifiedClusters() {
        Lazy lazy = this.qualifiedClusters$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OpenMapTable tabulate() {
        String $this$flatMapTo$iv$iv;
        Object v0;
        Element sampleComponent;
        List recognizedComponents;
        Object it;
        OpenMapTable table;
        ScoreVector score2;
        block12: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.corpus.getQualifiedDocuments$scent_auto_mining().isEmpty() || this.clusterGroup.isEmpty() || this.clusterGroup.isConstant()) {
                return new OpenMapTable(0, 0, 2, null);
            }
            int numColumns = 1 + this.getQualifiedClusters().size() + 1;
            score2 = this.clusterGroup.getScore();
            table = new OpenMapTable(numColumns, this.groupIndex);
            if (this.getQualifiedClusters().isEmpty()) {
                return table;
            }
            if (this.logger.isDebugEnabled()) {
                this.validateClusterOrder();
            }
            Iterable $this$distinctBy$iv = this.corpus.getComponentElements$scent_auto_mining();
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                it = (Element)e$iv;
                boolean bl = false;
                String key$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)it)).getSelector2();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Element bl = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)it2)).getSelector2(), (Object)NodeExtKt.getUniqueName((Node)((Node)it2))));
            }
            recognizedComponents = (List)destination$iv$iv;
            sampleComponent = (Element)CollectionsKt.first(((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getComponents());
            Iterable $this$firstOrNull$iv = ((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getComponents();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Element)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)NodeExtKt.getOwnerDocument((Node)((Node)it)).title(), (Object)NodeExtKt.getOwnerDocument((Node)((Node)sampleComponent)).title()))) continue;
                v0 = element$iv;
                break block12;
            }
            v0 = null;
        }
        Element sampleComponent2 = v0;
        String titleSuffix = "";
        if (sampleComponent2 != null) {
            if (!(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)sampleComponent)) != ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)sampleComponent2)))) {
                String $i$f$mapTo = "Failed requirement.";
                throw new IllegalArgumentException($i$f$mapTo.toString());
            }
            String t1 = PageCorpusTabulator.sniffTitle$default(this, (Node)sampleComponent, null, 2, null);
            String t2 = PageCorpusTabulator.sniffTitle$default(this, (Node)sampleComponent2, null, 2, null);
            String string = Strings.commonSuffix((CharSequence)t1, (CharSequence)t2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commonSuffix(...)");
            titleSuffix = ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        Object $this$flatMap$iv = this.getQualifiedClusters();
        int $i$f$flatMap = 0;
        it = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv2 = iterator.next();
            TileCluster it3 = (TileCluster)element$iv$iv2;
            boolean bl = false;
            Iterable list$iv$iv = it3.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        HyperPath hyperPath2 = new HyperPathBuilder(list).build();
        $this$flatMap$iv = hyperPath2.getPath();
        $i$f$flatMap = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedTop((Node)((Node)sampleComponent));
        $this$flatMapTo$iv$iv = NodeExtKt.getName((Node)((Node)sampleComponent));
        int n = this.getDocumentSize();
        String $i$f$flatMapTo22 = score2.toString();
        int n2 = this.clusterGroup.getClusters().size();
        int element$iv$iv2 = this.getQualifiedClusters().size();
        double list$iv$iv = this.clusterGroup.getDistortion();
        String string = titleSuffix;
        DataTypeStatistics dataTypeStatistics = this.clusterGroup.getDataTypeStatistics();
        ClusterTaskStatus clusterTaskStatus = this.clusterGroup.getClusterTaskStatus();
        NodeClusterGroupMetrics nodeClusterGroupMetrics = this.clusterGroup.getMetrics();
        double d = this.clusterGroup.getMicroP();
        double d2 = this.clusterGroup.getMicroR();
        double d3 = this.clusterGroup.getMicroF1();
        double d4 = this.clusterGroup.getMacroP();
        double d5 = this.clusterGroup.getMacroR();
        double d6 = this.clusterGroup.getMacroF1();
        int n3 = this.clusterGroup.getNumFineFields();
        double d7 = this.clusterGroup.getFineFieldRate();
        Intrinsics.checkNotNull((Object)$i$f$flatMapTo22);
        PageTableKt.setData((OpenMapTable)table, (TableData)new TableData(false, (String)$this$flatMap$iv, null, $i$f$flatMap, $this$flatMapTo$iv$iv, n, null, $i$f$flatMapTo22, n2, element$iv$iv2, string, list$iv$iv, dataTypeStatistics, clusterTaskStatus, nodeClusterGroupMetrics, d, d2, d3, d4, d5, d6, n3, d7, null, 8388677, null));
        PageTableKt.getData((OpenMapTable)table).getUrls().addAll((Collection)this.corpus.getDocumentUrls$scent_auto_mining());
        PageTableKt.getData((OpenMapTable)table).getRecognizedComponents().addAll(recognizedComponents);
        this.updateTitleColumnAttributes((OpenMapTable.Column)ArraysKt.first((Object[])table.getColumns()));
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster element$iv$iv2 = (TileCluster)item$iv;
            int k = n2;
            boolean bl = false;
            this.updateColumnAttributes((TileCluster)cluster2, table.getColumns()[k]);
        }
        this.updateURLColumnAttributes((OpenMapTable.Column)ArraysKt.last((Object[])table.getColumns()));
        String string2 = (String)CollectionsKt.firstOrNull((Iterable)this.corpus.getDocumentUrls$scent_auto_mining());
        if (string2 == null) {
            string2 = "http://example.com";
        }
        String sampleUrl = string2;
        PageTableKt.getData((OpenMapTable)table).setXsql(this.createXSQL(table, sampleUrl, hyperPath2));
        this.initRows(table);
        this.fillRowCells(table);
        this.fillSpecialRowCells(table);
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private final String createXSQL(OpenMapTable table, String url, HyperPath restrictPath) {
        void $this$filterTo$iv$iv;
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append("select ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        boolean i = false;
        OpenMapTable.Column[] $this$filter$iv = table.getColumns();
        boolean $i$f$filter = false;
        OpenMapTable.Column[] columnArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)PageTableKt.getData((OpenMapTable.Column)it).getHyperPath());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List columns = (List)destination$iv$iv;
        SequencesKt.joinTo$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])table.getColumns()), (Function1)createXSQL.1.INSTANCE), (Function1)createXSQL.2.INSTANCE), (Appendable)sb, (CharSequence)",\n", null, null, (int)0, null, (Function1)createXSQL.3.INSTANCE, (int)60, null);
        StringBuilder stringBuilder2 = sb.append("\nfrom load_and_select('" + url + "', '" + restrictPath + "');");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void fillSpecialRowCells(OpenMapTable table) {
        ((OpenMapTable.Column)ArraysKt.first((Object[])table.getColumns())).setName("Title");
        ((OpenMapTable.Column)ArraysKt.last((Object[])table.getColumns())).setName("URL");
        String titleSuffix = PageTableKt.getData((OpenMapTable)table).getTitleSuffix();
        boolean textOnly = this.cellType == CellType.PLAIN_TEXT;
        Iterable $this$forEach$iv = table.getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
            boolean bl = false;
            PageTableKt.getData((OpenMapTable.Row)row).setTitle(this.sniffTitle((Node)PageTableKt.getData((OpenMapTable.Row)row).getComponent(), titleSuffix));
            row.setValue(0, (Object)PageCorpusTabulator.buildTitleCell$default(this, PageTableKt.getData((OpenMapTable.Row)row).getLocation(), PageTableKt.getData((OpenMapTable.Row)row).getTitle(), 0, textOnly, 4, null));
            int lastColumnIndex = table.getNumColumns() - 1;
            switch (WhenMappings.$EnumSwitchMapping$0[this.cellType.ordinal()]) {
                case 1: {
                    row.setValue(lastColumnIndex, (Object)this.buildLinkCell(PageTableKt.getData((OpenMapTable.Row)row).getLocation()));
                    break;
                }
                case 2: {
                    row.setValue(lastColumnIndex, (Object)PageTableKt.getData((OpenMapTable.Row)row).getLocation());
                    break;
                }
                default: {
                    row.setValue(lastColumnIndex, (Object)("<a href='" + PageTableKt.getData((OpenMapTable.Row)row).getLocation() + "' target='_blank' class='_hidden'>detail&gt;</a>"));
                }
            }
        }
    }

    private final void validateClusterOrder() {
        for (Pair pair : CollectionsKt.zipWithNext((Iterable)this.getQualifiedClusters())) {
            double o2;
            Node n1 = ((NodePoint)((Object)CollectionsKt.first(((TileCluster)pair.getFirst()).getPoints()))).getNode();
            Node n2 = ((NodePoint)((Object)CollectionsKt.first(((TileCluster)pair.getSecond()).getPoints()))).getNode();
            double o1 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)n1);
            if (!(o1 > (o2 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)n2)))) continue;
            this.logger.warn("Unexpected cluster order");
            this.logger.warn(NodeExtKt.getUniqueName((Node)n1) + " (" + o1 + ")\t\t" + NodeExtKt.getUniqueName((Node)n2) + " (" + o2 + ")");
            String string = "%10d%10d%10d%10d";
            Object[] objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedCenterY((Node)n1), NodeExtKt.getX((Node)n1), NodeExtKt.getWidth((Node)n1), NodeExtKt.getHeight((Node)n1)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            this.logger.warn(string2);
            string = "%10d%10d%10d%10d";
            objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedCenterY((Node)n2), NodeExtKt.getX((Node)n2), NodeExtKt.getWidth((Node)n2), NodeExtKt.getHeight((Node)n2)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            this.logger.warn(string3);
        }
    }

    private final String sniffTitle(Node node, String titleSuffix) {
        String string;
        Node node2 = node;
        if (node2 == null || (node2 = node2.ownerDocument()) == null) {
            return "[Title]";
        }
        Node document = node2;
        String it = string = document.title();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 == null && (string2 = QueriesKt.selectFirstTextOrNull((Node)document, (String)"title")) == null && (string2 = QueriesKt.selectFirstTextOrNull((Node)document, (String)"h1")) == null) {
            string2 = "[Title]";
        }
        String title = string2;
        title = StringsKt.removeSuffix((String)title, (CharSequence)titleSuffix);
        return title;
    }

    static /* synthetic */ String sniffTitle$default(PageCorpusTabulator pageCorpusTabulator, Node node, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return pageCorpusTabulator.sniffTitle(node, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateTitleColumnAttributes(OpenMapTable.Column column) {
        Iterable iterable = ((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getPoints();
        int n = 0;
        for (Object t : iterable) {
            void it;
            NodePoint nodePoint = (NodePoint)((Object)t);
            int n2 = n;
            boolean bl = false;
            int n3 = PageCorpusTabulator.sniffTitle$default(this, it.getNode(), null, 2, null).length();
            n = n2 + n3;
        }
        double aveLength = (double)n / this.getQualifiedSize();
        PageTableKt.getData((OpenMapTable.Column)column).setDisplay("title");
        PageTableKt.getData((OpenMapTable.Column)column).setAveLen(aveLength);
    }

    private final void updateURLColumnAttributes(OpenMapTable.Column column) {
        PageTableKt.getData((OpenMapTable.Column)column).setDisplay("URL");
    }

    /*
     * WARNING - void declaration
     */
    private final void updateColumnAttributes(TileCluster cluster2, OpenMapTable.Column column) {
        NodePoint nodePoint;
        Object v4;
        void $this$minByOrNull$iv;
        NodePoint it;
        double d;
        ColumnData columnData;
        Object item$iv3;
        void $this$mapTo$iv;
        Collection collection;
        void $this$mapTo$iv2;
        List points = cluster2.getPoints();
        Node sampleNode = ((NodePoint)((Object)CollectionsKt.first(points))).getNode();
        Iterable iterable = points;
        Iterable destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv2) {
            void it2;
            NodePoint nodePoint2 = (NodePoint)((Object)item$iv2);
            collection = destination$iv;
            boolean bl = false;
            collection.add(NodeExtKt.getLocation((Node)it2.getNode()));
        }
        Frequency urlFrequency = (Frequency)destination$iv;
        destination$iv = points;
        Collection destination$iv2 = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo2 = false;
        for (Object item$iv3 : $this$mapTo$iv) {
            void it3;
            NodePoint bl = (NodePoint)((Object)item$iv3);
            collection = destination$iv2;
            boolean bl2 = false;
            collection.add(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)it3.getNode()).getSelector2());
        }
        Frequency pathFrequency = (Frequency)destination$iv2;
        ConfuseMatrix m = cluster2.getConfuseMatrix();
        ColumnData $this$updateColumnAttributes_u24lambda_u2413 = columnData = PageTableKt.getData((OpenMapTable.Column)column);
        boolean bl = false;
        item$iv3 = "c%02d";
        Object[] it3 = new Object[]{cluster2.getLabel()};
        String string = String.format(item$iv3, Arrays.copyOf(it3, it3.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        $this$updateColumnAttributes_u24lambda_u2413.setClusterId(string);
        $this$updateColumnAttributes_u24lambda_u2413.setDisplay(NodeExtKt.getName((Node)sampleNode));
        $this$updateColumnAttributes_u24lambda_u2413.setCName(cluster2.getNames().toString());
        $this$updateColumnAttributes_u24lambda_u2413.setMlLabel(cluster2.getMlLabel());
        int numPaths = pathFrequency.elementSet().size();
        $this$updateColumnAttributes_u24lambda_u2413.setNumPath(numPaths);
        Multiset.Entry mostEntry = pathFrequency.getMostEntry();
        String string2 = (String)mostEntry.getElement();
        if (string2 == null || (string2 = string2.toString()) == null) {
            string2 = "";
        }
        $this$updateColumnAttributes_u24lambda_u2413.setPath1(string2);
        $this$updateColumnAttributes_u24lambda_u2413.setNumPath1(mostEntry.getCount());
        if (numPaths > 1) {
            Multiset.Entry leastEntry = pathFrequency.getLeastEntry();
            String string3 = (String)leastEntry.getElement();
            if (string3 == null || (string3 = string3.toString()) == null) {
                string3 = "";
            }
            $this$updateColumnAttributes_u24lambda_u2413.setPath2(string3);
            $this$updateColumnAttributes_u24lambda_u2413.setNumPath2(leastEntry.getCount());
        }
        Iterable iterable2 = points;
        ColumnData columnData2 = $this$updateColumnAttributes_u24lambda_u2413;
        double d2 = 0.0;
        for (Object t : iterable2) {
            NodePoint nodePoint3 = (NodePoint)((Object)t);
            d = d2;
            boolean bl3 = false;
            RealVector realVector = it.getNode().getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
            double d3 = VectorsKt.get((RealVector)realVector, (int)DefinedFeaturesKt.CH);
            d2 = d + d3;
        }
        d = d2;
        columnData2.setAveLen(d / (double)points.size());
        Iterable iterable3 = points;
        columnData2 = $this$updateColumnAttributes_u24lambda_u2413;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                it = (NodePoint)((Object)minElem$iv);
                boolean bl4 = false;
                double minValue$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it.getNode());
                do {
                    Object e$iv = iterator$iv.next();
                    NodePoint it4 = (NodePoint)((Object)e$iv);
                    $i$a$-minByOrNull-PageCorpusTabulator$updateColumnAttributes$1$2 = false;
                    double v$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it4.getNode());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        columnData2.setMinFreq((nodePoint = (NodePoint)v4) != null && (nodePoint = nodePoint.getNode()) != null ? ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)nodePoint) : 0.0);
        $this$updateColumnAttributes_u24lambda_u2413.setNumUri(urlFrequency.size());
        $this$updateColumnAttributes_u24lambda_u2413.setMaxUrlFreq((double)urlFrequency.getMostEntry().getCount());
        $this$updateColumnAttributes_u24lambda_u2413.setDistortion(cluster2.getDistortion());
        $this$updateColumnAttributes_u24lambda_u2413.setInt(cluster2.isInt());
        $this$updateColumnAttributes_u24lambda_u2413.setFloat(cluster2.isFloat());
        $this$updateColumnAttributes_u24lambda_u2413.setNumeric(cluster2.isNumeric());
        $this$updateColumnAttributes_u24lambda_u2413.setNumericLike(cluster2.isNumericLike());
        $this$updateColumnAttributes_u24lambda_u2413.setMoneyLike(cluster2.isMoneyLike());
        $this$updateColumnAttributes_u24lambda_u2413.setLazy(cluster2.isLazy());
        $this$updateColumnAttributes_u24lambda_u2413.setTp(m.getTp());
        $this$updateColumnAttributes_u24lambda_u2413.setFp(m.getFp());
        $this$updateColumnAttributes_u24lambda_u2413.setFn(m.getFn());
        $this$updateColumnAttributes_u24lambda_u2413.setTn(m.getTn());
        $this$updateColumnAttributes_u24lambda_u2413.setPrecision(m.getPrecision());
        $this$updateColumnAttributes_u24lambda_u2413.setRecall(m.getRecall());
        $this$updateColumnAttributes_u24lambda_u2413.setF1(m.getF1());
        $this$updateColumnAttributes_u24lambda_u2413.setHyperPath(cluster2.getHyperPath().getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final void initRows(OpenMapTable table) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.corpus.getQualifiedDocuments$scent_auto_mining();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)it.getBody())), element$iv$iv);
        }
        Map indexedDocuments = destination$iv$iv;
        Set failedPids = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (TileCluster)item$iv;
            int k = n;
            boolean bl = false;
            Map<Integer, List<NodePoint>> $this$forEach$iv = cluster2.getPagePoints();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Integer, List<NodePoint>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Document document;
                Map.Entry<Integer, List<NodePoint>> element$iv;
                Map.Entry<Integer, List<NodePoint>> entry = element$iv = iterator.next();
                boolean bl2 = false;
                int pid = ((Number)entry.getKey()).intValue();
                List<NodePoint> points = entry.getValue();
                if (failedPids.contains(pid)) continue;
                VisualDocument visualDocument = (VisualDocument)indexedDocuments.get(pid);
                Object object = document = visualDocument != null ? visualDocument.getDocument() : null;
                if (document == null) {
                    failedPids.add(pid);
                    continue;
                }
                if (NodeExtKt.getNormalizedURI((Document)document) == null) continue;
                Ref.ObjectRef location = new Ref.ObjectRef();
                location.element = NodeExtKt.getLocation((Node)((Node)document));
                if (!StringsKt.startsWith$default((String)((String)location.element), (String)"http", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)document.baseUri(), (String)"baseUri(...)");
                    location.element = location.element;
                }
                Iterable $this$forEach$iv2 = points;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String url;
                    Element component;
                    NodePoint point = (NodePoint)((Object)element$iv2);
                    boolean bl3 = false;
                    if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getOwnerComponent((Node)point.getNode()) == null) continue;
                    table.computeIfAbsent((String)location.element, (Function1)new Function1<OpenMapTable.Row, Unit>(table, component, pid, url, (Ref.ObjectRef<String>)location, document){
                        final /* synthetic */ OpenMapTable $table;
                        final /* synthetic */ Element $component;
                        final /* synthetic */ int $pid;
                        final /* synthetic */ String $url;
                        final /* synthetic */ Ref.ObjectRef<String> $location;
                        final /* synthetic */ Document $document;
                        {
                            this.$table = $table;
                            this.$component = $component;
                            this.$pid = $pid;
                            this.$url = $url;
                            this.$location = $location;
                            this.$document = $document;
                            super(1);
                        }

                        public final void invoke(@NotNull OpenMapTable.Row row) {
                            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                            PageTableKt.getData((OpenMapTable.Row)row).setOwnerTable(this.$table);
                            PageTableKt.getData((OpenMapTable.Row)row).setComponent(this.$component);
                            PageTableKt.getData((OpenMapTable.Row)row).setPid(this.$pid);
                            PageTableKt.getData((OpenMapTable.Row)row).setNormalizedUrl(this.$url);
                            PageTableKt.getData((OpenMapTable.Row)row).setLocation((String)this.$location.element);
                            RowData rowData = PageTableKt.getData((OpenMapTable.Row)row);
                            String string = this.$document.title();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"title(...)");
                            rowData.setTitle(string);
                            PageTableKt.getData((OpenMapTable.Row)row).setExportPath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getAnnotatedView()).toString());
                            PageTableKt.getData((OpenMapTable.Row)row).setTilePath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getTileView()).toString());
                            PageTableKt.getData((OpenMapTable.Row)row).setEntityPath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getEntityView()).toString());
                        }
                    });
                }
            }
        }
        if (!((Collection)failedPids).isEmpty()) {
            this.logger.warn("There {} nodes can not find owner document", (Object)failedPids.size());
        }
    }

    private final void fillRowCells(OpenMapTable table) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.cellType.ordinal()]) {
            case 2: {
                this.buildPlainTextRows(table);
                break;
            }
            case 1: {
                this.buildDatabaseRows(table);
                break;
            }
            case 3: {
                this.buildHtmlRows(table);
                break;
            }
            default: {
                this.buildNodeRows(table);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildNodeRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int j = n;
            boolean bl = false;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String annotatedLabel;
                String vi;
                String url;
                OpenMapTable.Row row;
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl2 = false;
                if (NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)point.getNode())) == null) continue;
                OpenMapTable.Row row2 = row = table.computeIfAbsent(url);
                boolean bl3 = false;
                Node node = point.getNode();
                OpenMapTable.Cell cell = new OpenMapTable.Cell(j, (Object)node);
                String string = "%s %s %s %s";
                Object[] objectArray = new Object[]{NodeExtKt.getX((Node)node), NodeExtKt.getY((Node)node), NodeExtKt.getWidth((Node)node), NodeExtKt.getHeight((Node)node)};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                cell.getAttributes().put("tv", vi);
                String clusterLabel = cluster2.getMlLabel();
                Intrinsics.checkNotNullExpressionValue((Object)node.attr("L"), (String)"attr(...)");
                if (!StringsKt.isBlank((CharSequence)annotatedLabel)) {
                    cell.getAttributes().put("L", annotatedLabel);
                } else if (!StringsKt.isBlank((CharSequence)clusterLabel)) {
                    cell.getAttributes().put("disabled", "disabled");
                }
                row2.set(j, cell);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPlainTextRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OpenMapTable.Row row;
                String url;
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl2 = false;
                if (NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)point.getNode())) == null) continue;
                if (table.get(url) == null) continue;
                OpenMapTable.Row it = row;
                boolean bl3 = false;
                it.set(j, new OpenMapTable.Cell(j, (Object)this.getText(it.get(j), point.getNode())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildDatabaseRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OpenMapTable.Row row;
                String url;
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl2 = false;
                if (NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)point.getNode())) == null) continue;
                if (table.get(url) == null) continue;
                OpenMapTable.Row it = row;
                boolean bl3 = false;
                it.set(j, new OpenMapTable.Cell(j, (Object)this.getText(it.get(j), point.getNode())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildHtmlRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OpenMapTable.Row row;
                String url;
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl2 = false;
                if (NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)point.getNode())) == null) continue;
                if (table.get(url) == null) continue;
                OpenMapTable.Row row2 = row;
                boolean bl3 = false;
                OpenMapTable.Cell cell = new OpenMapTable.Cell(j, (Object)this.getSlimHtml(row2.get(j), point.getNode()));
                if (this.getOptions().getShowTip()) {
                    String string = "%.3f";
                    Object[] objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)point.getNode())};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    PageTableKt.setTip((OpenMapTable.Cell)cell, (String)string2);
                }
                row2.set(j, cell);
            }
        }
    }

    private final String buildLinkCell(String location) {
        String url = location;
        Object link = url;
        if (((String)link).length() > 80) {
            String anchorText = StringUtils.abbreviateMiddle((String)link, (String)"..", (int)80);
            link = "<a href='" + url + "' target='_blank'>" + anchorText + "</a>";
        }
        return link;
    }

    private final String buildTitleCell(String location, String title, int displayLength, boolean textOnly) {
        String displayTitle;
        String string = displayTitle = StringUtils.abbreviate((String)title, (int)displayLength);
        Intrinsics.checkNotNull((Object)string);
        if (StringsKt.isBlank((CharSequence)string)) {
            displayTitle = "[Title]";
        }
        if (textOnly) {
            string = displayTitle;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        return "<a href='" + location + "' title='" + title + "' target='_blank'>" + displayTitle + "</a>";
    }

    static /* synthetic */ String buildTitleCell$default(PageCorpusTabulator pageCorpusTabulator, String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 150;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return pageCorpusTabulator.buildTitleCell(string, string2, n, bl);
    }

    private final String getText(Object lastValue, Node node) {
        String lastText = lastValue != null ? ((Object)StringsKt.trim((CharSequence)lastValue.toString())).toString() + "\t" : "";
        String string = NodeExtKt.isImage((Node)node) ? node.attr("abs:src") : (NodeExtKt.isAnchor((Node)node) ? node.attr("abs:href") : NodeExtKt.getCleanText((Node)node));
        Intrinsics.checkNotNull((Object)string);
        String text = string;
        return !StringsKt.isBlank((CharSequence)lastText) ? lastText + "\n" + text : text;
    }

    private final String getRichText(Object lastValue, Node node) {
        String lastText = lastValue != null ? ((Object)StringsKt.trim((CharSequence)lastValue.toString())).toString() + "\t" : "";
        String text = NodeExtKt.isImage((Node)node) ? NodeExtKt.getSlimHtml((Node)node) : (NodeExtKt.isAnchor((Node)node) ? NodeExtKt.getSlimHtml((Node)node) : (NodeExtKt.isNumeric((Node)node) ? "<em class='numeric'>" + NodeExtKt.getCleanText((Node)node) + "</em>" : (NodeExtKt.isMoneyLike((Node)node) ? "<em class='money'>" + NodeExtKt.getCleanText((Node)node) + "</em>" : NodeExtKt.getCleanText((Node)node))));
        return !StringsKt.isBlank((CharSequence)lastText) ? lastText + "\n" + text : text;
    }

    private final String getSlimHtml(Object lastValue, Node node) {
        String text = this.getText(lastValue, node);
        if (StringsKt.isBlank((CharSequence)text)) {
            return "";
        }
        Object object = lastValue;
        String lastStrValue = object != null ? ((Object)StringsKt.trim((CharSequence)object.toString())).toString() + "\n" : "";
        String value = NodeExtKt.getSlimHtml((Node)node);
        CharSequence charSequence = lastStrValue + value;
        Regex regex = new Regex("\n");
        int n = 0;
        List parts = regex.split(charSequence, n);
        String visibleParts2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)parts, (int)3), (CharSequence)"\n", null, null, (int)0, null, (Function1)getSlimHtml.visibleParts.1.INSTANCE, (int)30, null);
        Object hiddenParts2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)parts, (int)3), (CharSequence)"\n", null, null, (int)0, null, (Function1)getSlimHtml.hiddenParts.1.INSTANCE, (int)30, null);
        if (((CharSequence)hiddenParts2).length() > 0) {
            hiddenParts2 = "<div class='hidden'>" + (String)hiddenParts2 + "</div>";
        }
        return visibleParts2 + (String)hiddenParts2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TileCluster> computeQualifiedClusters() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.clusterGroup.getClusters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileCluster it = (TileCluster)element$iv$iv;
            boolean bl = false;
            if (!((double)it.getPoints().size() >= this.getQualifiedSize() && (this.getOptions().getShowImage() || !it.isImage()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TileCluster it = (TileCluster)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getOrder());
                it = (TileCluster)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getOrder()));
            }
        });
    }

    public static final /* synthetic */ List access$computeQualifiedClusters(PageCorpusTabulator $this) {
        return $this.computeQualifiedClusters();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CellType.values().length];
            try {
                nArray[CellType.DATABASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.PLAIN_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CellType.SLIM_HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

