/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.Measurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/analysis/diagnosis/Distortion;", "Lai/platon/scent/ml/unsupervised/Measurable;", "clusters", "", "Lai/platon/scent/ml/unsupervised/CentroidCluster;", "Lai/platon/scent/ml/NodePoint;", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "(Ljava/util/List;Lorg/apache/commons/math3/ml/distance/DistanceMeasure;)V", "getClusters", "()Ljava/util/List;", "distortions", "", "getDistortions", "()[D", "k", "", "getK", "()I", "meanDistortion", "", "getMeanDistortion", "()D", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "compute", "", "getDistortion", "cluster", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClusterTaskDiagnotor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/Distortion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,667:1\n1864#2,3:668\n1549#2:671\n1620#2,3:672\n2989#2,5:675\n*S KotlinDebug\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/Distortion\n*L\n604#1:668,3\n614#1:671\n614#1:672,3\n614#1:675,5\n*E\n"})
public final class Distortion
implements Measurable {
    @NotNull
    private final List<CentroidCluster<NodePoint>> clusters;
    @NotNull
    private final DistanceMeasure measure;
    private final int k;
    @NotNull
    private final double[] distortions;

    public Distortion(@NotNull List<? extends CentroidCluster<NodePoint>> clusters, @NotNull DistanceMeasure measure) {
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.clusters = clusters;
        this.measure = measure;
        this.k = this.clusters.size();
        this.distortions = new double[this.k];
    }

    public /* synthetic */ Distortion(List list, DistanceMeasure distanceMeasure, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        this(list, distanceMeasure);
    }

    @NotNull
    public final List<CentroidCluster<NodePoint>> getClusters() {
        return this.clusters;
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final double[] getDistortions() {
        return this.distortions;
    }

    public final double getMeanDistortion() {
        return ArraysKt.sum((double[])this.distortions) / (double)this.distortions.length;
    }

    /*
     * WARNING - void declaration
     */
    public final void compute() {
        Iterable $this$forEachIndexed$iv = this.clusters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CentroidCluster centroidCluster = (CentroidCluster)item$iv;
            int i = n;
            boolean bl = false;
            this.distortions[i] = this.getDistortion((CentroidCluster<NodePoint>)cluster2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final double getDistortion(CentroidCluster<NodePoint> cluster2) {
        void $this$mapTo$iv$iv;
        RealVector centroid2 = cluster2.getCentroid();
        Iterable $this$map$iv = cluster2.getPoints();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NodePoint nodePoint = (NodePoint)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.distance(centroid2, (RealVector)it));
        }
        Iterable $this$sumByDouble$iv = (List)destination$iv$iv;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            double item$iv$iv = ((Number)element$iv).doubleValue();
            double d = sum$iv;
            boolean bl = false;
            void var14_17 = it * it;
            sum$iv = d + var14_17;
        }
        return sum$iv;
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        return Measurable.DefaultImpls.findClosestCluster(this, i, point, clusters);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }
}

