/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.scent.analysis.diagnosis.ClusterDiagnosor;
import ai.platon.scent.analysis.diagnosis.ClusterTaskDiagnotor;
import ai.platon.scent.ml.HasDistance;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.Cluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0(2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001cH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006*"}, d2={"Lai/platon/scent/analysis/diagnosis/Silhouette;", "Lai/platon/scent/ml/HasDistance;", "clusterDiagnosor", "Lai/platon/scent/analysis/diagnosis/ClusterDiagnosor;", "clusterTaskDiagnotor", "Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "(Lai/platon/scent/analysis/diagnosis/ClusterDiagnosor;Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;)V", "cluster", "Lai/platon/scent/ml/unsupervised/Cluster;", "Lai/platon/scent/ml/NodePoint;", "clusters", "", "meanIntraDistances", "", "getMeanIntraDistances", "()[D", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "neighbouringClusters", "", "getNeighbouringClusters", "()[I", "points", "silhouettes", "getSilhouettes", "size", "", "smallestMeanInterDistances", "getSmallestMeanInterDistances", "compute", "", "getMeanInterDistance", "", "point", "Lorg/apache/commons/math3/linear/RealVector;", "c", "getMeanIntraDistance", "getNeighbouringCluster", "Lkotlin/collections/IndexedValue;", "getSilhouette", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClusterTaskDiagnotor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/Silhouette\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,667:1\n1549#2:668\n1620#2,3:669\n1559#2:672\n1590#2,4:673\n1549#2:677\n1620#2,3:678\n1559#2:681\n1590#2,4:682\n1549#2:686\n1620#2,3:687\n*S KotlinDebug\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/Silhouette\n*L\n523#1:668\n523#1:669,3\n525#1:672\n525#1:673,4\n531#1:677\n531#1:678,3\n550#1:681\n550#1:682,4\n568#1:686\n568#1:687,3\n*E\n"})
public final class Silhouette
implements HasDistance {
    @NotNull
    private final ClusterDiagnosor clusterDiagnosor;
    @NotNull
    private final ClusterTaskDiagnotor clusterTaskDiagnotor;
    @NotNull
    private final DistanceMeasure measure;
    @NotNull
    private final Cluster<NodePoint> cluster;
    @NotNull
    private final List<Cluster<NodePoint>> clusters;
    @NotNull
    private final List<NodePoint> points;
    private final int size;
    @NotNull
    private final double[] meanIntraDistances;
    @NotNull
    private final double[] smallestMeanInterDistances;
    @NotNull
    private final int[] neighbouringClusters;
    @NotNull
    private final double[] silhouettes;

    public Silhouette(@NotNull ClusterDiagnosor clusterDiagnosor, @NotNull ClusterTaskDiagnotor clusterTaskDiagnotor) {
        Intrinsics.checkNotNullParameter((Object)clusterDiagnosor, (String)"clusterDiagnosor");
        Intrinsics.checkNotNullParameter((Object)clusterTaskDiagnotor, (String)"clusterTaskDiagnotor");
        this.clusterDiagnosor = clusterDiagnosor;
        this.clusterTaskDiagnotor = clusterTaskDiagnotor;
        this.measure = this.clusterDiagnosor.getMeasure();
        this.cluster = this.clusterDiagnosor.getCluster();
        this.clusters = this.clusterTaskDiagnotor.getClusterGroup().getClusters();
        this.points = this.cluster.getPoints();
        this.size = this.cluster.getPoints().size();
        this.meanIntraDistances = new double[this.size];
        this.smallestMeanInterDistances = new double[this.size];
        this.neighbouringClusters = new int[this.size];
        this.silhouettes = new double[this.size];
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @NotNull
    public final double[] getMeanIntraDistances() {
        return this.meanIntraDistances;
    }

    @NotNull
    public final double[] getSmallestMeanInterDistances() {
        return this.smallestMeanInterDistances;
    }

    @NotNull
    public final int[] getNeighbouringClusters() {
        return this.neighbouringClusters;
    }

    @NotNull
    public final double[] getSilhouettes() {
        return this.silhouettes;
    }

    /*
     * WARNING - void declaration
     */
    public final void compute() {
        Iterable $this$mapIndexedTo$iv$iv;
        int n;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(0, this.size);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            n = 0;
            this.meanIntraDistances[i] = this.getMeanIntraDistance((int)i);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = this.points;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            double smallestMeanDistance;
            void point;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv$iv2);
            int n3 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            IndexedValue<Double> indexedValue = this.getNeighbouringCluster((RealVector)point);
            int neighbouringCluster = indexedValue.component1();
            this.smallestMeanInterDistances[i] = smallestMeanDistance = ((Number)indexedValue.component2()).doubleValue();
            this.neighbouringClusters[i] = neighbouringCluster;
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_1 = (List)destination$iv$iv;
        $this$map$iv = (Iterable)new IntRange(0, this.size);
        $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int item$iv$iv2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            this.silhouettes[i] = this.getSilhouette((int)i);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_2 = (List)destination$iv$iv;
    }

    private final double getMeanIntraDistance(int point) {
        double[] dArray = this.clusterDiagnosor.getPairwiseIntraPointsDistances().getRow(point);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getRow(...)");
        return ArraysKt.sum((double[])dArray) / (double)this.size / (double)2;
    }

    private final double getSilhouette(int point) {
        double a = this.meanIntraDistances[point];
        double b = this.smallestMeanInterDistances[point];
        return a == b ? 0.0 : (b - a) / Math.max(a, b);
    }

    /*
     * WARNING - void declaration
     */
    private final IndexedValue<Double> getNeighbouringCluster(RealVector point) {
        void $this$mapIndexedTo$iv$iv;
        IndexedValue indexedValue = new IndexedValue(-1, (Object)Double.MAX_VALUE);
        int neighbouringCluster = 0;
        neighbouringCluster = indexedValue.component1();
        double smallestMeanDistance = 0.0;
        smallestMeanDistance = ((Number)indexedValue.component2()).doubleValue();
        Iterable $this$mapIndexed$iv = this.clusters;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            double distance;
            void c;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Cluster cluster2 = (Cluster)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)c, this.cluster) && (distance = this.getMeanInterDistance(point, (Cluster<NodePoint>)c)) < smallestMeanDistance) {
                void index;
                smallestMeanDistance = distance;
                neighbouringCluster = index;
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return new IndexedValue(neighbouringCluster, (Object)smallestMeanDistance);
    }

    /*
     * WARNING - void declaration
     */
    private final double getMeanInterDistance(RealVector point, Cluster<NodePoint> c) {
        void $this$mapTo$iv$iv;
        if (!(!Intrinsics.areEqual(c, this.cluster))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = c.getPoints();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NodePoint nodePoint = (NodePoint)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.distance(point, (RealVector)it));
        }
        return CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv)) / (double)c.getPoints().size();
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return HasDistance.DefaultImpls.distance((HasDistance)this, p1, p2);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return HasDistance.DefaultImpls.distance((HasDistance)this, p1, p2);
    }
}

