/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.diagnosis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0006H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014\"\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0004J!\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0014\"\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0004J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0006H\u0004R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\fj\b\u0012\u0004\u0012\u00020\u0006`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/platon/scent/diagnosis/DiagnosisFormatter;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "caption", "", "kotlin.jvm.PlatformType", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "description", "headers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "rows", "", "asTable", "buildHeader", "", "columnValues", "", "([Ljava/lang/String;)V", "columnNames", "", "buildRow", "getTableSafeHtml", "html", "length", "", "process", "setCaption", "setDescription", "Companion", "scent-auto-mining"})
public class DiagnosisFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final ArrayList<String> headers;
    @NotNull
    private final ArrayList<List<String>> rows;
    private String caption;
    @NotNull
    private String description;
    private static final Logger log = LoggerFactory.getLogger(DiagnosisFormatter.class);
    @NotNull
    private static final DecimalFormat decimalFormatter = new DecimalFormat("#.#");
    @NotNull
    private static final String columnSeparator = "^^";

    public DiagnosisFormatter(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.headers = new ArrayList();
        this.rows = new ArrayList();
        this.caption = this.getClass().getName();
        this.description = "";
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public void process() {
    }

    @NotNull
    public String asTable() {
        Object object;
        Object object2;
        Document document = Document.createShell((String)"http://internal.pulsar.platon.ai/empty");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createShell(...)");
        Document doc = document;
        Element element = doc.body().appendElement("table").attr("class", "table tablesorter");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attr(...)");
        Element table = element;
        table.appendElement("caption").text(this.caption);
        if (!this.headers.isEmpty()) {
            Element element2 = table.appendElement("tr");
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
            Element tr = element2;
            for (String header2 : this.headers) {
                tr.appendElement("th").text(header2);
            }
        }
        for (List<String> row : this.rows) {
            Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
            int n = row.size();
            for (int i = 0; i < n; ++i) {
                Element tr;
                if (i == 0) {
                    tr.appendElement("th").attr("title", row.get(i)).text(this.getTableSafeHtml(row.get(i), 20));
                    continue;
                }
                if (i < row.size() - 1) {
                    tr.appendElement("td").attr("title", row.get(i)).html(this.getTableSafeHtml(row.get(i), 1500));
                    continue;
                }
                tr.appendElement("td").attr("title", row.get(i)).text(this.getTableSafeHtml(row.get(i), 20));
            }
        }
        if (((CharSequence)this.description).length() == 0) {
            object2 = "total %s columns, %s rows";
            object = new Object[]{this.headers.size(), this.rows.size()};
            String string = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            this.description = string;
        }
        CharSequence charSequence = this.description;
        object2 = new Regex("\n");
        object = "<br />";
        table.append("<p>" + object2.replace(charSequence, (String)object) + "</p>");
        String string = table.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String caption() {
        String string = this.caption;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"caption");
        return string;
    }

    protected final void setCaption(@NotNull String caption) {
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        this.caption = caption;
    }

    protected final void setDescription(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.description = description;
    }

    protected final void buildHeader(String ... columnValues) {
        Intrinsics.checkNotNullParameter((Object)columnValues, (String)"columnValues");
        this.headers.addAll(ArraysKt.toList((Object[])columnValues));
    }

    protected final void buildHeader(@NotNull Iterable<String> columnNames) {
        Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
        CollectionsKt.addAll((Collection)this.headers, columnNames);
    }

    protected final void buildRow(String ... columnValues) {
        Intrinsics.checkNotNullParameter((Object)columnValues, (String)"columnValues");
        this.rows.add(ArraysKt.toList((Object[])columnValues));
    }

    protected final void buildRow(@NotNull Iterable<String> columnValues) {
        Intrinsics.checkNotNullParameter(columnValues, (String)"columnValues");
        this.rows.add(CollectionsKt.toList(columnValues));
    }

    @NotNull
    protected final String getTableSafeHtml(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        return DiagnosisFormatter.Companion.tableTagsToDiv(html);
    }

    @NotNull
    protected final String getTableSafeHtml(@NotNull String html, int length) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Document document = Document.createShell((String)"http://www.qiwur.com/scent/diagnosis");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createShell(...)");
        Document doc = document;
        Element element = doc.createElement("div").html(html);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"html(...)");
        Element div = element;
        NodeTraversor.traverse((NodeVisitor)new NodeVisitor(length){
            private int count;
            final /* synthetic */ int $length;
            {
                this.$length = $length;
            }

            public void head(@NotNull Node node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof TextNode) {
                    if (this.count > this.$length) {
                        ((TextNode)node).text("");
                    } else {
                        this.count += ((TextNode)node).text().length();
                    }
                }
            }
        }, (Node)((Node)div));
        String string = div.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html(...)");
        return this.getTableSafeHtml(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/diagnosis/DiagnosisFormatter$Companion;", "", "()V", "columnSeparator", "", "getColumnSeparator", "()Ljava/lang/String;", "decimalFormatter", "Ljava/text/DecimalFormat;", "getDecimalFormatter", "()Ljava/text/DecimalFormat;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "tableTagsToDiv", "text", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final DecimalFormat getDecimalFormatter() {
            return decimalFormatter;
        }

        @NotNull
        public final String getColumnSeparator() {
            return columnSeparator;
        }

        private final String tableTagsToDiv(String text) {
            String text2 = text;
            String regex = "table|tbody|tr|th|td";
            CharSequence charSequence = text2;
            Regex regex2 = new Regex(regex);
            String string = "div";
            text2 = regex2.replace(charSequence, string);
            return text2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

