/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.statistics;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.dom.nodes.DocumentFragment;
import ai.platon.scent.dom.nodes.data.BlockPattern;
import ai.platon.scent.feature.BlockFeature;
import ai.platon.scent.feature.ScentRule;
import ai.platon.scent.feature.statistics.BlockStatRule;
import ai.platon.scent.feature.statistics.StatFeature;
import ai.platon.scent.feature.statistics.StatRule;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Deprecated(message="Use ML and X-SQL system instead")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001cH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020$0,2\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0006\u0010.\u001a\u00020\u0006J\u0006\u0010/\u001a\u00020&J\b\u00100\u001a\u00020\u0006H\u0016RQ\u0010\b\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lai/platon/scent/feature/statistics/BlockStatFeature;", "Lai/platon/scent/feature/BlockFeature;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "resources", "", "", "(Lai/platon/pulsar/common/config/ImmutableConfig;[Ljava/lang/String;)V", "blockRules", "Lcom/google/common/collect/LinkedListMultimap;", "kotlin.jvm.PlatformType", "Lai/platon/scent/feature/statistics/BlockStatRule;", "getBlockRules", "()Lcom/google/common/collect/LinkedListMultimap;", "features", "Ljava/util/HashMap;", "Lai/platon/scent/feature/statistics/StatFeature;", "Lkotlin/collections/HashMap;", "getFeatures", "()Ljava/util/HashMap;", "globalVars", "getGlobalVars", "labels", "", "getLabels", "()Ljava/util/Set;", "getBlockRuleId", "eleBlock", "Lorg/jsoup/nodes/Element;", "getScore10", "", "fragment", "Lai/platon/scent/dom/nodes/DocumentFragment;", "label", "patterns", "", "Lai/platon/scent/dom/nodes/data/BlockPattern;", "parse", "", "doc", "Lorg/jsoup/nodes/Document;", "parseBlockRule", "block", "parsePatterns", "", "text", "report", "reset", "toString", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nBlockStatFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStatFeature.kt\nai/platon/scent/feature/statistics/BlockStatFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,145:1\n1855#2,2:146\n766#2:148\n857#2,2:149\n1549#2:151\n1620#2,3:152\n1855#2,2:155\n731#2,9:159\n37#3,2:157\n37#3,2:168\n*S KotlinDebug\n*F\n+ 1 BlockStatFeature.kt\nai/platon/scent/feature/statistics/BlockStatFeature\n*L\n59#1:146,2\n65#1:148\n65#1:149,2\n66#1:151\n66#1:152,3\n67#1:155,2\n131#1:159,9\n97#1:157,2\n131#1:168,2\n*E\n"})
public final class BlockStatFeature
extends BlockFeature {
    @NotNull
    private final HashMap<String, String> globalVars;
    @NotNull
    private final HashMap<String, StatFeature> features;
    private final LinkedListMultimap<String, BlockStatRule> blockRules;

    public BlockStatFeature(@NotNull ImmutableConfig conf, @NotNull String[] resources) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        super(conf, resources);
        this.globalVars = new HashMap();
        this.features = new HashMap();
        this.blockRules = LinkedListMultimap.create();
    }

    @NotNull
    public final HashMap<String, String> getGlobalVars() {
        return this.globalVars;
    }

    @NotNull
    public final HashMap<String, StatFeature> getFeatures() {
        return this.features;
    }

    public final LinkedListMultimap<String, BlockStatRule> getBlockRules() {
        return this.blockRules;
    }

    @Override
    @NotNull
    public Set<String> getLabels() {
        Set set = this.blockRules.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        return set;
    }

    @Override
    public double getScore10(@NotNull DocumentFragment fragment, @NotNull String label, @NotNull Collection<BlockPattern> patterns) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String report() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String name : this.blockRules.keySet()) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(": ");
            sb.append(((BlockStatRule)this.blockRules.get((Object)name).iterator().next()).getRules().size());
        }
        return this.getClass().getSimpleName() + " - " + sb;
    }

    public final void reset() {
        this.globalVars.clear();
        this.features.clear();
        this.blockRules.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parse(@NotNull Document doc) {
        void $this$mapTo$iv$iv;
        Element it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Iterable $this$forEach$iv = (Iterable)QueriesKt.select2$default((Node)((Node)doc), (String)"blocks > features > feature", (int)0, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            Element it2 = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.attr("name"), (String)"attr(...)");
            Map map = this.features;
            String string = it2.text();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
            StatFeature statFeature = new StatFeature(name, string);
            map.put(name, statFeature);
        }
        Iterable $this$filter$iv = (Iterable)QueriesKt.select2$default((Node)((Node)doc), (String)"blocks > block", (int)0, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Element)element$iv$iv;
            boolean bl = false;
            String string = it.attr("label");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
            boolean bl2 = ((CharSequence)string).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.parseBlockRule(it));
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockStatRule it3 = (BlockStatRule)element$iv;
            boolean bl = false;
            this.blockRules.put((Object)it3.getLabel(), (Object)it3);
        }
    }

    private final String getBlockRuleId(Element eleBlock) {
        String string = eleBlock.attr("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String label = string;
        return NodeExtKt.getLocation((Node)((Node)eleBlock)) + "/" + label + "#" + eleBlock.attr("id");
    }

    /*
     * WARNING - void declaration
     */
    private final BlockStatRule parseBlockRule(Element block) {
        String string = block.attr("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
        String label = string;
        String id = this.getBlockRuleId(block);
        String string2 = block.attr("leaf-only");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attr(...)");
        String leafOnly = string2;
        String string3 = block.attr("domain");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"attr(...)");
        String domain = string3;
        String string4 = block.attr("patterns");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attr(...)");
        String allowedPatterns = string4;
        String string5 = block.attr("negative-patterns");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"attr(...)");
        String disallowedPatterns = string5;
        BlockStatRule blockStatRule = new BlockStatRule(id, label, Intrinsics.areEqual((Object)leafOnly, (Object)"true"), domain, this.parsePatterns(allowedPatterns), this.parsePatterns(disallowedPatterns));
        for (Element eleRule : block.getElementsByTag("rule")) {
            int n;
            int i;
            void $this$toTypedArray$iv;
            StatFeature feature = this.features.get(eleRule.attr("feature"));
            if (feature == null) {
                this.getLog().error("invalid rule, miss feature {}", (Object)eleRule.attr("feature"));
                continue;
            }
            String string6 = eleRule.attr("range");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"attr(...)");
            Object object = string6;
            Regex regex = new Regex(",");
            int n2 = 2;
            object = regex.split((CharSequence)object, n2);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] range = thisCollection$iv.toArray(new String[0]);
            if (range.length != 2) {
                this.getLog().error("invalid rule range {}", (Object)eleRule.attr("range"));
                continue;
            }
            double min = NumberUtils.toDouble((String)range[0], (double)ScentRule.Companion.getMIN_SCORE());
            double max = NumberUtils.toDouble((String)range[1], (double)ScentRule.Companion.getMAX_SCORE());
            double score2 = NumberUtils.toDouble((String)eleRule.attr("score"));
            double negativeScore = NumberUtils.toDouble((String)eleRule.attr("negative-score"));
            StatRule rule = new StatRule(feature, min, max, score2, negativeScore);
            if (!feature.isSimple() && (i = 1) <= (n = ScentRule.Companion.getMAX_PLACE_HOLDERS())) {
                while (true) {
                    String v;
                    String ref = "_" + i;
                    Intrinsics.checkNotNullExpressionValue((Object)eleRule.attr(ref), (String)"attr(...)");
                    if (!(((CharSequence)v).length() == 0)) {
                        rule.ref("$" + ref, v);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            blockStatRule.getRules().add(rule);
        }
        return blockStatRule;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BlockPattern> parsePatterns(String text) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        ArrayList patterns = Lists.newArrayList();
        Object object = text;
        Regex regex = new Regex(",");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String pattern2 : thisCollection$iv.toArray(new String[0])) {
            BlockPattern p = new BlockPattern(pattern2);
            if (!BlockPattern.Companion.getPatterns().contains(p)) continue;
            patterns.add(p);
        }
        Intrinsics.checkNotNull((Object)patterns);
        return patterns;
    }

    @NotNull
    public String toString() {
        String string = this.blockRules.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

