/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.words.weighted;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.scent.dom.nodes.DocumentFragment;
import ai.platon.scent.dom.nodes.data.BlockPattern;
import ai.platon.scent.feature.BlockFeature;
import ai.platon.scent.feature.ScentRule;
import ai.platon.scent.feature.statistics.BlockStatRule;
import ai.platon.scent.feature.words.weighted.WeightedPhraseFeatureParser;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\u0006J&\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0006\u0010#\u001a\u00020\u0006J\b\u0010$\u001a\u00020\u0006H\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eRN\u0010\u000f\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lai/platon/scent/feature/words/weighted/WeightedPhraseFeature;", "Lai/platon/scent/feature/BlockFeature;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "resources_", "", "", "(Lai/platon/pulsar/common/config/ImmutableConfig;[Ljava/lang/String;)V", "blockRules", "Lcom/google/common/collect/Multimap;", "Lai/platon/scent/feature/statistics/BlockStatRule;", "labels", "", "getLabels", "()Ljava/util/Set;", "phraseRules", "Ljava/util/HashMap;", "kotlin.jvm.PlatformType", "", "phrases", "Ljava/util/SortedSet;", "getPhrases", "()Ljava/util/SortedSet;", "getRules", "", "label", "getScore10", "fragment", "Lai/platon/scent/dom/nodes/DocumentFragment;", "patterns", "Lai/platon/scent/dom/nodes/data/BlockPattern;", "parse", "", "doc", "Lorg/jsoup/nodes/Document;", "report", "toString", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nWeightedPhraseFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedPhraseFeature.kt\nai/platon/scent/feature/words/weighted/WeightedPhraseFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 WeightedPhraseFeature.kt\nai/platon/scent/feature/words/weighted/WeightedPhraseFeature\n*L\n53#1:114,2\n*E\n"})
public abstract class WeightedPhraseFeature
extends BlockFeature {
    @NotNull
    private Multimap<String, BlockStatRule> blockRules;
    private final HashMap<String, Double> phraseRules;

    public WeightedPhraseFeature(@NotNull ImmutableConfig conf, @NotNull String[] resources_) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)resources_, (String)"resources_");
        super(conf, resources_);
        TreeMultimap treeMultimap = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        this.blockRules = (Multimap)treeMultimap;
        this.phraseRules = Maps.newHashMap();
        Iterable $this$forEach$iv = this.getResources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.loadIgnoreMissing(it);
        }
    }

    @Override
    @NotNull
    public Set<String> getLabels() {
        Set set = this.blockRules.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        return set;
    }

    @NotNull
    public final SortedSet<String> getPhrases() {
        TreeSet phrases = Sets.newTreeSet();
        for (BlockStatRule blockStatRule : this.blockRules.values()) {
            for (ScentRule scentRule : blockStatRule.getRules()) {
                phrases.add(scentRule.name());
            }
        }
        Intrinsics.checkNotNull((Object)phrases);
        return phrases;
    }

    @NotNull
    public final Collection<BlockStatRule> getRules(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Collection collection = this.blockRules.get((Object)label);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    @Override
    public double getScore10(@NotNull DocumentFragment fragment, @NotNull String label, @NotNull Collection<BlockPattern> patterns) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Collection<BlockStatRule> rules = this.getRules(label);
        if (rules.isEmpty()) {
            return 0.0;
        }
        double maxScore = ScentRule.Companion.getMIN_SCORE();
        for (BlockStatRule rule : rules) {
            double score2 = rule.getScore(fragment, patterns);
            if (!(score2 > maxScore)) continue;
            maxScore = score2;
        }
        return maxScore;
    }

    @NotNull
    public final String report() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.blockRules.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String name = (String)iterator.next();
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(name);
            sb.append(" : ");
            sb.append(((BlockStatRule)this.blockRules.get((Object)name).iterator().next()).getRules().size());
        }
        return this.getClass().getSimpleName() + " - " + sb;
    }

    @NotNull
    public String toString() {
        return this.blockRules.toString();
    }

    @Override
    protected void parse(@NotNull Document doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        WeightedPhraseFeatureParser parser = new WeightedPhraseFeatureParser(this.getConf(), this.getResources());
        this.blockRules = parser.parse();
    }
}

