/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0004J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/ml/FLD;", "", "x", "", "", "y", "", "L", "", "tol", "", "([[D[IID)V", "k", "mean", "mu", "Lsmile/math/matrix/DenseMatrix;", "p", "projection", "getProjection", "()Lsmile/math/matrix/DenseMatrix;", "smean", "smu", "[[D", "predict", "project", "([[D)[[D", "scent-auto-mining"})
public final class FLD {
    private int L;
    private double tol;
    private final int p;
    private final int k;
    @NotNull
    private final double[] mean;
    @NotNull
    private final DenseMatrix mu;
    @NotNull
    private final DenseMatrix projection;
    @NotNull
    private final double[] smean;
    @NotNull
    private final double[][] smu;

    public FLD(@NotNull double[][] x, @NotNull int[] y, int L, double tol) {
        int n;
        int n2;
        int l;
        int l2;
        int j;
        int j2;
        int n3;
        int c;
        int i;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.L = L;
        this.tol = tol;
        if (((Object[])x).length != y.length) {
            String string = "The sizes of X and Y don't match: %d != %d";
            Object[] objectArray = new Object[]{((Object[])x).length, y.length};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        int[] labels = Math.unique((int[])y);
        Arrays.sort(labels);
        int n4 = labels.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (labels[i2] < 0) {
                throw new IllegalArgumentException("Negative class label: " + labels[i2]);
            }
            if (i2 <= 0 || labels[i2] - labels[i2 - 1] <= 1) continue;
            throw new IllegalArgumentException("Missing class: " + (labels[i2 - 1] + 1));
        }
        this.k = labels.length;
        if (this.k < 2) {
            throw new IllegalArgumentException("Only one class.");
        }
        if (this.tol < 0.0) {
            throw new IllegalArgumentException("Invalid tol: " + this.tol);
        }
        if (((Object[])x).length <= this.k) {
            String string = "Sample size is too small: %d <= %d";
            Object[] objectArray = new Object[]{((Object[])x).length, this.k};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new IllegalArgumentException(string3);
        }
        if (this.L >= this.k) {
            String string = "The dimensionality of mapped space is too high: %d >= %d";
            Object[] objectArray = new Object[]{this.L, this.k};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            throw new IllegalArgumentException(string4);
        }
        if (this.L <= 0) {
            this.L = this.k - 1;
        }
        int n5 = ((Object[])x).length;
        this.p = x[0].length;
        int[] ni = new int[this.k];
        double[] dArray = Math.colMeans((double[][])x);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"colMeans(...)");
        this.mean = dArray;
        DenseMatrix T = Matrix.zeros((int)this.p, (int)this.p);
        DenseMatrix denseMatrix = Matrix.zeros((int)this.k, (int)this.p);
        Intrinsics.checkNotNullExpressionValue((Object)denseMatrix, (String)"zeros(...)");
        this.mu = denseMatrix;
        for (i = 0; i < n5; ++i) {
            c = y[i];
            int n6 = ni[c];
            ni[c] = n6 + 1;
            n3 = this.p;
            for (j2 = 0; j2 < n3; ++j2) {
                this.mu.add(c, j2, x[i][j2]);
            }
        }
        c = this.k;
        for (i = 0; i < c; ++i) {
            n3 = this.p;
            for (j2 = 0; j2 < n3; ++j2) {
                this.mu.div(i, j2, (double)ni[i]);
                this.mu.sub(i, j2, this.mean[j2]);
            }
        }
        for (i = 0; i < n5; ++i) {
            j2 = this.p;
            block6: for (j = 0; j < j2; ++j) {
                l2 = 0;
                if (l2 > j) continue;
                while (true) {
                    T.add(j, l2, (x[i][j] - this.mean[j]) * (x[i][l2] - this.mean[l2]));
                    if (l2 == j) continue block6;
                    ++l2;
                }
            }
        }
        j = this.p;
        block8: for (int j3 = 0; j3 < j; ++j3) {
            l = 0;
            if (l > j3) continue;
            while (true) {
                T.div(j3, l, (double)n5);
                T.set(l, j3, T.get(j3, l));
                if (l == j3) continue block8;
                ++l;
            }
        }
        DenseMatrix B = Matrix.zeros((int)this.p, (int)this.p);
        l = this.k;
        for (int i3 = 0; i3 < l; ++i3) {
            n2 = this.p;
            block11: for (int j4 = 0; j4 < n2; ++j4) {
                int l3 = 0;
                if (l3 > j4) continue;
                while (true) {
                    B.add(j4, l3, this.mu.get(i3, j4) * this.mu.get(i3, l3));
                    if (l3 == j4) continue block11;
                    ++l3;
                }
            }
        }
        l = this.p;
        block13: for (j = 0; j < l; ++j) {
            l2 = 0;
            if (l2 > j) continue;
            while (true) {
                B.div(j, l2, (double)this.k);
                B.set(l2, j, B.get(j, l2));
                if (l2 == j) continue block13;
                ++l2;
            }
        }
        T.setSymmetric(true);
        EVD eigen = T.eigen();
        this.tol *= this.tol;
        double[] s2 = eigen.getEigenValues();
        n2 = s2.length;
        for (int i4 = 0; i4 < n2; ++i4) {
            if (s2[i4] < this.tol) {
                throw new IllegalArgumentException("The covariance matrix is close to singular.");
            }
            s2[i4] = 1.0 / s2[i4];
        }
        DenseMatrix U = eigen.getEigenVectors();
        DenseMatrix UB = (DenseMatrix)U.atbmm((Object)B);
        int n7 = this.k;
        for (int i5 = 0; i5 < n7; ++i5) {
            n = this.p;
            for (int j5 = 0; j5 < n; ++j5) {
                UB.mul(i5, j5, s2[j5]);
            }
        }
        B = (DenseMatrix)U.abmm((Object)UB);
        B.setSymmetric(true);
        eigen = B.eigen();
        U = eigen.getEigenVectors();
        DenseMatrix denseMatrix2 = Matrix.zeros((int)this.p, (int)this.L);
        Intrinsics.checkNotNullExpressionValue((Object)denseMatrix2, (String)"zeros(...)");
        this.projection = denseMatrix2;
        n7 = this.L;
        for (int j6 = 0; j6 < n7; ++j6) {
            n = this.p;
            for (int i6 = 0; i6 < n; ++i6) {
                this.projection.set(i6, j6, U.get(i6, j6));
            }
        }
        this.smean = new double[this.L];
        this.projection.atx(this.mean, this.smean);
        double[][] dArray2 = ((DenseMatrix)this.mu.abmm((Object)this.projection)).array();
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"array(...)");
        this.smu = dArray2;
    }

    public /* synthetic */ FLD(double[][] dArray, int[] nArray, int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            d = 1.0E-4;
        }
        this(dArray, nArray, n, d);
    }

    @NotNull
    public final DenseMatrix getProjection() {
        return this.projection;
    }

    public final int predict(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.p) {
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        double[] wx = this.project(x);
        int y = 0;
        double nearest = Double.POSITIVE_INFINITY;
        int n = this.k;
        for (int i = 0; i < n; ++i) {
            double d = Math.distance((double[])wx, (double[])this.smu[i]);
            if (!(d < nearest)) continue;
            nearest = d;
            y = i;
        }
        return y;
    }

    @NotNull
    public final double[] project(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.p) {
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        double[] y = new double[this.projection.ncols()];
        this.projection.atx(x, y);
        Math.minus((double[])y, (double[])this.smean);
        return y;
    }

    @NotNull
    public final double[][] project(@NotNull double[][] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        int n = 0;
        int n2 = ((Object[])x).length;
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.projection.ncols()];
        }
        double[][] y = dArrayArray;
        n2 = ((Object[])x).length;
        for (int i = 0; i < n2; ++i) {
            if (x[i].length != this.p) {
                String string = "Invalid input vector size: %d, expected: %d";
                Object[] objectArray = new Object[]{x[i].length, this.p};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new IllegalArgumentException(string2);
            }
            this.projection.atx(x[i], y[i]);
            Math.minus((double[])y[i], (double[])this.smean);
        }
        return y;
    }
}

