/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\"\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020%R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lai/platon/scent/ml/LDA;", "", "x", "", "", "y", "", "tol", "", "priori", "([[D[ID[D)V", "C", "Lsmile/math/matrix/DenseMatrix;", "ct", "evd", "Lsmile/math/matrix/EVD;", "k", "", "mean", "mu", "[[D", "p", "getPriori", "()[D", "setPriori", "([D)V", "getTol", "()D", "setTol", "(D)V", "getX", "()[[D", "getY", "()[I", "predict", "posterior", "rd", "", "scent-auto-mining"})
public final class LDA {
    @NotNull
    private final double[][] x;
    @NotNull
    private final int[] y;
    private double tol;
    @NotNull
    private double[] priori;
    private final int p;
    private final int k;
    @NotNull
    private final double[] ct;
    @NotNull
    private final double[][] mu;
    @NotNull
    private final double[] mean;
    @NotNull
    private final DenseMatrix C;
    @NotNull
    private final EVD evd;

    public LDA(@NotNull double[][] x, @NotNull int[] y, double tol, @NotNull double[] priori) {
        int n;
        double[] dArray;
        int c;
        int i;
        int n2;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)priori, (String)"priori");
        this.x = x;
        this.y = y;
        this.tol = tol;
        this.priori = priori;
        if (((Object[])this.x).length != this.y.length) {
            String string = "The sizes of X and Y don't match: %d != %d";
            Object[] objectArray = new Object[]{((Object[])this.x).length, this.y.length};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        if (!(this.priori.length == 0)) {
            if (this.priori.length < 2) {
                throw new IllegalArgumentException("Invalid number of priori probabilities: " + this.priori.length);
            }
            double sum = 0.0;
            for (double pr2 : this.priori) {
                if (pr2 <= 0.0 || pr2 >= 1.0) {
                    throw new IllegalArgumentException("Invalid priori probability: " + pr2);
                }
                sum += pr2;
            }
            if (java.lang.Math.abs(sum - 1.0) > 1.0E-10) {
                throw new IllegalArgumentException("The sum of priori probabilities is not one: " + sum);
            }
        }
        int[] labels = Math.unique((int[])this.y);
        Arrays.sort(labels);
        int n3 = labels.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (labels[i2] < 0) {
                throw new IllegalArgumentException("Negative class label: " + labels[i2]);
            }
            if (i2 <= 0 || labels[i2] - labels[i2 - 1] <= 1) continue;
            throw new IllegalArgumentException("Missing class: " + (labels[i2 - 1] + 1));
        }
        this.k = labels.length;
        if (this.k < 2) {
            throw new IllegalArgumentException("Only one class.");
        }
        if (!(this.priori.length == 0) && this.k != this.priori.length) {
            throw new IllegalArgumentException("The number of classes and the number of priori probabilities don't match.");
        }
        if (this.tol < 0.0) {
            throw new IllegalArgumentException("Invalid tol: " + this.tol);
        }
        int n4 = ((Object[])this.x).length;
        if (n4 <= this.k) {
            String string = "Sample size is too small: %d <= %d";
            Object[] objectArray = new Object[]{n4, this.k};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new IllegalArgumentException(string3);
        }
        this.p = this.x[0].length;
        int[] ni = new int[this.k];
        double[] dArray2 = Math.colMeans((double[][])this.x);
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"colMeans(...)");
        this.mean = dArray2;
        DenseMatrix denseMatrix = Matrix.zeros((int)this.p, (int)this.p);
        Intrinsics.checkNotNullExpressionValue((Object)denseMatrix, (String)"zeros(...)");
        this.C = denseMatrix;
        int n5 = 0;
        int n6 = this.k;
        double[][] pr2 = new double[n6][];
        LDA lDA = this;
        while (n5 < n6) {
            n2 = n5++;
            pr2[n2] = new double[this.p];
        }
        lDA.mu = pr2;
        for (i = 0; i < n4; ++i) {
            c = this.y[i];
            int pr2 = ni[c];
            ni[c] = pr2 + 1;
            n2 = this.p;
            for (int j = 0; j < n2; ++j) {
                dArray = this.mu[c];
                n = j;
                dArray[n] = dArray[n] + this.x[i][j];
            }
        }
        c = this.k;
        for (i = 0; i < c; ++i) {
            int j = 0;
            n2 = this.p;
            while (j < n2) {
                dArray = this.mu[i];
                n = j++;
                dArray[n] = dArray[n] / (double)ni[i];
            }
        }
        if (this.priori.length == 0) {
            this.priori = new double[this.k];
            c = this.k;
            for (i = 0; i < c; ++i) {
                this.priori[i] = (double)ni[i] / (double)n4;
            }
        }
        this.ct = new double[this.k];
        c = this.k;
        for (i = 0; i < c; ++i) {
            this.ct[i] = java.lang.Math.log(this.priori[i]);
        }
        for (i = 0; i < n4; ++i) {
            int j = this.p;
            for (c = 0; c < j; ++c) {
                int n7 = this.p;
                for (int r = c; r < n7; ++r) {
                    this.C.add(c, r, (this.x[i][c] - this.mean[c]) * (this.x[i][r] - this.mean[r]));
                }
            }
        }
        this.tol *= this.tol;
        double sd = n4 - this.k;
        n2 = this.p;
        for (int c2 = 0; c2 < n2; ++c2) {
            n = this.p;
            for (int r = c2; r < n; ++r) {
                this.C.div(c2, r, sd);
                this.C.set(r, c2, this.C.get(c2, r));
            }
            if (!(this.C.get(c2, c2) < this.tol)) continue;
            String string = "Covariance matrix (variable %d) is close to singular.";
            Object[] objectArray = new Object[]{c2};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            throw new IllegalArgumentException(string4);
        }
        this.C.setSymmetric(true);
        EVD eVD = this.C.eigen();
        Intrinsics.checkNotNullExpressionValue((Object)eVD, (String)"eigen(...)");
        this.evd = eVD;
    }

    public /* synthetic */ LDA(double[][] dArray, int[] nArray, double d, double[] dArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 1.0E-4;
        }
        if ((n & 8) != 0) {
            dArray2 = new double[]{};
        }
        this(dArray, nArray, d, dArray2);
    }

    @NotNull
    public final double[][] getX() {
        return this.x;
    }

    @NotNull
    public final int[] getY() {
        return this.y;
    }

    public final double getTol() {
        return this.tol;
    }

    public final void setTol(double d) {
        this.tol = d;
    }

    @NotNull
    public final double[] getPriori() {
        return this.priori;
    }

    public final void setPriori(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.priori = dArray;
    }

    public final void rd() {
        int n = ((Object[])this.x).length;
        DenseMatrix Sw = Matrix.zeros((int)this.p, (int)this.p);
        DenseMatrix Sb = Matrix.zeros((int)this.p, (int)this.p);
        double[] m = Math.rowMeans((double[][])this.x);
        for (int i = 0; i < n; ++i) {
            int n2 = this.p;
            for (int j = 0; j < n2; ++j) {
                Sb.set(i, j, (this.mu[i][j] - m[i]) * (this.mu[i][j] - m[i]));
            }
        }
        DenseMatrix D = Matrix.zeros((int)this.p, (int)this.p);
        this.C.mul(Sb, D);
        EVD evd = D.eigen();
        double[] dArray = evd.getEigenValues();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getEigenValues(...)");
        for (double s2 : dArray) {
            if (!(s2 < this.tol)) continue;
            throw new IllegalArgumentException("The covariance matrix is close to singular.");
        }
        double[] eigen = evd.getEigenValues();
        DenseMatrix W = evd.getEigenVectors();
    }

    public final int predict(@NotNull double[] x, @NotNull double[] posterior) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)posterior, (String)"posterior");
        double[] dArray = this.evd.getEigenValues();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getEigenValues(...)");
        for (double s2 : dArray) {
            if (!(s2 < this.tol)) continue;
            throw new IllegalArgumentException("The covariance matrix is close to singular.");
        }
        double[] eigen = this.evd.getEigenValues();
        DenseMatrix scaling = this.evd.getEigenVectors();
        if (x.length != this.p) {
            String s2 = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            String string = String.format(s2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new IllegalArgumentException(string);
        }
        if (posterior.length != this.k) {
            String s2 = "Invalid posterior vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{posterior.length, this.k};
            String string = String.format(s2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            throw new IllegalArgumentException(string);
        }
        int y = 0;
        double max = Double.NEGATIVE_INFINITY;
        double[] d = new double[this.p];
        double[] ux = new double[this.p];
        int n2 = this.k;
        for (int i2 = 0; i2 < n2; ++i2) {
            n = this.p;
            for (int j = 0; j < n; ++j) {
                d[j] = x[j] - this.mu[i2][j];
            }
            scaling.atx(d, ux);
            double f = 0.0;
            int n3 = this.p;
            for (int j = 0; j < n3; ++j) {
                f += ux[j] * ux[j] / eigen[j];
            }
            if (max < (f = this.ct[i2] - 0.5 * f)) {
                max = f;
                y = i2;
            }
            posterior[i2] = f;
        }
        double sum = 0.0;
        n = this.k;
        for (i = 0; i < n; ++i) {
            posterior[i] = java.lang.Math.exp(posterior[i] - max);
            sum += posterior[i];
        }
        i = 0;
        n = this.k;
        while (i < n) {
            int n4 = i++;
            posterior[n4] = posterior[n4] / sum;
        }
        return y;
    }
}

