/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.scent.ml.NodePoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007\u001a\u0014\u0010\b\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u001a8\u0010\n\u001a\u00020\u000b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u00a8\u0006\u0015"}, d2={"colMeans", "", "points", "", "([[D)[D", "colMeans2", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "", "colSds", "Lai/platon/scent/ml/NodePoint;", "fillSymmetricalMatrix", "", "Lorg/apache/commons/math3/linear/RealVector;", "matrix", "Lorg/apache/commons/math3/linear/RealMatrix;", "computer", "Lkotlin/Function2;", "", "squaredDistance", "x", "y", "scent-auto-mining"})
public final class MathsKt {
    public static final void fillSymmetricalMatrix(@NotNull List<? extends RealVector> points, @NotNull RealMatrix matrix, @NotNull Function2<? super RealVector, ? super RealVector, Double> computer) {
        int j;
        int i;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter(computer, (String)"computer");
        int size = points.size();
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                if (j < i) continue;
                matrix.setEntry(i, j, ((Number)computer.invoke((Object)points.get(i), (Object)points.get(j))).doubleValue());
            }
        }
        for (i = 0; i < size; ++i) {
            for (j = 0; j < size; ++j) {
                if (j >= i) continue;
                double value = matrix.getEntry(j, i);
                matrix.setEntry(i, j, value);
            }
        }
    }

    public static final double squaredDistance(@NotNull double[] x, @NotNull double[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vector sizes are different.");
        }
        double sum = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double z = x[i] - y[i];
            sum += z * z;
        }
        return sum;
    }

    @NotNull
    public static final double[] colMeans(@NotNull double[][] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        double[] x = (double[])points[0].clone();
        int n = ((Object[])points).length;
        for (int i = 1; i < n; ++i) {
            int n2 = x.length;
            for (int j = 0; j < n2; ++j) {
                int n3 = j;
                x[n3] = x[n3] + points[i][j];
            }
        }
        Math.scale((double)(1.0 / (double)((Object[])points).length), (double[])x);
        return x;
    }

    @NotNull
    public static final ArrayRealVector colMeans2(@NotNull List<? extends ArrayRealVector> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        double[] x = (double[])points.get(0).getDataRef().clone();
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            int n2 = x.length;
            for (int j = 0; j < n2; ++j) {
                int n3 = j;
                x[n3] = x[n3] + points.get(i).getDataRef()[j];
            }
        }
        Math.scale((double)(1.0 / (double)points.size()), (double[])x);
        return new ArrayRealVector(x, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ArrayRealVector colSds(@NotNull List<? extends NodePoint> points) {
        void var5_8;
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.size() < 2) {
            throw new IllegalArgumentException("Array length is less than 2.");
        }
        int dimension = points.get(0).getDimension();
        double[] sum = new double[dimension];
        double[] sumsq = new double[dimension];
        for (NodePoint nodePoint : points) {
            double[] x = nodePoint.getDataRef();
            for (int i = 0; i < dimension; ++i) {
                int n = i;
                sum[n] = sum[n] + x[i];
                n = i;
                sumsq[n] = sumsq[n] + x[i] * x[i];
            }
        }
        int n = points.size() - 1;
        boolean bl = false;
        while (var5_8 < dimension) {
            sumsq[var5_8] = FastMath.sqrt((double)(sumsq[var5_8] / (double)n - sum[var5_8] / (double)points.size() * (sum[var5_8] / (double)n)));
            ++var5_8;
        }
        return new ArrayRealVector(sumsq, false);
    }
}

