/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00100\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R%\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00150\u000f\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/platon/scent/ml/OneHotEncoder;", "Lai/platon/scent/ml/FeatureTransformer;", "featureKeys", "", "", "schema", "Lai/platon/scent/ml/Schema;", "weight", "", "verbose", "", "([ILai/platon/scent/ml/Schema;DZ)V", "getFeatureKeys", "()[I", "frequencies", "", "Lai/platon/pulsar/common/Frequency;", "getFrequencies", "()[Lai/platon/pulsar/common/Frequency;", "[Lai/platon/pulsar/common/Frequency;", "maps", "Ljava/util/HashMap;", "getMaps", "()[Ljava/util/HashMap;", "[Ljava/util/HashMap;", "fit", "", "xs", "", "Lai/platon/scent/ml/NodePoint;", "transform", "x", "transformSchema", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nFeatureEngineering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureEngineering.kt\nai/platon/scent/ml/OneHotEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,617:1\n1855#2,2:618\n1864#2,3:620\n13374#3,3:623\n13374#3,3:626\n1#4:629\n*S KotlinDebug\n*F\n+ 1 FeatureEngineering.kt\nai/platon/scent/ml/OneHotEncoder\n*L\n281#1:618,2\n283#1:620,3\n288#1:623,3\n294#1:626,3\n*E\n"})
public class OneHotEncoder
extends FeatureTransformer {
    @NotNull
    private final int[] featureKeys;
    private double weight;
    @NotNull
    private final Frequency<Integer>[] frequencies;
    @NotNull
    private final HashMap<Integer, Integer>[] maps;

    public OneHotEncoder(@NotNull int[] featureKeys, @NotNull Schema schema, double weight, boolean verbose) {
        int n;
        Intrinsics.checkNotNullParameter((Object)featureKeys, (String)"featureKeys");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(schema, verbose);
        this.featureKeys = featureKeys;
        this.weight = weight;
        int n2 = 0;
        int n3 = this.featureKeys.length;
        Object[] objectArray = new Frequency[n3];
        OneHotEncoder oneHotEncoder = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = new Frequency(null, 1, null);
        }
        oneHotEncoder.frequencies = objectArray;
        n2 = 0;
        n3 = this.featureKeys.length;
        objectArray = new HashMap[n3];
        oneHotEncoder = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = new HashMap();
        }
        oneHotEncoder.maps = objectArray;
    }

    public /* synthetic */ OneHotEncoder(int[] nArray, Schema schema, double d, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            schema = new Schema(null, 1, null);
        }
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(nArray, schema, d, bl);
    }

    @NotNull
    public final int[] getFeatureKeys() {
        return this.featureKeys;
    }

    @NotNull
    public final Frequency<Integer>[] getFrequencies() {
        return this.frequencies;
    }

    @NotNull
    public final HashMap<Integer, Integer>[] getMaps() {
        return this.maps;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fit(@NotNull List<? extends NodePoint> xs) {
        Object map;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        if (this.featureKeys.length == 0) {
            return;
        }
        Iterator<Schema.Column> iterator = this.getSchema().getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int j;
            Schema.Column column = iterator.next();
            if (!((j = n++) == column.getIndex())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int t = column.isPrimary() ? ArraysKt.indexOf((int[])this.featureKeys, (int)column.getPrimaryKey()) : -1;
            if (t < 0) continue;
            Frequency<Integer> frequency = this.frequencies[t];
            map = this.maps[t];
            Iterable $this$forEach$iv = xs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint x = (NodePoint)((Object)element$iv);
                boolean bl = false;
                frequency.add((Comparable)Integer.valueOf((int)VectorsKt.get((RealVector)((RealVector)x), (int)j)));
            }
            Iterable $this$forEachIndexed$iv = frequency.elementSet();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void nominal;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = ((Number)item$iv).intValue();
                int index = n2;
                boolean bl = false;
                Integer n4 = (int)nominal;
                Integer n5 = index;
                ((Map)map).put(n4, n5);
            }
        }
        if (this.getVerbose()) {
            Object it;
            int key;
            boolean bl;
            Frequency<Integer>[] frequencyArray = this.frequencies;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : frequencyArray) {
                int n6 = index$iv++;
                map = item$iv;
                int t = n6;
                bl = false;
                key = this.featureKeys[t];
                String string = "OneHotEncoder: feature key: " + key + " name: " + this.getSchema().getColumns().get(key) + " frequency size: " + it.elementSet().size() + " frequency:" + it;
                System.out.println((Object)string);
            }
            HashMap<Integer, Integer>[] hashMapArray = this.maps;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            for (Object item$iv : hashMapArray) {
                int n7 = index$iv++;
                it = item$iv;
                int t = n7;
                bl = false;
                key = this.featureKeys[t];
                System.out.println((Object)("feature key: " + key + " name: " + this.getSchema().getColumns().get(key) + " map to:" + it));
            }
        }
    }

    @Override
    @NotNull
    public Schema transformSchema() {
        if (this.featureKeys.length == 0) {
            this.setOutputSchema(this.getSchema());
        }
        List outputColumns = new ArrayList();
        int j = 0;
        Iterator<Schema.Column> iterator = this.getSchema().getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int t;
            int i;
            Schema.Column column = iterator.next();
            if (!((i = n++) == column.getIndex())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String name = column.getName();
            int n2 = t = column.isPrimary() ? ArraysKt.indexOf((int[])this.featureKeys, (int)column.getPrimaryKey()) : -1;
            if (t >= 0) {
                int s2 = this.frequencies[t].elementSet().size();
                for (int p = 0; p < s2; ++p) {
                    Schema.Column column2;
                    Schema.Column it = column2 = new Schema.Column(j + p, name + "-h" + p, 0, 4, null);
                    boolean bl = false;
                    outputColumns.add(it);
                }
                j += s2;
                continue;
            }
            outputColumns.add(new Schema.Column(j++, column.getName(), column.getType()));
        }
        this.setOutputSchema(new Schema(outputColumns));
        return this.getOutputSchema();
    }

    @Override
    @NotNull
    public NodePoint transform(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        if (this.featureKeys.length == 0) {
            return x;
        }
        if (!(x.getDimension() == this.getSchema().getColumns().size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double[] y = new double[this.getOutputSchema().getDimension()];
        int i = 0;
        Iterator<Schema.Column> iterator = this.getSchema().getColumns().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int t;
            int j;
            Schema.Column column = iterator.next();
            if (!((j = n++) == column.getIndex())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n2 = t = column.isPrimary() ? ArraysKt.indexOf((int[])this.featureKeys, (int)column.getPrimaryKey()) : -1;
            if (t >= 0) {
                int s2;
                int v = (int)VectorsKt.get((RealVector)((RealVector)x), (int)j);
                Integer n3 = this.maps[t].get(v);
                if (n3 == null) {
                    Object[] objectArray = new Object[]{v};
                    throw new MathArithmeticException((Localizable)LocalizedFormats.INDEX, objectArray);
                }
                int hot = ((Number)n3).intValue();
                if (!(hot < (s2 = this.frequencies[t].elementSet().size()))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                y[i + hot] = 1.0 * this.weight;
                i += s2;
                continue;
            }
            y[i++] = VectorsKt.get((RealVector)((RealVector)x), (int)j);
        }
        if (!(i == this.getOutputSchema().getDimension())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new NodePoint(x.getNode(), y, false, 4, null);
    }
}

