/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.data;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u0000J\u0006\u00103\u001a\u00020/J\b\u00104\u001a\u00020/H\u0016J\n\u00105\u001a\u0004\u0018\u00010%H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u00020/J\u0018\u0010;\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020%H\u0002J\u0018\u0010=\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010<\u001a\u00020%H\u0002J\u0018\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020%H\u0002J*\u0010>\u001a\u00020/2\b\u0010@\u001a\u0004\u0018\u0001072\u0006\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020%H\u0002J\u0010\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020\u0010H&J\u0006\u0010G\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R*\u0010\u0014\u001a\u0004\u0018\u00010\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010!\u001a\u0004\u0018\u00010\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0017R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000e\u00a8\u0006H"}, d2={"Lai/platon/scent/ml/data/SimpleDataFrame;", "Ljava/lang/AutoCloseable;", "schema", "Lai/platon/scent/ml/Schema;", "options", "Lai/platon/scent/ml/EncodeOptions;", "(Lai/platon/scent/ml/Schema;Lai/platon/scent/ml/EncodeOptions;)V", "FEATURE_FORMATTER", "Ljava/text/DecimalFormat;", "csvFormat", "Lorg/apache/commons/csv/CSVFormat;", "kotlin.jvm.PlatformType", "head", "getHead", "()Lai/platon/scent/ml/data/SimpleDataFrame;", "isHead", "", "()Z", "isTail", "<set-?>", "nextFrame", "getNextFrame", "setNextFrame", "(Lai/platon/scent/ml/data/SimpleDataFrame;)V", "getOptions", "()Lai/platon/scent/ml/EncodeOptions;", "points", "", "Lai/platon/scent/ml/NodePoint;", "getPoints", "()Ljava/util/List;", "setPoints", "(Ljava/util/List;)V", "prevFrame", "getPrevFrame", "setPrevFrame", "printer", "Lorg/apache/commons/csv/CSVPrinter;", "getSchema", "()Lai/platon/scent/ml/Schema;", "size", "", "getSize", "()I", "tail", "getTail", "addNext", "", "next", "addTail", "newTail", "clear", "close", "createWriterIfNecessary", "encodeLabel", "", "node", "Lorg/jsoup/nodes/Node;", "export", "exportHeader", "pr", "exportHeaderCSV", "exportNodeCSV", "point", "label", "features", "Lorg/apache/commons/math3/linear/RealVector;", "exportTo", "path", "Ljava/nio/file/Path;", "isEmpty", "isNotEmpty", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nDataFrames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/SimpleDataFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1864#2,3:221\n1855#2,2:224\n*S KotlinDebug\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/SimpleDataFrame\n*L\n114#1:221,3\n166#1:224,2\n*E\n"})
public abstract class SimpleDataFrame
implements AutoCloseable {
    @NotNull
    private final Schema schema;
    @NotNull
    private final EncodeOptions options;
    @Nullable
    private CSVPrinter printer;
    private final CSVFormat csvFormat;
    @NotNull
    private final DecimalFormat FEATURE_FORMATTER;
    @Nullable
    private SimpleDataFrame prevFrame;
    @Nullable
    private SimpleDataFrame nextFrame;

    public SimpleDataFrame(@NotNull Schema schema, @NotNull EncodeOptions options) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.schema = schema;
        this.options = options;
        this.csvFormat = CSVFormat.EXCEL;
        this.FEATURE_FORMATTER = new DecimalFormat("#.####");
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final EncodeOptions getOptions() {
        return this.options;
    }

    @Nullable
    public final synchronized SimpleDataFrame getPrevFrame() {
        return this.prevFrame;
    }

    public final synchronized void setPrevFrame(@Nullable SimpleDataFrame simpleDataFrame) {
        this.prevFrame = simpleDataFrame;
    }

    @Nullable
    public final synchronized SimpleDataFrame getNextFrame() {
        return this.nextFrame;
    }

    public final synchronized void setNextFrame(@Nullable SimpleDataFrame simpleDataFrame) {
        this.nextFrame = simpleDataFrame;
    }

    public final synchronized boolean isHead() {
        return this.prevFrame == null;
    }

    public final synchronized boolean isTail() {
        return this.nextFrame == null;
    }

    @NotNull
    public final synchronized SimpleDataFrame getHead() {
        SimpleDataFrame h = this;
        SimpleDataFrame prev = h.prevFrame;
        while (prev != null) {
            h = prev;
            prev = h.prevFrame;
        }
        return h;
    }

    @NotNull
    public final synchronized SimpleDataFrame getTail() {
        SimpleDataFrame t = this;
        SimpleDataFrame next = t.nextFrame;
        while (next != null) {
            t = next;
            next = t.nextFrame;
        }
        return t;
    }

    @NotNull
    public abstract List<NodePoint> getPoints();

    public abstract void setPoints(@NotNull List<? extends NodePoint> var1);

    public abstract int getSize();

    public abstract boolean isEmpty();

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final synchronized void addNext(@NotNull SimpleDataFrame next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        if (Intrinsics.areEqual((Object)next, (Object)this)) {
            throw new IllegalArgumentException("Can not add to itself");
        }
        this.nextFrame = next;
        next.prevFrame = this;
    }

    public final synchronized void addTail(@NotNull SimpleDataFrame newTail) {
        Intrinsics.checkNotNullParameter((Object)newTail, (String)"newTail");
        this.getTail().addNext(newTail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export() {
        Path path = this.options.getDatasetPath();
        if (path == null) {
            return;
        }
        Path path2 = path;
        Path lock = path2.resolveSibling("export.lock");
        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        Object object = new OpenOption[]{StandardOpenOption.CREATE};
        Files.writeString(lock, (CharSequence)String.valueOf(Thread.currentThread().getId()), object);
        object = new OpenOption[]{StandardOpenOption.APPEND};
        object = FileChannel.open(lock, object);
        Throwable throwable = null;
        try {
            FileChannel it = (FileChannel)object;
            boolean bl = false;
            it.lock();
            this.exportTo(path2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void exportTo(Path path) {
        CSVPrinter cSVPrinter = this.createWriterIfNecessary();
        if (cSVPrinter == null) {
            return;
        }
        CSVPrinter pr = cSVPrinter;
        if (!Files.exists(path, new LinkOption[0]) || 0L == Files.size(path)) {
            this.exportHeader(this.schema, pr);
        }
        Iterable $this$forEachIndexed$iv = this.getPoints();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void point;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl = false;
            this.exportNodeCSV((NodePoint)point, pr);
            pr.println();
        }
        pr.flush();
        this.clear();
    }

    public final void clear() {
        this.setPoints(CollectionsKt.emptyList());
    }

    @Override
    public void close() {
        block1: {
            CSVPrinter cSVPrinter = this.printer;
            if (cSVPrinter != null) {
                cSVPrinter.flush();
            }
            CSVPrinter cSVPrinter2 = this.printer;
            if (cSVPrinter2 == null) break block1;
            cSVPrinter2.close();
        }
    }

    private final CSVPrinter createWriterIfNecessary() {
        CSVPrinter cSVPrinter;
        if (this.isHead()) {
            Path path = this.options.getDatasetPath();
            if (path == null) {
                return null;
            }
            Path path2 = path;
            BufferedWriter writer = new BufferedWriter(new FileWriter(path2.toFile(), true));
            cSVPrinter = new CSVPrinter((Appendable)writer, this.csvFormat);
        } else {
            cSVPrinter = this.getHead().printer;
        }
        if ((this.printer = cSVPrinter) == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.printer;
    }

    private final void exportHeader(Schema schema, CSVPrinter pr) {
        this.exportHeaderCSV(schema, pr);
    }

    private final void exportNodeCSV(NodePoint point, CSVPrinter pr) {
        Node node = point.getNode();
        String label = this.encodeLabel(node);
        this.exportNodeCSV(label, (RealVector)point, point, pr);
    }

    private final String encodeLabel(Node node) {
        return (String)CollectionsKt.firstOrNull((List)NodeExtKt.getMlLabels((Node)node));
    }

    private final void exportHeaderCSV(Schema schema, CSVPrinter pr) {
        NodePoint nodePoint = (NodePoint)((Object)CollectionsKt.firstOrNull(this.getPoints()));
        if (nodePoint == null) {
            return;
        }
        nodePoint.getDimension();
        pr.print((Object)"label");
        Iterable $this$forEach$iv = schema.getColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Schema.Column it = (Schema.Column)element$iv;
            boolean bl = false;
            pr.print((Object)it);
        }
        pr.print((Object)"tag");
        pr.print((Object)"id");
        pr.print((Object)"class");
        pr.print((Object)"color");
        pr.print((Object)"bg-color");
        pr.print((Object)"font");
        pr.print((Object)"text");
        pr.print((Object)"url");
        pr.println();
    }

    private final void exportNodeCSV(String label, RealVector features, NodePoint point, CSVPrinter pr) {
        Node node = point.getNode();
        Element ele = NodeExtKt.getBestElement((Node)node);
        String text = StringsKt.take((String)NodeExtKt.getCleanText((Node)node), (int)this.options.getMaxTextLength());
        String url = NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)node));
        pr.print((Object)label);
        int n = features.getDimension();
        for (int j = 0; j < n; ++j) {
            pr.print((Object)VectorsKt.get((RealVector)features, (int)j));
        }
        pr.print((Object)ele.tagName());
        pr.print((Object)ele.id());
        pr.print((Object)ele.className());
        pr.print((Object)"");
        pr.print((Object)"");
        pr.print((Object)"");
        pr.print((Object)text);
        pr.print((Object)url);
    }
}

