/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.jpmml;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.ml.jpmml.JPMMLExecutor;
import ai.platon.scent.ml.jpmml.ParameterOrder;
import ai.platon.scent.ml.jpmml.SeparatorConverter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.collect.Sets;
import java.io.Console;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldNameSet;
import org.jpmml.evaluator.FunctionNameStack;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputFilters;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.testing.CsvUtil;
import org.jpmml.evaluator.visitors.AttributeFinalizerBattery;
import org.jpmml.evaluator.visitors.AttributeInternerBattery;
import org.jpmml.evaluator.visitors.AttributeOptimizerBattery;
import org.jpmml.evaluator.visitors.ElementFinalizerBattery;
import org.jpmml.evaluator.visitors.ElementInternerBattery;
import org.jpmml.evaluator.visitors.ElementOptimizerBattery;
import org.jpmml.model.visitors.LocatorNullifier;
import org.jpmml.model.visitors.MemoryMeasurer;
import org.jpmml.model.visitors.VisitorBattery;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 g2\u00020\u0001:\u0001gB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010a\u001a\u00020\u0016H\u0002J\"\u0010b\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030c2\u0010\u0010d\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030cJ\b\u0010e\u001a\u00020fH\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001e\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\f\"\u0004\b&\u0010\u000eR\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001e\u0010/\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\f\"\u0004\b1\u0010\u000eR\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\b\u0012\u0004\u0012\u00020\u0004058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010:\u001a\u00020\u001f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010!\"\u0004\b<\u0010#R&\u0010=\u001a\n >*\u0004\u0018\u00010\u00040\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0006\"\u0004\b@\u0010\bR \u0010A\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0006\"\u0004\bC\u0010\bR\u001e\u0010D\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\f\"\u0004\bF\u0010\u000eR \u0010G\u001a\u0004\u0018\u00010\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010!\"\u0004\bI\u0010#R\u0016\u0010J\u001a\n >*\u0004\u0018\u00010K0KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010L\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\f\"\u0004\bN\u0010\u000eR\u001e\u0010O\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0006\"\u0004\bQ\u0010\bR\u001e\u0010R\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\f\"\u0004\bT\u0010\u000eR&\u0010U\u001a\n >*\u0004\u0018\u00010\u00040\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0006\"\u0004\bW\u0010\bR\u001e\u0010X\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\f\"\u0004\bZ\u0010\u000eR\u001e\u0010[\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\f\"\u0004\b]\u0010\u000eR\u001e\u0010^\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010\f\"\u0004\b`\u0010\u000e\u00a8\u0006h"}, d2={"Lai/platon/scent/ml/jpmml/JPMMLEvaluator;", "Lai/platon/scent/ml/jpmml/JPMMLExecutor;", "()V", "cacheBuilderSpec", "", "getCacheBuilderSpec", "()Ljava/lang/String;", "setCacheBuilderSpec", "(Ljava/lang/String;)V", "catchErrors", "", "getCatchErrors", "()Z", "setCatchErrors", "(Z)V", "copyColumns", "getCopyColumns", "setCopyColumns", "errorColumn", "getErrorColumn", "setErrorColumn", "evaluator", "Lorg/jpmml/evaluator/Evaluator;", "getEvaluator", "()Lorg/jpmml/evaluator/Evaluator;", "evaluator$delegate", "Lkotlin/Lazy;", "filterOutput", "getFilterOutput", "setFilterOutput", "input", "Ljava/io/File;", "getInput", "()Ljava/io/File;", "setInput", "(Ljava/io/File;)V", "intern", "getIntern", "setIntern", "logger", "Lorg/slf4j/Logger;", "loop", "", "getLoop", "()I", "setLoop", "(I)V", "measure", "getMeasure", "setMeasure", "metricRegistry", "Lcom/codahale/metrics/MetricRegistry;", "missingValues", "", "getMissingValues", "()Ljava/util/List;", "setMissingValues", "(Ljava/util/List;)V", "model", "getModel", "setModel", "modelEvaluatorFactoryClazz", "kotlin.jvm.PlatformType", "getModelEvaluatorFactoryClazz", "setModelEvaluatorFactoryClazz", "modelName", "getModelName", "setModelName", "optimize", "getOptimize", "setOptimize", "output", "getOutput", "setOutput", "reporter", "Lcom/codahale/metrics/ConsoleReporter;", "safe", "getSafe", "setSafe", "separator", "getSeparator", "setSeparator", "sparse", "getSparse", "setSparse", "valueFactoryFactoryClazz", "getValueFactoryFactoryClazz", "setValueFactoryFactoryClazz", "waitAfterLoop", "getWaitAfterLoop", "setWaitAfterLoop", "waitBeforeInit", "getWaitBeforeInit", "setWaitBeforeInit", "waitBeforeLoop", "getWaitBeforeLoop", "setWaitBeforeLoop", "buildEvaluator", "evaluate", "", "record", "execute", "", "Companion", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nJPMMLEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JPMMLEvaluator.kt\nai/platon/scent/ml/jpmml/JPMMLEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,336:1\n1620#2,3:337\n1620#2,3:341\n1620#2,3:344\n1179#2,2:347\n1253#2,4:349\n1#3:340\n*S KotlinDebug\n*F\n+ 1 JPMMLEvaluator.kt\nai/platon/scent/ml/jpmml/JPMMLEvaluator\n*L\n172#1:337,3\n174#1:341,3\n225#1:344,3\n255#1:347,2\n255#1:349,4\n*E\n"})
public final class JPMMLEvaluator
extends JPMMLExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Parameter(names={"--model"}, description="Model PMML file", required=true)
    @ParameterOrder(value=1)
    public File model;
    @Parameter(names={"--input"}, description="Input CSV file", required=true)
    @ParameterOrder(value=2)
    public File input;
    @Parameter(names={"--output"}, description="Output CSV file", required=false)
    @ParameterOrder(value=3)
    @Nullable
    private File output;
    @Parameter(names={"--name"}, description="The name of the target model in a multi-model PMML file. If missing, the first model is targeted")
    @ParameterOrder(value=4)
    @Nullable
    private String modelName;
    @Parameter(names={"--separator"}, description="CSV cell separator character", converter=SeparatorConverter.class)
    @ParameterOrder(value=5)
    @NotNull
    private String separator = ",";
    @Parameter(names={"--missing-values"}, description="CSV missing value strings")
    @ParameterOrder(value=6)
    @NotNull
    private List<String> missingValues;
    @Parameter(names={"--sparse"}, description="Permit missing input field columns")
    @ParameterOrder(value=7)
    private boolean sparse;
    @Parameter(names={"--catch-errors"}, description="Catch and process evaluation errors. If true, the main evaluation loop will run till completion", arity=1)
    @ParameterOrder(value=8)
    private boolean catchErrors;
    @Parameter(names={"--copy-columns"}, description="Copy all columns from input CSV file to output CSV file", arity=1)
    @ParameterOrder(value=9)
    private boolean copyColumns;
    @Parameter(names={"--error-column"}, description="The name of error column. This column is appended to output CSV file only in case of evaluation errors")
    @ParameterOrder(value=10)
    @NotNull
    private String errorColumn;
    @Parameter(names={"--wait-before-init"}, description="Pause before initializing the JPMML stack", hidden=true)
    private boolean waitBeforeInit;
    @Parameter(names={"--cache-builder-spec"}, description="CacheBuilder configuration", hidden=true)
    @Nullable
    private String cacheBuilderSpec;
    @Parameter(names={"--factory-class", "--modelevaluatorfactory-class"}, description="The name of ModelEvaluatorFactory class", hidden=true)
    private String modelEvaluatorFactoryClazz;
    @Parameter(names={"--valuefactoryfactory-class"}, description="The name of ValueFactoryFactory class", hidden=true)
    private String valueFactoryFactoryClazz;
    @Parameter(names={"--filter-output"}, description="Exclude non-final output fields", hidden=true)
    private boolean filterOutput;
    @Parameter(names={"--safe"}, description="Guard against ill-fated derived field and function evaluations", hidden=true)
    private boolean safe;
    @Parameter(names={"--optimize"}, description="Optimize PMML class model", hidden=true)
    private boolean optimize;
    @Parameter(names={"--intern"}, description="Intern PMML class model", hidden=true)
    private boolean intern;
    @Parameter(names={"--measure"}, description="Measure PMML class model. Requires JPMML agent", hidden=true)
    private boolean measure;
    @Parameter(names={"--loop"}, description="The number of repetitions", hidden=true, validateWith={PositiveInteger.class})
    private int loop;
    @Parameter(names={"--wait-before-loop"}, description="Pause before entering the main evaluation loop", hidden=true)
    private boolean waitBeforeLoop;
    @Parameter(names={"--wait-after-loop"}, description="Pause after exiting the main evaluation loop", hidden=true)
    private boolean waitAfterLoop;
    @NotNull
    private final MetricRegistry metricRegistry;
    private final ConsoleReporter reporter;
    @NotNull
    private final Lazy evaluator$delegate;
    @NotNull
    private final Logger logger;

    public JPMMLEvaluator() {
        Object[] objectArray = new String[]{"N/A", "NA"};
        this.missingValues = CollectionsKt.listOf((Object[])objectArray);
        this.copyColumns = true;
        this.errorColumn = "_error";
        this.modelEvaluatorFactoryClazz = ModelEvaluatorFactory.class.getName();
        this.valueFactoryFactoryClazz = ValueFactoryFactory.class.getName();
        this.loop = 1;
        this.metricRegistry = new MetricRegistry();
        this.reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        this.evaluator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Evaluator>(this){
            final /* synthetic */ JPMMLEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Evaluator invoke() {
                return JPMMLEvaluator.access$buildEvaluator(this.this$0);
            }
        }));
        this.logger = LogsKt.getLogger((Object)this);
    }

    @NotNull
    public final File getModel() {
        File file = this.model;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        return null;
    }

    public final void setModel(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.model = file;
    }

    @NotNull
    public final File getInput() {
        File file = this.input;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"input");
        return null;
    }

    public final void setInput(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.input = file;
    }

    @Nullable
    public final File getOutput() {
        return this.output;
    }

    public final void setOutput(@Nullable File file) {
        this.output = file;
    }

    @Nullable
    public final String getModelName() {
        return this.modelName;
    }

    public final void setModelName(@Nullable String string) {
        this.modelName = string;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    public final void setSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.separator = string;
    }

    @NotNull
    public final List<String> getMissingValues() {
        return this.missingValues;
    }

    public final void setMissingValues(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.missingValues = list;
    }

    public final boolean getSparse() {
        return this.sparse;
    }

    public final void setSparse(boolean bl) {
        this.sparse = bl;
    }

    public final boolean getCatchErrors() {
        return this.catchErrors;
    }

    public final void setCatchErrors(boolean bl) {
        this.catchErrors = bl;
    }

    public final boolean getCopyColumns() {
        return this.copyColumns;
    }

    public final void setCopyColumns(boolean bl) {
        this.copyColumns = bl;
    }

    @NotNull
    public final String getErrorColumn() {
        return this.errorColumn;
    }

    public final void setErrorColumn(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.errorColumn = string;
    }

    public final boolean getWaitBeforeInit() {
        return this.waitBeforeInit;
    }

    public final void setWaitBeforeInit(boolean bl) {
        this.waitBeforeInit = bl;
    }

    @Nullable
    public final String getCacheBuilderSpec() {
        return this.cacheBuilderSpec;
    }

    public final void setCacheBuilderSpec(@Nullable String string) {
        this.cacheBuilderSpec = string;
    }

    public final String getModelEvaluatorFactoryClazz() {
        return this.modelEvaluatorFactoryClazz;
    }

    public final void setModelEvaluatorFactoryClazz(String string) {
        this.modelEvaluatorFactoryClazz = string;
    }

    public final String getValueFactoryFactoryClazz() {
        return this.valueFactoryFactoryClazz;
    }

    public final void setValueFactoryFactoryClazz(String string) {
        this.valueFactoryFactoryClazz = string;
    }

    public final boolean getFilterOutput() {
        return this.filterOutput;
    }

    public final void setFilterOutput(boolean bl) {
        this.filterOutput = bl;
    }

    public final boolean getSafe() {
        return this.safe;
    }

    public final void setSafe(boolean bl) {
        this.safe = bl;
    }

    public final boolean getOptimize() {
        return this.optimize;
    }

    public final void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public final boolean getIntern() {
        return this.intern;
    }

    public final void setIntern(boolean bl) {
        this.intern = bl;
    }

    public final boolean getMeasure() {
        return this.measure;
    }

    public final void setMeasure(boolean bl) {
        this.measure = bl;
    }

    public final int getLoop() {
        return this.loop;
    }

    public final void setLoop(int n) {
        this.loop = n;
    }

    public final boolean getWaitBeforeLoop() {
        return this.waitBeforeLoop;
    }

    public final void setWaitBeforeLoop(boolean bl) {
        this.waitBeforeLoop = bl;
    }

    public final boolean getWaitAfterLoop() {
        return this.waitAfterLoop;
    }

    public final void setWaitAfterLoop(boolean bl) {
        this.waitAfterLoop = bl;
    }

    private final Evaluator getEvaluator() {
        Lazy lazy = this.evaluator$delegate;
        return (Evaluator)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() throws Exception {
        void $this$mapTo$iv;
        Object results;
        Object it;
        Collection collection;
        if (this.waitBeforeInit) {
            JPMMLEvaluator.Companion.waitForUserInput();
        }
        List inputFields = this.getEvaluator().getInputFields();
        Evaluator evaluator2 = this.getEvaluator();
        HasGroupFields hasGroupFields = evaluator2 instanceof HasGroupFields ? (HasGroupFields)evaluator2 : null;
        List list = hasGroupFields != null ? hasGroupFields.getGroupFields() : null;
        List groupFields = list == null ? CollectionsKt.emptyList() : list;
        CsvUtil.Table inputTable = JPMMLExecutor.Companion.readTable(this.getInput(), this.separator);
        Function<String, String> cellParser = JPMMLExecutor.Companion.createCellParser(CollectionsKt.distinct((Iterable)this.missingValues));
        List inputRecords = null;
        List list2 = CsvUtil.toRecords((CsvUtil.Table)inputTable, cellParser);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toRecords(...)");
        inputRecords = list2;
        if (!((Collection)inputRecords).isEmpty()) {
            void $this$mapTo$iv2;
            void $this$mapTo$iv3;
            Map inputRecord = (Map)inputRecords.get(0);
            Intrinsics.checkNotNull((Object)inputFields);
            Iterable iterable = inputFields;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv3) {
                InputField inputField = (InputField)item$iv;
                collection = destination$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            Sets.SetView missingInputFields = Sets.difference((Set)((Set)destination$iv), inputRecord.keySet());
            if (!(missingInputFields.isEmpty() || this.sparse)) {
                boolean $i$a$-require-JPMMLEvaluator$execute$32 = false;
                String $i$a$-require-JPMMLEvaluator$execute$32 = "Missing input field(s): " + missingInputFields;
                throw new IllegalArgumentException($i$a$-require-JPMMLEvaluator$execute$32.toString());
            }
            Iterable $i$a$-require-JPMMLEvaluator$execute$32 = groupFields;
            Collection destination$iv2 = new HashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv2) {
                void it2;
                InputField bl = (InputField)item$iv;
                collection = destination$iv2;
                boolean bl2 = false;
                collection.add(it2.getName());
            }
            Sets.SetView missingGroupFields = Sets.difference((Set)((Set)destination$iv2), inputRecord.keySet());
            if (!missingGroupFields.isEmpty()) {
                boolean $i$a$-require-JPMMLEvaluator$execute$42 = false;
                String $i$a$-require-JPMMLEvaluator$execute$42 = "Missing group field(s): " + missingGroupFields;
                throw new IllegalArgumentException($i$a$-require-JPMMLEvaluator$execute$42.toString());
            }
        }
        if (this.getEvaluator() instanceof HasGroupFields) {
            Evaluator evaluator3 = this.getEvaluator();
            Intrinsics.checkNotNull((Object)evaluator3, (String)"null cannot be cast to non-null type org.jpmml.evaluator.HasGroupFields");
            List list3 = EvaluatorUtil.groupRows((HasGroupFields)((HasGroupFields)evaluator3), (List)inputRecords);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"groupRows(...)");
            inputRecords = list3;
        }
        List outputRecords = new ArrayList(inputRecords.size());
        String errorColumn = null;
        Timer timer = new Timer((Reservoir)new SlidingWindowReservoir(this.loop));
        this.metricRegistry.register("main", (Metric)timer);
        if (this.waitBeforeLoop) {
            JPMMLEvaluator.Companion.waitForUserInput();
        }
        int $i$a$-require-JPMMLEvaluator$execute$42 = this.loop;
        for (int i = 0; i < $i$a$-require-JPMMLEvaluator$execute$42; ++i) {
            Object item$iv;
            AutoCloseable $i$f$mapTo2 = (AutoCloseable)timer.time();
            item$iv = null;
            try {
                it = (Timer.Context)$i$f$mapTo2;
                boolean bl = false;
                outputRecords.clear();
                Map arguments = new LinkedHashMap();
                for (Map inputRecord : inputRecords) {
                    arguments.clear();
                    results = null;
                    try {
                        for (InputField inputField : inputFields) {
                            String name = inputField.getName();
                            Intrinsics.checkNotNull((Object)name);
                            arguments.put(name, inputField.prepare(inputRecord.get(name)));
                        }
                        Map map = this.getEvaluator().evaluate(arguments);
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"evaluate(...)");
                        results = map;
                    }
                    catch (Exception e) {
                        if (!this.catchErrors) {
                            throw e;
                        }
                        if (errorColumn == null) {
                            errorColumn = this.errorColumn;
                        }
                        Map<String, String> map = Collections.singletonMap(errorColumn, e.toString());
                        Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(...)");
                        results = map;
                    }
                    outputRecords.add(results);
                }
                it = Unit.INSTANCE;
                continue;
            }
            catch (Throwable it3) {
                item$iv = it3;
                throw it3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)$i$f$mapTo2, (Throwable)item$iv);
            }
        }
        if (this.waitAfterLoop) {
            JPMMLEvaluator.Companion.waitForUserInput();
        }
        List targetFields = this.getEvaluator().getTargetFields();
        List outputFields = this.getEvaluator().getOutputFields();
        Intrinsics.checkNotNull((Object)targetFields);
        Collection collection2 = targetFields;
        Intrinsics.checkNotNull((Object)outputFields);
        List resultFields = CollectionsKt.plus((Collection)collection2, (Iterable)outputFields);
        it = resultFields;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            results = (ResultField)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it4.getName());
        }
        ArrayList columns = (ArrayList)destination$iv;
        String string = errorColumn;
        if (string != null) {
            String it5 = string;
            boolean bl = false;
            columns.add(it5);
        }
        String separator = inputTable.getSeparator();
        List list4 = columns;
        Intrinsics.checkNotNull((Object)separator);
        CsvUtil.Table outputTable = CsvUtil.fromRecords((String)separator, (List)list4, (List)outputRecords, JPMMLExecutor.Companion.createCellFormatter(separator, (String)CollectionsKt.firstOrNull(this.missingValues)));
        if (inputTable.size() == outputTable.size() && this.copyColumns) {
            int n = inputTable.size();
            for (int i = 0; i < n; ++i) {
                List inputRow = (List)inputTable.get(i);
                List outputRow = (List)outputTable.get(i);
                Intrinsics.checkNotNull((Object)inputRow);
                outputRow.addAll(0, inputRow);
            }
        }
        File file = this.output;
        if (file != null) {
            File it6 = file;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)outputTable);
            JPMMLExecutor.Companion.writeTable(outputTable, it6);
        }
        if (this.loop > 1) {
            this.reporter.report();
        }
        this.reporter.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, ?> evaluate(@NotNull Map<String, ?> record) {
        Object object;
        Object $this$evaluate_u24lambda_u249;
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Object object2 = this;
        try {
            void $this$associateTo$iv$iv;
            $this$evaluate_u24lambda_u249 = object2;
            boolean bl = false;
            List list = super.getEvaluator().getInputFields();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputFields(...)");
            Iterable $this$associate$iv = list;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                InputField it = (InputField)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.prepare(record.get(it.getName())));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map arguments = destination$iv$iv;
            $this$evaluate_u24lambda_u249 = Result.constructor-impl((Object)super.getEvaluator().evaluate(arguments));
        }
        catch (Throwable bl) {
            $this$evaluate_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$evaluate_u24lambda_u249;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = MapsKt.mapOf((Pair)TuplesKt.to((Object)this.errorColumn, (Object)it.toString()));
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        return (Map)object;
    }

    private final Evaluator buildEvaluator() {
        PMML pmml = JPMMLExecutor.Companion.readPMML(this.getModel(), true);
        String string = this.cacheBuilderSpec;
        if (string != null) {
            String it = string;
            boolean bl = false;
            CacheUtil.setCacheBuilderSpec((CacheBuilderSpec)CacheBuilderSpec.parse((String)it));
        }
        VisitorBattery visitorBattery = new VisitorBattery();
        if (this.intern) {
            visitorBattery.add(LocatorNullifier.class);
        }
        if (this.optimize) {
            visitorBattery.addAll((Collection)new AttributeOptimizerBattery());
            visitorBattery.addAll((Collection)new ElementOptimizerBattery());
        }
        if (this.intern) {
            visitorBattery.addAll((Collection)new AttributeInternerBattery());
            visitorBattery.addAll((Collection)new ElementInternerBattery());
        }
        if (this.optimize || this.intern) {
            visitorBattery.addAll((Collection)new AttributeFinalizerBattery());
            visitorBattery.addAll((Collection)new ElementFinalizerBattery());
        }
        visitorBattery.applyTo((Visitable)pmml);
        if (this.measure) {
            MemoryMeasurer memoryMeasurer = new MemoryMeasurer();
            memoryMeasurer.applyTo((Visitable)pmml);
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setGroupingUsed(true);
            long size = memoryMeasurer.getSize();
            this.logger.info("Bytesize of the object graph: " + numberFormat.format(size));
            Set objects = memoryMeasurer.getObjects();
            long objectCount = objects.size();
            this.logger.info("Number of distinct Java objects in the object graph: " + numberFormat.format(objectCount));
            long pmmlObjectCount = objects.stream().filter(JPMMLEvaluator::buildEvaluator$lambda$12).count();
            this.logger.info("\tPMML class model objects: " + numberFormat.format(pmmlObjectCount));
            this.logger.info("\tOther objects: " + numberFormat.format(objectCount - pmmlObjectCount));
        }
        ModelEvaluatorBuilder builder = new ModelEvaluatorBuilder(pmml, this.modelName);
        String string2 = this.modelEvaluatorFactoryClazz;
        Intrinsics.checkNotNull((Object)string2);
        Object object = JPMMLExecutor.Companion.newInstance(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jpmml.evaluator.ModelEvaluatorFactory");
        builder.setModelEvaluatorFactory((ModelEvaluatorFactory)object);
        string2 = this.valueFactoryFactoryClazz;
        Intrinsics.checkNotNull((Object)string2);
        Object object2 = JPMMLExecutor.Companion.newInstance(string2);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jpmml.evaluator.ValueFactoryFactory");
        builder.setValueFactoryFactory((ValueFactoryFactory)object2);
        builder.setOutputFilter(this.filterOutput ? OutputFilters.KEEP_FINAL_RESULTS : OutputFilters.KEEP_ALL);
        if (this.safe) {
            builder.setDerivedFieldGuard((SymbolTable)new FieldNameSet(8));
            builder.setFunctionGuard((SymbolTable)new FunctionNameStack(4));
        }
        String it = string2 = builder.build();
        boolean bl = false;
        it.verify();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"also(...)");
        return (Evaluator)string3;
    }

    private static final boolean buildEvaluator$lambda$12(Object obj) {
        return PMMLObject.class.isInstance(obj);
    }

    public static final /* synthetic */ Evaluator access$buildEvaluator(JPMMLEvaluator $this) {
        return $this.buildEvaluator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/ml/jpmml/JPMMLEvaluator$Companion;", "", "()V", "waitForUserInput", "", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        private final void waitForUserInput() {
            Console console = System.console();
            if (console == null) {
                throw new IllegalStateException();
            }
            Console console2 = console;
            console2.readLine("Press ENTER to continue", new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

