/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.pulsar.common.math.MathsKt;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.ComponentCluster;
import ai.platon.scent.ml.unsupervised.NodeClusterGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B%\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\r\u001a\u00020\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0006\u0010\u0011\u001a\u00020\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/platon/scent/ml/unsupervised/ComponentClusterGroup;", "Lai/platon/scent/ml/unsupervised/NodeClusterGroup;", "Lai/platon/scent/ml/unsupervised/ComponentCluster;", "name", "", "clusters", "", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Ljava/lang/String;Ljava/util/List;Lai/platon/scent/dom/HarvestOptions;)V", "documents", "Lai/platon/scent/analysis/corpus/VisualDocument;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lai/platon/scent/dom/HarvestOptions;)V", "filter", "predicate", "Lkotlin/Function1;", "", "removeOutliers", "Companion", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClustering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/ComponentClusterGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1142:1\n1855#2,2:1143\n766#2:1145\n857#2,2:1146\n1855#2:1148\n1855#2,2:1149\n1611#2:1151\n1855#2:1152\n1856#2:1155\n1612#2:1156\n1856#2:1157\n766#2:1158\n857#2,2:1159\n1#3:1153\n1#3:1154\n*S KotlinDebug\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/ComponentClusterGroup\n*L\n910#1:1143,2\n918#1:1145\n918#1:1146,2\n923#1:1148\n929#1:1149,2\n931#1:1151\n931#1:1152\n931#1:1155\n931#1:1156\n923#1:1157\n939#1:1158\n939#1:1159,2\n931#1:1154\n*E\n"})
public final class ComponentClusterGroup
extends NodeClusterGroup<ComponentCluster> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<VisualDocument> documents;
    @NotNull
    private static final ComponentClusterGroup empty = new ComponentClusterGroup("", CollectionsKt.emptyList(), HarvestOptions.Companion.getUNSAFE());

    public ComponentClusterGroup(@NotNull String name, @NotNull List<? extends ComponentCluster> clusters, @NotNull List<VisualDocument> documents, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(name, clusters, options);
        this.documents = documents;
        if (!((Collection)this.documents).isEmpty()) {
            Iterable $this$forEach$iv = clusters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ComponentCluster it = (ComponentCluster)element$iv;
                boolean bl = false;
                it.setDocuments(this.documents);
            }
        }
    }

    private ComponentClusterGroup(String name, List<? extends ComponentCluster> clusters, HarvestOptions options) {
        this(name, clusters, CollectionsKt.emptyList(), options);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ComponentClusterGroup filter(@NotNull Function1<? super ComponentCluster, Boolean> predicate2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        Iterable iterable = this.getClusters();
        String string = this.getName();
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HarvestOptions harvestOptions = this.getOptions();
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new ComponentClusterGroup(string2, list, harvestOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ComponentClusterGroup removeOutliers() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Set outliers = new LinkedHashSet();
        Iterable $this$forEach$iv = this.getClusters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentCluster cluster2 = (ComponentCluster)element$iv;
            boolean bl = false;
            outliers.clear();
            Integer[] integerArray = new Integer[]{DefinedFeaturesKt.TOP, DefinedFeaturesKt.LEFT, DefinedFeaturesKt.WIDTH, DefinedFeaturesKt.TN};
            Integer[] variates = integerArray;
            int n = variates.length;
            for (int i = 0; i < n; ++i) {
                int k = variates[i];
                DescriptiveStatistics ds = new DescriptiveStatistics();
                Iterable $this$forEach$iv2 = cluster2.getPoints();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    NodePoint it = (NodePoint)((Object)element$iv2);
                    boolean bl2 = false;
                    ds.addValue(VectorsKt.get((RealVector)it.getUnmodifiedFeatures(), (int)k));
                }
                Pair pair = MathsKt.getOutlierInnerFence$default((DescriptiveStatistics)ds, (double)0.0, (double)0.0, (double)0.0, (int)14, null);
                double f1 = ((Number)pair.component1()).doubleValue();
                double f2 = ((Number)pair.component2()).doubleValue();
                Iterable $this$mapNotNullTo$iv = cluster2.getPoints();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    NodePoint it$iv;
                    NodePoint nodePoint;
                    Object element$iv$iv;
                    Object element$iv3 = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    NodePoint it = (NodePoint)((Object)element$iv3);
                    boolean bl4 = false;
                    NodePoint it2 = nodePoint = it;
                    boolean bl5 = false;
                    if ((VectorsKt.get((RealVector)it2.getUnmodifiedFeatures(), (int)k) > f1 && VectorsKt.get((RealVector)it2.getUnmodifiedFeatures(), (int)k) < f2 ? nodePoint : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl6 = false;
                    ((Collection)outliers).add(it$iv);
                }
            }
            cluster2.getPoints().removeAll(outliers);
        }
        $this$forEach$iv = this.getClusters();
        String string = this.getName();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ComponentCluster it = (ComponentCluster)element$iv$iv;
            boolean bl = false;
            if (!it.isNotEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HarvestOptions harvestOptions = this.getOptions();
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new ComponentClusterGroup(string2, list, harvestOptions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/ml/unsupervised/ComponentClusterGroup$Companion;", "", "()V", "empty", "Lai/platon/scent/ml/unsupervised/ComponentClusterGroup;", "getEmpty", "()Lai/platon/scent/ml/unsupervised/ComponentClusterGroup;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComponentClusterGroup getEmpty() {
            return empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

