/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.Measurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\"B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0003JT\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0002J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lai/platon/scent/ml/unsupervised/DBScan;", "Lai/platon/scent/ml/unsupervised/Measurable;", "points", "", "Lorg/apache/commons/math3/linear/RealVector;", "eps", "", "minPts", "", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "(Ljava/util/List;DILorg/apache/commons/math3/ml/distance/DistanceMeasure;)V", "getEps", "()D", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getMinPts", "()I", "getPoints", "()Ljava/util/List;", "cluster", "Lai/platon/scent/ml/unsupervised/Cluster;", "expandCluster", "point", "neighbors", "", "visited", "", "Lai/platon/scent/ml/unsupervised/DBScan$PointStatus;", "getNeighbors", "merge", "Ljava/util/ArrayList;", "one", "two", "PointStatus", "scent-auto-mining"})
public final class DBScan
implements Measurable {
    @NotNull
    private final List<RealVector> points;
    private final double eps;
    private final int minPts;
    @NotNull
    private final DistanceMeasure measure;

    public DBScan(@NotNull List<? extends RealVector> points, double eps, int minPts, @NotNull DistanceMeasure measure) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.points = points;
        this.eps = eps;
        this.minPts = minPts;
        this.measure = measure;
    }

    public /* synthetic */ DBScan(List list, double d, int n, DistanceMeasure distanceMeasure, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        this(list, d, n, distanceMeasure);
    }

    @NotNull
    public final List<RealVector> getPoints() {
        return this.points;
    }

    public final double getEps() {
        return this.eps;
    }

    public final int getMinPts() {
        return this.minPts;
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @NotNull
    public final List<Cluster<RealVector>> cluster() {
        List clusters = new ArrayList();
        HashMap visited = new HashMap();
        for (RealVector point : this.points) {
            if (visited.get(point) != null) continue;
            List<RealVector> neighbors = this.getNeighbors(point, (Collection<? extends RealVector>)this.points);
            if (neighbors.size() >= this.minPts) {
                Cluster<RealVector> cluster2 = new Cluster<RealVector>(null, 0, 3, null);
                clusters.add(this.expandCluster(cluster2, point, neighbors, (Collection<? extends RealVector>)this.points, visited));
                continue;
            }
            ((Map)visited).put(point, PointStatus.NOISE);
        }
        return clusters;
    }

    private final Cluster<RealVector> expandCluster(Cluster<RealVector> cluster2, RealVector point, List<? extends RealVector> neighbors, Collection<? extends RealVector> points, Map<RealVector, PointStatus> visited) {
        cluster2.getPoints().add(point);
        visited.put(point, PointStatus.PART_OF_CLUSTER);
        ArrayList<RealVector> seeds = new ArrayList<RealVector>((Collection)neighbors);
        for (int index = 0; index < seeds.size(); ++index) {
            List<RealVector> currentNeighbors;
            Object e = seeds.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            RealVector current = (RealVector)e;
            PointStatus pStatus = visited.get(current);
            if (pStatus == null && (currentNeighbors = this.getNeighbors(current, points)).size() >= this.minPts) {
                seeds = this.merge(seeds, currentNeighbors);
            }
            if (pStatus == PointStatus.PART_OF_CLUSTER) continue;
            visited.put(current, PointStatus.PART_OF_CLUSTER);
            cluster2.getPoints().add(current);
        }
        return cluster2;
    }

    private final List<RealVector> getNeighbors(RealVector point, Collection<? extends RealVector> points) {
        ArrayList<RealVector> neighbors = new ArrayList<RealVector>();
        for (RealVector realVector : points) {
            if (point == realVector || !(this.distance(realVector, point) <= this.eps)) continue;
            neighbors.add(realVector);
        }
        return neighbors;
    }

    private final ArrayList<RealVector> merge(ArrayList<RealVector> one, List<? extends RealVector> two) {
        HashSet oneSet = new HashSet(one);
        for (RealVector realVector : two) {
            if (oneSet.contains(realVector)) continue;
            one.add(realVector);
        }
        return one;
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        return Measurable.DefaultImpls.findClosestCluster(this, i, point, clusters);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/ml/unsupervised/DBScan$PointStatus;", "", "(Ljava/lang/String;I)V", "NOISE", "PART_OF_CLUSTER", "scent-auto-mining"})
    private static final class PointStatus
    extends Enum<PointStatus> {
        public static final /* enum */ PointStatus NOISE = new PointStatus();
        public static final /* enum */ PointStatus PART_OF_CLUSTER = new PointStatus();
        private static final /* synthetic */ PointStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PointStatus[] values() {
            return (PointStatus[])$VALUES.clone();
        }

        public static PointStatus valueOf(String value) {
            return Enum.valueOf(PointStatus.class, value);
        }

        @NotNull
        public static EnumEntries<PointStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pointStatusArray = new PointStatus[]{PointStatus.NOISE, PointStatus.PART_OF_CLUSTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

