/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.common.DataType;
import ai.platon.scent.dom.nodes.HyperPath;
import ai.platon.scent.dom.nodes.HyperPathBuilder;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.SeedSensitiveCluster;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010~\u001a\u00020\u007fJ\t\u0010\u0080\u0001\u001a\u00020\u007fH\u0016J\t\u0010\u0081\u0001\u001a\u00020\nH\u0016R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00020\n8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R!\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000e\u001a\u0004\b&\u0010!R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010*\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010%0%0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u000e\u001a\u0004\b,\u0010!R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001b\u00102\u001a\u0002038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u000e\u001a\u0004\b4\u00105R!\u00107\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000e\u001a\u0004\b9\u0010:R\u0011\u0010<\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010=R\u0011\u0010?\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010=R\u0011\u0010@\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010=R\u0011\u0010A\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010=R\u0011\u0010B\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010=R\u0011\u0010C\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010=R\u0011\u0010D\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010=R\u0011\u0010E\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010=R\u0011\u0010F\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010=R\u001b\u0010G\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bI\u0010\u000e\u001a\u0004\bH\u0010\fR\u0011\u0010J\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\bK\u00101R!\u0010L\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bN\u0010\u000e\u001a\u0004\bM\u0010:R!\u0010O\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\u000e\u001a\u0004\bP\u0010:R\u0011\u0010R\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\fR!\u0010T\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010\u000e\u001a\u0004\bU\u0010:R#\u0010W\u001a\n +*\u0004\u0018\u00010\n0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u0010\u000e\u001a\u0004\bX\u0010\fR!\u0010Z\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010\u000e\u001a\u0004\b[\u0010:R!\u0010]\u001a\b\u0012\u0004\u0012\u00020/0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u0010\u000e\u001a\u0004\b^\u0010!R\u001b\u0010`\u001a\u00020a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bd\u0010\u000e\u001a\u0004\bb\u0010cR-\u0010e\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001e0f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u0010\u000e\u001a\u0004\bg\u0010hR!\u0010j\u001a\b\u0012\u0004\u0012\u00020\u0007088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bl\u0010\u000e\u001a\u0004\bk\u0010:R\u0011\u0010m\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\bn\u0010cR!\u0010o\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010\u000e\u001a\u0004\bp\u0010:R!\u0010r\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010\u000e\u001a\u0004\bs\u0010:R!\u0010u\u001a\b\u0012\u0004\u0012\u00020\n088FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bw\u0010\u000e\u001a\u0004\bv\u0010:R\u0011\u0010x\u001a\u00020y8F\u00a2\u0006\u0006\u001a\u0004\bz\u0010{R\u0011\u0010|\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\b}\u0010c\u00a8\u0006\u0082\u0001"}, d2={"Lai/platon/scent/ml/unsupervised/NodeCluster;", "Lai/platon/scent/ml/unsupervised/SeedSensitiveCluster;", "Lai/platon/scent/ml/NodePoint;", "centroid", "Lorg/apache/commons/math3/linear/RealVector;", "seed", "label", "", "(Lorg/apache/commons/math3/linear/RealVector;Lai/platon/scent/ml/NodePoint;I)V", "bestSelector", "", "getBestSelector", "()Ljava/lang/String;", "bestSelector$delegate", "Lkotlin/Lazy;", "confuseMatrix", "Lai/platon/scent/entities/ConfuseMatrix;", "getConfuseMatrix", "()Lai/platon/scent/entities/ConfuseMatrix;", "setConfuseMatrix", "(Lai/platon/scent/entities/ConfuseMatrix;)V", "dataTypeStatistics", "Lai/platon/scent/entities/DataTypeStatistics;", "getDataTypeStatistics", "()Lai/platon/scent/entities/DataTypeStatistics;", "display", "getDisplay", "setDisplay", "(Ljava/lang/String;)V", "documents", "", "Lai/platon/scent/analysis/corpus/VisualDocument;", "getDocuments", "()Ljava/util/List;", "setDocuments", "(Ljava/util/List;)V", "elements", "Lorg/jsoup/nodes/Element;", "getElements", "elements$delegate", "estimated", "", "estimatedNodes", "kotlin.jvm.PlatformType", "getEstimatedNodes", "estimatedNodes$delegate", "firstNode", "Lorg/jsoup/nodes/Node;", "getFirstNode", "()Lorg/jsoup/nodes/Node;", "hyperPath", "Lai/platon/scent/dom/nodes/HyperPath;", "getHyperPath", "()Lai/platon/scent/dom/nodes/HyperPath;", "hyperPath$delegate", "images", "Lai/platon/pulsar/common/Frequency;", "getImages", "()Lai/platon/pulsar/common/Frequency;", "images$delegate", "isConstant", "()Z", "isFloat", "isImage", "isInt", "isLazy", "isLocallyConstant", "isMoneyLike", "isNumeric", "isNumericLike", "isVariable", "joinedSelector", "getJoinedSelector", "joinedSelector$delegate", "lastNode", "getLastNode", "locations", "getLocations", "locations$delegate", "mediumImages", "getMediumImages", "mediumImages$delegate", "mlLabel", "getMlLabel", "mlLabels", "getMlLabels", "mlLabels$delegate", "mostSelector", "getMostSelector", "mostSelector$delegate", "names", "getNames", "names$delegate", "nodes", "getNodes", "nodes$delegate", "order", "", "getOrder", "()D", "order$delegate", "pagePoints", "", "getPagePoints", "()Ljava/util/Map;", "pagePoints$delegate", "pids", "getPids", "pids$delegate", "pointRecall", "getPointRecall", "relativePaths", "getRelativePaths", "relativePaths$delegate", "shortTexts", "getShortTexts", "shortTexts$delegate", "texts", "getTexts", "texts$delegate", "type", "Lai/platon/scent/common/DataType;", "getType", "()Lai/platon/scent/common/DataType;", "typeThreshold", "getTypeThreshold", "detectDataType", "", "estimate", "toString", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClustering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/NodeCluster\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1142:1\n1#2:1143\n1855#3,2:1144\n*S KotlinDebug\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/NodeCluster\n*L\n328#1:1144,2\n*E\n"})
public abstract class NodeCluster
extends SeedSensitiveCluster<NodePoint> {
    private boolean estimated;
    @NotNull
    private List<VisualDocument> documents;
    @NotNull
    private final Lazy elements$delegate;
    @NotNull
    private final Lazy nodes$delegate;
    @NotNull
    private final Lazy estimatedNodes$delegate;
    @NotNull
    private final Lazy names$delegate;
    @NotNull
    private final Lazy mlLabels$delegate;
    @NotNull
    private String display;
    @NotNull
    private final Lazy locations$delegate;
    @NotNull
    private final Lazy pids$delegate;
    @NotNull
    private final Lazy shortTexts$delegate;
    @NotNull
    private final Lazy texts$delegate;
    @NotNull
    private final Lazy images$delegate;
    @NotNull
    private final Lazy mediumImages$delegate;
    @NotNull
    private final Lazy pagePoints$delegate;
    @NotNull
    private final Lazy relativePaths$delegate;
    @NotNull
    private final Lazy hyperPath$delegate;
    @NotNull
    private final Lazy joinedSelector$delegate;
    @NotNull
    private final Lazy mostSelector$delegate;
    @NotNull
    private final Lazy bestSelector$delegate;
    @NotNull
    private final DataTypeStatistics dataTypeStatistics;
    @NotNull
    private ConfuseMatrix confuseMatrix;
    @NotNull
    private final Lazy order$delegate;

    public NodeCluster(@NotNull RealVector centroid2, @NotNull NodePoint seed, int label) {
        Intrinsics.checkNotNullParameter((Object)centroid2, (String)"centroid");
        Intrinsics.checkNotNullParameter((Object)((Object)seed), (String)"seed");
        super(centroid2, (RealVector)seed, label);
        this.documents = CollectionsKt.emptyList();
        this.elements$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends Element>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Element> invoke() {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.this$0.getPoints();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Element it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)element$iv$iv);
                    boolean bl2 = false;
                    Node node = it.getNode();
                    if ((node instanceof Element ? (Element)node : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.nodes$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends Node>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Node> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.getPoints();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getNode());
                }
                return (List)destination$iv$iv;
            }
        }));
        this.estimatedNodes$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends Element>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Element> invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = this.this$0.getDocuments();
                NodeCluster nodeCluster = this.this$0;
                boolean $i$f$flatMap = false;
                void var4_4 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    VisualDocument it = (VisualDocument)element$iv$iv;
                    boolean bl = false;
                    Elements elements2 = it.getDocument().select(nodeCluster.getJoinedSelector());
                    Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"select(...)");
                    Iterable list$iv$iv = (Iterable)elements2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
        this.names$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv);
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getName((Node)it.getNode()));
                }
                return (Frequency)var2_2;
            }
        }));
        this.mlLabels$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv);
                    Collection collection = destination$iv;
                    boolean bl = false;
                    String string = (String)CollectionsKt.firstOrNull((List)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getMlLabels((Node)it.getNode()));
                    if (string == null) {
                        string = "";
                    }
                    collection.add(string);
                }
                return (Frequency)var2_2;
            }
        }));
        this.display = "";
        this.locations$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv);
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getLocation((Node)it.getNode()));
                }
                return (Frequency)var2_2;
            }
        }));
        this.pids$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<Integer>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<Integer> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv);
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(NodeExtKt.getPid((Node)it.getNode()));
                }
                return (Frequency)var2_2;
            }
        }));
        this.shortTexts$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapNotNullTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Node node;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl2 = false;
                    Node it2 = node = it.getNode();
                    boolean bl3 = false;
                    Object object = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isShortText((Node)it2) ? node : null;
                    if ((object != null ? ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)object) : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                return (Frequency)var2_2;
            }
        }));
        this.texts$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapNotNullTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Node node;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl2 = false;
                    Node it2 = node = it.getNode();
                    boolean bl3 = false;
                    Object object = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isRegularText((Node)it2) ? node : null;
                    if ((object != null ? ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)object) : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                return (Frequency)var2_2;
            }
        }));
        this.images$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapNotNullTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Node node;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl2 = false;
                    Node it2 = node = it.getNode();
                    boolean bl3 = false;
                    Object object = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isImage((Node)it2) ? node : null;
                    if ((object != null ? ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTextRepresentation((Node)object) : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                return (Frequency)var2_2;
            }
        }));
        this.mediumImages$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapNotNullTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    Node node;
                    T element$iv$iv;
                    T element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl2 = false;
                    Node it2 = node = it.getNode();
                    boolean bl3 = false;
                    Object object = NodeCharactersKt.isMediumImage((Node)it2) ? node : null;
                    if ((object != null ? ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getTextRepresentation((Node)object) : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                return (Frequency)var2_2;
            }
        }));
        this.pagePoints$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Map<Integer, ? extends List<? extends NodePoint>>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Integer, List<NodePoint>> invoke() {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = this.this$0.getPoints();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    NodePoint it = (NodePoint)((Object)element$iv$iv);
                    boolean bl = false;
                    Integer key$iv$iv = NodeExtKt.getPid((Node)it.getNode());
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
        this.relativePaths$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Frequency<String>>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Frequency<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getPoints();
                Collection destination$iv = (Collection)new Frequency(null, 1, null);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodePoint nodePoint = (NodePoint)((Object)item$iv);
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(NodeExtKt.getRelativePath((Node)it.getNode()));
                }
                return (Frequency)var2_2;
            }
        }));
        this.hyperPath$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<HyperPath>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HyperPath invoke() {
                return new HyperPathBuilder(this.this$0.getNodes()).build();
            }
        }));
        this.joinedSelector$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return CollectionsKt.joinToString$default((Iterable)this.this$0.getRelativePaths().elementSet(), null, null, null, (int)0, null, null, (int)63, null);
            }
        }));
        this.mostSelector$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return (String)this.this$0.getRelativePaths().getMostEntry().getElement();
            }
        }));
        this.bestSelector$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NodeCluster.access$bestSelector(this.this$0);
            }
        }));
        this.dataTypeStatistics = new DataTypeStatistics(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Short.MAX_VALUE, null);
        this.confuseMatrix = new ConfuseMatrix(0, 0, 0, 0, 15, null);
        this.order$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeCluster this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return NodeExtKt.getGeoOrder((Node)((NodePoint)((Object)CollectionsKt.first(this.this$0.getPoints()))).getNode());
            }
        }));
    }

    public /* synthetic */ NodeCluster(RealVector realVector, NodePoint nodePoint, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(realVector, nodePoint, n);
    }

    @NotNull
    public final List<VisualDocument> getDocuments() {
        return this.documents;
    }

    public final void setDocuments(@NotNull List<VisualDocument> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.documents = list;
    }

    @NotNull
    public final List<Element> getElements() {
        Lazy lazy = this.elements$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<Node> getNodes() {
        Lazy lazy = this.nodes$delegate;
        return (List)lazy.getValue();
    }

    public final double getTypeThreshold() {
        return 0.8 * (double)this.getSize();
    }

    @NotNull
    public final Node getFirstNode() {
        return ((NodePoint)((Object)CollectionsKt.first(this.getPoints()))).getNode();
    }

    @NotNull
    public final Node getLastNode() {
        return ((NodePoint)((Object)CollectionsKt.last(this.getPoints()))).getNode();
    }

    @NotNull
    public final List<Element> getEstimatedNodes() {
        Lazy lazy = this.estimatedNodes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getNames() {
        Lazy lazy = this.names$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getMlLabels() {
        Lazy lazy = this.mlLabels$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final String getMlLabel() {
        return this.getMlLabels().getTotalFrequency() <= 3 ? "" : ((double)this.getMlLabels().getTotalFrequency() < 0.3 * (double)this.getSize() ? "" : (String)((Object)this.getMlLabels().getMode()));
    }

    @NotNull
    public final String getDisplay() {
        if (StringsKt.isBlank((CharSequence)this.display)) {
            Multiset.Entry it = this.getNames().getMostEntry();
            NodeCluster nodeCluster = this;
            boolean bl = false;
            nodeCluster.display = it.getElement() + "[" + it.getCount() + "]";
        }
        return this.display;
    }

    public final void setDisplay(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.display = string;
    }

    @NotNull
    public final Frequency<String> getLocations() {
        Lazy lazy = this.locations$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<Integer> getPids() {
        Lazy lazy = this.pids$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getShortTexts() {
        Lazy lazy = this.shortTexts$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getTexts() {
        Lazy lazy = this.texts$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getImages() {
        Lazy lazy = this.images$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getMediumImages() {
        Lazy lazy = this.mediumImages$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final Map<Integer, List<NodePoint>> getPagePoints() {
        Lazy lazy = this.pagePoints$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Frequency<String> getRelativePaths() {
        Lazy lazy = this.relativePaths$delegate;
        return (Frequency)lazy.getValue();
    }

    @NotNull
    public final HyperPath getHyperPath() {
        Lazy lazy = this.hyperPath$delegate;
        return (HyperPath)lazy.getValue();
    }

    @NotNull
    public final String getJoinedSelector() {
        Lazy lazy = this.joinedSelector$delegate;
        return (String)lazy.getValue();
    }

    public final String getMostSelector() {
        Lazy lazy = this.mostSelector$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBestSelector() {
        Lazy lazy = this.bestSelector$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final DataTypeStatistics getDataTypeStatistics() {
        return this.dataTypeStatistics;
    }

    public final boolean isConstant() {
        return (double)this.dataTypeStatistics.getNumConstants() > this.getTypeThreshold();
    }

    public final boolean isLocallyConstant() {
        return (double)this.dataTypeStatistics.getNumLocallyConstants() > this.getTypeThreshold();
    }

    public final boolean isVariable() {
        return (double)this.dataTypeStatistics.getNumVariables() > this.getTypeThreshold();
    }

    public final boolean isImage() {
        return (double)this.dataTypeStatistics.getNumImages() >= this.getTypeThreshold();
    }

    public final boolean isInt() {
        return (double)this.dataTypeStatistics.getNumInts() >= this.getTypeThreshold();
    }

    public final boolean isFloat() {
        return (double)this.dataTypeStatistics.getNumFloats() >= this.getTypeThreshold();
    }

    public final boolean isNumeric() {
        return (double)this.dataTypeStatistics.getNumNumbers() >= this.getTypeThreshold();
    }

    public final boolean isNumericLike() {
        return (double)this.dataTypeStatistics.getNumNumberLikes() >= this.getTypeThreshold();
    }

    public final boolean isMoneyLike() {
        return (double)this.dataTypeStatistics.getNumMoneyLikes() >= this.getTypeThreshold();
    }

    public final boolean isLazy() {
        return (double)this.dataTypeStatistics.getNumLazy() >= 0.3 * (double)this.getSize();
    }

    @NotNull
    public final DataType getType() {
        return this.isVariable() ? DataType.VAR : (this.isConstant() ? DataType.CON : (this.isImage() ? DataType.IMG : (this.isNumeric() ? DataType.NUM : (this.isNumericLike() ? DataType.NUM2 : (this.isMoneyLike() ? DataType.MON : DataType.N)))));
    }

    @NotNull
    public final ConfuseMatrix getConfuseMatrix() {
        return this.confuseMatrix;
    }

    public final void setConfuseMatrix(@NotNull ConfuseMatrix confuseMatrix2) {
        Intrinsics.checkNotNullParameter((Object)confuseMatrix2, (String)"<set-?>");
        this.confuseMatrix = confuseMatrix2;
    }

    public final double getPointRecall() {
        return 1.0 * (double)this.getPoints().size() / (double)this.documents.size();
    }

    @Override
    public double getOrder() {
        Lazy lazy = this.order$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public void estimate() {
        if (!this.estimated) {
            this.detectDataType();
            this.estimated = true;
        }
    }

    public final void detectDataType() {
        DataTypeStatistics ds = this.dataTypeStatistics;
        ds.setNumNodes(this.getPoints().size());
        Iterable $this$forEach$iv = this.getPoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodePoint it = (NodePoint)((Object)element$iv);
            boolean bl = false;
            Node n = it.getNode();
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isBlankText((Node)n)) {
                ds.setNumBlanks(ds.getNumBlanks() + 1);
                ds.getNumBlanks();
                continue;
            }
            if (NodeExtKt.isLocallyConstant((Node)n)) {
                ds.setNumLocallyConstants(ds.getNumLocallyConstants() + 1);
                ds.getNumLocallyConstants();
            }
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isShortText((Node)n)) {
                ds.setNumShortTexts(ds.getNumShortTexts() + 1);
                ds.getNumShortTexts();
            } else if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isMediumText((Node)n)) {
                ds.setNumMediumTexts(ds.getNumMediumTexts() + 1);
                ds.getNumMediumTexts();
            } else if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isText((Node)n)) {
                ds.setNumTexts(ds.getNumTexts() + 1);
                ds.getNumTexts();
            } else if (NodeCharactersKt.isLazy((Node)n)) {
                ds.setNumLazy(ds.getNumLazy() + 1);
                ds.getNumLazy();
            }
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isImage((Node)n)) {
                ds.setNumImages(ds.getNumImages() + 1);
                ds.getNumImages();
            }
            if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isShortText((Node)n)) continue;
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isNumericLike((Node)n)) {
                ds.setNumNumberLikes(ds.getNumNumberLikes() + 1);
                ds.getNumNumberLikes();
            }
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isMoneyLike((Node)n)) {
                ds.setNumMoneyLikes(ds.getNumMoneyLikes() + 1);
                ds.getNumMoneyLikes();
            }
            if (ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isNumeric((Node)n)) {
                ds.setNumNumbers(ds.getNumNumbers() + 1);
                ds.getNumNumbers();
                if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isInt((Node)n)) continue;
                ds.setNumInts(ds.getNumInts() + 1);
                ds.getNumInts();
                continue;
            }
            if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isFloat((Node)n)) continue;
            ds.setNumFloats(ds.getNumFloats() + 1);
            ds.getNumFloats();
        }
        if (!((Collection)this.getShortTexts()).isEmpty() && this.getShortTexts().getModePercentage() >= 0.8) {
            ds.setNumConstants(ds.getNumConstants() + this.getShortTexts().getMostEntry().getCount());
        } else if (!((Collection)this.getTexts()).isEmpty() && this.getTexts().getModePercentage() >= 0.8) {
            ds.setNumConstants(ds.getNumConstants() + this.getTexts().getMostEntry().getCount());
        } else if (!((Collection)this.getImages()).isEmpty() && this.getImages().getModePercentage() >= 0.8) {
            ds.setNumConstants(ds.getNumConstants() + this.getImages().getMostEntry().getCount());
        }
        ds.setNumVariables(this.getPoints().size() - ds.getNumBlanks() - ds.getNumConstants());
    }

    @Override
    @NotNull
    public String toString() {
        String string = "names: [%s] points: %d";
        Object[] objectArray = new Object[]{this.getNames().toString(), this.getPoints().size()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String bestSelector() {
        String string;
        Multiset.Entry mostEntry = this.getRelativePaths().getMostEntry();
        Frequency<String> frequency = this.getRelativePaths();
        Object object = mostEntry.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getElement(...)");
        double p = frequency.percentageOf((Comparable)object);
        if (p >= 0.8) {
            Object object2 = mostEntry.getElement();
            Intrinsics.checkNotNull((Object)object2);
            string = (String)object2;
        } else {
            string = p > 0.5 ? this.getJoinedSelector() : this.getJoinedSelector();
        }
        return string;
    }

    public static final /* synthetic */ String access$bestSelector(NodeCluster $this) {
        return $this.bestSelector();
    }
}

