/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.HyperPath;
import ai.platon.scent.entities.ClusterTaskStatus;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.NodeClusterGroupMetrics;
import ai.platon.scent.ml.unsupervised.NodeCluster;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010v\u001a\u00020wH\u0016J\"\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020&0zH\u0016J\u001c\u0010{\u001a\u00020w2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020w0zH\u0016J\u0006\u0010}\u001a\u00020\u0005R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0017\u001a\u0004\b\"\u0010#R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010#R\u0011\u0010)\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010#R!\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0017\u001a\u0004\b.\u0010/R\u0011\u00101\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b3\u00102R\u0011\u00104\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b4\u00102R\u0016\u00105\u001a\n 7*\u0004\u0018\u00010606X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u00108\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0017\u001a\u0004\b9\u0010#R\u001b\u0010;\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u0017\u001a\u0004\b<\u0010#R\u001b\u0010>\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u0017\u001a\u0004\b?\u0010#R)\u0010A\u001a\u0010\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00050\u00050B8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bE\u0010\u0017\u001a\u0004\bC\u0010DR\u001a\u0010F\u001a\u00020GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010#R\u0011\u0010N\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010#R\u0011\u0010P\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020U8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u001b\u0010X\u001a\u00020U8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u0010\u0017\u001a\u0004\bY\u0010WR\u001b\u0010[\u001a\u00020U8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u0010\u0017\u001a\u0004\b\\\u0010WR\u001b\u0010^\u001a\u00020U8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b`\u0010\u0017\u001a\u0004\b_\u0010WR\u001b\u0010a\u001a\u00020U8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bc\u0010\u0017\u001a\u0004\bb\u0010WR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010eR\u001b\u0010f\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u0010\u0017\u001a\u0004\bg\u0010#R\u001b\u0010i\u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bk\u0010\u0017\u001a\u0004\bj\u0010#R\u001b\u0010l\u001a\u00020m8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bp\u0010\u0017\u001a\u0004\bn\u0010oR)\u0010q\u001a\u0010\u0012\f\u0012\n 7*\u0004\u0018\u00010\u00050\u00050B8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bs\u0010\u0017\u001a\u0004\br\u0010DR\u0011\u0010t\u001a\u00020U8F\u00a2\u0006\u0006\u001a\u0004\bu\u0010W\u00a8\u0006~"}, d2={"Lai/platon/scent/ml/unsupervised/NodeClusterGroup;", "T", "Lai/platon/scent/ml/unsupervised/NodeCluster;", "", "name", "", "clusters", "", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Ljava/lang/String;Ljava/util/List;Lai/platon/scent/dom/HarvestOptions;)V", "clusterTaskStatus", "Lai/platon/scent/entities/ClusterTaskStatus;", "getClusterTaskStatus", "()Lai/platon/scent/entities/ClusterTaskStatus;", "setClusterTaskStatus", "(Lai/platon/scent/entities/ClusterTaskStatus;)V", "getClusters", "()Ljava/util/List;", "confuseMatrices", "Lai/platon/scent/entities/ConfuseMatrix;", "getConfuseMatrices", "confuseMatrices$delegate", "Lkotlin/Lazy;", "confuseMatrix", "getConfuseMatrix", "()Lai/platon/scent/entities/ConfuseMatrix;", "confuseMatrix$delegate", "dataTypeStatistics", "Lai/platon/scent/entities/DataTypeStatistics;", "getDataTypeStatistics", "()Lai/platon/scent/entities/DataTypeStatistics;", "distortion", "", "getDistortion", "()D", "distortion$delegate", "estimated", "", "fineFieldRate", "getFineFieldRate", "fineVariableRate", "getFineVariableRate", "hyperPaths", "Ljava/util/ArrayList;", "Lai/platon/scent/dom/nodes/HyperPath;", "getHyperPaths", "()Ljava/util/ArrayList;", "hyperPaths$delegate", "isConstant", "()Z", "isEmpty", "isNotEmpty", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "macroF1", "getMacroF1", "macroF1$delegate", "macroP", "getMacroP", "macroP$delegate", "macroR", "getMacroR", "macroR$delegate", "mediumImages", "Ljava/util/HashSet;", "getMediumImages", "()Ljava/util/HashSet;", "mediumImages$delegate", "metrics", "Lai/platon/scent/entities/NodeClusterGroupMetrics;", "getMetrics", "()Lai/platon/scent/entities/NodeClusterGroupMetrics;", "setMetrics", "(Lai/platon/scent/entities/NodeClusterGroupMetrics;)V", "microF1", "getMicroF1", "microP", "getMicroP", "microR", "getMicroR", "getName", "()Ljava/lang/String;", "numFields", "", "getNumFields", "()I", "numFineFields", "getNumFineFields", "numFineFields$delegate", "numFineVariables", "getNumFineVariables", "numFineVariables$delegate", "numImageNodes", "getNumImageNodes", "numImageNodes$delegate", "numNodes", "getNumNodes", "numNodes$delegate", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "pathDistortion", "getPathDistortion", "pathDistortion$delegate", "pidDistortion", "getPidDistortion", "pidDistortion$delegate", "score", "Lai/platon/pulsar/common/ScoreVector;", "getScore", "()Lai/platon/pulsar/common/ScoreVector;", "score$delegate", "shortTexts", "getShortTexts", "shortTexts$delegate", "size", "getSize", "estimate", "", "filter", "predicate", "Lkotlin/Function1;", "forEach", "action", "toReport", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClustering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/NodeClusterGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1142:1\n1855#2,2:1143\n766#2:1145\n857#2,2:1146\n1855#2,2:1148\n1864#2,2:1150\n1866#2:1153\n1#3:1152\n*S KotlinDebug\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/NodeClusterGroup\n*L\n749#1:1143,2\n762#1:1145\n762#1:1146,2\n769#1:1148,2\n774#1:1150,2\n774#1:1153\n*E\n"})
public class NodeClusterGroup<T extends NodeCluster> {
    @NotNull
    private final String name;
    @NotNull
    private final List<T> clusters;
    @NotNull
    private final HarvestOptions options;
    private final Logger log;
    private boolean estimated;
    @NotNull
    private final Lazy hyperPaths$delegate;
    @NotNull
    private final Lazy shortTexts$delegate;
    @NotNull
    private final Lazy mediumImages$delegate;
    @NotNull
    private final Lazy numNodes$delegate;
    @NotNull
    private final Lazy numImageNodes$delegate;
    @NotNull
    private final Lazy score$delegate;
    @NotNull
    private final Lazy distortion$delegate;
    @NotNull
    private final Lazy pathDistortion$delegate;
    @NotNull
    private final Lazy pidDistortion$delegate;
    @NotNull
    private final DataTypeStatistics dataTypeStatistics;
    @NotNull
    private final Lazy numFineVariables$delegate;
    @NotNull
    private final Lazy numFineFields$delegate;
    @NotNull
    private final Lazy confuseMatrices$delegate;
    @NotNull
    private final Lazy confuseMatrix$delegate;
    @NotNull
    private final Lazy macroP$delegate;
    @NotNull
    private final Lazy macroR$delegate;
    @NotNull
    private final Lazy macroF1$delegate;
    @NotNull
    private ClusterTaskStatus clusterTaskStatus;
    @NotNull
    private NodeClusterGroupMetrics metrics;

    public NodeClusterGroup(@NotNull String name, @NotNull List<? extends T> clusters, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.name = name;
        this.clusters = clusters;
        this.options = options;
        this.log = LoggerFactory.getLogger(NodeClusterGroup.class);
        this.hyperPaths$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<ArrayList<HyperPath>>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<HyperPath> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Iterable iterable = this.this$0.getClusters();
                Collection destination$iv = new ArrayList<E>(this.this$0.getClusters().size());
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getHyperPath());
                }
                return (ArrayList)var2_2;
            }
        }));
        this.shortTexts$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<HashSet<String>>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<String> invoke() {
                void var2_2;
                void $this$flatMapTo$iv;
                Iterable iterable = this.this$0.getClusters();
                Collection destination$iv = new HashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    void $this$mapTo$iv$iv;
                    NodeCluster it = (NodeCluster)element$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = it.getShortTexts().entrySet();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Multiset.Entry entry = (Multiset.Entry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add((String)it2.getElement());
                    }
                    Iterable list$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                return (HashSet)var2_2;
            }
        }));
        this.mediumImages$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<HashSet<String>>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HashSet<String> invoke() {
                void var2_2;
                void $this$flatMapTo$iv;
                Iterable iterable = this.this$0.getClusters();
                Collection destination$iv = new HashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    void $this$mapTo$iv$iv;
                    NodeCluster it = (NodeCluster)element$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = it.getMediumImages().entrySet();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Multiset.Entry entry = (Multiset.Entry)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add((String)it2.getElement());
                    }
                    Iterable list$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                return (HashSet)var2_2;
            }
        }));
        this.numNodes$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                void var3_3;
                Iterable $this$sumBy$iv = this.this$0.getClusters();
                boolean $i$f$sumBy = false;
                int sum$iv = 0;
                for (T element$iv : $this$sumBy$iv) {
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)element$iv;
                    int n = sum$iv;
                    boolean bl = false;
                    int n2 = it.getNodes().size();
                    sum$iv = n + n2;
                }
                return (int)var3_3;
            }
        }));
        this.numImageNodes$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                void var3_3;
                Iterable $this$sumBy$iv = this.this$0.getClusters();
                boolean $i$f$sumBy = false;
                int sum$iv = 0;
                for (T element$iv : $this$sumBy$iv) {
                    int n;
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)element$iv;
                    int n2 = sum$iv;
                    boolean bl = false;
                    Iterable $this$count$iv = it.getNodes();
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T element$iv2 : $this$count$iv) {
                            Node it2 = (Node)element$iv2;
                            boolean bl2 = false;
                            if (!NodeExtKt.isImage((Node)it2) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int n3 = n;
                    sum$iv = n2 + n3;
                }
                return (int)var3_3;
            }
        }));
        this.score$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<ScoreVector>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScoreVector invoke() {
                int[] nArray = new int[]{this.this$0.getShortTexts().size(), this.this$0.getMediumImages().size()};
                return new ScoreVector("2", nArray);
            }
        }));
        this.distortion$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getClusters();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getDistortion();
                    sum$iv = d + d2;
                }
                return (double)var3_3;
            }
        }));
        this.pathDistortion$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getClusters();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = 1.0 * (double)it.getRelativePaths().size() / (double)it.getSize();
                    sum$iv = d + d2;
                }
                return (double)var3_3;
            }
        }));
        this.pidDistortion$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getClusters();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    NodeCluster nodeCluster = (NodeCluster)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = 1.0 * (double)it.getPids().size() / (double)it.getSize();
                    sum$iv = d + d2;
                }
                return (double)var3_3;
            }
        }));
        this.dataTypeStatistics = new DataTypeStatistics(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Short.MAX_VALUE, null);
        this.numFineVariables$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                int n;
                void $this$count$iv;
                Iterable iterable = this.this$0.getClusters();
                NodeClusterGroup<T> nodeClusterGroup = this.this$0;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        NodeCluster it = (NodeCluster)element$iv;
                        boolean bl = false;
                        if (!(it.isVariable() && it.getConfuseMatrix().getF1() >= nodeClusterGroup.getOptions().getFineF1Rate()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                return n;
            }
        }));
        this.numFineFields$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                int n;
                void $this$count$iv;
                Iterable iterable = this.this$0.getClusters();
                NodeClusterGroup<T> nodeClusterGroup = this.this$0;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        NodeCluster it = (NodeCluster)element$iv;
                        boolean bl = false;
                        if (!(it.getConfuseMatrix().getF1() >= nodeClusterGroup.getOptions().getFineF1Rate()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                return n;
            }
        }));
        this.confuseMatrices$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends ConfuseMatrix>>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ConfuseMatrix> invoke() {
                void $this$mapTo$iv$iv;
                NodeCluster it;
                Iterable iterable;
                Iterable $this$onEach$iv = this.this$0.getClusters();
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
                boolean bl = false;
                for (T element$iv : $this$onEach_u24lambda_u2416$iv) {
                    it = (NodeCluster)element$iv;
                    boolean bl2 = false;
                    it.estimate();
                }
                Iterable $this$map$iv = iterable;
                boolean $i$f$map = false;
                iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (NodeCluster)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getConfuseMatrix());
                }
                return (List)destination$iv$iv;
            }
        }));
        this.confuseMatrix$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<ConfuseMatrix>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfuseMatrix invoke() {
                void $this$fold$iv;
                Iterable iterable = this.this$0.getConfuseMatrices();
                ConfuseMatrix initial$iv = new ConfuseMatrix(0, 0, 0, 0, 15, null);
                boolean $i$f$fold = false;
                ConfuseMatrix accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void matrix;
                    ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)element$iv;
                    ConfuseMatrix acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.accumulate((ConfuseMatrix)matrix);
                }
                return accumulator$iv.estimate();
            }
        }));
        this.macroP$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getConfuseMatrices();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getPrecision();
                    sum$iv = d + d2;
                }
                return (double)(var3_3 / (double)this.this$0.getSize());
            }
        }));
        this.macroR$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getConfuseMatrices();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getRecall();
                    sum$iv = d + d2;
                }
                return (double)(var3_3 / (double)this.this$0.getSize());
            }
        }));
        this.macroF1$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ NodeClusterGroup<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Double invoke() {
                void var3_3;
                Iterable $this$sumByDouble$iv = this.this$0.getConfuseMatrices();
                boolean $i$f$sumByDouble = false;
                double sum$iv = 0.0;
                for (T element$iv : $this$sumByDouble$iv) {
                    void it;
                    ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)element$iv;
                    double d = sum$iv;
                    boolean bl = false;
                    double d2 = it.getF1();
                    sum$iv = d + d2;
                }
                return (double)(var3_3 / (double)this.this$0.getSize());
            }
        }));
        this.clusterTaskStatus = ClusterTaskStatus.Companion.getEMPTY();
        this.metrics = NodeClusterGroupMetrics.Companion.getEMPTY();
    }

    public /* synthetic */ NodeClusterGroup(String string, List list, HarvestOptions harvestOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list, harvestOptions);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<T> getClusters() {
        return this.clusters;
    }

    @NotNull
    public final HarvestOptions getOptions() {
        return this.options;
    }

    public final int getSize() {
        return this.clusters.size();
    }

    public final boolean isEmpty() {
        return this.clusters.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !((Collection)this.clusters).isEmpty();
    }

    @NotNull
    public final ArrayList<HyperPath> getHyperPaths() {
        Lazy lazy = this.hyperPaths$delegate;
        return (ArrayList)lazy.getValue();
    }

    @NotNull
    public final HashSet<String> getShortTexts() {
        Lazy lazy = this.shortTexts$delegate;
        return (HashSet)lazy.getValue();
    }

    @NotNull
    public final HashSet<String> getMediumImages() {
        Lazy lazy = this.mediumImages$delegate;
        return (HashSet)lazy.getValue();
    }

    public final int getNumNodes() {
        Lazy lazy = this.numNodes$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getNumImageNodes() {
        Lazy lazy = this.numImageNodes$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public ScoreVector getScore() {
        Lazy lazy = this.score$delegate;
        return (ScoreVector)lazy.getValue();
    }

    public final double getDistortion() {
        Lazy lazy = this.distortion$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getPathDistortion() {
        Lazy lazy = this.pathDistortion$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getPidDistortion() {
        Lazy lazy = this.pidDistortion$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final boolean isConstant() {
        return this.dataTypeStatistics.getNumConstants() == this.getSize();
    }

    public final int getNumFields() {
        return this.getSize();
    }

    @NotNull
    public final DataTypeStatistics getDataTypeStatistics() {
        return this.dataTypeStatistics;
    }

    public final int getNumFineVariables() {
        Lazy lazy = this.numFineVariables$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getNumFineFields() {
        Lazy lazy = this.numFineFields$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final double getFineVariableRate() {
        return 1.0 * (double)this.getNumFineVariables() / (double)this.dataTypeStatistics.getNumVariables();
    }

    public final double getFineFieldRate() {
        return 1.0 * (double)this.getNumFineFields() / (double)this.getSize();
    }

    @NotNull
    public final List<ConfuseMatrix> getConfuseMatrices() {
        Lazy lazy = this.confuseMatrices$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final ConfuseMatrix getConfuseMatrix() {
        Lazy lazy = this.confuseMatrix$delegate;
        return (ConfuseMatrix)lazy.getValue();
    }

    public final double getMicroP() {
        return this.getConfuseMatrix().getPrecision();
    }

    public final double getMicroR() {
        return this.getConfuseMatrix().getRecall();
    }

    public final double getMicroF1() {
        return this.getConfuseMatrix().getF1();
    }

    public final double getMacroP() {
        Lazy lazy = this.macroP$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getMacroR() {
        Lazy lazy = this.macroR$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    public final double getMacroF1() {
        Lazy lazy = this.macroF1$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @NotNull
    public final ClusterTaskStatus getClusterTaskStatus() {
        return this.clusterTaskStatus;
    }

    public final void setClusterTaskStatus(@NotNull ClusterTaskStatus clusterTaskStatus) {
        Intrinsics.checkNotNullParameter((Object)clusterTaskStatus, (String)"<set-?>");
        this.clusterTaskStatus = clusterTaskStatus;
    }

    @NotNull
    public final NodeClusterGroupMetrics getMetrics() {
        return this.metrics;
    }

    public final void setMetrics(@NotNull NodeClusterGroupMetrics nodeClusterGroupMetrics) {
        Intrinsics.checkNotNullParameter((Object)nodeClusterGroupMetrics, (String)"<set-?>");
        this.metrics = nodeClusterGroupMetrics;
    }

    public void estimate() {
        if (this.clusters.isEmpty() || this.estimated) {
            return;
        }
        this.estimated = true;
        Iterable $this$forEach$iv = this.clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeCluster it = (NodeCluster)element$iv;
            boolean bl = false;
            it.estimate();
            this.dataTypeStatistics.accumulate(it.getDataTypeStatistics());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NodeClusterGroup<T> filter(@NotNull Function1<? super T, Boolean> predicate2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        Iterable iterable = this.clusters;
        String string = this.name;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HarvestOptions harvestOptions = this.options;
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new NodeClusterGroup<T>(string2, list, harvestOptions);
    }

    public void forEach(@NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Iterable $this$forEach$iv = this.clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toReport() {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = this.clusters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodeCluster nodeCluster = (NodeCluster)item$iv;
            int i = n;
            boolean bl = false;
            String name = cluster2.getNames().getMostEntry().toString();
            DataTypeStatistics ds = cluster2.getDataTypeStatistics();
            String string2 = "%3d.\t%5s%5d%5d";
            Object[] objectArray = new Object[]{1 + i, cluster2.getShortTexts().size(), cluster2.getTexts().size()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            String it = string;
            boolean bl2 = false;
            sb.append(it);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

