/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.ml.MathsKt;
import ai.platon.scent.ml.NodePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;
import smile.math.matrix.SVD;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003j\n\u0012\u0006\b\u0001\u0012\u00020\u0004`\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001d\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fJ$\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020 0\u0003j\b\u0012\u0004\u0012\u00020 `\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"J\u0010\u0010#\u001a\u00020\u00002\b\b\u0002\u0010$\u001a\u00020\tJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lai/platon/scent/ml/unsupervised/PCA;", "", "data", "Ljava/util/ArrayList;", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "Lkotlin/collections/ArrayList;", "cor", "", "projectionRate", "", "(Ljava/util/ArrayList;ZD)V", "cumulativeProportion", "", "eigvalues", "eigvectors", "Lsmile/math/matrix/DenseMatrix;", "mu", "n", "", "p", "pmu", "projection", "proportion", "variance", "getVariance", "()[D", "calculateProjectionInternal", "topP", "project", "", "x", "([[D)[[D", "Lai/platon/scent/ml/NodePoint;", "xs", "", "withProjection", "percentage", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nPCA.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCA.kt\nai/platon/scent/ml/unsupervised/PCA\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,231:1\n1549#2:232\n1620#2,3:233\n37#3,2:236\n1699#4,6:238\n11266#4,4:244\n*S KotlinDebug\n*F\n+ 1 PCA.kt\nai/platon/scent/ml/unsupervised/PCA\n*L\n65#1:232\n65#1:233,3\n65#1:236,2\n156#1:238,6\n216#1:244,4\n*E\n"})
public final class PCA {
    private final int n;
    @NotNull
    private final double[] mu;
    @NotNull
    private DenseMatrix eigvectors;
    @NotNull
    private double[] eigvalues;
    @NotNull
    private final double[] proportion;
    @NotNull
    private final double[] cumulativeProportion;
    private int p;
    private DenseMatrix projection;
    private double[] pmu;

    /*
     * WARNING - void declaration
     */
    public PCA(@NotNull ArrayList<? extends ArrayRealVector> data, boolean cor, double projectionRate) {
        int i;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.n = data.get(0).getDimension();
        double[] dArray = MathsKt.colMeans2((List<? extends ArrayRealVector>)data).getDataRef();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getDataRef(...)");
        this.mu = dArray;
        int m = data.size();
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo2 = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArrayRealVector arrayRealVector = (ArrayRealVector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDataRef());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv22 = $this$toTypedArray$iv;
        double[][] array2D = (double[][])thisCollection$iv22.toArray((T[])new double[0][]);
        DenseMatrix x = Matrix.newInstance((double[][])array2D);
        int thisCollection$iv22 = this.n;
        for (int j = 0; j < thisCollection$iv22; ++j) {
            for (int i2 = 0; i2 < m; ++i2) {
                x.sub(i2, j, this.mu[j]);
            }
        }
        if (m > this.n && !cor) {
            SVD svd = x.svd();
            double[] dArray2 = svd.getSingularValues();
            Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"getSingularValues(...)");
            this.eigvalues = dArray2;
            int i2 = this.eigvalues.length;
            for (i = 0; i < i2; ++i) {
                double[] $i$f$mapTo2 = this.eigvalues;
                int n = i;
                $i$f$mapTo2[n] = $i$f$mapTo2[n] * this.eigvalues[i];
            }
            DenseMatrix denseMatrix = svd.getV();
            Intrinsics.checkNotNullExpressionValue((Object)denseMatrix, (String)"getV(...)");
            this.eigvectors = denseMatrix;
        } else {
            int j;
            DenseMatrix cov = Matrix.zeros((int)this.n, (int)this.n);
            for (int k = 0; k < m; ++k) {
                $i$f$mapTo2 = this.n;
                block5: for (int i3 = 0; i3 < $i$f$mapTo2; ++i3) {
                    int j2 = 0;
                    if (j2 > i3) continue;
                    while (true) {
                        cov.add(i3, j2, x.get(k, i3) * x.get(k, j2));
                        if (j2 == i3) continue block5;
                        ++j2;
                    }
                }
            }
            int i3 = this.n;
            block7: for (i = 0; i < i3; ++i) {
                j = 0;
                if (j > i) continue;
                while (true) {
                    cov.div(i, j, (double)m);
                    cov.set(j, i, cov.get(i, j));
                    if (j == i) continue block7;
                    ++j;
                }
            }
            double[] sd = null;
            if (cor) {
                sd = new double[this.n];
                j = this.n;
                for (i3 = 0; i3 < j; ++i3) {
                    sd[i3] = Math.sqrt((double)cov.get(i3, i3));
                }
                j = this.n;
                block10: for (i3 = 0; i3 < j; ++i3) {
                    int j3 = 0;
                    if (j3 > i3) continue;
                    while (true) {
                        cov.div(i3, j3, sd[i3] * sd[j3]);
                        cov.set(j3, i3, cov.get(i3, j3));
                        if (j3 == i3) continue block10;
                        ++j3;
                    }
                }
            }
            cov.setSymmetric(true);
            EVD eigen = cov.eigen();
            DenseMatrix loadings = eigen.getEigenVectors();
            if (cor && sd != null) {
                int n = this.n;
                for (int i4 = 0; i4 < n; ++i4) {
                    int n2 = this.n;
                    for (int j4 = 0; j4 < n2; ++j4) {
                        loadings.div(i4, j4, sd[i4]);
                    }
                }
            }
            double[] dArray3 = eigen.getEigenValues();
            Intrinsics.checkNotNullExpressionValue((Object)dArray3, (String)"getEigenValues(...)");
            this.eigvalues = dArray3;
            Intrinsics.checkNotNull((Object)loadings);
            this.eigvectors = loadings;
        }
        this.proportion = (double[])this.eigvalues.clone();
        Math.unitize1((double[])this.proportion);
        this.cumulativeProportion = new double[this.eigvalues.length];
        this.cumulativeProportion[0] = this.proportion[0];
        int n = this.eigvalues.length;
        for (int i5 = 1; i5 < n; ++i5) {
            this.cumulativeProportion[i5] = this.cumulativeProportion[i5 - 1] + this.proportion[i5];
        }
        if (projectionRate < 1.0) {
            this.withProjection(projectionRate);
        } else {
            this.withProjection((int)projectionRate);
        }
    }

    public /* synthetic */ PCA(ArrayList arrayList, boolean bl, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            d = 0.95;
        }
        this(arrayList, bl, d);
    }

    @NotNull
    public final double[] getVariance() {
        return this.eigvalues;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PCA withProjection(double percentage) {
        int n;
        block3: {
            void $this$indexOfFirst$iv;
            if (percentage <= 0.0 || percentage > 1.0) {
                throw new IllegalArgumentException("Invalid percentage of variance: " + percentage);
            }
            double[] dArray = this.cumulativeProportion;
            PCA pCA = this;
            boolean $i$f$indexOfFirst = false;
            int n2 = ((void)$this$indexOfFirst$iv).length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                void it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it >= percentage)) continue;
                n = index$iv;
                break block3;
            }
            n = -1;
        }
        int n3 = n;
        pCA.p = n3 + 1;
        this.projection = this.calculateProjectionInternal(this.p);
        DenseMatrix denseMatrix = this.projection;
        if (denseMatrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        }
        double[] dArray = denseMatrix.ax(this.mu, new double[this.p]);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"ax(...)");
        this.pmu = dArray;
        return this;
    }

    public static /* synthetic */ PCA withProjection$default(PCA pCA, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.9;
        }
        return pCA.withProjection(d);
    }

    @NotNull
    public final PCA withProjection(int topP) {
        if (topP < 1 || topP > this.n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + topP);
        }
        this.p = topP;
        this.projection = this.calculateProjectionInternal(this.p);
        DenseMatrix denseMatrix = this.projection;
        if (denseMatrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        }
        double[] dArray = denseMatrix.ax(this.mu, new double[this.p]);
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"ax(...)");
        this.pmu = dArray;
        return this;
    }

    @NotNull
    public final double[] project(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.n) {
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.n};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        double[] y = new double[this.p];
        DenseMatrix denseMatrix = this.projection;
        if (denseMatrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
            denseMatrix = null;
        }
        denseMatrix.ax(x, y);
        double[] dArray = this.pmu;
        if (this.pmu == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
            dArray = null;
        }
        Math.minus((double[])y, (double[])dArray);
        return y;
    }

    @NotNull
    public final double[][] project(@NotNull double[][] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x[0].length != this.mu.length) {
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x[0].length, this.n};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        int n = 0;
        int n2 = ((Object[])x).length;
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.p];
        }
        double[][] y = dArrayArray;
        n2 = ((Object[])x).length;
        for (int i = 0; i < n2; ++i) {
            DenseMatrix denseMatrix = this.projection;
            if (denseMatrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
                denseMatrix = null;
            }
            denseMatrix.ax(x[i], y[i]);
            double[] dArray = y[i];
            double[] dArray2 = this.pmu;
            if (this.pmu == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
                dArray2 = null;
            }
            Math.minus((double[])dArray, (double[])dArray2);
        }
        return y;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<NodePoint> project(@NotNull List<? extends NodePoint> xs) {
        void $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        if (xs.get(0).getDimension() != this.mu.length) {
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{xs.get(0).getDimension(), this.n};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message2 = string2;
            throw new IllegalArgumentException(message2);
        }
        int n = 0;
        int n2 = xs.size();
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.p];
        }
        double[][] ys = dArrayArray;
        n2 = xs.size();
        for (int i = 0; i < n2; ++i) {
            DenseMatrix denseMatrix = this.projection;
            if (denseMatrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projection");
                denseMatrix = null;
            }
            denseMatrix.ax(xs.get(i).getDataRef(), ys[i]);
            double[] dArray = ys[i];
            double[] dArray2 = this.pmu;
            if (this.pmu == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pmu");
                dArray2 = null;
            }
            Math.minus((double[])dArray, (double[])dArray2);
        }
        Object[] i = (Object[])ys;
        Collection destination$iv = new ArrayList(xs.size());
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (void item$iv : $this$mapIndexedTo$iv) {
            void data;
            void i2;
            int n4 = index$iv++;
            double[] dArray = (double[])item$iv;
            int n5 = n4;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new NodePoint(xs.get((int)i2).getNode(), (double[])data, false, 4, null));
        }
        return (ArrayList)destination$iv;
    }

    private final DenseMatrix calculateProjectionInternal(int topP) {
        int p = topP;
        DenseMatrix projection = Matrix.zeros((int)p, (int)this.n);
        int n = this.n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                projection.set(j, i, this.eigvectors.get(i, j));
            }
        }
        Intrinsics.checkNotNull((Object)projection);
        return projection;
    }
}

